/*
 * Decompiled with CFR 0.152.
 */
package io.rebloom.client;

import io.rebloom.client.Command;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.Connection;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.commands.ProtocolCommand;
import redis.clients.jedis.exceptions.JedisException;
import redis.clients.jedis.util.Pool;

public class Client
implements Closeable {
    private final Pool<Jedis> pool;

    Jedis _conn() {
        return (Jedis)this.pool.getResource();
    }

    private Connection sendCommand(Jedis conn, Command command, String ... args) {
        redis.clients.jedis.Client client = conn.getClient();
        client.sendCommand((ProtocolCommand)command, args);
        return client;
    }

    private Connection sendCommand(Jedis conn, Command command, byte[] ... args) {
        redis.clients.jedis.Client client = conn.getClient();
        client.sendCommand((ProtocolCommand)command, args);
        return client;
    }

    public Client(Pool<Jedis> pool) {
        this.pool = pool;
    }

    public Client(String host, int port, int timeout, int poolSize) {
        JedisPoolConfig conf = new JedisPoolConfig();
        conf.setMaxTotal(poolSize);
        conf.setTestOnBorrow(false);
        conf.setTestOnReturn(false);
        conf.setTestOnCreate(false);
        conf.setTestWhileIdle(false);
        conf.setMinEvictableIdleTimeMillis(60000L);
        conf.setTimeBetweenEvictionRunsMillis(30000L);
        conf.setNumTestsPerEvictionRun(-1);
        conf.setFairness(true);
        this.pool = new JedisPool((GenericObjectPoolConfig)conf, host, port, timeout);
    }

    public Client(String host, int port) {
        this(host, port, 500, 100);
    }

    public void createFilter(String name, long initCapacity, double errorRate) {
        try (Jedis conn = this._conn();){
            String rep = this.sendCommand(conn, Command.RESERVE, name, errorRate + "", initCapacity + "").getStatusCodeReply();
            if (!rep.equals("OK")) {
                throw new JedisException(rep);
            }
        }
    }

    public boolean add(String name, String value) {
        try (Jedis conn = this._conn();){
            boolean bl = this.sendCommand(conn, Command.ADD, name, value).getIntegerReply() != 0L;
            return bl;
        }
    }

    public boolean add(String name, byte[] value) {
        try (Jedis conn = this._conn();){
            boolean bl = this.sendCommand(conn, Command.ADD, name.getBytes(), value).getIntegerReply() != 0L;
            return bl;
        }
    }

    @SafeVarargs
    private final <T> boolean[] sendMultiCommand(Command cmd, T name, T ... value) {
        List reps;
        ArrayList<T> arr = new ArrayList<T>();
        arr.add(name);
        arr.addAll(Arrays.asList(value));
        try (Jedis conn = this._conn();){
            reps = name instanceof String ? this.sendCommand(conn, cmd, arr.toArray((String[])value)).getIntegerMultiBulkReply() : this.sendCommand(conn, cmd, (byte[][])arr.toArray((T[])((byte[][])value))).getIntegerMultiBulkReply();
        }
        boolean[] ret = new boolean[value.length];
        for (int i = 0; i < reps.size(); ++i) {
            ret[i] = (Long)reps.get(i) != 0L;
        }
        return ret;
    }

    public boolean[] addMulti(String name, byte[] ... values) {
        return this.sendMultiCommand(Command.MADD, (Object)name.getBytes(), (T[])values);
    }

    public boolean[] addMulti(String name, String ... values) {
        return this.sendMultiCommand(Command.MADD, name, values);
    }

    public boolean exists(String name, String value) {
        try (Jedis conn = this._conn();){
            boolean bl = this.sendCommand(conn, Command.EXISTS, name, value).getIntegerReply() != 0L;
            return bl;
        }
    }

    public boolean exists(String name, byte[] value) {
        try (Jedis conn = this._conn();){
            boolean bl = this.sendCommand(conn, Command.EXISTS, name.getBytes(), value).getIntegerReply() != 0L;
            return bl;
        }
    }

    public boolean[] existsMulti(String name, byte[] ... values) {
        return this.sendMultiCommand(Command.MEXISTS, (Object)name.getBytes(), (T[])values);
    }

    public boolean[] existsMulti(String name, String ... values) {
        return this.sendMultiCommand(Command.MEXISTS, name, values);
    }

    public boolean delete(String name) {
        try (Jedis conn = this._conn();){
            boolean bl = conn.del(name) != 0L;
            return bl;
        }
    }

    @Override
    public void close() {
        this.pool.close();
    }
}

