/*
 * Decompiled with CFR 0.152.
 */
package io.rebloom.client;

import io.rebloom.client.Command;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.Client;
import redis.clients.jedis.Connection;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.JedisClusterCommand;
import redis.clients.jedis.commands.ProtocolCommand;

public class ClusterClient
extends JedisCluster {
    public ClusterClient(HostAndPort node) {
        super(node);
    }

    public ClusterClient(HostAndPort node, int timeout) {
        super(node, timeout);
    }

    public ClusterClient(HostAndPort node, int timeout, int maxAttempts) {
        super(node, timeout, maxAttempts);
    }

    public ClusterClient(HostAndPort node, GenericObjectPoolConfig poolConfig) {
        super(node, poolConfig);
    }

    public ClusterClient(HostAndPort node, int timeout, GenericObjectPoolConfig poolConfig) {
        super(node, timeout, poolConfig);
    }

    public ClusterClient(HostAndPort node, int timeout, int maxAttempts, GenericObjectPoolConfig poolConfig) {
        super(node, timeout, maxAttempts, poolConfig);
    }

    public ClusterClient(HostAndPort node, int connectionTimeout, int soTimeout, int maxAttempts, GenericObjectPoolConfig poolConfig) {
        super(node, connectionTimeout, soTimeout, maxAttempts, poolConfig);
    }

    public ClusterClient(HostAndPort node, int connectionTimeout, int soTimeout, int maxAttempts, String password, GenericObjectPoolConfig poolConfig) {
        super(node, connectionTimeout, soTimeout, maxAttempts, password, poolConfig);
    }

    public ClusterClient(HostAndPort node, int connectionTimeout, int soTimeout, int maxAttempts, String password, String clientName, GenericObjectPoolConfig poolConfig) {
        super(node, connectionTimeout, soTimeout, maxAttempts, password, clientName, poolConfig);
    }

    public ClusterClient(Set<HostAndPort> nodes) {
        super(nodes);
    }

    public ClusterClient(Set<HostAndPort> nodes, int timeout) {
        super(nodes, timeout);
    }

    public ClusterClient(Set<HostAndPort> nodes, int timeout, int maxAttempts) {
        super(nodes, timeout, maxAttempts);
    }

    public ClusterClient(Set<HostAndPort> nodes, GenericObjectPoolConfig poolConfig) {
        super(nodes, poolConfig);
    }

    public ClusterClient(Set<HostAndPort> nodes, int timeout, GenericObjectPoolConfig poolConfig) {
        super(nodes, timeout, poolConfig);
    }

    public ClusterClient(Set<HostAndPort> jedisClusterNode, int timeout, int maxAttempts, GenericObjectPoolConfig poolConfig) {
        super(jedisClusterNode, timeout, maxAttempts, poolConfig);
    }

    public ClusterClient(Set<HostAndPort> jedisClusterNode, int connectionTimeout, int soTimeout, int maxAttempts, GenericObjectPoolConfig poolConfig) {
        super(jedisClusterNode, connectionTimeout, soTimeout, maxAttempts, poolConfig);
    }

    public ClusterClient(Set<HostAndPort> jedisClusterNode, int connectionTimeout, int soTimeout, int maxAttempts, String password, GenericObjectPoolConfig poolConfig) {
        super(jedisClusterNode, connectionTimeout, soTimeout, maxAttempts, password, poolConfig);
    }

    public ClusterClient(Set<HostAndPort> jedisClusterNode, int connectionTimeout, int soTimeout, int maxAttempts, String password, String clientName, GenericObjectPoolConfig poolConfig) {
        super(jedisClusterNode, connectionTimeout, soTimeout, maxAttempts, password, clientName, poolConfig);
    }

    public boolean createFilter(final String name, final long initCapacity, final double errorRate) {
        return (Boolean)new JedisClusterCommand<Boolean>(this.connectionHandler, this.maxAttempts){

            public Boolean execute(Jedis connection) {
                Client conn = connection.getClient();
                conn.sendCommand((ProtocolCommand)Command.RESERVE, new String[]{name, errorRate + "", initCapacity + ""});
                return conn.getStatusCodeReply().equals("OK");
            }
        }.run(name);
    }

    public boolean add(final String name, final String value) {
        return (Boolean)new JedisClusterCommand<Boolean>(this.connectionHandler, this.maxAttempts){

            public Boolean execute(Jedis connection) {
                Client conn = connection.getClient();
                conn.sendCommand((ProtocolCommand)Command.ADD, new String[]{name, value});
                return conn.getIntegerReply() != 0L;
            }
        }.run(name);
    }

    public boolean add(final String name, final byte[] value) {
        return (Boolean)new JedisClusterCommand<Boolean>(this.connectionHandler, this.maxAttempts){

            public Boolean execute(Jedis connection) {
                Client conn = connection.getClient();
                conn.sendCommand((ProtocolCommand)Command.ADD, (byte[][])new byte[][]{name.getBytes(), value});
                return conn.getIntegerReply() != 0L;
            }
        }.run(name);
    }

    public boolean exists(final String name, final String value) {
        return (Boolean)new JedisClusterCommand<Boolean>(this.connectionHandler, this.maxAttempts){

            public Boolean execute(Jedis connection) {
                Client conn = connection.getClient();
                conn.sendCommand((ProtocolCommand)Command.EXISTS, new String[]{name, value});
                return conn.getIntegerReply() != 0L;
            }
        }.run(name);
    }

    public boolean exists(final String name, final byte[] value) {
        return (Boolean)new JedisClusterCommand<Boolean>(this.connectionHandler, this.maxAttempts){

            public Boolean execute(Jedis connection) {
                Client conn = connection.getClient();
                conn.sendCommand((ProtocolCommand)Command.EXISTS, (byte[][])new byte[][]{name.getBytes(), value});
                return conn.getIntegerReply() != 0L;
            }
        }.run(name);
    }

    public boolean[] addMulti(final String name, final byte[] ... values) {
        return (boolean[])new JedisClusterCommand<boolean[]>(this.connectionHandler, this.maxAttempts){

            public boolean[] execute(Jedis connection) {
                Client conn = connection.getClient();
                return ClusterClient.this.sendMultiCommand((Connection)conn, Command.MADD, name.getBytes(), (Object[])values);
            }
        }.run(name);
    }

    public boolean[] addMulti(final String name, final String ... values) {
        return (boolean[])new JedisClusterCommand<boolean[]>(this.connectionHandler, this.maxAttempts){

            public boolean[] execute(Jedis connection) {
                Client conn = connection.getClient();
                return ClusterClient.this.sendMultiCommand((Connection)conn, Command.MADD, name, values);
            }
        }.run(name);
    }

    public boolean[] existsMulti(final String name, final byte[] ... values) {
        return (boolean[])new JedisClusterCommand<boolean[]>(this.connectionHandler, this.maxAttempts){

            public boolean[] execute(Jedis connection) {
                Client conn = connection.getClient();
                return ClusterClient.this.sendMultiCommand((Connection)conn, Command.MEXISTS, name.getBytes(), (Object[])values);
            }
        }.run(name);
    }

    public boolean[] existsMulti(final String name, final String ... values) {
        return (boolean[])new JedisClusterCommand<boolean[]>(this.connectionHandler, this.maxAttempts){

            public boolean[] execute(Jedis connection) {
                Client conn = connection.getClient();
                return ClusterClient.this.sendMultiCommand((Connection)conn, Command.MEXISTS, name, values);
            }
        }.run(name);
    }

    public boolean delete(final String name) {
        return (Boolean)new JedisClusterCommand<Boolean>(this.connectionHandler, this.maxAttempts){

            public Boolean execute(Jedis connection) {
                Client conn = connection.getClient();
                conn.del(new String[]{name});
                return conn.getIntegerReply() != 0L;
            }
        }.run(name);
    }

    @SafeVarargs
    private final <T> boolean[] sendMultiCommand(Connection conn, Command cmd, T name, T ... value) {
        List reps;
        ArrayList<T> arr = new ArrayList<T>();
        arr.add(name);
        arr.addAll(Arrays.asList(value));
        if (name instanceof String) {
            conn.sendCommand((ProtocolCommand)cmd, arr.toArray((String[])value));
            reps = conn.getIntegerMultiBulkReply();
        } else {
            conn.sendCommand((ProtocolCommand)cmd, (byte[][])arr.toArray((T[])((byte[][])value)));
            reps = conn.getIntegerMultiBulkReply();
        }
        boolean[] ret = new boolean[value.length];
        for (int i = 0; i < reps.size(); ++i) {
            ret[i] = (Long)reps.get(i) != 0L;
        }
        return ret;
    }
}

