/*
 * Decompiled with CFR 0.152.
 */
package io.redisearch;

import io.redisearch.FieldName;
import io.redisearch.Keywords;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.util.SafeEncoder;

public class Query {
    protected final List<Filter> _filters = new LinkedList<Filter>();
    protected final String _queryString;
    protected final Paging _paging = new Paging(0, 10);
    protected boolean _verbatim = false;
    protected boolean _noContent = false;
    protected boolean _noStopwords = false;
    protected boolean _withScores = false;
    protected boolean _withPayloads = false;
    protected String _language = null;
    protected String[] _fields = null;
    protected String[] _keys = null;
    protected String[] _returnFields = null;
    private FieldName[] returnFieldNames = null;
    protected String[] highlightFields = null;
    protected String[] summarizeFields = null;
    protected String[] highlightTags = null;
    protected String summarizeSeparator = null;
    protected int summarizeNumFragments = -1;
    protected int summarizeFragmentLen = -1;
    protected byte[] _payload = null;
    protected String _sortBy = null;
    protected boolean _sortAsc = true;
    protected boolean wantsHighlight = false;
    protected boolean wantsSummarize = false;
    protected String _scorer = null;

    public Query() {
        this("*");
    }

    public Query(String queryString) {
        this._queryString = queryString;
    }

    public void serializeRedisArgs(List<byte[]> args) {
        args.add(SafeEncoder.encode((String)this._queryString));
        if (this._verbatim) {
            args.add(Keywords.VERBATIM.getRaw());
        }
        if (this._noContent) {
            args.add(Keywords.NOCONTENT.getRaw());
        }
        if (this._noStopwords) {
            args.add(Keywords.NOSTOPWORDS.getRaw());
        }
        if (this._withScores) {
            args.add(Keywords.WITHSCORES.getRaw());
        }
        if (this._withPayloads) {
            args.add(Keywords.WITHPAYLOADS.getRaw());
        }
        if (this._language != null) {
            args.add(Keywords.LANGUAGE.getRaw());
            args.add(SafeEncoder.encode((String)this._language));
        }
        if (this._scorer != null) {
            args.add(Keywords.SCORER.getRaw());
            args.add(SafeEncoder.encode((String)this._scorer));
        }
        if (this._fields != null && this._fields.length > 0) {
            args.add(Keywords.INFIELDS.getRaw());
            args.add(Protocol.toByteArray((int)this._fields.length));
            for (String string : this._fields) {
                args.add(SafeEncoder.encode((String)string));
            }
        }
        if (this._sortBy != null) {
            args.add(Keywords.SORTBY.getRaw());
            args.add(SafeEncoder.encode((String)this._sortBy));
            args.add((this._sortAsc ? Keywords.ASC : Keywords.DESC).getRaw());
        }
        if (this._payload != null) {
            args.add(Keywords.PAYLOAD.getRaw());
            args.add(this._payload);
        }
        if (this._paging.offset != 0 || this._paging.num != 10) {
            args.addAll(Arrays.asList(Keywords.LIMIT.getRaw(), Protocol.toByteArray((int)this._paging.offset), Protocol.toByteArray((int)this._paging.num)));
        }
        if (!this._filters.isEmpty()) {
            for (Filter f : this._filters) {
                f.serializeRedisArgs(args);
            }
        }
        if (this.wantsHighlight) {
            args.add(Keywords.HIGHLIGHT.getRaw());
            if (this.highlightFields != null) {
                args.add(Keywords.FIELDS.getRaw());
                args.add(Protocol.toByteArray((int)this.highlightFields.length));
                for (String string : this.highlightFields) {
                    args.add(SafeEncoder.encode((String)string));
                }
            }
            if (this.highlightTags != null) {
                args.add(Keywords.TAGS.getRaw());
                for (String string : this.highlightTags) {
                    args.add(SafeEncoder.encode((String)string));
                }
            }
        }
        if (this.wantsSummarize) {
            args.add(Keywords.SUMMARIZE.getRaw());
            if (this.summarizeFields != null) {
                args.add(Keywords.FIELDS.getRaw());
                args.add(Protocol.toByteArray((int)this.summarizeFields.length));
                for (String string : this.summarizeFields) {
                    args.add(SafeEncoder.encode((String)string));
                }
            }
            if (this.summarizeNumFragments != -1) {
                args.add(Keywords.FRAGS.getRaw());
                args.add(Protocol.toByteArray((int)this.summarizeNumFragments));
            }
            if (this.summarizeFragmentLen != -1) {
                args.add(Keywords.LEN.getRaw());
                args.add(Protocol.toByteArray((int)this.summarizeFragmentLen));
            }
            if (this.summarizeSeparator != null) {
                args.add(Keywords.SEPARATOR.getRaw());
                args.add(SafeEncoder.encode((String)this.summarizeSeparator));
            }
        }
        if (this._keys != null && this._keys.length > 0) {
            args.add(Keywords.INKEYS.getRaw());
            args.add(Protocol.toByteArray((int)this._keys.length));
            for (String string : this._keys) {
                args.add(SafeEncoder.encode((String)string));
            }
        }
        if (this._returnFields != null && this._returnFields.length > 0) {
            args.add(Keywords.RETURN.getRaw());
            args.add(Protocol.toByteArray((int)this._returnFields.length));
            for (String string : this._returnFields) {
                args.add(SafeEncoder.encode((String)string));
            }
        } else if (this.returnFieldNames != null && this.returnFieldNames.length > 0) {
            args.add(Keywords.RETURN.getRaw());
            int returnCountIndex = args.size();
            args.add(null);
            int returnCount = 0;
            for (FieldName fn : this.returnFieldNames) {
                returnCount += fn.addCommandBinaryArguments(args);
            }
            args.set(returnCountIndex, Protocol.toByteArray((int)returnCount));
        }
    }

    public Query limit(Integer offset, Integer limit) {
        this._paging.offset = offset;
        this._paging.num = limit;
        return this;
    }

    public Query addFilter(Filter f) {
        this._filters.add(f);
        return this;
    }

    public Query setPayload(byte[] payload) {
        this._payload = payload;
        return this;
    }

    public Query setVerbatim() {
        this._verbatim = true;
        return this;
    }

    public boolean getNoContent() {
        return this._noContent;
    }

    public Query setNoContent() {
        this._noContent = true;
        return this;
    }

    public Query setNoStopwords() {
        this._noStopwords = true;
        return this;
    }

    public boolean getWithScores() {
        return this._withScores;
    }

    public Query setWithScores() {
        this._withScores = true;
        return this;
    }

    public boolean getWithPayloads() {
        return this._withPayloads;
    }

    @Deprecated
    public Query setWithPaload() {
        return this.setWithPayload();
    }

    public Query setWithPayload() {
        this._withPayloads = true;
        return this;
    }

    public Query setLanguage(String language) {
        this._language = language;
        return this;
    }

    public Query setScorer(String scorer) {
        this._scorer = scorer;
        return this;
    }

    public Query limitFields(String ... fields) {
        this._fields = fields;
        return this;
    }

    public Query limitKeys(String ... keys) {
        this._keys = keys;
        return this;
    }

    public Query returnFields(String ... fields) {
        this._returnFields = fields;
        this.returnFieldNames = null;
        return this;
    }

    public Query returnFields(FieldName ... fields) {
        this.returnFieldNames = fields;
        this._returnFields = null;
        return this;
    }

    public Query highlightFields(HighlightTags tags, String ... fields) {
        if (fields == null || fields.length > 0) {
            this.highlightFields = fields;
        }
        this.highlightTags = tags != null ? new String[]{tags.open, tags.close} : null;
        this.wantsHighlight = true;
        return this;
    }

    public Query highlightFields(String ... fields) {
        return this.highlightFields((HighlightTags)null, fields);
    }

    public Query summarizeFields(int contextLen, int fragmentCount, String separator, String ... fields) {
        if (fields == null || fields.length > 0) {
            this.summarizeFields = fields;
        }
        this.summarizeFragmentLen = contextLen;
        this.summarizeNumFragments = fragmentCount;
        this.summarizeSeparator = separator;
        this.wantsSummarize = true;
        return this;
    }

    public Query summarizeFields(String ... fields) {
        return this.summarizeFields(-1, -1, null, fields);
    }

    public Query setSortBy(String field, boolean ascending) {
        this._sortBy = field;
        this._sortAsc = ascending;
        return this;
    }

    public static class HighlightTags {
        private final String open;
        private final String close;

        public HighlightTags(String open, String close) {
            this.open = open;
            this.close = close;
        }
    }

    public static class Paging {
        int offset;
        int num;

        public Paging(int offset, int num) {
            this.offset = offset;
            this.num = num;
        }
    }

    public static class GeoFilter
    extends Filter {
        public static final String KILOMETERS = "km";
        public static final String METERS = "m";
        public static final String FEET = "ft";
        public static final String MILES = "mi";
        private final double lon;
        private final double lat;
        private final double radius;
        private final String unit;

        public GeoFilter(String property, double lon, double lat, double radius, String unit) {
            super(property);
            this.lon = lon;
            this.lat = lat;
            this.radius = radius;
            this.unit = unit;
        }

        @Override
        public void serializeRedisArgs(List<byte[]> args) {
            args.add(Keywords.GEOFILTER.getRaw());
            args.add(SafeEncoder.encode((String)this.property));
            args.add(Protocol.toByteArray((double)this.lon));
            args.add(Protocol.toByteArray((double)this.lat));
            args.add(Protocol.toByteArray((double)this.radius));
            args.add(SafeEncoder.encode((String)this.unit));
        }
    }

    public static class NumericFilter
    extends Filter {
        private final double min;
        private final boolean exclusiveMin;
        private final double max;
        private final boolean exclusiveMax;

        public NumericFilter(String property, double min, boolean exclusiveMin, double max, boolean exclusiveMax) {
            super(property);
            this.min = min;
            this.max = max;
            this.exclusiveMax = exclusiveMax;
            this.exclusiveMin = exclusiveMin;
        }

        public NumericFilter(String property, double min, double max) {
            this(property, min, false, max, false);
        }

        private byte[] formatNum(double num, boolean exclude) {
            if (num == Double.POSITIVE_INFINITY) {
                return Keywords.POSITIVE_INFINITY.getRaw();
            }
            if (num == Double.NEGATIVE_INFINITY) {
                return Keywords.NEGATIVE_INFINITY.getRaw();
            }
            return exclude ? SafeEncoder.encode((String)("(" + num)) : Protocol.toByteArray((double)num);
        }

        @Override
        public void serializeRedisArgs(List<byte[]> args) {
            args.add(Keywords.FILTER.getRaw());
            args.add(SafeEncoder.encode((String)this.property));
            args.add(this.formatNum(this.min, this.exclusiveMin));
            args.add(this.formatNum(this.max, this.exclusiveMax));
        }
    }

    public static abstract class Filter {
        public final String property;

        public abstract void serializeRedisArgs(List<byte[]> var1);

        public Filter(String property) {
            this.property = property;
        }
    }
}

