/*
 * Decompiled with CFR 0.152.
 */
package com.redislabs.redistimeseries;

import com.redislabs.redistimeseries.Aggregation;
import com.redislabs.redistimeseries.Command;
import com.redislabs.redistimeseries.Keyword;
import com.redislabs.redistimeseries.Measurement;
import com.redislabs.redistimeseries.Range;
import com.redislabs.redistimeseries.Value;
import com.redislabs.redistimeseries.information.Info;
import com.redislabs.redistimeseries.information.Rule;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.BinaryClient;
import redis.clients.jedis.Client;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.commands.ProtocolCommand;
import redis.clients.jedis.util.Pool;
import redis.clients.jedis.util.SafeEncoder;

public class RedisTimeSeries {
    private static final byte[] STAR = SafeEncoder.encode((String)"*");
    private final Pool<Jedis> pool;

    public RedisTimeSeries() {
        this("localhost", 6379);
    }

    public RedisTimeSeries(String host, int port) {
        this(host, port, 500, 100);
    }

    public RedisTimeSeries(String host, int port, int timeout, int poolSize) {
        this(host, port, timeout, poolSize, null);
    }

    public RedisTimeSeries(String host, int port, int timeout, int poolSize, String password) {
        this((Pool<Jedis>)new JedisPool((GenericObjectPoolConfig)RedisTimeSeries.initPoolConfig(poolSize), host, port, timeout, password));
    }

    public RedisTimeSeries(Pool<Jedis> pool) {
        this.pool = pool;
    }

    public boolean create(String key) {
        try (Jedis conn = this.getConnection();){
            boolean bl = this.sendCommand(conn, Command.CREATE, new byte[][]{SafeEncoder.encode((String)key)}).getStatusCodeReply().equals("OK");
            return bl;
        }
    }

    public boolean create(String key, long retentionTime) {
        try (Jedis conn = this.getConnection();){
            boolean bl = this.sendCommand(conn, Command.CREATE, SafeEncoder.encode((String)key), Keyword.RETENTION.getRaw(), Protocol.toByteArray((long)retentionTime)).getStatusCodeReply().equals("OK");
            return bl;
        }
    }

    public boolean create(String key, Map<String, String> labels) {
        try (Jedis conn = this.getConnection();){
            byte[][] args = new byte[1 + (labels == null ? 0 : 2 * labels.size() + 1)][];
            int i = 0;
            args[i++] = SafeEncoder.encode((String)key);
            if (labels != null) {
                args[i++] = Keyword.LABELS.getRaw();
                for (Map.Entry<String, String> e : labels.entrySet()) {
                    args[i++] = SafeEncoder.encode((String)e.getKey());
                    args[i++] = SafeEncoder.encode((String)e.getValue());
                }
            }
            boolean bl = this.sendCommand(conn, Command.CREATE, args).getStatusCodeReply().equals("OK");
            return bl;
        }
    }

    public boolean create(String key, long retentionTime, Map<String, String> labels) {
        try (Jedis conn = this.getConnection();){
            byte[][] args = new byte[3 + (labels == null ? 0 : 2 * labels.size() + 1)][];
            int i = 0;
            args[i++] = SafeEncoder.encode((String)key);
            args[i++] = Keyword.RETENTION.getRaw();
            args[i++] = Protocol.toByteArray((long)retentionTime);
            if (labels != null) {
                args[i++] = Keyword.LABELS.getRaw();
                for (Map.Entry<String, String> e : labels.entrySet()) {
                    args[i++] = SafeEncoder.encode((String)e.getKey());
                    args[i++] = SafeEncoder.encode((String)e.getValue());
                }
            }
            boolean bl = this.sendCommand(conn, Command.CREATE, args).getStatusCodeReply().equals("OK");
            return bl;
        }
    }

    public boolean createRule(String sourceKey, Aggregation aggregation, long bucketSize, String destKey) {
        try (Jedis conn = this.getConnection();){
            boolean bl = this.sendCommand(conn, Command.CREATE_RULE, SafeEncoder.encode((String)sourceKey), SafeEncoder.encode((String)destKey), Keyword.AGGREGATION.getRaw(), aggregation.getRaw(), Protocol.toByteArray((long)bucketSize)).getStatusCodeReply().equals("OK");
            return bl;
        }
    }

    public boolean deleteRule(String sourceKey, String destKey) {
        try (Jedis conn = this.getConnection();){
            boolean bl = this.sendCommand(conn, Command.DELETE_RULE, SafeEncoder.encode((String)sourceKey), SafeEncoder.encode((String)destKey)).getStatusCodeReply().equals("OK");
            return bl;
        }
    }

    public long add(String sourceKey, long timestamp, double value) {
        try (Jedis conn = this.getConnection();){
            long l = this.sendCommand(conn, Command.ADD, SafeEncoder.encode((String)sourceKey), timestamp > 0L ? Protocol.toByteArray((long)timestamp) : STAR, Protocol.toByteArray((double)value)).getIntegerReply();
            return l;
        }
    }

    public long add(String sourceKey, long timestamp, double value, long retentionTime) {
        try (Jedis conn = this.getConnection();){
            long l = this.sendCommand(conn, Command.ADD, SafeEncoder.encode((String)sourceKey), timestamp > 0L ? Protocol.toByteArray((long)timestamp) : STAR, Protocol.toByteArray((double)value), Keyword.RETENTION.getRaw(), Protocol.toByteArray((long)retentionTime)).getIntegerReply();
            return l;
        }
    }

    public long add(String sourceKey, long timestamp, double value, Map<String, String> labels) {
        try (Jedis conn = this.getConnection();){
            byte[][] args = new byte[3 + (labels == null ? 0 : 2 * labels.size() + 1)][];
            int i = 0;
            args[i++] = SafeEncoder.encode((String)sourceKey);
            args[i++] = timestamp > 0L ? Protocol.toByteArray((long)timestamp) : STAR;
            args[i++] = Protocol.toByteArray((double)value);
            if (labels != null) {
                args[i++] = Keyword.LABELS.getRaw();
                for (Map.Entry<String, String> e : labels.entrySet()) {
                    args[i++] = SafeEncoder.encode((String)e.getKey());
                    args[i++] = SafeEncoder.encode((String)e.getValue());
                }
            }
            long l = this.sendCommand(conn, Command.ADD, args).getIntegerReply();
            return l;
        }
    }

    public long add(String sourceKey, long timestamp, double value, long retentionTime, Map<String, String> labels) {
        try (Jedis conn = this.getConnection();){
            byte[][] args = new byte[5 + (labels == null ? 0 : 2 * labels.size() + 1)][];
            int i = 0;
            args[i++] = SafeEncoder.encode((String)sourceKey);
            args[i++] = timestamp > 0L ? Protocol.toByteArray((long)timestamp) : STAR;
            args[i++] = Protocol.toByteArray((double)value);
            args[i++] = Keyword.RETENTION.getRaw();
            args[i++] = Protocol.toByteArray((long)retentionTime);
            if (labels != null) {
                args[i++] = Keyword.LABELS.getRaw();
                for (Map.Entry<String, String> e : labels.entrySet()) {
                    args[i++] = SafeEncoder.encode((String)e.getKey());
                    args[i++] = SafeEncoder.encode((String)e.getValue());
                }
            }
            long l = this.sendCommand(conn, Command.ADD, args).getIntegerReply();
            return l;
        }
    }

    public List<Object> madd(Measurement ... measurements) {
        try (Jedis conn = this.getConnection();){
            byte[][] args = new byte[measurements.length * 3][];
            for (int i = 0; i < measurements.length; ++i) {
                int argsIndx = i * 3;
                args[argsIndx] = SafeEncoder.encode((String)measurements[i].getSourceKey());
                long timestamp = measurements[i].getTimestamp();
                args[argsIndx + 1] = timestamp > 0L ? Protocol.toByteArray((long)timestamp) : STAR;
                args[argsIndx + 2] = Protocol.toByteArray((double)measurements[i].getValue());
            }
            List list = this.sendCommand(conn, Command.MADD, args).getObjectMultiBulkReply();
            return list;
        }
    }

    public Value[] range(String key, long from, long to) {
        try (Jedis conn = this.getConnection();){
            List range = this.sendCommand(conn, Command.RANGE, SafeEncoder.encode((String)key), Protocol.toByteArray((long)from), Protocol.toByteArray((long)to)).getObjectMultiBulkReply();
            Value[] values = new Value[range.size()];
            for (int i = 0; i < values.length; ++i) {
                List touple = (List)range.get(i);
                values[i] = new Value((Long)touple.get(0), Double.parseDouble(SafeEncoder.encode((byte[])((byte[])touple.get(1)))));
            }
            Value[] valueArray = values;
            return valueArray;
        }
    }

    public Value[] range(String key, long from, long to, Aggregation aggregation, long retentionTime) {
        try (Jedis conn = this.getConnection();){
            List range = this.sendCommand(conn, Command.RANGE, SafeEncoder.encode((String)key), Protocol.toByteArray((long)from), Protocol.toByteArray((long)to), Keyword.AGGREGATION.getRaw(), aggregation.getRaw(), Protocol.toByteArray((long)retentionTime)).getObjectMultiBulkReply();
            Value[] values = new Value[range.size()];
            for (int i = 0; i < values.length; ++i) {
                List touple = (List)range.get(i);
                values[i] = new Value((Long)touple.get(0), Double.parseDouble(SafeEncoder.encode((byte[])((byte[])touple.get(1)))));
            }
            Value[] valueArray = values;
            return valueArray;
        }
    }

    public Range[] mrange(long from, long to, Aggregation aggregation, long retentionTime, String ... filters) {
        try (Jedis conn = this.getConnection();){
            byte[][] args = new byte[6 + (filters == null ? 0 : filters.length)][];
            int i = 0;
            args[i++] = Protocol.toByteArray((long)from);
            args[i++] = Protocol.toByteArray((long)to);
            args[i++] = Keyword.AGGREGATION.getRaw();
            args[i++] = aggregation.getRaw();
            args[i++] = Protocol.toByteArray((long)retentionTime);
            args[i++] = Keyword.FILTER.getRaw();
            if (filters != null) {
                for (String label : filters) {
                    args[i++] = SafeEncoder.encode((String)label);
                }
            }
            List result = this.sendCommand(conn, Command.MRANGE, args).getObjectMultiBulkReply();
            Range[] ranges = new Range[result.size()];
            for (int j = 0; j < ranges.length; ++j) {
                List series = (List)result.get(j);
                String resKey = SafeEncoder.encode((byte[])((byte[])series.get(0)));
                List resLables = (List)series.get(1);
                HashMap<String, String> rangeLabels = new HashMap<String, String>();
                for (int l = 0; l < resLables.size(); ++l) {
                    List label = (List)resLables.get(l);
                    rangeLabels.put(SafeEncoder.encode((byte[])((byte[])label.get(0))), SafeEncoder.encode((byte[])((byte[])label.get(1))));
                }
                List resRange = (List)series.get(2);
                Value[] values = new Value[resRange.size()];
                for (int r = 0; r < values.length; ++r) {
                    List touple = (List)resRange.get(r);
                    values[r] = new Value((Long)touple.get(0), Double.parseDouble(SafeEncoder.encode((byte[])((byte[])touple.get(1)))));
                }
                ranges[j] = new Range(resKey, rangeLabels, values);
            }
            Range[] rangeArray = ranges;
            return rangeArray;
        }
    }

    public boolean incrBy(String key, int value, long timeBucket) {
        try (Jedis conn = this.getConnection();){
            boolean bl = this.sendCommand(conn, Command.INCRBY, SafeEncoder.encode((String)key), Protocol.toByteArray((int)value), Keyword.RESET.getRaw(), Protocol.toByteArray((long)timeBucket)).getStatusCodeReply().equals("OK");
            return bl;
        }
    }

    public boolean decrBy(String key, int value, long timeBucket) {
        try (Jedis conn = this.getConnection();){
            boolean bl = this.sendCommand(conn, Command.DECRBY, SafeEncoder.encode((String)key), Protocol.toByteArray((int)value), Keyword.RESET.getRaw(), Protocol.toByteArray((long)timeBucket)).getStatusCodeReply().equals("OK");
            return bl;
        }
    }

    public Info info(String key) {
        try (Jedis conn = this.getConnection();){
            List resp = this.sendCommand(conn, Command.INFO, new byte[][]{SafeEncoder.encode((String)key)}).getObjectMultiBulkReply();
            HashMap<String, Long> properties = new HashMap<String, Long>();
            HashMap<String, String> labels = new HashMap<String, String>();
            HashMap<String, Rule> rules = new HashMap<String, Rule>();
            for (int i = 0; i < resp.size(); i += 2) {
                String prop = SafeEncoder.encode((byte[])((byte[])resp.get(i)));
                Object value = resp.get(i + 1);
                if (value instanceof Long) {
                    properties.put(prop, (Long)value);
                    continue;
                }
                if (!prop.equals("labels")) continue;
                List labelsList = (List)value;
                for (int j = 0; j < labelsList.size(); j += 2) {
                    labels.put(SafeEncoder.encode((byte[])((byte[])labelsList.get(j))), SafeEncoder.encode((byte[])((byte[])labelsList.get(j + 1))));
                }
            }
            Info info = new Info(properties, labels, rules);
            return info;
        }
    }

    private Jedis getConnection() {
        return (Jedis)this.pool.getResource();
    }

    private BinaryClient sendCommand(Jedis conn, Command command, byte[] ... args) {
        Client client = conn.getClient();
        client.sendCommand((ProtocolCommand)command, args);
        return client;
    }

    private static JedisPoolConfig initPoolConfig(int poolSize) {
        JedisPoolConfig conf = new JedisPoolConfig();
        conf.setMaxTotal(poolSize);
        conf.setTestOnBorrow(false);
        conf.setTestOnReturn(false);
        conf.setTestOnCreate(false);
        conf.setTestWhileIdle(false);
        conf.setMinEvictableIdleTimeMillis(60000L);
        conf.setTimeBetweenEvictionRunsMillis(30000L);
        conf.setNumTestsPerEvictionRun(-1);
        conf.setFairness(true);
        return conf;
    }
}

