/*
 * Decompiled with CFR 0.152.
 */
package com.redislabs.redistimeseries;

import com.redislabs.redistimeseries.Aggregation;
import com.redislabs.redistimeseries.Keyword;
import com.redislabs.redistimeseries.Value;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.util.SafeEncoder;

public class Range {
    private final String key;
    private final Map<String, String> labels;
    private final Value[] values;

    public Range(String key, Map<String, String> labels, Value[] values) {
        this.key = key;
        this.labels = labels;
        this.values = values;
    }

    public String getKey() {
        return this.key;
    }

    public Map<String, String> getLabels() {
        return this.labels;
    }

    public Value[] getValues() {
        return this.values;
    }

    protected static Value[] parseRange(List<Object> range) {
        Value[] values = new Value[range.size()];
        for (int i = 0; i < values.length; ++i) {
            List tuple = (List)range.get(i);
            values[i] = Value.parseValue(tuple);
        }
        return values;
    }

    private static Map<String, String> getLabelsStringStringMap(List<?> resLabels) {
        HashMap<String, String> rangeLabels = new HashMap<String, String>(resLabels.size());
        for (Object resLabel : resLabels) {
            List label = (List)resLabel;
            rangeLabels.put(SafeEncoder.encode((byte[])((byte[])label.get(0))), SafeEncoder.encode((byte[])((byte[])label.get(1))));
        }
        return rangeLabels;
    }

    protected static Range[] parseRanges(List<?> result) {
        Range[] ranges = new Range[result.size()];
        for (int j = 0; j < ranges.length; ++j) {
            List series = (List)result.get(j);
            String resKey = SafeEncoder.encode((byte[])((byte[])series.get(0)));
            List resLabels = (List)series.get(1);
            Map<String, String> rangeLabels = Range.getLabelsStringStringMap(resLabels);
            Value[] values = Range.parseRange((List)series.get(2));
            ranges[j] = new Range(resKey, rangeLabels, values);
        }
        return ranges;
    }

    protected static Range[] parseMget(List<?> result) {
        Range[] ranges = new Range[result.size()];
        for (int j = 0; j < ranges.length; ++j) {
            List series = (List)result.get(j);
            String resKey = SafeEncoder.encode((byte[])((byte[])series.get(0)));
            List resLabels = (List)series.get(1);
            Map<String, String> rangeLabels = Range.getLabelsStringStringMap(resLabels);
            List tuple = (List)series.get(2);
            Value[] values = tuple.isEmpty() ? new Value[]{} : new Value[]{Value.parseValue(tuple)};
            ranges[j] = new Range(resKey, rangeLabels, values);
        }
        return ranges;
    }

    protected static byte[][] multiRangeArgs(long from, long to, Aggregation aggregation, long timeBucket, boolean withLabels, Integer count, String[] filters) {
        byte[][] args = new byte[2 + (filters == null ? 0 : 1 + filters.length) + (aggregation == null ? 0 : 3) + (withLabels ? 1 : 0) + (count == null ? 0 : 2)][];
        int i = 0;
        args[i++] = Protocol.toByteArray((long)from);
        args[i++] = Protocol.toByteArray((long)to);
        if (aggregation != null) {
            args[i++] = Keyword.AGGREGATION.getRaw();
            args[i++] = aggregation.getRaw();
            args[i++] = Protocol.toByteArray((long)timeBucket);
        }
        if (withLabels) {
            args[i++] = Keyword.WITHLABELS.getRaw();
        }
        if (count != null) {
            args[i++] = Keyword.COUNT.getRaw();
            args[i++] = Protocol.toByteArray((int)count);
        }
        if (filters != null) {
            args[i++] = Keyword.FILTER.getRaw();
            for (String label : filters) {
                args[i++] = SafeEncoder.encode((String)label);
            }
        }
        return args;
    }
}

