/*
 * Decompiled with CFR 0.152.
 */
package com.redislabs.redistimeseries;

import com.redislabs.redistimeseries.Aggregation;
import com.redislabs.redistimeseries.Command;
import com.redislabs.redistimeseries.Keyword;
import com.redislabs.redistimeseries.Measurement;
import com.redislabs.redistimeseries.Range;
import com.redislabs.redistimeseries.Value;
import com.redislabs.redistimeseries.information.Info;
import java.util.List;
import java.util.Map;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.BinaryClient;
import redis.clients.jedis.Client;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.commands.ProtocolCommand;
import redis.clients.jedis.util.Pool;
import redis.clients.jedis.util.SafeEncoder;

public class RedisTimeSeries {
    private static final byte[] STAR = SafeEncoder.encode((String)"*");
    private final Pool<Jedis> pool;

    public RedisTimeSeries() {
        this("localhost", 6379);
    }

    public RedisTimeSeries(String host, int port) {
        this(host, port, 500, 100);
    }

    public RedisTimeSeries(String host, int port, int timeout, int poolSize) {
        this(host, port, timeout, poolSize, null);
    }

    public RedisTimeSeries(String host, int port, int timeout, int poolSize, String password) {
        this((Pool<Jedis>)new JedisPool((GenericObjectPoolConfig)RedisTimeSeries.initPoolConfig(poolSize), host, port, timeout, password));
    }

    public RedisTimeSeries(Pool<Jedis> pool) {
        this.pool = pool;
    }

    public boolean create(String key) {
        try (Jedis conn = this.getConnection();){
            byte[][] args = RedisTimeSeries.tsCreateArgs(key, null, false, null);
            boolean bl = this.sendCommand(conn, Command.CREATE, args).getStatusCodeReply().equals("OK");
            return bl;
        }
    }

    public boolean create(String key, long retentionTime) {
        return this.create(key, retentionTime, false, null);
    }

    public boolean create(String key, Map<String, String> labels) {
        try (Jedis conn = this.getConnection();){
            byte[][] args = RedisTimeSeries.tsCreateArgs(key, null, false, labels);
            boolean bl = this.sendCommand(conn, Command.CREATE, args).getStatusCodeReply().equals("OK");
            return bl;
        }
    }

    public boolean create(String key, long retentionTime, Map<String, String> labels) {
        return this.create(key, retentionTime, false, labels);
    }

    public boolean create(String key, long retentionTime, boolean uncompressed, Map<String, String> labels) {
        try (Jedis conn = this.getConnection();){
            byte[][] args = RedisTimeSeries.tsCreateArgs(key, retentionTime, uncompressed, labels);
            boolean bl = this.sendCommand(conn, Command.CREATE, args).getStatusCodeReply().equals("OK");
            return bl;
        }
    }

    private static byte[][] tsCreateArgs(String key, Long retentionTime, boolean uncompressed, Map<String, String> labels) {
        byte[][] args = new byte[1 + (labels == null ? 0 : 2 * labels.size() + 1) + (retentionTime != null ? 2 : 0) + (uncompressed ? 1 : 0)][];
        int i = 0;
        args[i++] = SafeEncoder.encode((String)key);
        if (retentionTime != null) {
            args[i++] = Keyword.RETENTION.getRaw();
            args[i++] = Protocol.toByteArray((long)retentionTime);
        }
        if (uncompressed) {
            args[i++] = Keyword.UNCOMPRESSED.getRaw();
        }
        if (labels != null) {
            args[i++] = Keyword.LABELS.getRaw();
            for (Map.Entry<String, String> e : labels.entrySet()) {
                args[i++] = SafeEncoder.encode((String)e.getKey());
                args[i++] = SafeEncoder.encode((String)e.getValue());
            }
        }
        return args;
    }

    public boolean alter(String key, Map<String, String> labels) {
        try (Jedis conn = this.getConnection();){
            byte[][] args = RedisTimeSeries.tsAlterArgs(key, null, labels);
            boolean bl = this.sendCommand(conn, Command.ALTER, args).getStatusCodeReply().equals("OK");
            return bl;
        }
    }

    public boolean alter(String key, long retentionTime, Map<String, String> labels) {
        try (Jedis conn = this.getConnection();){
            byte[][] args = RedisTimeSeries.tsAlterArgs(key, retentionTime, labels);
            boolean bl = this.sendCommand(conn, Command.ALTER, args).getStatusCodeReply().equals("OK");
            return bl;
        }
    }

    private static byte[][] tsAlterArgs(String key, Long retentionTime, Map<String, String> labels) {
        byte[][] args = new byte[1 + (retentionTime != null ? 2 : 0) + (labels == null ? 0 : 2 * labels.size() + 1)][];
        int i = 0;
        args[i++] = SafeEncoder.encode((String)key);
        if (retentionTime != null) {
            args[i++] = Keyword.RETENTION.getRaw();
            args[i++] = Protocol.toByteArray((long)retentionTime);
        }
        if (labels != null) {
            args[i++] = Keyword.LABELS.getRaw();
            for (Map.Entry<String, String> e : labels.entrySet()) {
                args[i++] = SafeEncoder.encode((String)e.getKey());
                args[i++] = SafeEncoder.encode((String)e.getValue());
            }
        }
        return args;
    }

    public boolean createRule(String sourceKey, Aggregation aggregation, long bucketSize, String destKey) {
        try (Jedis conn = this.getConnection();){
            boolean bl = this.sendCommand(conn, Command.CREATE_RULE, SafeEncoder.encode((String)sourceKey), SafeEncoder.encode((String)destKey), Keyword.AGGREGATION.getRaw(), aggregation.getRaw(), Protocol.toByteArray((long)bucketSize)).getStatusCodeReply().equals("OK");
            return bl;
        }
    }

    public boolean deleteRule(String sourceKey, String destKey) {
        try (Jedis conn = this.getConnection();){
            boolean bl = this.sendCommand(conn, Command.DELETE_RULE, SafeEncoder.encode((String)sourceKey), SafeEncoder.encode((String)destKey)).getStatusCodeReply().equals("OK");
            return bl;
        }
    }

    public long add(String sourceKey, double value) {
        try (Jedis conn = this.getConnection();){
            byte[][] args = RedisTimeSeries.tsAddArgs(sourceKey, null, value, null, false, null);
            long l = this.sendCommand(conn, Command.ADD, args).getIntegerReply();
            return l;
        }
    }

    public long add(String sourceKey, long timestamp, double value) {
        try (Jedis conn = this.getConnection();){
            byte[][] args = RedisTimeSeries.tsAddArgs(sourceKey, timestamp, value, null, false, null);
            long l = this.sendCommand(conn, Command.ADD, args).getIntegerReply();
            return l;
        }
    }

    public long add(String sourceKey, long timestamp, double value, long retentionTime) {
        return this.add(sourceKey, timestamp, value, retentionTime, false, null);
    }

    public long add(String sourceKey, double value, long retentionTime) {
        try (Jedis conn = this.getConnection();){
            byte[][] args = RedisTimeSeries.tsAddArgs(sourceKey, null, value, retentionTime, false, null);
            long l = this.sendCommand(conn, Command.ADD, args).getIntegerReply();
            return l;
        }
    }

    public long add(String sourceKey, long timestamp, double value, Map<String, String> labels) {
        try (Jedis conn = this.getConnection();){
            byte[][] args = RedisTimeSeries.tsAddArgs(sourceKey, timestamp, value, null, false, labels);
            long l = this.sendCommand(conn, Command.ADD, args).getIntegerReply();
            return l;
        }
    }

    public long add(String sourceKey, long timestamp, double value, long retentionTime, Map<String, String> labels) {
        try (Jedis conn = this.getConnection();){
            byte[][] args = RedisTimeSeries.tsAddArgs(sourceKey, timestamp, value, retentionTime, false, labels);
            long l = this.sendCommand(conn, Command.ADD, args).getIntegerReply();
            return l;
        }
    }

    public long add(String sourceKey, long timestamp, double value, long retentionTime, boolean uncompressed, Map<String, String> labels) {
        try (Jedis conn = this.getConnection();){
            byte[][] args = RedisTimeSeries.tsAddArgs(sourceKey, timestamp, value, retentionTime, uncompressed, labels);
            long l = this.sendCommand(conn, Command.ADD, args).getIntegerReply();
            return l;
        }
    }

    private static byte[][] tsAddArgs(String sourceKey, Long timestamp, double value, Long retentionTime, boolean uncompressed, Map<String, String> labels) {
        byte[][] args = new byte[3 + (retentionTime != null ? 2 : 0) + (labels == null ? 0 : 2 * labels.size() + 1) + (uncompressed ? 1 : 0)][];
        int i = 0;
        args[i++] = SafeEncoder.encode((String)sourceKey);
        args[i++] = timestamp != null ? Protocol.toByteArray((long)timestamp) : STAR;
        args[i++] = Protocol.toByteArray((double)value);
        if (retentionTime != null) {
            args[i++] = Keyword.RETENTION.getRaw();
            args[i++] = Protocol.toByteArray((long)retentionTime);
        }
        if (uncompressed) {
            args[i++] = Keyword.UNCOMPRESSED.getRaw();
        }
        if (labels != null) {
            args[i++] = Keyword.LABELS.getRaw();
            for (Map.Entry<String, String> e : labels.entrySet()) {
                args[i++] = SafeEncoder.encode((String)e.getKey());
                args[i++] = SafeEncoder.encode((String)e.getValue());
            }
        }
        return args;
    }

    public List<Object> madd(Measurement ... measurements) {
        try (Jedis conn = this.getConnection();){
            byte[][] args = new byte[measurements.length * 3][];
            for (int i = 0; i < measurements.length; ++i) {
                int argsIndx = i * 3;
                args[argsIndx] = SafeEncoder.encode((String)measurements[i].getSourceKey());
                long timestamp = measurements[i].getTimestamp();
                args[argsIndx + 1] = timestamp > 0L ? Protocol.toByteArray((long)timestamp) : STAR;
                args[argsIndx + 2] = Protocol.toByteArray((double)measurements[i].getValue());
            }
            List list = this.sendCommand(conn, Command.MADD, args).getObjectMultiBulkReply();
            return list;
        }
    }

    private Value[] range(Command command, byte[] ... args) {
        try (Jedis conn = this.getConnection();){
            List range = this.sendCommand(conn, command, args).getObjectMultiBulkReply();
            Value[] valueArray = Range.parseRange(range);
            return valueArray;
        }
    }

    public Value[] range(String key, long from, long to) {
        return this.range(Command.RANGE, SafeEncoder.encode((String)key), Protocol.toByteArray((long)from), Protocol.toByteArray((long)to));
    }

    public Value[] range(String key, long from, long to, int count) {
        return this.range(Command.RANGE, SafeEncoder.encode((String)key), Protocol.toByteArray((long)from), Protocol.toByteArray((long)to), Keyword.COUNT.getRaw(), Protocol.toByteArray((int)count));
    }

    public Value[] range(String key, long from, long to, Aggregation aggregation, long timeBucket) {
        return this.range(Command.RANGE, SafeEncoder.encode((String)key), Protocol.toByteArray((long)from), Protocol.toByteArray((long)to), Keyword.AGGREGATION.getRaw(), aggregation.getRaw(), Protocol.toByteArray((long)timeBucket));
    }

    public Value[] range(String key, long from, long to, Aggregation aggregation, long timeBucket, int count) {
        return this.range(Command.RANGE, SafeEncoder.encode((String)key), Protocol.toByteArray((long)from), Protocol.toByteArray((long)to), Keyword.AGGREGATION.getRaw(), aggregation.getRaw(), Protocol.toByteArray((long)timeBucket), Keyword.COUNT.getRaw(), Protocol.toByteArray((int)count));
    }

    public Value[] revrange(String key, long from, long to) {
        return this.range(Command.REVRANGE, SafeEncoder.encode((String)key), Protocol.toByteArray((long)from), Protocol.toByteArray((long)to));
    }

    public Value[] revrange(String key, long from, long to, int count) {
        return this.range(Command.REVRANGE, SafeEncoder.encode((String)key), Protocol.toByteArray((long)from), Protocol.toByteArray((long)to), Keyword.COUNT.getRaw(), Protocol.toByteArray((int)count));
    }

    public Value[] revrange(String key, long from, long to, Aggregation aggregation, long timeBucket) {
        return this.range(Command.REVRANGE, SafeEncoder.encode((String)key), Protocol.toByteArray((long)from), Protocol.toByteArray((long)to), Keyword.AGGREGATION.getRaw(), aggregation.getRaw(), Protocol.toByteArray((long)timeBucket));
    }

    public Value[] revrange(String key, long from, long to, Aggregation aggregation, long timeBucket, int count) {
        return this.range(Command.REVRANGE, SafeEncoder.encode((String)key), Protocol.toByteArray((long)from), Protocol.toByteArray((long)to), Keyword.AGGREGATION.getRaw(), aggregation.getRaw(), Protocol.toByteArray((long)timeBucket), Keyword.COUNT.getRaw(), Protocol.toByteArray((int)count));
    }

    public Range[] mrange(long from, long to, String ... filters) {
        return this.multiRange(Command.MRANGE, from, to, null, 0L, false, null, filters);
    }

    public Range[] mrange(long from, long to, int count, String ... filters) {
        return this.multiRange(Command.MRANGE, from, to, null, 0L, false, count, filters);
    }

    public Range[] mrange(long from, long to, Aggregation aggregation, long timeBucket, String ... filters) {
        return this.multiRange(Command.MRANGE, from, to, aggregation, timeBucket, false, null, filters);
    }

    public Range[] mrange(long from, long to, Aggregation aggregation, long timeBucket, boolean withLabels, String ... filters) {
        return this.multiRange(Command.MRANGE, from, to, aggregation, timeBucket, withLabels, null, filters);
    }

    public Range[] mrange(long from, long to, Aggregation aggregation, long timeBucket, boolean withLabels, int count, String ... filters) {
        return this.multiRange(Command.MRANGE, from, to, aggregation, timeBucket, withLabels, count, filters);
    }

    private Range[] multiRange(Command command, long from, long to, Aggregation aggregation, long timeBucket, boolean withLabels, Integer count, String ... filters) {
        try (Jedis conn = this.getConnection();){
            byte[][] args = Range.multiRangeArgs(from, to, aggregation, timeBucket, withLabels, count, filters);
            List result = this.sendCommand(conn, command, args).getObjectMultiBulkReply();
            Range[] rangeArray = Range.parseRanges(result);
            return rangeArray;
        }
    }

    public Range[] mrevrange(long from, long to, String ... filters) {
        return this.mrevrange(from, to, null, 0L, filters);
    }

    public Range[] mrevrange(long from, long to, int count, String ... filters) {
        return this.mrevrange(from, to, null, 0L, false, count, filters);
    }

    public Range[] mrevrange(long from, long to, Aggregation aggregation, long timeBucket, String ... filters) {
        return this.mrevrange(from, to, aggregation, timeBucket, false, filters);
    }

    public Range[] mrevrange(long from, long to, Aggregation aggregation, long timeBucket, boolean withLabels, String ... filters) {
        return this.multiRange(Command.MREVRANGE, from, to, aggregation, timeBucket, withLabels, null, filters);
    }

    public Range[] mrevrange(long from, long to, Aggregation aggregation, long timeBucket, boolean withLabels, int count, String ... filters) {
        return this.multiRange(Command.MREVRANGE, from, to, aggregation, timeBucket, withLabels, count, filters);
    }

    public Value get(String key) {
        try (Jedis conn = this.getConnection();){
            List tuple = this.sendCommand(conn, Command.GET, new byte[][]{SafeEncoder.encode((String)key)}).getObjectMultiBulkReply();
            if (tuple.isEmpty()) {
                Value value = null;
                return value;
            }
            Value value = Value.parseValue(tuple);
            return value;
        }
    }

    public Range[] mget(boolean withLabels, String ... filters) {
        try (Jedis conn = this.getConnection();){
            byte[][] args = new byte[1 + (withLabels ? 1 : 0) + (filters == null ? 0 : filters.length)][];
            int i = 0;
            if (withLabels) {
                args[i++] = Keyword.WITHLABELS.getRaw();
            }
            args[i++] = Keyword.FILTER.getRaw();
            if (filters != null) {
                for (String label : filters) {
                    args[i++] = SafeEncoder.encode((String)label);
                }
            }
            List result = this.sendCommand(conn, Command.MGET, args).getObjectMultiBulkReply();
            Range[] rangeArray = Range.parseMget(result);
            return rangeArray;
        }
    }

    public long incrBy(String key, int value) {
        try (Jedis conn = this.getConnection();){
            long l = this.sendCommand(conn, Command.INCRBY, SafeEncoder.encode((String)key), Protocol.toByteArray((int)value)).getIntegerReply();
            return l;
        }
    }

    public long incrBy(String key, int value, long timestamp) {
        try (Jedis conn = this.getConnection();){
            long l = this.sendCommand(conn, Command.INCRBY, SafeEncoder.encode((String)key), Protocol.toByteArray((int)value), Keyword.TIMESTAMP.getRaw(), Protocol.toByteArray((long)timestamp)).getIntegerReply();
            return l;
        }
    }

    public long decrBy(String key, int value) {
        try (Jedis conn = this.getConnection();){
            long l = this.sendCommand(conn, Command.DECRBY, SafeEncoder.encode((String)key), Protocol.toByteArray((int)value)).getIntegerReply();
            return l;
        }
    }

    public long decrBy(String key, int value, long timestamp) {
        try (Jedis conn = this.getConnection();){
            long l = this.sendCommand(conn, Command.DECRBY, SafeEncoder.encode((String)key), Protocol.toByteArray((int)value), Keyword.TIMESTAMP.getRaw(), Protocol.toByteArray((long)timestamp)).getIntegerReply();
            return l;
        }
    }

    public String[] queryIndex(String ... filters) {
        try (Jedis conn = this.getConnection();){
            List result = this.sendCommand(conn, Command.QUERYINDEX, SafeEncoder.encodeMany((String[])filters)).getMultiBulkReply();
            String[] stringArray = result.toArray(new String[result.size()]);
            return stringArray;
        }
    }

    public Info info(String key) {
        try (Jedis conn = this.getConnection();){
            List resp = this.sendCommand(conn, Command.INFO, new byte[][]{SafeEncoder.encode((String)key)}).getObjectMultiBulkReply();
            Info info = Info.parseInfoReply(resp);
            return info;
        }
    }

    private Jedis getConnection() {
        return (Jedis)this.pool.getResource();
    }

    private BinaryClient sendCommand(Jedis conn, Command command, byte[] ... args) {
        Client client = conn.getClient();
        client.sendCommand((ProtocolCommand)command, args);
        return client;
    }

    private static JedisPoolConfig initPoolConfig(int poolSize) {
        JedisPoolConfig conf = new JedisPoolConfig();
        conf.setMaxTotal(poolSize);
        conf.setTestOnBorrow(false);
        conf.setTestOnReturn(false);
        conf.setTestOnCreate(false);
        conf.setTestWhileIdle(false);
        conf.setMinEvictableIdleTimeMillis(60000L);
        conf.setTimeBetweenEvictionRunsMillis(30000L);
        conf.setNumTestsPerEvictionRun(-1);
        conf.setFairness(true);
        return conf;
    }
}

