/*
 * Decompiled with CFR 0.152.
 */
package com.redislabs.redistimeseries.information;

import com.redislabs.redistimeseries.Aggregation;
import com.redislabs.redistimeseries.information.Rule;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import redis.clients.jedis.util.SafeEncoder;

public class Info {
    private final Map<String, Long> properties;
    private final Map<String, String> labels;
    private final Map<String, Rule> rules;

    public Info(Map<String, Long> properties, Map<String, String> labels, Map<String, Rule> rules) {
        this.properties = properties;
        this.labels = labels;
        this.rules = rules;
    }

    public Long getProperty(String property) {
        return this.properties.get(property);
    }

    public String getLabel(String label) {
        return this.labels.get(label);
    }

    public Rule getRule(String rule) {
        return this.rules.get(rule);
    }

    public static Info parseInfoReply(List<Object> resp) {
        HashMap<String, Long> properties = new HashMap<String, Long>();
        HashMap<String, String> labels = new HashMap<String, String>();
        HashMap<String, Rule> rules = new HashMap<String, Rule>();
        for (int i = 0; i < resp.size(); i += 2) {
            String prop = SafeEncoder.encode((byte[])((byte[])resp.get(i)));
            Object value = resp.get(i + 1);
            if (value instanceof Long) {
                properties.put(prop, (Long)value);
                continue;
            }
            if (prop.equals("labels")) {
                List labelsList = (List)value;
                for (List labelBytes : labelsList) {
                    labels.put(SafeEncoder.encode((byte[])((byte[])labelBytes.get(0))), SafeEncoder.encode((byte[])((byte[])labelBytes.get(1))));
                }
                continue;
            }
            if (!prop.equals("rules")) continue;
            List rulesList = (List)value;
            for (List ruleBytes : rulesList) {
                String target = SafeEncoder.encode((byte[])((byte[])ruleBytes.get(0)));
                String agg = SafeEncoder.encode((byte[])((byte[])ruleBytes.get(2)));
                rules.put(target, new Rule(target, (Long)ruleBytes.get(1), Aggregation.valueOf(agg)));
            }
        }
        return new Info(properties, labels, rules);
    }
}

