package com.redislabs.lettusearch;

import static com.redislabs.lettusearch.impl.protocol.CommandKeyword.FUZZY;
import static com.redislabs.lettusearch.impl.protocol.CommandKeyword.MAX;
import static com.redislabs.lettusearch.impl.protocol.CommandKeyword.WITHPAYLOADS;
import static com.redislabs.lettusearch.impl.protocol.CommandKeyword.WITHSCORES;

import com.redislabs.lettusearch.RediSearchArgument;
import com.redislabs.lettusearch.impl.protocol.RediSearchCommandArgs;

import lombok.Builder;
import lombok.Data;

@Data
@Builder
public class SuggetOptions implements RediSearchArgument {

	private boolean fuzzy;
	private boolean withScores;
	private boolean withPayloads;
	private Long max;

	@Override
	public <K, V> void build(RediSearchCommandArgs<K, V> args) {
		if (fuzzy) {
			args.add(FUZZY);
		}
		if (withScores) {
			args.add(WITHSCORES);
		}
		if (withPayloads) {
			args.add(WITHPAYLOADS);
		}
		if (max != null) {
			args.add(MAX);
			args.add(max);
		}
	}

}
