/*
 * Decompiled with CFR 0.152.
 */
package com.redislabs.lettusearch;

import com.redislabs.lettusearch.RediSearchArgument;
import com.redislabs.lettusearch.impl.protocol.CommandKeyword;
import com.redislabs.lettusearch.impl.protocol.RediSearchCommandArgs;
import io.lettuce.core.internal.LettuceAssert;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class AggregateOptions
implements RediSearchArgument {
    private List<String> loads;
    private List<Operation> operations;

    @Override
    public <K, V> void build(RediSearchCommandArgs<K, V> args) {
        if (!this.loads.isEmpty()) {
            args.add(CommandKeyword.LOAD);
            args.add(this.loads.size());
            this.loads.forEach(args::addProperty);
        }
        this.operations.forEach(o -> o.build(args));
    }

    AggregateOptions(List<String> loads, List<Operation> operations) {
        this.loads = loads;
        this.operations = operations;
    }

    public static AggregateOptionsBuilder builder() {
        return new AggregateOptionsBuilder();
    }

    public List<String> getLoads() {
        return this.loads;
    }

    public List<Operation> getOperations() {
        return this.operations;
    }

    public void setLoads(List<String> loads) {
        this.loads = loads;
    }

    public void setOperations(List<Operation> operations) {
        this.operations = operations;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AggregateOptions)) {
            return false;
        }
        AggregateOptions other = (AggregateOptions)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<String> this$loads = this.getLoads();
        List<String> other$loads = other.getLoads();
        if (this$loads == null ? other$loads != null : !((Object)this$loads).equals(other$loads)) {
            return false;
        }
        List<Operation> this$operations = this.getOperations();
        List<Operation> other$operations = other.getOperations();
        return !(this$operations == null ? other$operations != null : !((Object)this$operations).equals(other$operations));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AggregateOptions;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $loads = this.getLoads();
        result = result * 59 + ($loads == null ? 43 : ((Object)$loads).hashCode());
        List<Operation> $operations = this.getOperations();
        result = result * 59 + ($operations == null ? 43 : ((Object)$operations).hashCode());
        return result;
    }

    public String toString() {
        return "AggregateOptions(loads=" + this.getLoads() + ", operations=" + this.getOperations() + ")";
    }

    public static interface Operation
    extends RediSearchArgument {

        public static enum Order {
            Asc,
            Desc;

        }

        public static class SortBy
        implements Operation {
            private List<Property> properties;
            private Long max;

            @Override
            public <K, V> void build(RediSearchCommandArgs<K, V> args) {
                args.add(CommandKeyword.SORTBY);
                args.add(this.properties.size() * 2);
                this.properties.forEach(property -> property.build(args));
                if (this.max != null) {
                    args.add(CommandKeyword.MAX);
                    args.add(this.max);
                }
            }

            SortBy(List<Property> properties, Long max) {
                this.properties = properties;
                this.max = max;
            }

            public static SortByBuilder builder() {
                return new SortByBuilder();
            }

            public List<Property> getProperties() {
                return this.properties;
            }

            public Long getMax() {
                return this.max;
            }

            public void setProperties(List<Property> properties) {
                this.properties = properties;
            }

            public void setMax(Long max) {
                this.max = max;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof SortBy)) {
                    return false;
                }
                SortBy other = (SortBy)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$max = this.getMax();
                Long other$max = other.getMax();
                if (this$max == null ? other$max != null : !((Object)this$max).equals(other$max)) {
                    return false;
                }
                List<Property> this$properties = this.getProperties();
                List<Property> other$properties = other.getProperties();
                return !(this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties));
            }

            protected boolean canEqual(Object other) {
                return other instanceof SortBy;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $max = this.getMax();
                result = result * 59 + ($max == null ? 43 : ((Object)$max).hashCode());
                List<Property> $properties = this.getProperties();
                result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
                return result;
            }

            public String toString() {
                return "AggregateOptions.Operation.SortBy(properties=" + this.getProperties() + ", max=" + this.getMax() + ")";
            }

            public static class SortByBuilder {
                private ArrayList<Property> properties;
                private Long max;

                SortByBuilder() {
                }

                public SortByBuilder property(Property property) {
                    if (this.properties == null) {
                        this.properties = new ArrayList();
                    }
                    this.properties.add(property);
                    return this;
                }

                public SortByBuilder properties(Collection<? extends Property> properties) {
                    if (properties == null) {
                        throw new NullPointerException("properties cannot be null");
                    }
                    if (this.properties == null) {
                        this.properties = new ArrayList();
                    }
                    this.properties.addAll(properties);
                    return this;
                }

                public SortByBuilder clearProperties() {
                    if (this.properties != null) {
                        this.properties.clear();
                    }
                    return this;
                }

                public SortByBuilder max(Long max) {
                    this.max = max;
                    return this;
                }

                public SortBy build() {
                    List<Property> properties;
                    switch (this.properties == null ? 0 : this.properties.size()) {
                        case 0: {
                            properties = Collections.emptyList();
                            break;
                        }
                        case 1: {
                            properties = Collections.singletonList(this.properties.get(0));
                            break;
                        }
                        default: {
                            properties = Collections.unmodifiableList(new ArrayList<Property>(this.properties));
                        }
                    }
                    return new SortBy(properties, this.max);
                }

                public String toString() {
                    return "AggregateOptions.Operation.SortBy.SortByBuilder(properties=" + this.properties + ", max=" + this.max + ")";
                }
            }

            public static class Property
            implements RediSearchArgument {
                public static final Order DEFAULT_ORDER = Order.Asc;
                private String property;
                private Order order;

                @Override
                public <K, V> void build(RediSearchCommandArgs<K, V> args) {
                    args.addProperty(this.property);
                    args.add(this.order == Order.Asc ? CommandKeyword.ASC : CommandKeyword.DESC);
                }

                private static Order $default$order() {
                    return DEFAULT_ORDER;
                }

                Property(String property, Order order) {
                    this.property = property;
                    this.order = order;
                }

                public static PropertyBuilder builder() {
                    return new PropertyBuilder();
                }

                public String getProperty() {
                    return this.property;
                }

                public Order getOrder() {
                    return this.order;
                }

                public void setProperty(String property) {
                    this.property = property;
                }

                public void setOrder(Order order) {
                    this.order = order;
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Property)) {
                        return false;
                    }
                    Property other = (Property)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$property = this.getProperty();
                    String other$property = other.getProperty();
                    if (this$property == null ? other$property != null : !this$property.equals(other$property)) {
                        return false;
                    }
                    Order this$order = this.getOrder();
                    Order other$order = other.getOrder();
                    return !(this$order == null ? other$order != null : !((Object)((Object)this$order)).equals((Object)other$order));
                }

                protected boolean canEqual(Object other) {
                    return other instanceof Property;
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $property = this.getProperty();
                    result = result * 59 + ($property == null ? 43 : $property.hashCode());
                    Order $order = this.getOrder();
                    result = result * 59 + ($order == null ? 43 : ((Object)((Object)$order)).hashCode());
                    return result;
                }

                public String toString() {
                    return "AggregateOptions.Operation.SortBy.Property(property=" + this.getProperty() + ", order=" + (Object)((Object)this.getOrder()) + ")";
                }

                public static class PropertyBuilder {
                    private String property;
                    private boolean order$set;
                    private Order order$value;

                    PropertyBuilder() {
                    }

                    public PropertyBuilder property(String property) {
                        this.property = property;
                        return this;
                    }

                    public PropertyBuilder order(Order order) {
                        this.order$value = order;
                        this.order$set = true;
                        return this;
                    }

                    public Property build() {
                        Order order$value = this.order$value;
                        if (!this.order$set) {
                            order$value = Property.$default$order();
                        }
                        return new Property(this.property, order$value);
                    }

                    public String toString() {
                        return "AggregateOptions.Operation.SortBy.Property.PropertyBuilder(property=" + this.property + ", order$value=" + (Object)((Object)this.order$value) + ")";
                    }
                }
            }
        }

        public static class Limit
        implements Operation {
            private long offset;
            private long num;

            @Override
            public <K, V> void build(RediSearchCommandArgs<K, V> args) {
                args.add(CommandKeyword.LIMIT);
                args.add(this.offset);
                args.add(this.num);
            }

            Limit(long offset, long num) {
                this.offset = offset;
                this.num = num;
            }

            public static LimitBuilder builder() {
                return new LimitBuilder();
            }

            public long getOffset() {
                return this.offset;
            }

            public long getNum() {
                return this.num;
            }

            public void setOffset(long offset) {
                this.offset = offset;
            }

            public void setNum(long num) {
                this.num = num;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Limit)) {
                    return false;
                }
                Limit other = (Limit)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                if (this.getOffset() != other.getOffset()) {
                    return false;
                }
                return this.getNum() == other.getNum();
            }

            protected boolean canEqual(Object other) {
                return other instanceof Limit;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                long $offset = this.getOffset();
                result = result * 59 + (int)($offset >>> 32 ^ $offset);
                long $num = this.getNum();
                result = result * 59 + (int)($num >>> 32 ^ $num);
                return result;
            }

            public String toString() {
                return "AggregateOptions.Operation.Limit(offset=" + this.getOffset() + ", num=" + this.getNum() + ")";
            }

            public static class LimitBuilder {
                private long offset;
                private long num;

                LimitBuilder() {
                }

                public LimitBuilder offset(long offset) {
                    this.offset = offset;
                    return this;
                }

                public LimitBuilder num(long num) {
                    this.num = num;
                    return this;
                }

                public Limit build() {
                    return new Limit(this.offset, this.num);
                }

                public String toString() {
                    return "AggregateOptions.Operation.Limit.LimitBuilder(offset=" + this.offset + ", num=" + this.num + ")";
                }
            }
        }

        public static class GroupBy
        implements Operation {
            private List<String> properties;
            private List<Reducer> reducers;

            @Override
            public <K, V> void build(RediSearchCommandArgs<K, V> args) {
                args.add(CommandKeyword.GROUPBY);
                args.add(this.properties.size());
                this.properties.forEach(args::addProperty);
                this.reducers.forEach(reducer -> reducer.build(args));
            }

            GroupBy(List<String> properties, List<Reducer> reducers) {
                this.properties = properties;
                this.reducers = reducers;
            }

            public static GroupByBuilder builder() {
                return new GroupByBuilder();
            }

            public List<String> getProperties() {
                return this.properties;
            }

            public List<Reducer> getReducers() {
                return this.reducers;
            }

            public void setProperties(List<String> properties) {
                this.properties = properties;
            }

            public void setReducers(List<Reducer> reducers) {
                this.reducers = reducers;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof GroupBy)) {
                    return false;
                }
                GroupBy other = (GroupBy)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                List<String> this$properties = this.getProperties();
                List<String> other$properties = other.getProperties();
                if (this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties)) {
                    return false;
                }
                List<Reducer> this$reducers = this.getReducers();
                List<Reducer> other$reducers = other.getReducers();
                return !(this$reducers == null ? other$reducers != null : !((Object)this$reducers).equals(other$reducers));
            }

            protected boolean canEqual(Object other) {
                return other instanceof GroupBy;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                List<String> $properties = this.getProperties();
                result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
                List<Reducer> $reducers = this.getReducers();
                result = result * 59 + ($reducers == null ? 43 : ((Object)$reducers).hashCode());
                return result;
            }

            public String toString() {
                return "AggregateOptions.Operation.GroupBy(properties=" + this.getProperties() + ", reducers=" + this.getReducers() + ")";
            }

            public static class GroupByBuilder {
                private ArrayList<String> properties;
                private ArrayList<Reducer> reducers;

                GroupByBuilder() {
                }

                public GroupByBuilder property(String property) {
                    if (this.properties == null) {
                        this.properties = new ArrayList();
                    }
                    this.properties.add(property);
                    return this;
                }

                public GroupByBuilder properties(Collection<? extends String> properties) {
                    if (properties == null) {
                        throw new NullPointerException("properties cannot be null");
                    }
                    if (this.properties == null) {
                        this.properties = new ArrayList();
                    }
                    this.properties.addAll(properties);
                    return this;
                }

                public GroupByBuilder clearProperties() {
                    if (this.properties != null) {
                        this.properties.clear();
                    }
                    return this;
                }

                public GroupByBuilder reducer(Reducer reducer) {
                    if (this.reducers == null) {
                        this.reducers = new ArrayList();
                    }
                    this.reducers.add(reducer);
                    return this;
                }

                public GroupByBuilder reducers(Collection<? extends Reducer> reducers) {
                    if (reducers == null) {
                        throw new NullPointerException("reducers cannot be null");
                    }
                    if (this.reducers == null) {
                        this.reducers = new ArrayList();
                    }
                    this.reducers.addAll(reducers);
                    return this;
                }

                public GroupByBuilder clearReducers() {
                    if (this.reducers != null) {
                        this.reducers.clear();
                    }
                    return this;
                }

                public GroupBy build() {
                    List<Object> reducers;
                    List<String> properties;
                    switch (this.properties == null ? 0 : this.properties.size()) {
                        case 0: {
                            properties = Collections.emptyList();
                            break;
                        }
                        case 1: {
                            properties = Collections.singletonList(this.properties.get(0));
                            break;
                        }
                        default: {
                            properties = Collections.unmodifiableList(new ArrayList<String>(this.properties));
                        }
                    }
                    switch (this.reducers == null ? 0 : this.reducers.size()) {
                        case 0: {
                            reducers = Collections.emptyList();
                            break;
                        }
                        case 1: {
                            reducers = Collections.singletonList(this.reducers.get(0));
                            break;
                        }
                        default: {
                            reducers = Collections.unmodifiableList(new ArrayList<Reducer>(this.reducers));
                        }
                    }
                    return new GroupBy(properties, reducers);
                }

                public String toString() {
                    return "AggregateOptions.Operation.GroupBy.GroupByBuilder(properties=" + this.properties + ", reducers=" + this.reducers + ")";
                }
            }

            private static abstract class AbstractPropertyReducer
            extends Reducer {
                private String property;

                protected AbstractPropertyReducer(String as, String property) {
                    super(as);
                    this.property = property;
                }

                @Override
                protected <K, V> void buildFunction(RediSearchCommandArgs<K, V> args) {
                    this.buildFunction(args, this.property);
                }

                protected abstract <K, V> void buildFunction(RediSearchCommandArgs<K, V> var1, String var2);

                public String getProperty() {
                    return this.property;
                }

                public void setProperty(String property) {
                    this.property = property;
                }
            }

            public static abstract class Reducer
            implements RediSearchArgument {
                private String as;

                @Override
                public <K, V> void build(RediSearchCommandArgs<K, V> args) {
                    args.add(CommandKeyword.REDUCE);
                    this.buildFunction(args);
                    if (this.as != null) {
                        args.add(CommandKeyword.AS);
                        args.add(this.as);
                    }
                }

                protected abstract <K, V> void buildFunction(RediSearchCommandArgs<K, V> var1);

                public Reducer(String as) {
                    this.as = as;
                }

                public void setAs(String as) {
                    this.as = as;
                }

                public static class ToList
                extends AbstractPropertyReducer {
                    private ToList(String as, String property) {
                        super(as, property);
                    }

                    @Override
                    protected <K, V> void buildFunction(RediSearchCommandArgs<K, V> args, String property) {
                        args.add(CommandKeyword.TOLIST);
                        args.add(1L);
                        args.addProperty(property);
                    }

                    public static ToListBuilder builder() {
                        return new ToListBuilder();
                    }

                    public static class ToListBuilder {
                        private String as;
                        private String property;

                        ToListBuilder() {
                        }

                        public ToListBuilder as(String as) {
                            this.as = as;
                            return this;
                        }

                        public ToListBuilder property(String property) {
                            this.property = property;
                            return this;
                        }

                        public ToList build() {
                            return new ToList(this.as, this.property);
                        }

                        public String toString() {
                            return "AggregateOptions.Operation.GroupBy.Reducer.ToList.ToListBuilder(as=" + this.as + ", property=" + this.property + ")";
                        }
                    }
                }

                public static class Sum
                extends AbstractPropertyReducer {
                    private Sum(String as, String property) {
                        super(as, property);
                    }

                    @Override
                    protected <K, V> void buildFunction(RediSearchCommandArgs<K, V> args, String property) {
                        args.add(CommandKeyword.SUM);
                        args.add(1L);
                        args.addProperty(property);
                    }

                    public static SumBuilder builder() {
                        return new SumBuilder();
                    }

                    public static class SumBuilder {
                        private String as;
                        private String property;

                        SumBuilder() {
                        }

                        public SumBuilder as(String as) {
                            this.as = as;
                            return this;
                        }

                        public SumBuilder property(String property) {
                            this.property = property;
                            return this;
                        }

                        public Sum build() {
                            return new Sum(this.as, this.property);
                        }

                        public String toString() {
                            return "AggregateOptions.Operation.GroupBy.Reducer.Sum.SumBuilder(as=" + this.as + ", property=" + this.property + ")";
                        }
                    }
                }

                public static class StdDev
                extends AbstractPropertyReducer {
                    private StdDev(String as, String property) {
                        super(as, property);
                    }

                    @Override
                    protected <K, V> void buildFunction(RediSearchCommandArgs<K, V> args, String property) {
                        args.add(CommandKeyword.STDDEV);
                        args.add(1L);
                        args.addProperty(property);
                    }

                    public static StdDevBuilder builder() {
                        return new StdDevBuilder();
                    }

                    public static class StdDevBuilder {
                        private String as;
                        private String property;

                        StdDevBuilder() {
                        }

                        public StdDevBuilder as(String as) {
                            this.as = as;
                            return this;
                        }

                        public StdDevBuilder property(String property) {
                            this.property = property;
                            return this;
                        }

                        public StdDev build() {
                            return new StdDev(this.as, this.property);
                        }

                        public String toString() {
                            return "AggregateOptions.Operation.GroupBy.Reducer.StdDev.StdDevBuilder(as=" + this.as + ", property=" + this.property + ")";
                        }
                    }
                }

                public static class RandomSample
                extends AbstractPropertyReducer {
                    private int size;

                    private RandomSample(String as, String property, int size) {
                        super(as, property);
                        this.size = size;
                    }

                    @Override
                    protected <K, V> void buildFunction(RediSearchCommandArgs<K, V> args, String property) {
                        args.add(CommandKeyword.RANDOM_SAMPLE);
                        args.add(2L);
                        args.addProperty(property);
                        args.add(this.size);
                    }

                    public static RandomSampleBuilder builder() {
                        return new RandomSampleBuilder();
                    }

                    public int getSize() {
                        return this.size;
                    }

                    public void setSize(int size) {
                        this.size = size;
                    }

                    public static class RandomSampleBuilder {
                        private String as;
                        private String property;
                        private int size;

                        RandomSampleBuilder() {
                        }

                        public RandomSampleBuilder as(String as) {
                            this.as = as;
                            return this;
                        }

                        public RandomSampleBuilder property(String property) {
                            this.property = property;
                            return this;
                        }

                        public RandomSampleBuilder size(int size) {
                            this.size = size;
                            return this;
                        }

                        public RandomSample build() {
                            return new RandomSample(this.as, this.property, this.size);
                        }

                        public String toString() {
                            return "AggregateOptions.Operation.GroupBy.Reducer.RandomSample.RandomSampleBuilder(as=" + this.as + ", property=" + this.property + ", size=" + this.size + ")";
                        }
                    }
                }

                public static class Quantile
                extends AbstractPropertyReducer {
                    private double quantile;

                    private Quantile(String as, String property) {
                        super(as, property);
                    }

                    @Override
                    protected <K, V> void buildFunction(RediSearchCommandArgs<K, V> args, String property) {
                        args.add(CommandKeyword.QUANTILE);
                        args.add(2L);
                        args.addProperty(property);
                        args.add(this.quantile);
                    }

                    public static QuantileBuilder builder() {
                        return new QuantileBuilder();
                    }

                    public double getQuantile() {
                        return this.quantile;
                    }

                    public void setQuantile(double quantile) {
                        this.quantile = quantile;
                    }

                    public static class QuantileBuilder {
                        private String as;
                        private String property;

                        QuantileBuilder() {
                        }

                        public QuantileBuilder as(String as) {
                            this.as = as;
                            return this;
                        }

                        public QuantileBuilder property(String property) {
                            this.property = property;
                            return this;
                        }

                        public Quantile build() {
                            return new Quantile(this.as, this.property);
                        }

                        public String toString() {
                            return "AggregateOptions.Operation.GroupBy.Reducer.Quantile.QuantileBuilder(as=" + this.as + ", property=" + this.property + ")";
                        }
                    }
                }

                public static class Min
                extends AbstractPropertyReducer {
                    private Min(String as, String property) {
                        super(as, property);
                    }

                    @Override
                    protected <K, V> void buildFunction(RediSearchCommandArgs<K, V> args, String property) {
                        args.add(CommandKeyword.MIN);
                        args.add(1L);
                        args.addProperty(property);
                    }

                    public static MinBuilder builder() {
                        return new MinBuilder();
                    }

                    public static class MinBuilder {
                        private String as;
                        private String property;

                        MinBuilder() {
                        }

                        public MinBuilder as(String as) {
                            this.as = as;
                            return this;
                        }

                        public MinBuilder property(String property) {
                            this.property = property;
                            return this;
                        }

                        public Min build() {
                            return new Min(this.as, this.property);
                        }

                        public String toString() {
                            return "AggregateOptions.Operation.GroupBy.Reducer.Min.MinBuilder(as=" + this.as + ", property=" + this.property + ")";
                        }
                    }
                }

                public static class Max
                extends AbstractPropertyReducer {
                    private Max(String as, String property) {
                        super(as, property);
                    }

                    @Override
                    protected <K, V> void buildFunction(RediSearchCommandArgs<K, V> args, String property) {
                        args.add(CommandKeyword.MAX);
                        args.add(1L);
                        args.addProperty(property);
                    }

                    public static MaxBuilder builder() {
                        return new MaxBuilder();
                    }

                    public static class MaxBuilder {
                        private String as;
                        private String property;

                        MaxBuilder() {
                        }

                        public MaxBuilder as(String as) {
                            this.as = as;
                            return this;
                        }

                        public MaxBuilder property(String property) {
                            this.property = property;
                            return this;
                        }

                        public Max build() {
                            return new Max(this.as, this.property);
                        }

                        public String toString() {
                            return "AggregateOptions.Operation.GroupBy.Reducer.Max.MaxBuilder(as=" + this.as + ", property=" + this.property + ")";
                        }
                    }
                }

                public static class FirstValue
                extends AbstractPropertyReducer {
                    private By by;

                    private FirstValue(String as, String property, By by) {
                        super(as, property);
                        this.by = by;
                    }

                    @Override
                    protected <K, V> void buildFunction(RediSearchCommandArgs<K, V> args, String property) {
                        args.add(CommandKeyword.FIRST_VALUE);
                        args.add(this.getNumberOfArgs());
                        args.addProperty(property);
                        if (this.by != null) {
                            args.add(CommandKeyword.BY);
                            args.addProperty(property);
                            if (this.by.getOrder() != null) {
                                args.add(this.by.getOrder() == Order.Asc ? CommandKeyword.ASC : CommandKeyword.DESC);
                            }
                        }
                    }

                    private int getNumberOfArgs() {
                        int nargs = 1;
                        if (this.by != null) {
                            nargs += this.by.getOrder() == null ? 2 : 3;
                        }
                        return nargs;
                    }

                    public static FirstValueBuilder builder() {
                        return new FirstValueBuilder();
                    }

                    public By getBy() {
                        return this.by;
                    }

                    public void setBy(By by) {
                        this.by = by;
                    }

                    public static class FirstValueBuilder {
                        private String as;
                        private String property;
                        private By by;

                        FirstValueBuilder() {
                        }

                        public FirstValueBuilder as(String as) {
                            this.as = as;
                            return this;
                        }

                        public FirstValueBuilder property(String property) {
                            this.property = property;
                            return this;
                        }

                        public FirstValueBuilder by(By by) {
                            this.by = by;
                            return this;
                        }

                        public FirstValue build() {
                            return new FirstValue(this.as, this.property, this.by);
                        }

                        public String toString() {
                            return "AggregateOptions.Operation.GroupBy.Reducer.FirstValue.FirstValueBuilder(as=" + this.as + ", property=" + this.property + ", by=" + this.by + ")";
                        }
                    }

                    public static class By {
                        private String property;
                        private Order order;

                        By(String property, Order order) {
                            this.property = property;
                            this.order = order;
                        }

                        public static ByBuilder builder() {
                            return new ByBuilder();
                        }

                        public String getProperty() {
                            return this.property;
                        }

                        public Order getOrder() {
                            return this.order;
                        }

                        public void setProperty(String property) {
                            this.property = property;
                        }

                        public void setOrder(Order order) {
                            this.order = order;
                        }

                        public boolean equals(Object o) {
                            if (o == this) {
                                return true;
                            }
                            if (!(o instanceof By)) {
                                return false;
                            }
                            By other = (By)o;
                            if (!other.canEqual(this)) {
                                return false;
                            }
                            String this$property = this.getProperty();
                            String other$property = other.getProperty();
                            if (this$property == null ? other$property != null : !this$property.equals(other$property)) {
                                return false;
                            }
                            Order this$order = this.getOrder();
                            Order other$order = other.getOrder();
                            return !(this$order == null ? other$order != null : !((Object)((Object)this$order)).equals((Object)other$order));
                        }

                        protected boolean canEqual(Object other) {
                            return other instanceof By;
                        }

                        public int hashCode() {
                            int PRIME = 59;
                            int result = 1;
                            String $property = this.getProperty();
                            result = result * 59 + ($property == null ? 43 : $property.hashCode());
                            Order $order = this.getOrder();
                            result = result * 59 + ($order == null ? 43 : ((Object)((Object)$order)).hashCode());
                            return result;
                        }

                        public String toString() {
                            return "AggregateOptions.Operation.GroupBy.Reducer.FirstValue.By(property=" + this.getProperty() + ", order=" + (Object)((Object)this.getOrder()) + ")";
                        }

                        public static class ByBuilder {
                            private String property;
                            private Order order;

                            ByBuilder() {
                            }

                            public ByBuilder property(String property) {
                                this.property = property;
                                return this;
                            }

                            public ByBuilder order(Order order) {
                                this.order = order;
                                return this;
                            }

                            public By build() {
                                return new By(this.property, this.order);
                            }

                            public String toString() {
                                return "AggregateOptions.Operation.GroupBy.Reducer.FirstValue.By.ByBuilder(property=" + this.property + ", order=" + (Object)((Object)this.order) + ")";
                            }
                        }
                    }
                }

                public static class CountDistinctish
                extends AbstractPropertyReducer {
                    private CountDistinctish(String as, String property) {
                        super(as, property);
                    }

                    @Override
                    protected <K, V> void buildFunction(RediSearchCommandArgs<K, V> args, String property) {
                        args.add(CommandKeyword.COUNT_DISTINCTISH);
                        args.add(1L);
                        args.addProperty(property);
                    }

                    public static CountDistinctishBuilder builder() {
                        return new CountDistinctishBuilder();
                    }

                    public static class CountDistinctishBuilder {
                        private String as;
                        private String property;

                        CountDistinctishBuilder() {
                        }

                        public CountDistinctishBuilder as(String as) {
                            this.as = as;
                            return this;
                        }

                        public CountDistinctishBuilder property(String property) {
                            this.property = property;
                            return this;
                        }

                        public CountDistinctish build() {
                            return new CountDistinctish(this.as, this.property);
                        }

                        public String toString() {
                            return "AggregateOptions.Operation.GroupBy.Reducer.CountDistinctish.CountDistinctishBuilder(as=" + this.as + ", property=" + this.property + ")";
                        }
                    }
                }

                public static class CountDistinct
                extends AbstractPropertyReducer {
                    private CountDistinct(String as, String property) {
                        super(as, property);
                    }

                    @Override
                    protected <K, V> void buildFunction(RediSearchCommandArgs<K, V> args, String property) {
                        args.add(CommandKeyword.COUNT_DISTINCT);
                        args.add(1L);
                        args.addProperty(property);
                    }

                    public static CountDistinctBuilder builder() {
                        return new CountDistinctBuilder();
                    }

                    public static class CountDistinctBuilder {
                        private String as;
                        private String property;

                        CountDistinctBuilder() {
                        }

                        public CountDistinctBuilder as(String as) {
                            this.as = as;
                            return this;
                        }

                        public CountDistinctBuilder property(String property) {
                            this.property = property;
                            return this;
                        }

                        public CountDistinct build() {
                            return new CountDistinct(this.as, this.property);
                        }

                        public String toString() {
                            return "AggregateOptions.Operation.GroupBy.Reducer.CountDistinct.CountDistinctBuilder(as=" + this.as + ", property=" + this.property + ")";
                        }
                    }
                }

                public static class Count
                extends Reducer {
                    private Count(String as) {
                        super(as);
                    }

                    public static Count of(String as) {
                        return new Count(as);
                    }

                    @Override
                    protected <K, V> void buildFunction(RediSearchCommandArgs<K, V> args) {
                        args.add(CommandKeyword.COUNT);
                        args.add(0L);
                    }
                }

                public static class Avg
                extends AbstractPropertyReducer {
                    private Avg(String as, String property) {
                        super(as, property);
                    }

                    @Override
                    protected <K, V> void buildFunction(RediSearchCommandArgs<K, V> args, String property) {
                        args.add(CommandKeyword.AVG);
                        args.add(1L);
                        args.addProperty(property);
                    }

                    public static AvgBuilder builder() {
                        return new AvgBuilder();
                    }

                    public static class AvgBuilder {
                        private String as;
                        private String property;

                        AvgBuilder() {
                        }

                        public AvgBuilder as(String as) {
                            this.as = as;
                            return this;
                        }

                        public AvgBuilder property(String property) {
                            this.property = property;
                            return this;
                        }

                        public Avg build() {
                            return new Avg(this.as, this.property);
                        }

                        public String toString() {
                            return "AggregateOptions.Operation.GroupBy.Reducer.Avg.AvgBuilder(as=" + this.as + ", property=" + this.property + ")";
                        }
                    }
                }
            }
        }

        public static class Filter
        implements Operation {
            private String expression;

            public static Filter of(String expression) {
                return new Filter(expression);
            }

            @Override
            public <K, V> void build(RediSearchCommandArgs<K, V> args) {
                args.add(CommandKeyword.FILTER);
                args.add(this.expression);
            }

            public String getExpression() {
                return this.expression;
            }

            public void setExpression(String expression) {
                this.expression = expression;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Filter)) {
                    return false;
                }
                Filter other = (Filter)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$expression = this.getExpression();
                String other$expression = other.getExpression();
                return !(this$expression == null ? other$expression != null : !this$expression.equals(other$expression));
            }

            protected boolean canEqual(Object other) {
                return other instanceof Filter;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $expression = this.getExpression();
                result = result * 59 + ($expression == null ? 43 : $expression.hashCode());
                return result;
            }

            public String toString() {
                return "AggregateOptions.Operation.Filter(expression=" + this.getExpression() + ")";
            }

            public Filter(String expression) {
                this.expression = expression;
            }
        }

        public static class Apply
        implements Operation {
            private String expression;
            private String as;

            @Override
            public <K, V> void build(RediSearchCommandArgs<K, V> args) {
                args.add(CommandKeyword.APPLY);
                args.add(this.expression);
                args.add(CommandKeyword.AS);
                args.add(this.as);
            }

            Apply(String expression, String as) {
                this.expression = expression;
                this.as = as;
            }

            public static ApplyBuilder builder() {
                return new ApplyBuilder();
            }

            public String getExpression() {
                return this.expression;
            }

            public String getAs() {
                return this.as;
            }

            public void setExpression(String expression) {
                this.expression = expression;
            }

            public void setAs(String as) {
                this.as = as;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Apply)) {
                    return false;
                }
                Apply other = (Apply)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$expression = this.getExpression();
                String other$expression = other.getExpression();
                if (this$expression == null ? other$expression != null : !this$expression.equals(other$expression)) {
                    return false;
                }
                String this$as = this.getAs();
                String other$as = other.getAs();
                return !(this$as == null ? other$as != null : !this$as.equals(other$as));
            }

            protected boolean canEqual(Object other) {
                return other instanceof Apply;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $expression = this.getExpression();
                result = result * 59 + ($expression == null ? 43 : $expression.hashCode());
                String $as = this.getAs();
                result = result * 59 + ($as == null ? 43 : $as.hashCode());
                return result;
            }

            public String toString() {
                return "AggregateOptions.Operation.Apply(expression=" + this.getExpression() + ", as=" + this.getAs() + ")";
            }

            public static class ApplyBuilder {
                private String expression;
                private String as;

                ApplyBuilder() {
                }

                public ApplyBuilder expression(String expression) {
                    this.expression = expression;
                    return this;
                }

                public ApplyBuilder as(String as) {
                    this.as = as;
                    return this;
                }

                public Apply build() {
                    return new Apply(this.expression, this.as);
                }

                public String toString() {
                    return "AggregateOptions.Operation.Apply.ApplyBuilder(expression=" + this.expression + ", as=" + this.as + ")";
                }
            }
        }
    }

    public static class AggregateOptionsBuilder {
        private ArrayList<String> loads;
        private ArrayList<Operation> operations;

        public AggregateOptionsBuilder apply(String expression, String alias) {
            this.operation(Operation.Apply.builder().expression(expression).as(alias).build());
            return this;
        }

        public AggregateOptionsBuilder filter(String expression) {
            this.operation(Operation.Filter.of(expression));
            return this;
        }

        public AggregateOptionsBuilder groupBy(Collection<String> properties, Operation.GroupBy.Reducer ... reducers) {
            LettuceAssert.isTrue((!properties.isEmpty() ? 1 : 0) != 0, (String)"At least one group-by property is required.");
            LettuceAssert.isTrue((reducers.length > 0 ? 1 : 0) != 0, (String)"At least one reducer is required.");
            this.operation(Operation.GroupBy.builder().properties(properties).reducers(Arrays.asList(reducers)).build());
            return this;
        }

        public AggregateOptionsBuilder sortBy(Operation.SortBy.Property ... properties) {
            LettuceAssert.isTrue((properties.length > 0 ? 1 : 0) != 0, (String)"At least one sort-by property is required.");
            this.operation(Operation.SortBy.builder().properties(Arrays.asList(properties)).build());
            return this;
        }

        public AggregateOptionsBuilder sortBy(long max, Operation.SortBy.Property ... properties) {
            LettuceAssert.isTrue((properties.length > 0 ? 1 : 0) != 0, (String)"At least one sort-by property is required.");
            this.operation(Operation.SortBy.builder().properties(Arrays.asList(properties)).max(max).build());
            return this;
        }

        public AggregateOptionsBuilder limit(long offset, long num) {
            this.operation(Operation.Limit.builder().offset(offset).num(num).build());
            return this;
        }

        AggregateOptionsBuilder() {
        }

        public AggregateOptionsBuilder load(String load) {
            if (this.loads == null) {
                this.loads = new ArrayList();
            }
            this.loads.add(load);
            return this;
        }

        public AggregateOptionsBuilder loads(Collection<? extends String> loads) {
            if (loads == null) {
                throw new NullPointerException("loads cannot be null");
            }
            if (this.loads == null) {
                this.loads = new ArrayList();
            }
            this.loads.addAll(loads);
            return this;
        }

        public AggregateOptionsBuilder clearLoads() {
            if (this.loads != null) {
                this.loads.clear();
            }
            return this;
        }

        public AggregateOptionsBuilder operation(Operation operation) {
            if (this.operations == null) {
                this.operations = new ArrayList();
            }
            this.operations.add(operation);
            return this;
        }

        public AggregateOptionsBuilder operations(Collection<? extends Operation> operations) {
            if (operations == null) {
                throw new NullPointerException("operations cannot be null");
            }
            if (this.operations == null) {
                this.operations = new ArrayList();
            }
            this.operations.addAll(operations);
            return this;
        }

        public AggregateOptionsBuilder clearOperations() {
            if (this.operations != null) {
                this.operations.clear();
            }
            return this;
        }

        public AggregateOptions build() {
            List<Object> operations;
            List<String> loads;
            switch (this.loads == null ? 0 : this.loads.size()) {
                case 0: {
                    loads = Collections.emptyList();
                    break;
                }
                case 1: {
                    loads = Collections.singletonList(this.loads.get(0));
                    break;
                }
                default: {
                    loads = Collections.unmodifiableList(new ArrayList<String>(this.loads));
                }
            }
            switch (this.operations == null ? 0 : this.operations.size()) {
                case 0: {
                    operations = Collections.emptyList();
                    break;
                }
                case 1: {
                    operations = Collections.singletonList(this.operations.get(0));
                    break;
                }
                default: {
                    operations = Collections.unmodifiableList(new ArrayList<Operation>(this.operations));
                }
            }
            return new AggregateOptions(loads, operations);
        }

        public String toString() {
            return "AggregateOptions.AggregateOptionsBuilder(loads=" + this.loads + ", operations=" + this.operations + ")";
        }
    }
}

