/*
 * Decompiled with CFR 0.152.
 */
package com.redislabs.lettusearch;

import com.redislabs.lettusearch.Field;
import com.redislabs.lettusearch.IndexInfo;
import com.redislabs.lettusearch.impl.protocol.CommandKeyword;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RediSearchUtils {
    private static final Long ZERO = 0L;

    public static <K> IndexInfo<K> getInfo(List<Object> infoList) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (int i = 0; i < infoList.size() / 2; ++i) {
            map.put((String)infoList.get(i * 2), infoList.get(i * 2 + 1));
        }
        return IndexInfo.builder().indexName(RediSearchUtils.getString(map.get("index_name"))).indexOptions((List)map.get("index_options")).fields(RediSearchUtils.fields(map.get("fields"))).numDocs(RediSearchUtils.getDouble(map.get("num_docs"))).maxDocId((String)RediSearchUtils.getString(map.get("max_doc_id"))).numTerms(RediSearchUtils.getLong(map, "num_terms")).numRecords(RediSearchUtils.getLong(map, "num_records")).invertedSizeMb(RediSearchUtils.getDouble(map.get("inverted_sz_mb"))).totalInvertedIndexBlocks(RediSearchUtils.getLong(map, "total_inverted_index_blocks")).offsetVectorsSizeMb(RediSearchUtils.getDouble(map.get("offset_vectors_sz_mb"))).docTableSizeMb(RediSearchUtils.getDouble(map.get("doc_table_size_mb"))).sortableValuesSizeMb(RediSearchUtils.getDouble(map.get("sortable_values_size_mb"))).keyTableSizeMb(RediSearchUtils.getDouble(map.get("key_table_size_mb"))).recordsPerDocAvg(RediSearchUtils.getDouble(map.get("records_per_doc_avg"))).bytesPerRecordAvg(RediSearchUtils.getDouble(map.get("bytes_per_record_avg"))).offsetsPerTermAvg(RediSearchUtils.getDouble(map.get("offsets_per_term_avg"))).offsetBitsPerRecordAvg(RediSearchUtils.getDouble(map.get("offset_bits_per_record_avg"))).gcStats((List)map.get("gc_stats")).cursorStats((List)map.get("cursor_stats")).build();
    }

    private static Double getDouble(Object object) {
        return (Double)object;
    }

    private static <K> K getString(Object object) {
        if (object != null) {
            if (object instanceof String) {
                return (K)object;
            }
            if (ZERO.equals(object)) {
                return null;
            }
        }
        return null;
    }

    private static <K> List<Field<K>> fields(Object object) {
        ArrayList<Field<K>> fields = new ArrayList<Field<K>>();
        for (Object infoObject : (List)object) {
            List info = (List)infoObject;
            Object name = info.get(0);
            CommandKeyword type = CommandKeyword.valueOf((String)info.get(2));
            Field field = RediSearchUtils.field(name, type, info);
            for (Object attribute : info.subList(3, info.size())) {
                if (CommandKeyword.NOINDEX.name().equals(attribute)) {
                    field.setNoIndex(true);
                }
                if (!CommandKeyword.SORTABLE.name().equals(attribute)) continue;
                field.setSortable(true);
            }
            fields.add(field);
        }
        return fields;
    }

    private static <K> Field<K> field(K name, CommandKeyword type, List<Object> info) {
        switch (type) {
            case GEO: {
                return Field.Geo.builder(name).build();
            }
            case NUMERIC: {
                return Field.Numeric.builder(name).build();
            }
            case TAG: {
                return Field.Tag.builder(name).separator((String)info.get(4)).build();
            }
        }
        return Field.Text.builder(name).weight((Double)info.get(4)).noStem(CommandKeyword.NOSTEM.name().equals(info.get(info.size() - 1))).build();
    }

    private static Long getLong(Map<String, Object> map, String key) {
        Object value;
        if (map.containsKey(key) && (value = map.get(key)) != null) {
            String string;
            if (value instanceof Long) {
                return (Long)value;
            }
            if (value instanceof String && (string = (String)value).length() > 0) {
                try {
                    return Long.parseLong(string);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public static String escapeTag(String value) {
        return value.replaceAll("([^a-zA-Z0-9])", "\\\\$1");
    }
}

