/*
 * Decompiled with CFR 0.152.
 */
package com.redislabs.lettusearch;

import com.redislabs.lettusearch.RediSearchArgument;
import com.redislabs.lettusearch.impl.protocol.CommandKeyword;
import com.redislabs.lettusearch.impl.protocol.RediSearchCommandArgs;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class SearchOptions<K>
implements RediSearchArgument {
    private boolean noContent;
    private boolean verbatim;
    private boolean noStopWords;
    private boolean withScores;
    private boolean withPayloads;
    private boolean withSortKeys;
    private List<K> inKeys;
    private List<K> inFields;
    private List<K> returnFields;
    private Highlight<K> highlight;
    private Language language;
    private SortBy<K> sortBy;
    private Limit limit;

    public void build(RediSearchCommandArgs args) {
        if (this.noContent) {
            args.add(CommandKeyword.NOCONTENT);
        }
        if (this.verbatim) {
            args.add(CommandKeyword.VERBATIM);
        }
        if (this.noStopWords) {
            args.add(CommandKeyword.NOSTOPWORDS);
        }
        if (this.withScores) {
            args.add(CommandKeyword.WITHSCORES);
        }
        if (this.withPayloads) {
            args.add(CommandKeyword.WITHPAYLOADS);
        }
        if (this.withSortKeys) {
            args.add(CommandKeyword.WITHSORTKEYS);
        }
        if (!this.inKeys.isEmpty()) {
            args.add(CommandKeyword.INKEYS);
            args.add(this.inKeys.size());
            this.inKeys.forEach(args::addKey);
        }
        if (!this.inFields.isEmpty()) {
            args.add(CommandKeyword.INFIELDS);
            args.add(this.inFields.size());
            this.inFields.forEach(args::addKey);
        }
        if (!this.returnFields.isEmpty()) {
            args.add(CommandKeyword.RETURN);
            args.add(this.returnFields.size());
            this.returnFields.forEach(args::addKey);
        }
        if (this.highlight != null) {
            args.add(CommandKeyword.HIGHLIGHT);
            this.highlight.build(args);
        }
        if (this.sortBy != null) {
            args.add(CommandKeyword.SORTBY);
            this.sortBy.build(args);
        }
        if (this.language != null) {
            args.add(CommandKeyword.LANGUAGE);
            args.add(this.language.name());
        }
        if (this.limit != null) {
            this.limit.build(args);
        }
    }

    SearchOptions(boolean noContent, boolean verbatim, boolean noStopWords, boolean withScores, boolean withPayloads, boolean withSortKeys, List<K> inKeys, List<K> inFields, List<K> returnFields, Highlight<K> highlight, Language language, SortBy<K> sortBy, Limit limit) {
        this.noContent = noContent;
        this.verbatim = verbatim;
        this.noStopWords = noStopWords;
        this.withScores = withScores;
        this.withPayloads = withPayloads;
        this.withSortKeys = withSortKeys;
        this.inKeys = inKeys;
        this.inFields = inFields;
        this.returnFields = returnFields;
        this.highlight = highlight;
        this.language = language;
        this.sortBy = sortBy;
        this.limit = limit;
    }

    public static <K> SearchOptionsBuilder<K> builder() {
        return new SearchOptionsBuilder();
    }

    public boolean isNoContent() {
        return this.noContent;
    }

    public boolean isVerbatim() {
        return this.verbatim;
    }

    public boolean isNoStopWords() {
        return this.noStopWords;
    }

    public boolean isWithScores() {
        return this.withScores;
    }

    public boolean isWithPayloads() {
        return this.withPayloads;
    }

    public boolean isWithSortKeys() {
        return this.withSortKeys;
    }

    public List<K> getInKeys() {
        return this.inKeys;
    }

    public List<K> getInFields() {
        return this.inFields;
    }

    public List<K> getReturnFields() {
        return this.returnFields;
    }

    public Highlight<K> getHighlight() {
        return this.highlight;
    }

    public Language getLanguage() {
        return this.language;
    }

    public SortBy<K> getSortBy() {
        return this.sortBy;
    }

    public Limit getLimit() {
        return this.limit;
    }

    public void setNoContent(boolean noContent) {
        this.noContent = noContent;
    }

    public void setVerbatim(boolean verbatim) {
        this.verbatim = verbatim;
    }

    public void setNoStopWords(boolean noStopWords) {
        this.noStopWords = noStopWords;
    }

    public void setWithScores(boolean withScores) {
        this.withScores = withScores;
    }

    public void setWithPayloads(boolean withPayloads) {
        this.withPayloads = withPayloads;
    }

    public void setWithSortKeys(boolean withSortKeys) {
        this.withSortKeys = withSortKeys;
    }

    public void setInKeys(List<K> inKeys) {
        this.inKeys = inKeys;
    }

    public void setInFields(List<K> inFields) {
        this.inFields = inFields;
    }

    public void setReturnFields(List<K> returnFields) {
        this.returnFields = returnFields;
    }

    public void setHighlight(Highlight<K> highlight) {
        this.highlight = highlight;
    }

    public void setLanguage(Language language) {
        this.language = language;
    }

    public void setSortBy(SortBy<K> sortBy) {
        this.sortBy = sortBy;
    }

    public void setLimit(Limit limit) {
        this.limit = limit;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SearchOptions)) {
            return false;
        }
        SearchOptions other = (SearchOptions)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isNoContent() != other.isNoContent()) {
            return false;
        }
        if (this.isVerbatim() != other.isVerbatim()) {
            return false;
        }
        if (this.isNoStopWords() != other.isNoStopWords()) {
            return false;
        }
        if (this.isWithScores() != other.isWithScores()) {
            return false;
        }
        if (this.isWithPayloads() != other.isWithPayloads()) {
            return false;
        }
        if (this.isWithSortKeys() != other.isWithSortKeys()) {
            return false;
        }
        List<K> this$inKeys = this.getInKeys();
        List<K> other$inKeys = other.getInKeys();
        if (this$inKeys == null ? other$inKeys != null : !((Object)this$inKeys).equals(other$inKeys)) {
            return false;
        }
        List<K> this$inFields = this.getInFields();
        List<K> other$inFields = other.getInFields();
        if (this$inFields == null ? other$inFields != null : !((Object)this$inFields).equals(other$inFields)) {
            return false;
        }
        List<K> this$returnFields = this.getReturnFields();
        List<K> other$returnFields = other.getReturnFields();
        if (this$returnFields == null ? other$returnFields != null : !((Object)this$returnFields).equals(other$returnFields)) {
            return false;
        }
        Highlight<K> this$highlight = this.getHighlight();
        Highlight<K> other$highlight = other.getHighlight();
        if (this$highlight == null ? other$highlight != null : !((Object)this$highlight).equals(other$highlight)) {
            return false;
        }
        Language this$language = this.getLanguage();
        Language other$language = other.getLanguage();
        if (this$language == null ? other$language != null : !((Object)((Object)this$language)).equals((Object)other$language)) {
            return false;
        }
        SortBy<K> this$sortBy = this.getSortBy();
        SortBy<K> other$sortBy = other.getSortBy();
        if (this$sortBy == null ? other$sortBy != null : !((Object)this$sortBy).equals(other$sortBy)) {
            return false;
        }
        Limit this$limit = this.getLimit();
        Limit other$limit = other.getLimit();
        return !(this$limit == null ? other$limit != null : !((Object)this$limit).equals(other$limit));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SearchOptions;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isNoContent() ? 79 : 97);
        result = result * 59 + (this.isVerbatim() ? 79 : 97);
        result = result * 59 + (this.isNoStopWords() ? 79 : 97);
        result = result * 59 + (this.isWithScores() ? 79 : 97);
        result = result * 59 + (this.isWithPayloads() ? 79 : 97);
        result = result * 59 + (this.isWithSortKeys() ? 79 : 97);
        List<K> $inKeys = this.getInKeys();
        result = result * 59 + ($inKeys == null ? 43 : ((Object)$inKeys).hashCode());
        List<K> $inFields = this.getInFields();
        result = result * 59 + ($inFields == null ? 43 : ((Object)$inFields).hashCode());
        List<K> $returnFields = this.getReturnFields();
        result = result * 59 + ($returnFields == null ? 43 : ((Object)$returnFields).hashCode());
        Highlight<K> $highlight = this.getHighlight();
        result = result * 59 + ($highlight == null ? 43 : ((Object)$highlight).hashCode());
        Language $language = this.getLanguage();
        result = result * 59 + ($language == null ? 43 : ((Object)((Object)$language)).hashCode());
        SortBy<K> $sortBy = this.getSortBy();
        result = result * 59 + ($sortBy == null ? 43 : ((Object)$sortBy).hashCode());
        Limit $limit = this.getLimit();
        result = result * 59 + ($limit == null ? 43 : ((Object)$limit).hashCode());
        return result;
    }

    public String toString() {
        return "SearchOptions(noContent=" + this.isNoContent() + ", verbatim=" + this.isVerbatim() + ", noStopWords=" + this.isNoStopWords() + ", withScores=" + this.isWithScores() + ", withPayloads=" + this.isWithPayloads() + ", withSortKeys=" + this.isWithSortKeys() + ", inKeys=" + this.getInKeys() + ", inFields=" + this.getInFields() + ", returnFields=" + this.getReturnFields() + ", highlight=" + this.getHighlight() + ", language=" + (Object)((Object)this.getLanguage()) + ", sortBy=" + this.getSortBy() + ", limit=" + this.getLimit() + ")";
    }

    public static class SearchOptionsBuilder<K> {
        private boolean noContent;
        private boolean verbatim;
        private boolean noStopWords;
        private boolean withScores;
        private boolean withPayloads;
        private boolean withSortKeys;
        private ArrayList<K> inKeys;
        private ArrayList<K> inFields;
        private ArrayList<K> returnFields;
        private Highlight<K> highlight;
        private Language language;
        private SortBy<K> sortBy;
        private Limit limit;

        SearchOptionsBuilder() {
        }

        public SearchOptionsBuilder<K> noContent(boolean noContent) {
            this.noContent = noContent;
            return this;
        }

        public SearchOptionsBuilder<K> verbatim(boolean verbatim) {
            this.verbatim = verbatim;
            return this;
        }

        public SearchOptionsBuilder<K> noStopWords(boolean noStopWords) {
            this.noStopWords = noStopWords;
            return this;
        }

        public SearchOptionsBuilder<K> withScores(boolean withScores) {
            this.withScores = withScores;
            return this;
        }

        public SearchOptionsBuilder<K> withPayloads(boolean withPayloads) {
            this.withPayloads = withPayloads;
            return this;
        }

        public SearchOptionsBuilder<K> withSortKeys(boolean withSortKeys) {
            this.withSortKeys = withSortKeys;
            return this;
        }

        public SearchOptionsBuilder<K> inKey(K inKey) {
            if (this.inKeys == null) {
                this.inKeys = new ArrayList();
            }
            this.inKeys.add(inKey);
            return this;
        }

        public SearchOptionsBuilder<K> inKeys(Collection<? extends K> inKeys) {
            if (inKeys == null) {
                throw new NullPointerException("inKeys cannot be null");
            }
            if (this.inKeys == null) {
                this.inKeys = new ArrayList();
            }
            this.inKeys.addAll(inKeys);
            return this;
        }

        public SearchOptionsBuilder<K> clearInKeys() {
            if (this.inKeys != null) {
                this.inKeys.clear();
            }
            return this;
        }

        public SearchOptionsBuilder<K> inField(K inField) {
            if (this.inFields == null) {
                this.inFields = new ArrayList();
            }
            this.inFields.add(inField);
            return this;
        }

        public SearchOptionsBuilder<K> inFields(Collection<? extends K> inFields) {
            if (inFields == null) {
                throw new NullPointerException("inFields cannot be null");
            }
            if (this.inFields == null) {
                this.inFields = new ArrayList();
            }
            this.inFields.addAll(inFields);
            return this;
        }

        public SearchOptionsBuilder<K> clearInFields() {
            if (this.inFields != null) {
                this.inFields.clear();
            }
            return this;
        }

        public SearchOptionsBuilder<K> returnField(K returnField) {
            if (this.returnFields == null) {
                this.returnFields = new ArrayList();
            }
            this.returnFields.add(returnField);
            return this;
        }

        public SearchOptionsBuilder<K> returnFields(Collection<? extends K> returnFields) {
            if (returnFields == null) {
                throw new NullPointerException("returnFields cannot be null");
            }
            if (this.returnFields == null) {
                this.returnFields = new ArrayList();
            }
            this.returnFields.addAll(returnFields);
            return this;
        }

        public SearchOptionsBuilder<K> clearReturnFields() {
            if (this.returnFields != null) {
                this.returnFields.clear();
            }
            return this;
        }

        public SearchOptionsBuilder<K> highlight(Highlight<K> highlight) {
            this.highlight = highlight;
            return this;
        }

        public SearchOptionsBuilder<K> language(Language language) {
            this.language = language;
            return this;
        }

        public SearchOptionsBuilder<K> sortBy(SortBy<K> sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public SearchOptionsBuilder<K> limit(Limit limit) {
            this.limit = limit;
            return this;
        }

        public SearchOptions<K> build() {
            List<Object> returnFields;
            List<Object> inFields;
            List<Object> inKeys;
            switch (this.inKeys == null ? 0 : this.inKeys.size()) {
                case 0: {
                    inKeys = Collections.emptyList();
                    break;
                }
                case 1: {
                    inKeys = Collections.singletonList(this.inKeys.get(0));
                    break;
                }
                default: {
                    inKeys = Collections.unmodifiableList(new ArrayList<K>(this.inKeys));
                }
            }
            switch (this.inFields == null ? 0 : this.inFields.size()) {
                case 0: {
                    inFields = Collections.emptyList();
                    break;
                }
                case 1: {
                    inFields = Collections.singletonList(this.inFields.get(0));
                    break;
                }
                default: {
                    inFields = Collections.unmodifiableList(new ArrayList<K>(this.inFields));
                }
            }
            switch (this.returnFields == null ? 0 : this.returnFields.size()) {
                case 0: {
                    returnFields = Collections.emptyList();
                    break;
                }
                case 1: {
                    returnFields = Collections.singletonList(this.returnFields.get(0));
                    break;
                }
                default: {
                    returnFields = Collections.unmodifiableList(new ArrayList<K>(this.returnFields));
                }
            }
            return new SearchOptions(this.noContent, this.verbatim, this.noStopWords, this.withScores, this.withPayloads, this.withSortKeys, inKeys, inFields, returnFields, this.highlight, this.language, this.sortBy, this.limit);
        }

        public String toString() {
            return "SearchOptions.SearchOptionsBuilder(noContent=" + this.noContent + ", verbatim=" + this.verbatim + ", noStopWords=" + this.noStopWords + ", withScores=" + this.withScores + ", withPayloads=" + this.withPayloads + ", withSortKeys=" + this.withSortKeys + ", inKeys=" + this.inKeys + ", inFields=" + this.inFields + ", returnFields=" + this.returnFields + ", highlight=" + this.highlight + ", language=" + (Object)((Object)this.language) + ", sortBy=" + this.sortBy + ", limit=" + this.limit + ")";
        }
    }

    public static class SortBy<K>
    implements RediSearchArgument {
        public static final Direction DEFAULT_DIRECTION = Direction.Ascending;
        private K field;
        private Direction direction;

        public void build(RediSearchCommandArgs args) {
            args.addKey((Object)this.field);
            args.add(this.direction == Direction.Ascending ? CommandKeyword.ASC : CommandKeyword.DESC);
        }

        private static <K> Direction $default$direction() {
            return DEFAULT_DIRECTION;
        }

        SortBy(K field, Direction direction) {
            this.field = field;
            this.direction = direction;
        }

        public static <K> SortByBuilder<K> builder() {
            return new SortByBuilder();
        }

        public K getField() {
            return this.field;
        }

        public Direction getDirection() {
            return this.direction;
        }

        public void setField(K field) {
            this.field = field;
        }

        public void setDirection(Direction direction) {
            this.direction = direction;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SortBy)) {
                return false;
            }
            SortBy other = (SortBy)o;
            if (!other.canEqual(this)) {
                return false;
            }
            K this$field = this.getField();
            K other$field = other.getField();
            if (this$field == null ? other$field != null : !this$field.equals(other$field)) {
                return false;
            }
            Direction this$direction = this.getDirection();
            Direction other$direction = other.getDirection();
            return !(this$direction == null ? other$direction != null : !((Object)((Object)this$direction)).equals((Object)other$direction));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SortBy;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            K $field = this.getField();
            result = result * 59 + ($field == null ? 43 : $field.hashCode());
            Direction $direction = this.getDirection();
            result = result * 59 + ($direction == null ? 43 : ((Object)((Object)$direction)).hashCode());
            return result;
        }

        public String toString() {
            return "SearchOptions.SortBy(field=" + this.getField() + ", direction=" + (Object)((Object)this.getDirection()) + ")";
        }

        public static class SortByBuilder<K> {
            private K field;
            private boolean direction$set;
            private Direction direction$value;

            SortByBuilder() {
            }

            public SortByBuilder<K> field(K field) {
                this.field = field;
                return this;
            }

            public SortByBuilder<K> direction(Direction direction) {
                this.direction$value = direction;
                this.direction$set = true;
                return this;
            }

            public SortBy<K> build() {
                Direction direction$value = this.direction$value;
                if (!this.direction$set) {
                    direction$value = SortBy.$default$direction();
                }
                return new SortBy<K>(this.field, direction$value);
            }

            public String toString() {
                return "SearchOptions.SortBy.SortByBuilder(field=" + this.field + ", direction$value=" + (Object)((Object)this.direction$value) + ")";
            }
        }

        public static enum Direction {
            Ascending,
            Descending;

        }
    }

    public static enum Language {
        Arabic,
        Danish,
        Dutch,
        English,
        Finnish,
        French,
        German,
        Hungarian,
        Italian,
        Norwegian,
        Portuguese,
        Romanian,
        Russian,
        Spanish,
        Swedish,
        Tamil,
        Turkish,
        Chinese;

    }

    public static class Limit
    implements RediSearchArgument {
        public static final long DEFAULT_OFFSET = 0L;
        public static final long DEFAULT_NUM = 10L;
        private long offset;
        private long num;

        @Override
        public <K, V> void build(RediSearchCommandArgs<K, V> args) {
            args.add(CommandKeyword.LIMIT);
            args.add(this.offset);
            args.add(this.num);
        }

        private static long $default$offset() {
            return 0L;
        }

        private static long $default$num() {
            return 10L;
        }

        Limit(long offset, long num) {
            this.offset = offset;
            this.num = num;
        }

        public static LimitBuilder builder() {
            return new LimitBuilder();
        }

        public long getOffset() {
            return this.offset;
        }

        public long getNum() {
            return this.num;
        }

        public void setOffset(long offset) {
            this.offset = offset;
        }

        public void setNum(long num) {
            this.num = num;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Limit)) {
                return false;
            }
            Limit other = (Limit)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getOffset() != other.getOffset()) {
                return false;
            }
            return this.getNum() == other.getNum();
        }

        protected boolean canEqual(Object other) {
            return other instanceof Limit;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $offset = this.getOffset();
            result = result * 59 + (int)($offset >>> 32 ^ $offset);
            long $num = this.getNum();
            result = result * 59 + (int)($num >>> 32 ^ $num);
            return result;
        }

        public String toString() {
            return "SearchOptions.Limit(offset=" + this.getOffset() + ", num=" + this.getNum() + ")";
        }

        public static class LimitBuilder {
            private boolean offset$set;
            private long offset$value;
            private boolean num$set;
            private long num$value;

            LimitBuilder() {
            }

            public LimitBuilder offset(long offset) {
                this.offset$value = offset;
                this.offset$set = true;
                return this;
            }

            public LimitBuilder num(long num) {
                this.num$value = num;
                this.num$set = true;
                return this;
            }

            public Limit build() {
                long offset$value = this.offset$value;
                if (!this.offset$set) {
                    offset$value = Limit.$default$offset();
                }
                long num$value = this.num$value;
                if (!this.num$set) {
                    num$value = Limit.$default$num();
                }
                return new Limit(offset$value, num$value);
            }

            public String toString() {
                return "SearchOptions.Limit.LimitBuilder(offset$value=" + this.offset$value + ", num$value=" + this.num$value + ")";
            }
        }
    }

    public static class Highlight<K>
    implements RediSearchArgument {
        private List<K> fields;
        private Tag<K> tag;

        public void build(RediSearchCommandArgs args) {
            if (this.fields.size() > 0) {
                args.add(CommandKeyword.FIELDS);
                args.add(this.fields.size());
                this.fields.forEach(args::addKey);
            }
            if (this.tag != null) {
                args.add(CommandKeyword.TAGS);
                args.addKey((Object)this.tag.getOpen());
                args.addKey((Object)this.tag.getClose());
            }
        }

        public static <K> HighlightBuilder<K> builder() {
            return new HighlightBuilder();
        }

        public List<K> getFields() {
            return this.fields;
        }

        public Tag<K> getTag() {
            return this.tag;
        }

        public void setFields(List<K> fields) {
            this.fields = fields;
        }

        public void setTag(Tag<K> tag) {
            this.tag = tag;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Highlight)) {
                return false;
            }
            Highlight other = (Highlight)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<K> this$fields = this.getFields();
            List<K> other$fields = other.getFields();
            if (this$fields == null ? other$fields != null : !((Object)this$fields).equals(other$fields)) {
                return false;
            }
            Tag<K> this$tag = this.getTag();
            Tag<K> other$tag = other.getTag();
            return !(this$tag == null ? other$tag != null : !((Object)this$tag).equals(other$tag));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Highlight;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<K> $fields = this.getFields();
            result = result * 59 + ($fields == null ? 43 : ((Object)$fields).hashCode());
            Tag<K> $tag = this.getTag();
            result = result * 59 + ($tag == null ? 43 : ((Object)$tag).hashCode());
            return result;
        }

        public String toString() {
            return "SearchOptions.Highlight(fields=" + this.getFields() + ", tag=" + this.getTag() + ")";
        }

        public Highlight() {
        }

        public Highlight(List<K> fields, Tag<K> tag) {
            this.fields = fields;
            this.tag = tag;
        }

        public static class HighlightBuilder<K> {
            private ArrayList<K> fields;
            private Tag<K> tag;

            HighlightBuilder() {
            }

            public HighlightBuilder<K> field(K field) {
                if (this.fields == null) {
                    this.fields = new ArrayList();
                }
                this.fields.add(field);
                return this;
            }

            public HighlightBuilder<K> fields(Collection<? extends K> fields) {
                if (fields == null) {
                    throw new NullPointerException("fields cannot be null");
                }
                if (this.fields == null) {
                    this.fields = new ArrayList();
                }
                this.fields.addAll(fields);
                return this;
            }

            public HighlightBuilder<K> clearFields() {
                if (this.fields != null) {
                    this.fields.clear();
                }
                return this;
            }

            public HighlightBuilder<K> tag(Tag<K> tag) {
                this.tag = tag;
                return this;
            }

            public Highlight<K> build() {
                List<Object> fields;
                switch (this.fields == null ? 0 : this.fields.size()) {
                    case 0: {
                        fields = Collections.emptyList();
                        break;
                    }
                    case 1: {
                        fields = Collections.singletonList(this.fields.get(0));
                        break;
                    }
                    default: {
                        fields = Collections.unmodifiableList(new ArrayList<K>(this.fields));
                    }
                }
                return new Highlight(fields, this.tag);
            }

            public String toString() {
                return "SearchOptions.Highlight.HighlightBuilder(fields=" + this.fields + ", tag=" + this.tag + ")";
            }
        }

        public static class Tag<K> {
            private K open;
            private K close;

            Tag(K open, K close) {
                this.open = open;
                this.close = close;
            }

            public static <K> TagBuilder<K> builder() {
                return new TagBuilder();
            }

            public K getOpen() {
                return this.open;
            }

            public K getClose() {
                return this.close;
            }

            public void setOpen(K open) {
                this.open = open;
            }

            public void setClose(K close) {
                this.close = close;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Tag)) {
                    return false;
                }
                Tag other = (Tag)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                K this$open = this.getOpen();
                K other$open = other.getOpen();
                if (this$open == null ? other$open != null : !this$open.equals(other$open)) {
                    return false;
                }
                K this$close = this.getClose();
                K other$close = other.getClose();
                return !(this$close == null ? other$close != null : !this$close.equals(other$close));
            }

            protected boolean canEqual(Object other) {
                return other instanceof Tag;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                K $open = this.getOpen();
                result = result * 59 + ($open == null ? 43 : $open.hashCode());
                K $close = this.getClose();
                result = result * 59 + ($close == null ? 43 : $close.hashCode());
                return result;
            }

            public String toString() {
                return "SearchOptions.Highlight.Tag(open=" + this.getOpen() + ", close=" + this.getClose() + ")";
            }

            public static class TagBuilder<K> {
                private K open;
                private K close;

                TagBuilder() {
                }

                public TagBuilder<K> open(K open) {
                    this.open = open;
                    return this;
                }

                public TagBuilder<K> close(K close) {
                    this.close = close;
                    return this;
                }

                public Tag<K> build() {
                    return new Tag<K>(this.open, this.close);
                }

                public String toString() {
                    return "SearchOptions.Highlight.Tag.TagBuilder(open=" + this.open + ", close=" + this.close + ")";
                }
            }
        }
    }
}

