/*
 * Decompiled with CFR 0.152.
 */
package com.redislabs.lettusearch;

import io.lettuce.core.internal.LettuceAssert;

public class Suggestion<V> {
    private V string;
    private Double score;
    private V payload;

    public static <V> SuggestionBuilder<V> builder(V string) {
        return new SuggestionBuilder<V>().string(string);
    }

    public static <V> SuggestionBuilder<V> builder() {
        return new SuggestionBuilder();
    }

    public V getString() {
        return this.string;
    }

    public Double getScore() {
        return this.score;
    }

    public V getPayload() {
        return this.payload;
    }

    public void setString(V string) {
        this.string = string;
    }

    public void setScore(Double score) {
        this.score = score;
    }

    public void setPayload(V payload) {
        this.payload = payload;
    }

    public static class SuggestionBuilder<V> {
        private V string;
        private double score = 1.0;
        private V payload;

        public Suggestion<V> build() {
            LettuceAssert.notNull(this.string, (String)"String is required.");
            Suggestion<V> suggestion = new Suggestion<V>();
            suggestion.setString(this.string);
            suggestion.setScore(this.score);
            suggestion.setPayload(this.payload);
            return suggestion;
        }

        public SuggestionBuilder<V> string(V string) {
            this.string = string;
            return this;
        }

        public SuggestionBuilder<V> score(double score) {
            this.score = score;
            return this;
        }

        public SuggestionBuilder<V> payload(V payload) {
            this.payload = payload;
            return this;
        }
    }
}

