/*
 * Decompiled with CFR 0.152.
 */
package com.redislabs.lettusearch.output;

import com.redislabs.lettusearch.AggregateResults;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.output.CommandOutput;
import io.lettuce.core.output.MapOutput;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class AggregateOutput<K, V, R extends AggregateResults<K, V>>
extends CommandOutput<K, V, R> {
    private final MapOutput<K, V> nested;
    private int mapCount = -1;
    private final List<Integer> counts = new ArrayList<Integer>();

    public AggregateOutput(RedisCodec<K, V> codec, R results) {
        super(codec, results);
        this.nested = new MapOutput(codec);
    }

    public int getMapCount() {
        return this.mapCount;
    }

    public void set(ByteBuffer bytes) {
        this.nested.set(bytes);
    }

    public void complete(int depth) {
        if (!this.counts.isEmpty()) {
            int expectedSize = this.counts.get(0);
            if (((Map)this.nested.get()).size() == expectedSize) {
                this.counts.remove(0);
                ((AggregateResults)this.output).add(new LinkedHashMap((Map)this.nested.get()));
                ((Map)this.nested.get()).clear();
            }
        }
    }

    public void set(long integer) {
        ((AggregateResults)this.output).setCount(integer);
    }

    public void multi(int count) {
        this.nested.multi(count);
        if (this.mapCount == -1) {
            this.mapCount = count - 1;
        } else {
            this.counts.add(count / 2);
        }
    }
}

