/*
 * Decompiled with CFR 0.152.
 */
package com.redislabs.lettusearch;

import com.redislabs.lettusearch.RediSearchArgument;
import com.redislabs.lettusearch.impl.protocol.CommandKeyword;
import com.redislabs.lettusearch.impl.protocol.RediSearchCommandArgs;

public abstract class Field<K>
implements RediSearchArgument {
    static final String MUST_NOT_BE_EMPTY = "must not be empty";
    static final String MUST_NOT_BE_NULL = "must not be null";
    private final Type type;
    private final K name;
    private boolean sortable;
    private boolean noIndex;

    protected Field(Type type, K name) {
        this.type = type;
        this.name = name;
    }

    public void build(RediSearchCommandArgs args) {
        args.addKey((Object)this.name);
        this.buildField(args);
        if (this.sortable) {
            args.add(CommandKeyword.SORTABLE);
        }
        if (this.noIndex) {
            args.add(CommandKeyword.NOINDEX);
        }
    }

    protected abstract void buildField(RediSearchCommandArgs var1);

    public static <K> Text.TextFieldBuilder<K> text(K name) {
        return Text.builder(name);
    }

    public static <K> Geo.GeoFieldBuilder<K> geo(K name) {
        return Geo.builder(name);
    }

    public static <K> Tag.TagFieldBuilder<K> tag(K name) {
        return Tag.builder(name);
    }

    public static <K> Numeric.NumericFieldBuilder<K> numeric(K name) {
        return Numeric.builder(name);
    }

    public Type getType() {
        return this.type;
    }

    public K getName() {
        return this.name;
    }

    public boolean isSortable() {
        return this.sortable;
    }

    public boolean isNoIndex() {
        return this.noIndex;
    }

    public void setSortable(boolean sortable) {
        this.sortable = sortable;
    }

    public void setNoIndex(boolean noIndex) {
        this.noIndex = noIndex;
    }

    public static enum Type {
        TEXT,
        NUMERIC,
        GEO,
        TAG;

    }

    public static class Text<K>
    extends Field<K> {
        private Double weight;
        private boolean noStem;
        private PhoneticMatcher matcher;

        public Text(K name) {
            super(Type.TEXT, name);
        }

        @Override
        protected void buildField(RediSearchCommandArgs args) {
            args.add(CommandKeyword.TEXT);
            if (this.noStem) {
                args.add(CommandKeyword.NOSTEM);
            }
            if (this.weight != null) {
                args.add(CommandKeyword.WEIGHT);
                args.add(this.weight);
            }
            if (this.matcher != null) {
                args.add(CommandKeyword.PHONETIC);
                args.add(this.matcher.getCode());
            }
        }

        public static <K> TextFieldBuilder<K> builder(K name) {
            return new TextFieldBuilder<K>(name);
        }

        public Double getWeight() {
            return this.weight;
        }

        public boolean isNoStem() {
            return this.noStem;
        }

        public PhoneticMatcher getMatcher() {
            return this.matcher;
        }

        public void setWeight(Double weight) {
            this.weight = weight;
        }

        public void setNoStem(boolean noStem) {
            this.noStem = noStem;
        }

        public void setMatcher(PhoneticMatcher matcher) {
            this.matcher = matcher;
        }

        public static enum PhoneticMatcher {
            English("dm:en"),
            French("dm:fr"),
            Portuguese("dm:pt"),
            Spanish("dm:es");

            private final String code;

            private PhoneticMatcher(String code) {
                this.code = code;
            }

            public String getCode() {
                return this.code;
            }
        }

        public static class TextFieldBuilder<K>
        extends FieldBuilder<K, Text<K>, TextFieldBuilder<K>> {
            private Double weight;
            private boolean noStem;
            private PhoneticMatcher matcher;

            public TextFieldBuilder(K name) {
                super(name);
            }

            @Override
            protected Text<K> newField(K name) {
                Text<K> field = new Text<K>(name);
                field.setWeight(this.weight);
                field.setNoStem(this.noStem);
                field.setMatcher(this.matcher);
                return field;
            }

            public TextFieldBuilder<K> weight(Double weight) {
                this.weight = weight;
                return this;
            }

            public TextFieldBuilder<K> noStem(boolean noStem) {
                this.noStem = noStem;
                return this;
            }

            public TextFieldBuilder<K> matcher(PhoneticMatcher matcher) {
                this.matcher = matcher;
                return this;
            }
        }
    }

    public static class Tag<K>
    extends Field<K> {
        private String separator;

        public Tag(K name) {
            super(Type.TAG, name);
        }

        @Override
        protected void buildField(RediSearchCommandArgs args) {
            args.add(CommandKeyword.TAG);
            if (this.separator != null) {
                args.add(CommandKeyword.SEPARATOR);
                args.add(this.separator);
            }
        }

        public static <K> TagFieldBuilder<K> builder(K name) {
            return new TagFieldBuilder<K>(name);
        }

        public String getSeparator() {
            return this.separator;
        }

        public void setSeparator(String separator) {
            this.separator = separator;
        }

        public static class TagFieldBuilder<K>
        extends FieldBuilder<K, Tag<K>, TagFieldBuilder<K>> {
            private String separator;

            public TagFieldBuilder(K name) {
                super(name);
            }

            @Override
            protected Tag<K> newField(K name) {
                Tag<K> field = new Tag<K>(name);
                field.setSeparator(this.separator);
                return field;
            }

            public TagFieldBuilder<K> separator(String separator) {
                this.separator = separator;
                return this;
            }
        }
    }

    public static class Numeric<K>
    extends Field<K> {
        public Numeric(K name) {
            super(Type.NUMERIC, name);
        }

        @Override
        protected void buildField(RediSearchCommandArgs args) {
            args.add(CommandKeyword.NUMERIC);
        }

        public static <K> NumericFieldBuilder<K> builder(K name) {
            return new NumericFieldBuilder<K>(name);
        }

        public static class NumericFieldBuilder<K>
        extends FieldBuilder<K, Numeric<K>, NumericFieldBuilder<K>> {
            public NumericFieldBuilder(K name) {
                super(name);
            }

            @Override
            protected Numeric<K> newField(K name) {
                return new Numeric<K>(name);
            }
        }
    }

    public static class Geo<K>
    extends Field<K> {
        public Geo(K name) {
            super(Type.GEO, name);
        }

        @Override
        protected void buildField(RediSearchCommandArgs args) {
            args.add(CommandKeyword.GEO);
        }

        public static <K> GeoFieldBuilder<K> builder(K name) {
            return new GeoFieldBuilder<K>(name);
        }

        public static class GeoFieldBuilder<K>
        extends FieldBuilder<K, Geo<K>, GeoFieldBuilder<K>> {
            public GeoFieldBuilder(K name) {
                super(name);
            }

            @Override
            protected Geo<K> newField(K name) {
                return new Geo<K>(name);
            }
        }
    }

    protected static abstract class FieldBuilder<K, F extends Field<K>, B extends FieldBuilder<K, F, B>> {
        private final K name;
        private boolean sortable;
        private boolean noIndex;

        protected FieldBuilder(K name) {
            this.name = name;
        }

        public B sortable(boolean sortable) {
            this.sortable = sortable;
            return (B)this;
        }

        public B noIndex(boolean noIndex) {
            this.noIndex = noIndex;
            return (B)this;
        }

        public F build() {
            F field = this.newField(this.name);
            ((Field)field).setNoIndex(this.noIndex);
            ((Field)field).setSortable(this.sortable);
            return field;
        }

        protected abstract F newField(K var1);
    }
}

