/*
 * Decompiled with CFR 0.152.
 */
package com.redislabs.lettusearch;

import com.redislabs.lettusearch.StatefulRediSearchConnection;
import com.redislabs.lettusearch.impl.StatefulRediSearchConnectionImpl;
import io.lettuce.core.RedisChannelWriter;
import io.lettuce.core.RedisClient;
import io.lettuce.core.RedisURI;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.protocol.PushHandler;
import io.lettuce.core.resource.ClientResources;
import java.time.Duration;

public class RediSearchClient
extends RedisClient {
    protected RediSearchClient(ClientResources clientResources, RedisURI redisURI) {
        super(clientResources, redisURI);
    }

    protected RediSearchClient() {
    }

    public static RediSearchClient create() {
        return new RediSearchClient();
    }

    public static RediSearchClient create(RedisURI redisURI) {
        RediSearchClient.assertNotNull(redisURI);
        return new RediSearchClient(null, redisURI);
    }

    public static RediSearchClient create(String uri) {
        LettuceAssert.notEmpty((CharSequence)uri, (String)"URI must not be empty");
        return new RediSearchClient(null, RedisURI.create((String)uri));
    }

    public static RediSearchClient create(ClientResources clientResources) {
        RediSearchClient.assertNotNull(clientResources);
        return new RediSearchClient(clientResources, new RedisURI());
    }

    public static RediSearchClient create(ClientResources clientResources, String uri) {
        RediSearchClient.assertNotNull(clientResources);
        LettuceAssert.notEmpty((CharSequence)uri, (String)"URI must not be empty");
        return RediSearchClient.create(clientResources, RedisURI.create((String)uri));
    }

    private static void assertNotNull(ClientResources clientResources) {
        LettuceAssert.notNull((Object)clientResources, (String)"ClientResources must not be null");
    }

    public static RediSearchClient create(ClientResources clientResources, RedisURI redisURI) {
        RediSearchClient.assertNotNull(clientResources);
        RediSearchClient.assertNotNull(redisURI);
        return new RediSearchClient(clientResources, redisURI);
    }

    public StatefulRediSearchConnection<String, String> connect() {
        return this.connect(this.newStringStringCodec());
    }

    public <K, V> StatefulRediSearchConnection<K, V> connect(RedisCodec<K, V> codec) {
        return (StatefulRediSearchConnection)super.connect(codec);
    }

    public StatefulRediSearchConnection<String, String> connect(RedisURI redisURI) {
        return (StatefulRediSearchConnection)super.connect(redisURI);
    }

    public <K, V> StatefulRediSearchConnection<K, V> connect(RedisCodec<K, V> codec, RedisURI redisURI) {
        return (StatefulRediSearchConnection)super.connect(codec, redisURI);
    }

    private static void assertNotNull(RedisURI redisURI) {
        LettuceAssert.notNull((Object)redisURI, (String)"RedisURI must not be null");
    }

    protected <K, V> StatefulRediSearchConnectionImpl<K, V> newStatefulRedisConnection(RedisChannelWriter channelWriter, PushHandler pushHandler, RedisCodec<K, V> codec, Duration timeout) {
        return new StatefulRediSearchConnectionImpl<K, V>(channelWriter, pushHandler, codec, timeout);
    }
}

