/*
 * Decompiled with CFR 0.152.
 */
package com.redislabs.lettusearch.impl;

import com.redislabs.lettusearch.AggregateOptions;
import com.redislabs.lettusearch.AggregateResults;
import com.redislabs.lettusearch.AggregateWithCursorResults;
import com.redislabs.lettusearch.CreateOptions;
import com.redislabs.lettusearch.Cursor;
import com.redislabs.lettusearch.Field;
import com.redislabs.lettusearch.RediSearchAsyncCommands;
import com.redislabs.lettusearch.RediSearchCommandBuilder;
import com.redislabs.lettusearch.SearchOptions;
import com.redislabs.lettusearch.SearchResults;
import com.redislabs.lettusearch.StatefulRediSearchConnection;
import com.redislabs.lettusearch.Suggestion;
import com.redislabs.lettusearch.SuggetOptions;
import io.lettuce.core.RedisAsyncCommandsImpl;
import io.lettuce.core.RedisFuture;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.protocol.RedisCommand;
import java.util.List;

public class RediSearchAsyncCommandsImpl<K, V>
extends RedisAsyncCommandsImpl<K, V>
implements RediSearchAsyncCommands<K, V> {
    private final StatefulRediSearchConnection<K, V> connection;
    private final RediSearchCommandBuilder<K, V> commandBuilder;

    public RediSearchAsyncCommandsImpl(StatefulRediSearchConnection<K, V> connection, RedisCodec<K, V> codec) {
        super(connection, codec);
        this.connection = connection;
        this.commandBuilder = new RediSearchCommandBuilder<K, V>(codec);
    }

    @Override
    public StatefulRediSearchConnection<K, V> getStatefulConnection() {
        return this.connection;
    }

    @Override
    public RedisFuture<String> create(K index, Field<K> ... fields) {
        return this.create(index, (CreateOptions<K, V>)null, fields);
    }

    @Override
    public RedisFuture<String> create(K index, CreateOptions<K, V> options, Field<K> ... fields) {
        return this.dispatch((RedisCommand)this.commandBuilder.create(index, options, fields));
    }

    @Override
    public RedisFuture<String> dropIndex(K index) {
        return this.dropIndex(index, false);
    }

    @Override
    public RedisFuture<String> dropIndex(K index, boolean deleteDocs) {
        return this.dispatch((RedisCommand)this.commandBuilder.dropIndex(index, deleteDocs));
    }

    @Override
    public RedisFuture<List<Object>> ftInfo(K index) {
        return this.dispatch((RedisCommand)this.commandBuilder.info(index));
    }

    @Override
    public RedisFuture<SearchResults<K, V>> search(K index, V query) {
        return this.dispatch((RedisCommand)this.commandBuilder.search(index, query, null));
    }

    @Override
    public RedisFuture<SearchResults<K, V>> search(K index, V query, SearchOptions<K> options) {
        return this.dispatch((RedisCommand)this.commandBuilder.search(index, query, options));
    }

    @Override
    public RedisFuture<AggregateResults<K>> aggregate(K index, V query) {
        return this.dispatch((RedisCommand)this.commandBuilder.aggregate(index, query, null));
    }

    @Override
    public RedisFuture<AggregateResults<K>> aggregate(K index, V query, AggregateOptions options) {
        return this.dispatch((RedisCommand)this.commandBuilder.aggregate(index, query, options));
    }

    @Override
    public RedisFuture<AggregateWithCursorResults<K>> aggregate(K index, V query, Cursor cursor) {
        return this.dispatch((RedisCommand)this.commandBuilder.aggregate(index, query, cursor, null));
    }

    @Override
    public RedisFuture<AggregateWithCursorResults<K>> aggregate(K index, V query, Cursor cursor, AggregateOptions options) {
        return this.dispatch((RedisCommand)this.commandBuilder.aggregate(index, query, cursor, options));
    }

    @Override
    public RedisFuture<AggregateWithCursorResults<K>> cursorRead(K index, long cursor) {
        return this.dispatch((RedisCommand)this.commandBuilder.cursorRead(index, cursor, null));
    }

    @Override
    public RedisFuture<AggregateWithCursorResults<K>> cursorRead(K index, long cursor, long count) {
        return this.dispatch((RedisCommand)this.commandBuilder.cursorRead(index, cursor, count));
    }

    @Override
    public RedisFuture<String> cursorDelete(K index, long cursor) {
        return this.dispatch((RedisCommand)this.commandBuilder.cursorDelete(index, cursor));
    }

    @Override
    public RedisFuture<Long> sugadd(K key, Suggestion<V> suggestion) {
        return this.dispatch((RedisCommand)this.commandBuilder.sugadd(key, suggestion));
    }

    @Override
    public RedisFuture<Long> sugadd(K key, Suggestion<V> suggestion, boolean increment) {
        return this.dispatch((RedisCommand)this.commandBuilder.sugadd(key, suggestion, increment));
    }

    @Override
    public RedisFuture<List<Suggestion<V>>> sugget(K key, V prefix) {
        return this.dispatch((RedisCommand)this.commandBuilder.sugget(key, prefix));
    }

    @Override
    public RedisFuture<List<Suggestion<V>>> sugget(K key, V prefix, SuggetOptions options) {
        return this.dispatch((RedisCommand)this.commandBuilder.sugget(key, prefix, options));
    }

    @Override
    public RedisFuture<Boolean> sugdel(K key, V string) {
        return this.dispatch((RedisCommand)this.commandBuilder.sugdel(key, string));
    }

    @Override
    public RedisFuture<Long> suglen(K key) {
        return this.dispatch((RedisCommand)this.commandBuilder.suglen(key));
    }

    @Override
    public RedisFuture<String> alter(K index, Field<K> field) {
        return this.dispatch((RedisCommand)this.commandBuilder.alter(index, field));
    }

    @Override
    public RedisFuture<String> aliasAdd(K name, K index) {
        return this.dispatch((RedisCommand)this.commandBuilder.aliasAdd(name, index));
    }

    @Override
    public RedisFuture<String> aliasDel(K name) {
        return this.dispatch((RedisCommand)this.commandBuilder.aliasDel(name));
    }

    @Override
    public RedisFuture<String> aliasUpdate(K name, K index) {
        return this.dispatch((RedisCommand)this.commandBuilder.aliasUpdate(name, index));
    }

    @Override
    public RedisFuture<List<K>> list() {
        return this.dispatch((RedisCommand)this.commandBuilder.list());
    }
}

