/*
 * Decompiled with CFR 0.152.
 */
package com.redislabs.lettusearch.impl;

import com.redislabs.lettusearch.AggregateOptions;
import com.redislabs.lettusearch.AggregateResults;
import com.redislabs.lettusearch.AggregateWithCursorResults;
import com.redislabs.lettusearch.CreateOptions;
import com.redislabs.lettusearch.Cursor;
import com.redislabs.lettusearch.Field;
import com.redislabs.lettusearch.RediSearchCommandBuilder;
import com.redislabs.lettusearch.RediSearchReactiveCommands;
import com.redislabs.lettusearch.SearchOptions;
import com.redislabs.lettusearch.SearchResults;
import com.redislabs.lettusearch.StatefulRediSearchConnection;
import com.redislabs.lettusearch.Suggestion;
import com.redislabs.lettusearch.SuggetOptions;
import io.lettuce.core.RedisReactiveCommandsImpl;
import io.lettuce.core.codec.RedisCodec;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class RediSearchReactiveCommandsImpl<K, V>
extends RedisReactiveCommandsImpl<K, V>
implements RediSearchReactiveCommands<K, V> {
    private final StatefulRediSearchConnection<K, V> connection;
    private final RediSearchCommandBuilder<K, V> commandBuilder;

    public RediSearchReactiveCommandsImpl(StatefulRediSearchConnection<K, V> connection, RedisCodec<K, V> codec) {
        super(connection, codec);
        this.connection = connection;
        this.commandBuilder = new RediSearchCommandBuilder<K, V>(codec);
    }

    @Override
    public StatefulRediSearchConnection<K, V> getStatefulConnection() {
        return this.connection;
    }

    @Override
    public Mono<String> create(K index, Field<K> ... fields) {
        return this.create(index, (CreateOptions<K, V>)null, fields);
    }

    @Override
    public Mono<String> create(K index, CreateOptions<K, V> options, Field<K> ... fields) {
        return this.createMono(() -> this.commandBuilder.create(index, options, fields));
    }

    @Override
    public Mono<String> dropIndex(K index) {
        return this.dropIndex(index, false);
    }

    @Override
    public Mono<String> dropIndex(K index, boolean deleteDocs) {
        return this.createMono(() -> this.commandBuilder.dropIndex(index, deleteDocs));
    }

    @Override
    public Flux<Object> ftInfo(K index) {
        return this.createDissolvingFlux(() -> this.commandBuilder.info(index));
    }

    @Override
    public Mono<SearchResults<K, V>> search(K index, V query) {
        return this.createMono(() -> this.commandBuilder.search(index, query, null));
    }

    @Override
    public Mono<SearchResults<K, V>> search(K index, V query, SearchOptions<K> options) {
        return this.createMono(() -> this.commandBuilder.search(index, query, options));
    }

    @Override
    public Mono<AggregateResults<K>> aggregate(K index, V query) {
        return this.createMono(() -> this.commandBuilder.aggregate(index, query, null));
    }

    @Override
    public Mono<AggregateResults<K>> aggregate(K index, V query, AggregateOptions options) {
        return this.createMono(() -> this.commandBuilder.aggregate(index, query, options));
    }

    @Override
    public Mono<AggregateWithCursorResults<K>> aggregate(K index, V query, Cursor cursor) {
        return this.createMono(() -> this.commandBuilder.aggregate(index, query, cursor, null));
    }

    @Override
    public Mono<AggregateWithCursorResults<K>> aggregate(K index, V query, Cursor cursor, AggregateOptions options) {
        return this.createMono(() -> this.commandBuilder.aggregate(index, query, cursor, options));
    }

    @Override
    public Mono<AggregateWithCursorResults<K>> cursorRead(K index, long cursor) {
        return this.createMono(() -> this.commandBuilder.cursorRead(index, cursor, null));
    }

    @Override
    public Mono<AggregateWithCursorResults<K>> cursorRead(K index, long cursor, long count) {
        return this.createMono(() -> this.commandBuilder.cursorRead(index, cursor, count));
    }

    @Override
    public Mono<String> cursorDelete(K index, long cursor) {
        return this.createMono(() -> this.commandBuilder.cursorDelete(index, cursor));
    }

    @Override
    public Mono<Long> sugadd(K key, Suggestion<V> suggestion) {
        return this.createMono(() -> this.commandBuilder.sugadd(key, suggestion));
    }

    @Override
    public Mono<Long> sugadd(K key, Suggestion<V> suggestion, boolean increment) {
        return this.createMono(() -> this.commandBuilder.sugadd(key, suggestion, increment));
    }

    @Override
    public Flux<Suggestion<V>> sugget(K key, V prefix) {
        return this.createDissolvingFlux(() -> this.commandBuilder.sugget(key, prefix));
    }

    @Override
    public Flux<Suggestion<V>> sugget(K key, V prefix, SuggetOptions options) {
        return this.createDissolvingFlux(() -> this.commandBuilder.sugget(key, prefix, options));
    }

    @Override
    public Mono<Boolean> sugdel(K key, V string) {
        return this.createMono(() -> this.commandBuilder.sugdel(key, string));
    }

    @Override
    public Mono<Long> suglen(K key) {
        return this.createMono(() -> this.commandBuilder.suglen(key));
    }

    @Override
    public Mono<String> alter(K index, Field<K> field) {
        return this.createMono(() -> this.commandBuilder.alter(index, field));
    }

    @Override
    public Mono<String> aliasAdd(K name, K index) {
        return this.createMono(() -> this.commandBuilder.aliasAdd(name, index));
    }

    @Override
    public Mono<String> aliasUpdate(K name, K index) {
        return this.createMono(() -> this.commandBuilder.aliasUpdate(name, index));
    }

    @Override
    public Mono<String> aliasDel(K name) {
        return this.createMono(() -> this.commandBuilder.aliasDel(name));
    }

    @Override
    public Flux<K> list() {
        return this.createDissolvingFlux(this.commandBuilder::list);
    }
}

