/*
 * Decompiled with CFR 0.152.
 */
package com.redislabs.mesclun.gears;

import com.redislabs.mesclun.gears.Execution;
import com.redislabs.mesclun.gears.ExecutionDetails;
import com.redislabs.mesclun.gears.ExecutionMode;
import com.redislabs.mesclun.gears.Registration;
import com.redislabs.mesclun.gears.output.ExecutionDetailsOutput;
import com.redislabs.mesclun.gears.output.ExecutionListOutput;
import com.redislabs.mesclun.gears.output.ExecutionResults;
import com.redislabs.mesclun.gears.output.ExecutionResultsOutput;
import com.redislabs.mesclun.gears.output.RegistrationListOutput;
import com.redislabs.mesclun.gears.protocol.CommandKeyword;
import com.redislabs.mesclun.gears.protocol.CommandType;
import com.redislabs.mesclun.impl.RedisModulesCommandBuilder;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.output.ArrayOutput;
import io.lettuce.core.output.CommandOutput;
import io.lettuce.core.output.StatusOutput;
import io.lettuce.core.output.ValueListOutput;
import io.lettuce.core.protocol.Command;
import io.lettuce.core.protocol.CommandArgs;
import io.lettuce.core.protocol.ProtocolKeyword;
import java.util.List;
import java.util.Map;

public class RedisGearsCommandBuilder<K, V>
extends RedisModulesCommandBuilder<K, V> {
    public RedisGearsCommandBuilder(RedisCodec<K, V> codec) {
        super(codec);
    }

    protected <A, B, T> Command<A, B, T> createCommand(CommandType type, CommandOutput<A, B, T> output) {
        return new Command((ProtocolKeyword)type, output);
    }

    protected <A, B, T> Command<A, B, T> createCommand(CommandType type, CommandOutput<A, B, T> output, CommandArgs<A, B> args) {
        return new Command((ProtocolKeyword)type, output, args);
    }

    private CommandArgs<K, V> args() {
        return new CommandArgs(this.codec);
    }

    public Command<K, V, String> abortExecution(String id) {
        this.notNull(id, "execution ID");
        CommandArgs<K, V> args = this.args();
        args.add(id);
        return this.createCommand(CommandType.ABORTEXECUTION, (CommandOutput)new StatusOutput(this.codec), (CommandArgs)args);
    }

    public Command<K, V, List<V>> configGet(K ... keys) {
        LettuceAssert.notEmpty((Object[])keys, (String)"At least one key is required.");
        CommandArgs<K, V> args = this.args();
        for (K key : keys) {
            args.addKey(key);
        }
        return this.createCommand(CommandType.CONFIGGET, (CommandOutput)new ValueListOutput(this.codec), (CommandArgs)args);
    }

    public Command<K, V, List<V>> configSet(Map<K, V> map) {
        this.notNull(map, "Map");
        LettuceAssert.isTrue((!map.isEmpty() ? 1 : 0) != 0, (String)"At least one key/value is required.");
        CommandArgs<K, V> args = this.args();
        args.add(map);
        return this.createCommand(CommandType.CONFIGSET, (CommandOutput)new ValueListOutput(this.codec), (CommandArgs)args);
    }

    public Command<K, V, String> dropExecution(String id) {
        this.notNull(id, "Execution ID");
        CommandArgs<K, V> args = this.args();
        args.add(id);
        return this.createCommand(CommandType.DROPEXECUTION, (CommandOutput)new StatusOutput(this.codec), (CommandArgs)args);
    }

    public Command<K, V, List<Execution>> dumpExecutions() {
        return this.createCommand(CommandType.DUMPEXECUTIONS, new ExecutionListOutput(this.codec));
    }

    public Command<K, V, List<Registration>> dumpRegistrations() {
        return this.createCommand(CommandType.DUMPREGISTRATIONS, new RegistrationListOutput(this.codec));
    }

    public Command<K, V, ExecutionDetails> getExecution(String id) {
        return this.getExecution(id, null);
    }

    public Command<K, V, ExecutionDetails> getExecution(String id, ExecutionMode mode) {
        this.notNull(id, "Execution ID");
        CommandArgs<K, V> args = this.args();
        args.add(id);
        if (mode != null) {
            args.add((ProtocolKeyword)(mode == ExecutionMode.SHARD ? CommandKeyword.SHARD : CommandKeyword.CLUSTER));
        }
        return this.createCommand(CommandType.GETEXECUTION, new ExecutionDetailsOutput(this.codec), args);
    }

    public Command<K, V, ExecutionResults> getResults(String id) {
        return this.getResults(id, false);
    }

    public Command<K, V, ExecutionResults> getResultsBlocking(String id) {
        return this.getResults(id, true);
    }

    private Command<K, V, ExecutionResults> getResults(String id, boolean blocking) {
        this.notNull(id, "Execution ID");
        CommandArgs<K, V> args = this.args();
        args.add(id);
        return this.createCommand(blocking ? CommandType.GETRESULTSBLOCKING : CommandType.GETRESULTS, new ExecutionResultsOutput(this.codec), args);
    }

    public Command<K, V, ExecutionResults> pyExecute(String function, V ... requirements) {
        CommandArgs<K, V> args = this.pyExecuteArgs(function, false, requirements);
        return this.createCommand(CommandType.PYEXECUTE, new ExecutionResultsOutput(this.codec), args);
    }

    public Command<K, V, String> pyExecuteUnblocking(String function, V ... requirements) {
        CommandArgs<K, V> args = this.pyExecuteArgs(function, true, requirements);
        return this.createCommand(CommandType.PYEXECUTE, (CommandOutput)new StatusOutput(this.codec), (CommandArgs)args);
    }

    private CommandArgs<K, V> pyExecuteArgs(String function, boolean unblocking, V ... requirements) {
        this.notNull(function, "Function");
        this.notNull(requirements, "Requirements");
        CommandArgs<K, V> args = this.args();
        args.add(function);
        if (unblocking) {
            args.add((ProtocolKeyword)CommandKeyword.UNBLOCKING);
        }
        if (requirements.length > 0) {
            args.add((ProtocolKeyword)CommandKeyword.REQUIREMENTS);
            args.addValues((Object[])requirements);
        }
        return args;
    }

    public Command<K, V, List<Object>> trigger(String trigger, V ... args) {
        this.notNull(trigger, "Trigger name");
        CommandArgs<K, V> commandArgs = this.args();
        commandArgs.add(trigger);
        commandArgs.addValues((Object[])args);
        return this.createCommand(CommandType.TRIGGER, (CommandOutput)new ArrayOutput(this.codec), (CommandArgs)commandArgs);
    }

    public Command<K, V, String> unregister(String id) {
        this.notNull(id, "Registration ID");
        CommandArgs<K, V> args = this.args();
        args.add(id);
        return this.createCommand(CommandType.UNREGISTER, (CommandOutput)new StatusOutput(this.codec), (CommandArgs)args);
    }
}

