/*
 * Decompiled with CFR 0.152.
 */
package com.redislabs.mesclun.gears.output;

import com.redislabs.mesclun.gears.Registration;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.output.CommandOutput;
import io.lettuce.core.output.ListSubscriber;
import io.lettuce.core.output.StreamingOutput;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class RegistrationListOutput<K, V>
extends CommandOutput<K, V, List<Registration>>
implements StreamingOutput<Registration> {
    private boolean initialized;
    private StreamingOutput.Subscriber<Registration> subscriber;
    private Registration registration;
    private String field;
    private int argSize;

    public RegistrationListOutput(RedisCodec<K, V> codec) {
        super(codec, Collections.emptyList());
        this.setSubscriber((StreamingOutput.Subscriber<Registration>)ListSubscriber.instance());
    }

    public void set(ByteBuffer bytes) {
        if (this.field == null) {
            this.field = this.decodeAscii(bytes);
            return;
        }
        if (this.field.equals("id")) {
            this.registration = new Registration();
            this.registration.setId(this.decodeAscii(bytes));
            this.field = null;
            return;
        }
        if (this.field.equals("reader")) {
            this.registration.setReader(this.decodeAscii(bytes));
            this.field = null;
            return;
        }
        if (this.field.equals("desc")) {
            this.registration.setDescription(this.decodeAscii(bytes));
            this.field = null;
            return;
        }
        if (this.field.equals("RegistrationData")) {
            this.registration.setData(new Registration.Data());
            this.field = this.decodeAscii(bytes);
            return;
        }
        if (this.field.equals("mode")) {
            this.registration.getData().setMode(this.decodeAscii(bytes));
            this.field = null;
            return;
        }
        if (this.field.equals("lastError")) {
            this.registration.getData().setLastError(this.decodeAscii(bytes));
            this.field = null;
            return;
        }
        if (this.field.equals("args")) {
            this.field = this.decodeAscii(bytes);
            return;
        }
        if (this.registration.getData().getArgs().size() < this.argSize) {
            this.registration.getData().getArgs().put(this.field, this.decodeAscii(bytes));
            this.field = null;
            return;
        }
        if (this.field.equals("status")) {
            this.registration.getData().setStatus(this.decodeAscii(bytes));
            this.field = null;
            return;
        }
        if (this.field.equals("PD")) {
            this.registration.setPrivateData(this.decodeAscii(bytes));
            this.field = null;
            this.subscriber.onNext((Collection)this.output, (Object)this.registration);
            this.registration = null;
        }
    }

    public void set(long integer) {
        if (this.field.equals("numTriggered")) {
            this.registration.getData().setNumTriggered(integer);
            this.field = null;
            return;
        }
        if (this.field.equals("numSuccess")) {
            this.registration.getData().setNumSuccess(integer);
            this.field = null;
            return;
        }
        if (this.field.equals("numFailures")) {
            this.registration.getData().setNumFailures(integer);
            this.field = null;
            return;
        }
        if (this.field.equals("numAborted")) {
            this.registration.getData().setNumAborted(integer);
            this.field = null;
            return;
        }
        if (this.registration.getData().getArgs().size() < this.argSize) {
            this.registration.getData().getArgs().put(this.field, integer);
            this.field = null;
        }
    }

    public void multi(int count) {
        if (!this.initialized) {
            this.output = this.newList(count);
            this.initialized = true;
            return;
        }
        if ("args".equals(this.field)) {
            this.argSize = count / 2;
            this.registration.getData().setArgs(new HashMap<String, Object>(this.argSize));
        }
    }

    private List<Registration> newList(int capacity) {
        if (capacity < 1) {
            return Collections.emptyList();
        }
        return new ArrayList<Registration>(capacity);
    }

    public void setSubscriber(StreamingOutput.Subscriber<Registration> subscriber) {
        this.subscriber = subscriber;
    }

    public StreamingOutput.Subscriber<Registration> getSubscriber() {
        return this.subscriber;
    }
}

