/*
 * Decompiled with CFR 0.152.
 */
package com.redislabs.mesclun.impl;

import com.redislabs.mesclun.RedisModulesReactiveCommands;
import com.redislabs.mesclun.StatefulRedisModulesConnection;
import com.redislabs.mesclun.gears.Execution;
import com.redislabs.mesclun.gears.ExecutionDetails;
import com.redislabs.mesclun.gears.ExecutionMode;
import com.redislabs.mesclun.gears.RedisGearsCommandBuilder;
import com.redislabs.mesclun.gears.Registration;
import com.redislabs.mesclun.gears.output.ExecutionResults;
import com.redislabs.mesclun.search.AggregateOptions;
import com.redislabs.mesclun.search.AggregateResults;
import com.redislabs.mesclun.search.AggregateWithCursorResults;
import com.redislabs.mesclun.search.Cursor;
import com.redislabs.mesclun.search.Field;
import com.redislabs.mesclun.search.RediSearchCommandBuilder;
import com.redislabs.mesclun.search.SearchOptions;
import com.redislabs.mesclun.search.SearchResults;
import com.redislabs.mesclun.search.SugaddOptions;
import com.redislabs.mesclun.search.Suggestion;
import com.redislabs.mesclun.search.SuggetOptions;
import com.redislabs.mesclun.timeseries.Aggregation;
import com.redislabs.mesclun.timeseries.CreateOptions;
import com.redislabs.mesclun.timeseries.Label;
import com.redislabs.mesclun.timeseries.RedisTimeSeriesCommandBuilder;
import io.lettuce.core.RedisReactiveCommandsImpl;
import io.lettuce.core.codec.RedisCodec;
import java.util.Map;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class RedisModulesReactiveCommandsImpl<K, V>
extends RedisReactiveCommandsImpl<K, V>
implements RedisModulesReactiveCommands<K, V> {
    private final StatefulRedisModulesConnection<K, V> connection;
    private final RedisTimeSeriesCommandBuilder<K, V> timeSeriesCommandBuilder;
    private final RedisGearsCommandBuilder<K, V> gearsCommandBuilder;
    private final RediSearchCommandBuilder<K, V> searchCommandBuilder;

    public RedisModulesReactiveCommandsImpl(StatefulRedisModulesConnection<K, V> connection, RedisCodec<K, V> codec) {
        super(connection, codec);
        this.connection = connection;
        this.gearsCommandBuilder = new RedisGearsCommandBuilder<K, V>(codec);
        this.timeSeriesCommandBuilder = new RedisTimeSeriesCommandBuilder<K, V>(codec);
        this.searchCommandBuilder = new RediSearchCommandBuilder<K, V>(codec);
    }

    @Override
    public StatefulRedisModulesConnection<K, V> getStatefulConnection() {
        return this.connection;
    }

    @Override
    public Mono<ExecutionResults> pyExecute(String function, V ... requirements) {
        return this.createMono(() -> this.gearsCommandBuilder.pyExecute(function, requirements));
    }

    @Override
    public Mono<String> pyExecuteUnblocking(String function, V ... requirements) {
        return this.createMono(() -> this.gearsCommandBuilder.pyExecuteUnblocking(function, requirements));
    }

    @Override
    public Flux<Object> trigger(String trigger, V ... args) {
        return this.createDissolvingFlux(() -> this.gearsCommandBuilder.trigger(trigger, args));
    }

    @Override
    public Mono<String> unregister(String id) {
        return this.createMono(() -> this.gearsCommandBuilder.unregister(id));
    }

    @Override
    public Mono<String> abortExecution(String id) {
        return this.createMono(() -> this.gearsCommandBuilder.abortExecution(id));
    }

    @Override
    public Flux<V> configGet(K ... keys) {
        return this.createDissolvingFlux(() -> this.gearsCommandBuilder.configGet(keys));
    }

    @Override
    public Flux<V> configSet(Map<K, V> map) {
        return this.createDissolvingFlux(() -> this.gearsCommandBuilder.configSet(map));
    }

    @Override
    public Mono<String> dropExecution(String id) {
        return this.createMono(() -> this.gearsCommandBuilder.dropExecution(id));
    }

    @Override
    public Flux<Execution> dumpExecutions() {
        return this.createDissolvingFlux(this.gearsCommandBuilder::dumpExecutions);
    }

    @Override
    public Flux<Registration> dumpRegistrations() {
        return this.createDissolvingFlux(this.gearsCommandBuilder::dumpRegistrations);
    }

    @Override
    public Mono<ExecutionDetails> getExecution(String id) {
        return this.createMono(() -> this.gearsCommandBuilder.getExecution(id));
    }

    @Override
    public Mono<ExecutionDetails> getExecution(String id, ExecutionMode mode) {
        return this.createMono(() -> this.gearsCommandBuilder.getExecution(id, mode));
    }

    @Override
    public Mono<ExecutionResults> getResults(String id) {
        return this.createMono(() -> this.gearsCommandBuilder.getResults(id));
    }

    @Override
    public Mono<ExecutionResults> getResultsBlocking(String id) {
        return this.createMono(() -> this.gearsCommandBuilder.getResultsBlocking(id));
    }

    @Override
    public Mono<String> create(K key, CreateOptions options, Label<K, V> ... labels) {
        return this.createMono(() -> this.timeSeriesCommandBuilder.create(key, options, labels));
    }

    @Override
    public Mono<String> create(K key, Label<K, V> ... labels) {
        return this.createMono(() -> this.timeSeriesCommandBuilder.create(key, null, labels));
    }

    @Override
    public Mono<Long> add(K key, long timestamp, double value, CreateOptions options, Label<K, V> ... labels) {
        return this.createMono(() -> this.timeSeriesCommandBuilder.add(key, timestamp, value, options, labels));
    }

    @Override
    public Mono<Long> add(K key, long timestamp, double value, Label<K, V> ... labels) {
        return this.createMono(() -> this.timeSeriesCommandBuilder.add(key, timestamp, value, null, labels));
    }

    @Override
    public Mono<String> createRule(K sourceKey, K destKey, Aggregation aggregationType, long timeBucket) {
        return this.createMono(() -> this.timeSeriesCommandBuilder.createRule(sourceKey, destKey, aggregationType, timeBucket));
    }

    @Override
    public Mono<String> deleteRule(K sourceKey, K destKey) {
        return this.createMono(() -> this.timeSeriesCommandBuilder.deleteRule(sourceKey, destKey));
    }

    @Override
    public Mono<String> create(K index, Field ... fields) {
        return this.create(index, (com.redislabs.mesclun.search.CreateOptions<K, V>)null, fields);
    }

    @Override
    public Mono<String> create(K index, com.redislabs.mesclun.search.CreateOptions<K, V> options, Field ... fields) {
        return this.createMono(() -> this.searchCommandBuilder.create(index, options, fields));
    }

    @Override
    public Mono<String> dropIndex(K index) {
        return this.dropIndex(index, false);
    }

    @Override
    public Mono<String> dropIndex(K index, boolean deleteDocs) {
        return this.createMono(() -> this.searchCommandBuilder.dropIndex(index, deleteDocs));
    }

    @Override
    public Flux<Object> indexInfo(K index) {
        return this.createDissolvingFlux(() -> this.searchCommandBuilder.info(index));
    }

    @Override
    public Mono<SearchResults<K, V>> search(K index, V query) {
        return this.createMono(() -> this.searchCommandBuilder.search(index, query, null));
    }

    @Override
    public Mono<SearchResults<K, V>> search(K index, V query, SearchOptions options) {
        return this.createMono(() -> this.searchCommandBuilder.search(index, query, options));
    }

    @Override
    public Mono<AggregateResults<K>> aggregate(K index, V query) {
        return this.createMono(() -> this.searchCommandBuilder.aggregate(index, query, null));
    }

    @Override
    public Mono<AggregateResults<K>> aggregate(K index, V query, AggregateOptions options) {
        return this.createMono(() -> this.searchCommandBuilder.aggregate(index, query, options));
    }

    @Override
    public Mono<AggregateWithCursorResults<K>> aggregate(K index, V query, Cursor cursor) {
        return this.createMono(() -> this.searchCommandBuilder.aggregate(index, query, cursor, null));
    }

    @Override
    public Mono<AggregateWithCursorResults<K>> aggregate(K index, V query, Cursor cursor, AggregateOptions options) {
        return this.createMono(() -> this.searchCommandBuilder.aggregate(index, query, cursor, options));
    }

    @Override
    public Mono<AggregateWithCursorResults<K>> cursorRead(K index, long cursor) {
        return this.createMono(() -> this.searchCommandBuilder.cursorRead(index, cursor, null));
    }

    @Override
    public Mono<AggregateWithCursorResults<K>> cursorRead(K index, long cursor, long count) {
        return this.createMono(() -> this.searchCommandBuilder.cursorRead(index, cursor, count));
    }

    @Override
    public Mono<String> cursorDelete(K index, long cursor) {
        return this.createMono(() -> this.searchCommandBuilder.cursorDelete(index, cursor));
    }

    @Override
    public Mono<Long> sugadd(K key, V string, double score) {
        return this.createMono(() -> this.searchCommandBuilder.sugadd(key, string, score));
    }

    @Override
    public Mono<Long> sugadd(K key, V string, double score, SugaddOptions<V> options) {
        return this.createMono(() -> this.searchCommandBuilder.sugadd(key, string, score, options));
    }

    @Override
    public Flux<Suggestion<V>> sugget(K key, V prefix) {
        return this.createDissolvingFlux(() -> this.searchCommandBuilder.sugget(key, prefix));
    }

    @Override
    public Flux<Suggestion<V>> sugget(K key, V prefix, SuggetOptions options) {
        return this.createDissolvingFlux(() -> this.searchCommandBuilder.sugget(key, prefix, options));
    }

    @Override
    public Mono<Boolean> sugdel(K key, V string) {
        return this.createMono(() -> this.searchCommandBuilder.sugdel(key, string));
    }

    @Override
    public Mono<Long> suglen(K key) {
        return this.createMono(() -> this.searchCommandBuilder.suglen(key));
    }

    @Override
    public Mono<String> alter(K index, Field field) {
        return this.createMono(() -> this.searchCommandBuilder.alter(index, field));
    }

    @Override
    public Mono<String> aliasAdd(K name, K index) {
        return this.createMono(() -> this.searchCommandBuilder.aliasAdd(name, index));
    }

    @Override
    public Mono<String> aliasUpdate(K name, K index) {
        return this.createMono(() -> this.searchCommandBuilder.aliasUpdate(name, index));
    }

    @Override
    public Mono<String> aliasDel(K name) {
        return this.createMono(() -> this.searchCommandBuilder.aliasDel(name));
    }

    @Override
    public Flux<K> list() {
        return this.createDissolvingFlux(this.searchCommandBuilder::list);
    }
}

