/*
 * Decompiled with CFR 0.152.
 */
package com.redislabs.mesclun.search;

import com.redislabs.mesclun.search.RediSearchArgument;
import com.redislabs.mesclun.search.protocol.CommandKeyword;
import com.redislabs.mesclun.search.protocol.RediSearchCommandArgs;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class AggregateOptions
implements RediSearchArgument {
    private final boolean verbatim;
    private final List<String> loads;
    private final List<Operation> operations;

    public void build(RediSearchCommandArgs args) {
        if (this.verbatim) {
            args.add(CommandKeyword.VERBATIM);
        }
        if (!this.loads.isEmpty()) {
            args.add(CommandKeyword.LOAD);
            args.add(this.loads.size());
            for (String load : this.loads) {
                args.addProperty(load);
            }
        }
        for (Operation operation : this.operations) {
            operation.build(args);
        }
    }

    AggregateOptions(boolean verbatim, List<String> loads, List<Operation> operations) {
        this.verbatim = verbatim;
        this.loads = loads;
        this.operations = operations;
    }

    public static AggregateOptionsBuilder builder() {
        return new AggregateOptionsBuilder();
    }

    public static class AggregateOptionsBuilder {
        private boolean verbatim;
        private ArrayList<String> loads;
        private ArrayList<Operation> operations;

        AggregateOptionsBuilder() {
        }

        public AggregateOptionsBuilder verbatim(boolean verbatim) {
            this.verbatim = verbatim;
            return this;
        }

        public AggregateOptionsBuilder load(String load) {
            if (this.loads == null) {
                this.loads = new ArrayList();
            }
            this.loads.add(load);
            return this;
        }

        public AggregateOptionsBuilder loads(Collection<? extends String> loads) {
            if (loads == null) {
                throw new NullPointerException("loads cannot be null");
            }
            if (this.loads == null) {
                this.loads = new ArrayList();
            }
            this.loads.addAll(loads);
            return this;
        }

        public AggregateOptionsBuilder clearLoads() {
            if (this.loads != null) {
                this.loads.clear();
            }
            return this;
        }

        public AggregateOptionsBuilder operation(Operation operation) {
            if (this.operations == null) {
                this.operations = new ArrayList();
            }
            this.operations.add(operation);
            return this;
        }

        public AggregateOptionsBuilder operations(Collection<? extends Operation> operations) {
            if (operations == null) {
                throw new NullPointerException("operations cannot be null");
            }
            if (this.operations == null) {
                this.operations = new ArrayList();
            }
            this.operations.addAll(operations);
            return this;
        }

        public AggregateOptionsBuilder clearOperations() {
            if (this.operations != null) {
                this.operations.clear();
            }
            return this;
        }

        public AggregateOptions build() {
            List<Operation> operations;
            List<String> loads;
            switch (this.loads == null ? 0 : this.loads.size()) {
                case 0: {
                    loads = Collections.emptyList();
                    break;
                }
                case 1: {
                    loads = Collections.singletonList(this.loads.get(0));
                    break;
                }
                default: {
                    loads = Collections.unmodifiableList(new ArrayList<String>(this.loads));
                }
            }
            switch (this.operations == null ? 0 : this.operations.size()) {
                case 0: {
                    operations = Collections.emptyList();
                    break;
                }
                case 1: {
                    operations = Collections.singletonList(this.operations.get(0));
                    break;
                }
                default: {
                    operations = Collections.unmodifiableList(new ArrayList<Operation>(this.operations));
                }
            }
            return new AggregateOptions(this.verbatim, loads, operations);
        }

        public String toString() {
            return "AggregateOptions.AggregateOptionsBuilder(verbatim=" + this.verbatim + ", loads=" + this.loads + ", operations=" + this.operations + ")";
        }
    }

    public static interface Operation
    extends RediSearchArgument {
    }

    public static interface Reducer
    extends RediSearchArgument {
    }
}

