/*
 * Decompiled with CFR 0.152.
 */
package com.redislabs.mesclun.search;

import com.redislabs.mesclun.search.Language;
import com.redislabs.mesclun.search.RediSearchArgument;
import com.redislabs.mesclun.search.protocol.CommandKeyword;
import com.redislabs.mesclun.search.protocol.RediSearchCommandArgs;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class CreateOptions<K, V>
implements RediSearchArgument<K, V> {
    private Structure on;
    private List<K> prefixes;
    private String filter;
    private Language defaultLanguage;
    private K languageField;
    private Double defaultScore;
    private K scoreField;
    private K payloadField;
    private boolean maxTextFields;
    private Long temporary;
    private boolean noOffsets;
    private boolean noHL;
    private boolean noFields;
    private boolean noFreqs;
    private boolean noItitialScan;
    private List<V> stopWords;

    @Override
    public void build(RediSearchCommandArgs<K, V> args) {
        if (this.on != null) {
            args.add(CommandKeyword.ON);
            args.add(this.on.name());
        }
        if (this.prefixes != null) {
            args.add(CommandKeyword.PREFIX);
            args.add(this.prefixes.size());
            this.prefixes.forEach(args::addKey);
        }
        if (this.filter != null) {
            args.add(CommandKeyword.FILTER);
            args.add(this.filter);
        }
        if (this.defaultLanguage != null) {
            args.add(CommandKeyword.LANGUAGE);
            args.add(this.defaultLanguage.name());
        }
        if (this.languageField != null) {
            args.add(CommandKeyword.LANGUAGE_FIELD);
            args.addKey((Object)this.languageField);
        }
        if (this.defaultScore != null) {
            args.add(CommandKeyword.SCORE);
            args.add(this.defaultScore);
        }
        if (this.scoreField != null) {
            args.add(CommandKeyword.SCORE_FIELD);
            args.addKey((Object)this.scoreField);
        }
        if (this.payloadField != null) {
            args.add(CommandKeyword.PAYLOAD_FIELD);
            args.addKey((Object)this.payloadField);
        }
        if (this.maxTextFields) {
            args.add(CommandKeyword.MAXTEXTFIELDS);
        }
        if (this.temporary != null) {
            args.add(CommandKeyword.TEMPORARY);
            args.add(this.temporary);
        }
        if (this.noOffsets) {
            args.add(CommandKeyword.NOOFFSETS);
        }
        if (this.noHL) {
            args.add(CommandKeyword.NOHL);
        }
        if (this.noFields) {
            args.add(CommandKeyword.NOFIELDS);
        }
        if (this.noFreqs) {
            args.add(CommandKeyword.NOFREQS);
        }
        if (this.noItitialScan) {
            args.add(CommandKeyword.NOINITIALSCAN);
        }
        if (this.stopWords != null) {
            args.add(CommandKeyword.STOPWORDS);
            args.add(this.stopWords.size());
            this.stopWords.forEach(args::addValue);
        }
    }

    public static <K, V> CreateOptionsBuilder<K, V> builder() {
        return new CreateOptionsBuilder();
    }

    public Structure getOn() {
        return this.on;
    }

    public List<K> getPrefixes() {
        return this.prefixes;
    }

    public String getFilter() {
        return this.filter;
    }

    public Language getDefaultLanguage() {
        return this.defaultLanguage;
    }

    public K getLanguageField() {
        return this.languageField;
    }

    public Double getDefaultScore() {
        return this.defaultScore;
    }

    public K getScoreField() {
        return this.scoreField;
    }

    public K getPayloadField() {
        return this.payloadField;
    }

    public boolean isMaxTextFields() {
        return this.maxTextFields;
    }

    public Long getTemporary() {
        return this.temporary;
    }

    public boolean isNoOffsets() {
        return this.noOffsets;
    }

    public boolean isNoHL() {
        return this.noHL;
    }

    public boolean isNoFields() {
        return this.noFields;
    }

    public boolean isNoFreqs() {
        return this.noFreqs;
    }

    public boolean isNoItitialScan() {
        return this.noItitialScan;
    }

    public List<V> getStopWords() {
        return this.stopWords;
    }

    public void setOn(Structure on) {
        this.on = on;
    }

    public void setPrefixes(List<K> prefixes) {
        this.prefixes = prefixes;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public void setDefaultLanguage(Language defaultLanguage) {
        this.defaultLanguage = defaultLanguage;
    }

    public void setLanguageField(K languageField) {
        this.languageField = languageField;
    }

    public void setDefaultScore(Double defaultScore) {
        this.defaultScore = defaultScore;
    }

    public void setScoreField(K scoreField) {
        this.scoreField = scoreField;
    }

    public void setPayloadField(K payloadField) {
        this.payloadField = payloadField;
    }

    public void setMaxTextFields(boolean maxTextFields) {
        this.maxTextFields = maxTextFields;
    }

    public void setTemporary(Long temporary) {
        this.temporary = temporary;
    }

    public void setNoOffsets(boolean noOffsets) {
        this.noOffsets = noOffsets;
    }

    public void setNoHL(boolean noHL) {
        this.noHL = noHL;
    }

    public void setNoFields(boolean noFields) {
        this.noFields = noFields;
    }

    public void setNoFreqs(boolean noFreqs) {
        this.noFreqs = noFreqs;
    }

    public void setNoItitialScan(boolean noItitialScan) {
        this.noItitialScan = noItitialScan;
    }

    public void setStopWords(List<V> stopWords) {
        this.stopWords = stopWords;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CreateOptions)) {
            return false;
        }
        CreateOptions other = (CreateOptions)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isMaxTextFields() != other.isMaxTextFields()) {
            return false;
        }
        if (this.isNoOffsets() != other.isNoOffsets()) {
            return false;
        }
        if (this.isNoHL() != other.isNoHL()) {
            return false;
        }
        if (this.isNoFields() != other.isNoFields()) {
            return false;
        }
        if (this.isNoFreqs() != other.isNoFreqs()) {
            return false;
        }
        if (this.isNoItitialScan() != other.isNoItitialScan()) {
            return false;
        }
        Double this$defaultScore = this.getDefaultScore();
        Double other$defaultScore = other.getDefaultScore();
        if (this$defaultScore == null ? other$defaultScore != null : !((Object)this$defaultScore).equals(other$defaultScore)) {
            return false;
        }
        Long this$temporary = this.getTemporary();
        Long other$temporary = other.getTemporary();
        if (this$temporary == null ? other$temporary != null : !((Object)this$temporary).equals(other$temporary)) {
            return false;
        }
        Structure this$on = this.getOn();
        Structure other$on = other.getOn();
        if (this$on == null ? other$on != null : !((Object)((Object)this$on)).equals((Object)other$on)) {
            return false;
        }
        List<K> this$prefixes = this.getPrefixes();
        List<K> other$prefixes = other.getPrefixes();
        if (this$prefixes == null ? other$prefixes != null : !((Object)this$prefixes).equals(other$prefixes)) {
            return false;
        }
        String this$filter = this.getFilter();
        String other$filter = other.getFilter();
        if (this$filter == null ? other$filter != null : !this$filter.equals(other$filter)) {
            return false;
        }
        Language this$defaultLanguage = this.getDefaultLanguage();
        Language other$defaultLanguage = other.getDefaultLanguage();
        if (this$defaultLanguage == null ? other$defaultLanguage != null : !((Object)((Object)this$defaultLanguage)).equals((Object)other$defaultLanguage)) {
            return false;
        }
        K this$languageField = this.getLanguageField();
        K other$languageField = other.getLanguageField();
        if (this$languageField == null ? other$languageField != null : !this$languageField.equals(other$languageField)) {
            return false;
        }
        K this$scoreField = this.getScoreField();
        K other$scoreField = other.getScoreField();
        if (this$scoreField == null ? other$scoreField != null : !this$scoreField.equals(other$scoreField)) {
            return false;
        }
        K this$payloadField = this.getPayloadField();
        K other$payloadField = other.getPayloadField();
        if (this$payloadField == null ? other$payloadField != null : !this$payloadField.equals(other$payloadField)) {
            return false;
        }
        List<V> this$stopWords = this.getStopWords();
        List<V> other$stopWords = other.getStopWords();
        return !(this$stopWords == null ? other$stopWords != null : !((Object)this$stopWords).equals(other$stopWords));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CreateOptions;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isMaxTextFields() ? 79 : 97);
        result = result * 59 + (this.isNoOffsets() ? 79 : 97);
        result = result * 59 + (this.isNoHL() ? 79 : 97);
        result = result * 59 + (this.isNoFields() ? 79 : 97);
        result = result * 59 + (this.isNoFreqs() ? 79 : 97);
        result = result * 59 + (this.isNoItitialScan() ? 79 : 97);
        Double $defaultScore = this.getDefaultScore();
        result = result * 59 + ($defaultScore == null ? 43 : ((Object)$defaultScore).hashCode());
        Long $temporary = this.getTemporary();
        result = result * 59 + ($temporary == null ? 43 : ((Object)$temporary).hashCode());
        Structure $on = this.getOn();
        result = result * 59 + ($on == null ? 43 : ((Object)((Object)$on)).hashCode());
        List<K> $prefixes = this.getPrefixes();
        result = result * 59 + ($prefixes == null ? 43 : ((Object)$prefixes).hashCode());
        String $filter = this.getFilter();
        result = result * 59 + ($filter == null ? 43 : $filter.hashCode());
        Language $defaultLanguage = this.getDefaultLanguage();
        result = result * 59 + ($defaultLanguage == null ? 43 : ((Object)((Object)$defaultLanguage)).hashCode());
        K $languageField = this.getLanguageField();
        result = result * 59 + ($languageField == null ? 43 : $languageField.hashCode());
        K $scoreField = this.getScoreField();
        result = result * 59 + ($scoreField == null ? 43 : $scoreField.hashCode());
        K $payloadField = this.getPayloadField();
        result = result * 59 + ($payloadField == null ? 43 : $payloadField.hashCode());
        List<V> $stopWords = this.getStopWords();
        result = result * 59 + ($stopWords == null ? 43 : ((Object)$stopWords).hashCode());
        return result;
    }

    public String toString() {
        return "CreateOptions(on=" + (Object)((Object)this.getOn()) + ", prefixes=" + this.getPrefixes() + ", filter=" + this.getFilter() + ", defaultLanguage=" + (Object)((Object)this.getDefaultLanguage()) + ", languageField=" + this.getLanguageField() + ", defaultScore=" + this.getDefaultScore() + ", scoreField=" + this.getScoreField() + ", payloadField=" + this.getPayloadField() + ", maxTextFields=" + this.isMaxTextFields() + ", temporary=" + this.getTemporary() + ", noOffsets=" + this.isNoOffsets() + ", noHL=" + this.isNoHL() + ", noFields=" + this.isNoFields() + ", noFreqs=" + this.isNoFreqs() + ", noItitialScan=" + this.isNoItitialScan() + ", stopWords=" + this.getStopWords() + ")";
    }

    public CreateOptions() {
    }

    public CreateOptions(Structure on, List<K> prefixes, String filter, Language defaultLanguage, K languageField, Double defaultScore, K scoreField, K payloadField, boolean maxTextFields, Long temporary, boolean noOffsets, boolean noHL, boolean noFields, boolean noFreqs, boolean noItitialScan, List<V> stopWords) {
        this.on = on;
        this.prefixes = prefixes;
        this.filter = filter;
        this.defaultLanguage = defaultLanguage;
        this.languageField = languageField;
        this.defaultScore = defaultScore;
        this.scoreField = scoreField;
        this.payloadField = payloadField;
        this.maxTextFields = maxTextFields;
        this.temporary = temporary;
        this.noOffsets = noOffsets;
        this.noHL = noHL;
        this.noFields = noFields;
        this.noFreqs = noFreqs;
        this.noItitialScan = noItitialScan;
        this.stopWords = stopWords;
    }

    public static class CreateOptionsBuilder<K, V> {
        private Structure on;
        private ArrayList<K> prefixes;
        private String filter;
        private Language defaultLanguage;
        private K languageField;
        private Double defaultScore;
        private K scoreField;
        private K payloadField;
        private boolean maxTextFields;
        private Long temporary;
        private boolean noOffsets;
        private boolean noHL;
        private boolean noFields;
        private boolean noFreqs;
        private boolean noItitialScan;
        private List<V> stopWords;

        CreateOptionsBuilder() {
        }

        public CreateOptionsBuilder<K, V> on(Structure on) {
            this.on = on;
            return this;
        }

        public CreateOptionsBuilder<K, V> prefix(K prefix) {
            if (this.prefixes == null) {
                this.prefixes = new ArrayList();
            }
            this.prefixes.add(prefix);
            return this;
        }

        public CreateOptionsBuilder<K, V> prefixes(Collection<? extends K> prefixes) {
            if (prefixes == null) {
                throw new NullPointerException("prefixes cannot be null");
            }
            if (this.prefixes == null) {
                this.prefixes = new ArrayList();
            }
            this.prefixes.addAll(prefixes);
            return this;
        }

        public CreateOptionsBuilder<K, V> clearPrefixes() {
            if (this.prefixes != null) {
                this.prefixes.clear();
            }
            return this;
        }

        public CreateOptionsBuilder<K, V> filter(String filter) {
            this.filter = filter;
            return this;
        }

        public CreateOptionsBuilder<K, V> defaultLanguage(Language defaultLanguage) {
            this.defaultLanguage = defaultLanguage;
            return this;
        }

        public CreateOptionsBuilder<K, V> languageField(K languageField) {
            this.languageField = languageField;
            return this;
        }

        public CreateOptionsBuilder<K, V> defaultScore(Double defaultScore) {
            this.defaultScore = defaultScore;
            return this;
        }

        public CreateOptionsBuilder<K, V> scoreField(K scoreField) {
            this.scoreField = scoreField;
            return this;
        }

        public CreateOptionsBuilder<K, V> payloadField(K payloadField) {
            this.payloadField = payloadField;
            return this;
        }

        public CreateOptionsBuilder<K, V> maxTextFields(boolean maxTextFields) {
            this.maxTextFields = maxTextFields;
            return this;
        }

        public CreateOptionsBuilder<K, V> temporary(Long temporary) {
            this.temporary = temporary;
            return this;
        }

        public CreateOptionsBuilder<K, V> noOffsets(boolean noOffsets) {
            this.noOffsets = noOffsets;
            return this;
        }

        public CreateOptionsBuilder<K, V> noHL(boolean noHL) {
            this.noHL = noHL;
            return this;
        }

        public CreateOptionsBuilder<K, V> noFields(boolean noFields) {
            this.noFields = noFields;
            return this;
        }

        public CreateOptionsBuilder<K, V> noFreqs(boolean noFreqs) {
            this.noFreqs = noFreqs;
            return this;
        }

        public CreateOptionsBuilder<K, V> noItitialScan(boolean noItitialScan) {
            this.noItitialScan = noItitialScan;
            return this;
        }

        public CreateOptionsBuilder<K, V> stopWords(List<V> stopWords) {
            this.stopWords = stopWords;
            return this;
        }

        public CreateOptions<K, V> build() {
            List<Object> prefixes;
            switch (this.prefixes == null ? 0 : this.prefixes.size()) {
                case 0: {
                    prefixes = Collections.emptyList();
                    break;
                }
                case 1: {
                    prefixes = Collections.singletonList(this.prefixes.get(0));
                    break;
                }
                default: {
                    prefixes = Collections.unmodifiableList(new ArrayList<K>(this.prefixes));
                }
            }
            return new CreateOptions(this.on, prefixes, this.filter, this.defaultLanguage, this.languageField, this.defaultScore, this.scoreField, this.payloadField, this.maxTextFields, this.temporary, this.noOffsets, this.noHL, this.noFields, this.noFreqs, this.noItitialScan, this.stopWords);
        }

        public String toString() {
            return "CreateOptions.CreateOptionsBuilder(on=" + (Object)((Object)this.on) + ", prefixes=" + this.prefixes + ", filter=" + this.filter + ", defaultLanguage=" + (Object)((Object)this.defaultLanguage) + ", languageField=" + this.languageField + ", defaultScore=" + this.defaultScore + ", scoreField=" + this.scoreField + ", payloadField=" + this.payloadField + ", maxTextFields=" + this.maxTextFields + ", temporary=" + this.temporary + ", noOffsets=" + this.noOffsets + ", noHL=" + this.noHL + ", noFields=" + this.noFields + ", noFreqs=" + this.noFreqs + ", noItitialScan=" + this.noItitialScan + ", stopWords=" + this.stopWords + ")";
        }
    }

    public static enum Structure {
        HASH;

    }
}

