/*
 * Decompiled with CFR 0.152.
 */
package com.redislabs.mesclun.search;

import com.redislabs.mesclun.search.RediSearchArgument;
import com.redislabs.mesclun.search.protocol.CommandKeyword;
import com.redislabs.mesclun.search.protocol.RediSearchCommandArgs;
import io.lettuce.core.internal.LettuceAssert;

public abstract class Field
implements RediSearchArgument {
    private final Type type;
    private final String name;
    private final boolean sortable;
    private final boolean noIndex;

    protected Field(Type type, String name, boolean sortable, boolean noIndex) {
        LettuceAssert.notNull((Object)((Object)type), (String)"A type is required");
        LettuceAssert.notNull((Object)name, (String)"A name is required");
        this.type = type;
        this.name = name;
        this.sortable = sortable;
        this.noIndex = noIndex;
    }

    public void build(RediSearchCommandArgs args) {
        args.add(this.name);
        this.buildField(args);
        if (this.sortable) {
            args.add(CommandKeyword.SORTABLE);
        }
        if (this.noIndex) {
            args.add(CommandKeyword.NOINDEX);
        }
    }

    protected abstract void buildField(RediSearchCommandArgs var1);

    public static Text.TextFieldBuilder text(String name) {
        return Text.builder(name);
    }

    public static Geo.GeoFieldBuilder geo(String name) {
        return Geo.builder(name);
    }

    public static Tag.TagFieldBuilder tag(String name) {
        return Tag.builder(name);
    }

    public static Numeric.NumericFieldBuilder numeric(String name) {
        return Numeric.builder(name);
    }

    public Type getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public boolean isSortable() {
        return this.sortable;
    }

    public boolean isNoIndex() {
        return this.noIndex;
    }

    public static enum Type {
        TEXT,
        NUMERIC,
        GEO,
        TAG;

    }

    public static class Text
    extends Field {
        private final Double weight;
        private final boolean noStem;
        private final PhoneticMatcher matcher;

        public Text(String name, boolean sortable, boolean noIndex, Double weight, boolean noStem) {
            this(name, sortable, noIndex, weight, noStem, null);
        }

        public Text(String name, boolean sortable, boolean noIndex, Double weight, boolean noStem, PhoneticMatcher matcher) {
            super(Type.TEXT, name, sortable, noIndex);
            this.weight = weight;
            this.noStem = noStem;
            this.matcher = matcher;
        }

        @Override
        protected void buildField(RediSearchCommandArgs args) {
            args.add(CommandKeyword.TEXT);
            if (this.noStem) {
                args.add(CommandKeyword.NOSTEM);
            }
            if (this.weight != null) {
                args.add(CommandKeyword.WEIGHT);
                args.add(this.weight);
            }
            if (this.matcher != null) {
                args.add(CommandKeyword.PHONETIC);
                args.add(this.matcher.getCode());
            }
        }

        public static TextFieldBuilder builder(String name) {
            return new TextFieldBuilder(name);
        }

        public Double getWeight() {
            return this.weight;
        }

        public boolean isNoStem() {
            return this.noStem;
        }

        public PhoneticMatcher getMatcher() {
            return this.matcher;
        }

        public static enum PhoneticMatcher {
            English("dm:en"),
            French("dm:fr"),
            Portuguese("dm:pt"),
            Spanish("dm:es");

            private final String code;

            private PhoneticMatcher(String code) {
                this.code = code;
            }

            public String getCode() {
                return this.code;
            }
        }

        public static class TextFieldBuilder
        extends FieldBuilder<Text, TextFieldBuilder> {
            private Double weight;
            private boolean noStem;
            private PhoneticMatcher matcher;

            public TextFieldBuilder(String name) {
                super(name);
            }

            @Override
            public Text build() {
                return new Text(this.name, this.sortable, this.noIndex, this.weight, this.noStem, this.matcher);
            }

            public TextFieldBuilder weight(Double weight) {
                this.weight = weight;
                return this;
            }

            public TextFieldBuilder noStem(boolean noStem) {
                this.noStem = noStem;
                return this;
            }

            public TextFieldBuilder matcher(PhoneticMatcher matcher) {
                this.matcher = matcher;
                return this;
            }
        }
    }

    public static class Tag
    extends Field {
        private final String separator;

        public Tag(String name, boolean sortable, boolean noIndex, String separator) {
            super(Type.TAG, name, sortable, noIndex);
            this.separator = separator;
        }

        @Override
        protected void buildField(RediSearchCommandArgs args) {
            args.add(CommandKeyword.TAG);
            if (this.separator != null) {
                args.add(CommandKeyword.SEPARATOR);
                args.add(this.separator);
            }
        }

        public static TagFieldBuilder builder(String name) {
            return new TagFieldBuilder(name);
        }

        public String getSeparator() {
            return this.separator;
        }

        public static class TagFieldBuilder
        extends FieldBuilder<Tag, TagFieldBuilder> {
            private String separator;

            public TagFieldBuilder(String name) {
                super(name);
            }

            @Override
            public Tag build() {
                return new Tag(this.name, this.sortable, this.noIndex, this.separator);
            }

            public TagFieldBuilder separator(String separator) {
                this.separator = separator;
                return this;
            }
        }
    }

    public static class Numeric
    extends Field {
        public Numeric(String name, boolean sortable, boolean noIndex) {
            super(Type.NUMERIC, name, sortable, noIndex);
        }

        @Override
        protected void buildField(RediSearchCommandArgs args) {
            args.add(CommandKeyword.NUMERIC);
        }

        public static NumericFieldBuilder builder(String name) {
            return new NumericFieldBuilder(name);
        }

        public static class NumericFieldBuilder
        extends FieldBuilder<Numeric, NumericFieldBuilder> {
            public NumericFieldBuilder(String name) {
                super(name);
            }

            @Override
            public Numeric build() {
                return new Numeric(this.name, this.sortable, this.noIndex);
            }
        }
    }

    public static class Geo
    extends Field {
        public Geo(String name, boolean sortable, boolean noIndex) {
            super(Type.GEO, name, sortable, noIndex);
        }

        @Override
        protected void buildField(RediSearchCommandArgs args) {
            args.add(CommandKeyword.GEO);
        }

        public static GeoFieldBuilder builder(String name) {
            return new GeoFieldBuilder(name);
        }

        public static class GeoFieldBuilder
        extends FieldBuilder<Geo, GeoFieldBuilder> {
            public GeoFieldBuilder(String name) {
                super(name);
            }

            @Override
            public Geo build() {
                return new Geo(this.name, this.sortable, this.noIndex);
            }
        }
    }

    protected static abstract class FieldBuilder<F extends Field, B extends FieldBuilder<F, B>> {
        protected final String name;
        protected boolean sortable;
        protected boolean noIndex;

        protected FieldBuilder(String name) {
            this.name = name;
        }

        public B sortable(boolean sortable) {
            this.sortable = sortable;
            return (B)this;
        }

        public B noIndex(boolean noIndex) {
            this.noIndex = noIndex;
            return (B)this;
        }

        public abstract F build();
    }
}

