/*
 * Decompiled with CFR 0.152.
 */
package com.redislabs.mesclun.search;

import com.redislabs.mesclun.impl.RedisModulesCommandBuilder;
import com.redislabs.mesclun.search.AggregateOptions;
import com.redislabs.mesclun.search.AggregateResults;
import com.redislabs.mesclun.search.AggregateWithCursorResults;
import com.redislabs.mesclun.search.CreateOptions;
import com.redislabs.mesclun.search.Cursor;
import com.redislabs.mesclun.search.Field;
import com.redislabs.mesclun.search.SearchOptions;
import com.redislabs.mesclun.search.SearchResults;
import com.redislabs.mesclun.search.SugaddOptions;
import com.redislabs.mesclun.search.Suggestion;
import com.redislabs.mesclun.search.SuggetOptions;
import com.redislabs.mesclun.search.output.AggregateOutput;
import com.redislabs.mesclun.search.output.AggregateWithCursorOutput;
import com.redislabs.mesclun.search.output.SearchNoContentOutput;
import com.redislabs.mesclun.search.output.SearchOutput;
import com.redislabs.mesclun.search.output.SuggestOutput;
import com.redislabs.mesclun.search.protocol.CommandKeyword;
import com.redislabs.mesclun.search.protocol.CommandType;
import com.redislabs.mesclun.search.protocol.RediSearchCommandArgs;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.output.BooleanOutput;
import io.lettuce.core.output.CommandOutput;
import io.lettuce.core.output.IntegerOutput;
import io.lettuce.core.output.KeyListOutput;
import io.lettuce.core.output.NestedMultiOutput;
import io.lettuce.core.output.StatusOutput;
import io.lettuce.core.protocol.Command;
import io.lettuce.core.protocol.CommandArgs;
import io.lettuce.core.protocol.ProtocolKeyword;
import java.util.List;

public class RediSearchCommandBuilder<K, V>
extends RedisModulesCommandBuilder<K, V> {
    public RediSearchCommandBuilder(RedisCodec<K, V> codec) {
        super(codec);
    }

    protected <A, B, T> Command<A, B, T> createCommand(CommandType type, CommandOutput<A, B, T> output, CommandArgs<A, B> args) {
        return new Command((ProtocolKeyword)type, output, args);
    }

    public Command<K, V, String> create(K index, CreateOptions<K, V> options, Field ... fields) {
        this.notNull(index, "index");
        LettuceAssert.isTrue((fields.length > 0 ? 1 : 0) != 0, (String)"At least one field is required.");
        RediSearchCommandArgs<K, V> args = this.createArgs(index);
        if (options != null) {
            options.build(args);
        }
        args.add(CommandKeyword.SCHEMA);
        for (Field field : fields) {
            field.build((RediSearchCommandArgs)args);
        }
        return this.createCommand(CommandType.CREATE, (CommandOutput)new StatusOutput(this.codec), (CommandArgs)args);
    }

    public Command<K, V, String> dropIndex(K index, boolean deleteDocs) {
        this.notNull(index, "index");
        RediSearchCommandArgs<K, V> args = this.createArgs(index);
        if (deleteDocs) {
            args.add(CommandKeyword.DD);
        }
        return this.createCommand(CommandType.DROPINDEX, (CommandOutput)new StatusOutput(this.codec), (CommandArgs)args);
    }

    public Command<K, V, List<Object>> info(K index) {
        this.notNull(index, "index");
        RediSearchCommandArgs<K, V> args = this.createArgs(index);
        return this.createCommand(CommandType.INFO, (CommandOutput)new NestedMultiOutput(this.codec), (CommandArgs)args);
    }

    public Command<K, V, String> alter(K index, Field field) {
        this.notNull(index, "index");
        this.notNull(field, "field");
        RediSearchCommandArgs<K, V> args = this.createArgs(index);
        args.add(CommandKeyword.SCHEMA);
        args.add(CommandKeyword.ADD);
        field.build((RediSearchCommandArgs)args);
        return this.createCommand(CommandType.ALTER, (CommandOutput)new StatusOutput(this.codec), (CommandArgs)args);
    }

    private RediSearchCommandArgs<K, V> createArgs(K index) {
        return new RediSearchCommandArgs(this.codec).addKey((Object)index);
    }

    public Command<K, V, SearchResults<K, V>> search(K index, V query, SearchOptions options) {
        this.notNull(index, "index");
        this.notNull(query, "query");
        RediSearchCommandArgs<K, V> commandArgs = this.createArgs(index);
        commandArgs.addValue((Object)query);
        if (options != null) {
            options.build((RediSearchCommandArgs)commandArgs);
        }
        return this.createCommand(CommandType.SEARCH, this.searchOutput(options), commandArgs);
    }

    private CommandOutput<K, V, SearchResults<K, V>> searchOutput(SearchOptions options) {
        if (options == null) {
            return new SearchOutput(this.codec);
        }
        if (options.isNoContent()) {
            return new SearchNoContentOutput(this.codec, options.isWithScores());
        }
        return new SearchOutput(this.codec, options.isWithScores(), options.isWithSortKeys(), options.isWithPayloads());
    }

    public Command<K, V, AggregateResults<K>> aggregate(K index, V query, AggregateOptions options) {
        this.notNull(index, "index");
        this.notNull(query, "query");
        RediSearchCommandArgs<K, V> args = this.createArgs(index);
        args.addValue((Object)query);
        if (options != null) {
            options.build((RediSearchCommandArgs)args);
        }
        return this.createCommand(CommandType.AGGREGATE, new AggregateOutput(this.codec, new AggregateResults()), args);
    }

    public Command<K, V, AggregateWithCursorResults<K>> aggregate(K index, V query, Cursor cursor, AggregateOptions options) {
        this.notNull(index, "index");
        this.notNull(query, "query");
        RediSearchCommandArgs<K, V> args = this.createArgs(index);
        args.addValue((Object)query);
        if (options != null) {
            options.build((RediSearchCommandArgs)args);
        }
        args.add(CommandKeyword.WITHCURSOR);
        if (cursor != null) {
            cursor.build(args);
        }
        return this.createCommand(CommandType.AGGREGATE, new AggregateWithCursorOutput(this.codec), args);
    }

    public Command<K, V, AggregateWithCursorResults<K>> cursorRead(K index, long cursor, Long count) {
        this.notNull(index, "index");
        RediSearchCommandArgs args = new RediSearchCommandArgs(this.codec);
        args.add(CommandKeyword.READ);
        args.addKey((Object)index);
        args.add(cursor);
        if (count != null) {
            args.add(CommandKeyword.COUNT);
            args.add(count);
        }
        return this.createCommand(CommandType.CURSOR, new AggregateWithCursorOutput(this.codec), args);
    }

    public Command<K, V, String> cursorDelete(K index, long cursor) {
        this.notNull(index, "index");
        RediSearchCommandArgs args = new RediSearchCommandArgs(this.codec);
        args.add(CommandKeyword.DEL);
        args.addKey((Object)index);
        args.add(cursor);
        return this.createCommand(CommandType.CURSOR, (CommandOutput)new StatusOutput(this.codec), args);
    }

    public Command<K, V, Long> sugadd(K key, V string, double score) {
        return this.sugadd(key, string, score, null);
    }

    public Command<K, V, Long> sugadd(K key, V string, double score, SugaddOptions<V> options) {
        this.notNull(key, "key");
        this.notNull(string, "suggestion string");
        RediSearchCommandArgs args = new RediSearchCommandArgs(this.codec);
        args.addKey((Object)key);
        args.addValue((Object)string);
        args.add(score);
        if (options != null) {
            if (options.isIncrement()) {
                args.add(CommandKeyword.INCR);
            }
            if (options.getPayload() != null) {
                args.add(CommandKeyword.PAYLOAD);
                args.addValue((Object)options.getPayload());
            }
        }
        return this.createCommand(CommandType.SUGADD, (CommandOutput)new IntegerOutput(this.codec), args);
    }

    public Command<K, V, List<Suggestion<V>>> sugget(K key, V prefix) {
        return this.sugget(key, prefix, null);
    }

    public Command<K, V, List<Suggestion<V>>> sugget(K key, V prefix, SuggetOptions options) {
        this.notNull(key, "key");
        this.notNull(prefix, "prefix");
        RediSearchCommandArgs args = new RediSearchCommandArgs(this.codec);
        args.addKey((Object)key);
        args.addValue((Object)prefix);
        if (options != null) {
            options.build(args);
        }
        return this.createCommand(CommandType.SUGGET, this.suggestOutput(options), args);
    }

    private SuggestOutput<K, V> suggestOutput(SuggetOptions options) {
        if (options == null) {
            return new SuggestOutput(this.codec);
        }
        return new SuggestOutput(this.codec, options.isWithScores(), options.isWithPayloads());
    }

    public Command<K, V, Boolean> sugdel(K key, V string) {
        this.notNull(key, "key");
        this.notNull(string, "string");
        CommandArgs args = new RediSearchCommandArgs(this.codec).addKey((Object)key).addValue((Object)string);
        return this.createCommand(CommandType.SUGDEL, (CommandOutput)new BooleanOutput(this.codec), (CommandArgs)args);
    }

    public Command<K, V, Long> suglen(K key) {
        this.notNull(key, "key");
        CommandArgs args = new RediSearchCommandArgs(this.codec).addKey((Object)key);
        return this.createCommand(CommandType.SUGLEN, (CommandOutput)new IntegerOutput(this.codec), (CommandArgs)args);
    }

    public Command<K, V, String> aliasAdd(K name, K index) {
        this.notNull(name, "name");
        this.notNull(index, "index");
        RediSearchCommandArgs args = new RediSearchCommandArgs(this.codec);
        args.addKey((Object)name);
        args.addKey((Object)index);
        return this.createCommand(CommandType.ALIASADD, (CommandOutput)new StatusOutput(this.codec), args);
    }

    public Command<K, V, String> aliasUpdate(K name, K index) {
        this.notNull(name, "name");
        this.notNull(index, "index");
        RediSearchCommandArgs args = new RediSearchCommandArgs(this.codec);
        args.addKey((Object)name);
        args.addKey((Object)index);
        return this.createCommand(CommandType.ALIASUPDATE, (CommandOutput)new StatusOutput(this.codec), args);
    }

    public Command<K, V, String> aliasDel(K name) {
        this.notNull(name, "name");
        RediSearchCommandArgs args = new RediSearchCommandArgs(this.codec);
        args.addKey((Object)name);
        return this.createCommand(CommandType.ALIASDEL, (CommandOutput)new StatusOutput(this.codec), args);
    }

    public Command<K, V, List<K>> list() {
        return new Command((ProtocolKeyword)CommandType._LIST, (CommandOutput)new KeyListOutput(this.codec));
    }
}

