/*
 * Decompiled with CFR 0.152.
 */
package com.redislabs.mesclun.search;

import com.redislabs.mesclun.search.Field;
import com.redislabs.mesclun.search.IndexInfo;
import com.redislabs.mesclun.search.protocol.CommandKeyword;
import io.lettuce.core.internal.LettuceAssert;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RediSearchUtils {
    private static final Long ZERO = 0L;
    private static final String GEO_LONLAT_SEPARATOR = ",";

    public static <K, V> IndexInfo<K, V> getInfo(List<Object> infoList) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (int i = 0; i < infoList.size() / 2; ++i) {
            map.put((String)infoList.get(i * 2), infoList.get(i * 2 + 1));
        }
        return IndexInfo.builder().indexName(RediSearchUtils.getString(map.get("index_name"))).indexOptions((List)map.get("index_options")).fields(RediSearchUtils.fields(map.get("fields"))).numDocs(RediSearchUtils.getDouble(map.get("num_docs"))).maxDocId((String)RediSearchUtils.getString(map.get("max_doc_id"))).numTerms(RediSearchUtils.toLong(map, "num_terms")).numRecords(RediSearchUtils.toLong(map, "num_records")).invertedSizeMb(RediSearchUtils.getDouble(map.get("inverted_sz_mb"))).totalInvertedIndexBlocks(RediSearchUtils.toLong(map, "total_inverted_index_blocks")).offsetVectorsSizeMb(RediSearchUtils.getDouble(map.get("offset_vectors_sz_mb"))).docTableSizeMb(RediSearchUtils.getDouble(map.get("doc_table_size_mb"))).sortableValuesSizeMb(RediSearchUtils.getDouble(map.get("sortable_values_size_mb"))).keyTableSizeMb(RediSearchUtils.getDouble(map.get("key_table_size_mb"))).recordsPerDocAvg(RediSearchUtils.getDouble(map.get("records_per_doc_avg"))).bytesPerRecordAvg(RediSearchUtils.getDouble(map.get("bytes_per_record_avg"))).offsetsPerTermAvg(RediSearchUtils.getDouble(map.get("offsets_per_term_avg"))).offsetBitsPerRecordAvg(RediSearchUtils.getDouble(map.get("offset_bits_per_record_avg"))).gcStats((List)map.get("gc_stats")).cursorStats((List)map.get("cursor_stats")).build();
    }

    private static Double getDouble(Object object) {
        return (Double)object;
    }

    private static <K> K getString(Object object) {
        if (object != null) {
            if (object instanceof String) {
                return (K)object;
            }
            if (ZERO.equals(object)) {
                return null;
            }
        }
        return null;
    }

    private static List<Field> fields(Object object) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Object infoObject : (List)object) {
            List info = (List)infoObject;
            String name = (String)info.get(0);
            CommandKeyword type = CommandKeyword.valueOf((String)info.get(2));
            boolean sortable = false;
            boolean noIndex = false;
            for (Object attribute : info.subList(3, info.size())) {
                if (CommandKeyword.NOINDEX.name().equals(attribute)) {
                    noIndex = true;
                    continue;
                }
                if (!CommandKeyword.SORTABLE.name().equals(attribute)) continue;
                sortable = true;
            }
            fields.add(RediSearchUtils.field(type, name, sortable, noIndex, info));
        }
        return fields;
    }

    private static Field field(CommandKeyword type, String name, boolean sortable, boolean noIndex, List<Object> info) {
        switch (type) {
            case GEO: {
                return new Field.Geo(name, sortable, noIndex);
            }
            case NUMERIC: {
                return new Field.Numeric(name, sortable, noIndex);
            }
            case TAG: {
                return new Field.Tag(name, sortable, noIndex, (String)info.get(4));
            }
        }
        return new Field.Text(name, sortable, noIndex, (Double)info.get(4), CommandKeyword.NOSTEM.name().equals(info.get(info.size() - 1)));
    }

    private static Long toLong(Map<String, Object> map, String key) {
        Object value;
        if (map.containsKey(key) && (value = map.get(key)) != null) {
            String string;
            if (value instanceof Long) {
                return (Long)value;
            }
            if (value instanceof String && (string = (String)value).length() > 0) {
                try {
                    return Long.parseLong(string);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public static String escapeTag(String value) {
        return value.replaceAll("([^a-zA-Z0-9])", "\\\\$1");
    }

    public static class GeoLocation {
        private double latitude;
        private double longitude;

        public static GeoLocation of(String location) {
            LettuceAssert.notNull((Object)location, (String)"Location string must not be null");
            String[] lonlat = location.split(RediSearchUtils.GEO_LONLAT_SEPARATOR);
            LettuceAssert.isTrue((lonlat.length == 2 ? 1 : 0) != 0, (String)"Location string not in proper format \"longitude,latitude\"");
            return GeoLocation.builder().longitude(Double.parseDouble(lonlat[0])).latitude(Double.parseDouble(lonlat[1])).build();
        }

        public static String toString(String longitude, String latitude) {
            if (longitude == null || latitude == null) {
                return null;
            }
            return longitude + RediSearchUtils.GEO_LONLAT_SEPARATOR + latitude;
        }

        public static GeoLocationBuilder builder() {
            return new GeoLocationBuilder();
        }

        public double getLatitude() {
            return this.latitude;
        }

        public double getLongitude() {
            return this.longitude;
        }

        public void setLatitude(double latitude) {
            this.latitude = latitude;
        }

        public void setLongitude(double longitude) {
            this.longitude = longitude;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GeoLocation)) {
                return false;
            }
            GeoLocation other = (GeoLocation)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (Double.compare(this.getLatitude(), other.getLatitude()) != 0) {
                return false;
            }
            return Double.compare(this.getLongitude(), other.getLongitude()) == 0;
        }

        protected boolean canEqual(Object other) {
            return other instanceof GeoLocation;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $latitude = Double.doubleToLongBits(this.getLatitude());
            result = result * 59 + (int)($latitude >>> 32 ^ $latitude);
            long $longitude = Double.doubleToLongBits(this.getLongitude());
            result = result * 59 + (int)($longitude >>> 32 ^ $longitude);
            return result;
        }

        public String toString() {
            return "RediSearchUtils.GeoLocation(latitude=" + this.getLatitude() + ", longitude=" + this.getLongitude() + ")";
        }

        public GeoLocation() {
        }

        public GeoLocation(double latitude, double longitude) {
            this.latitude = latitude;
            this.longitude = longitude;
        }

        public static class GeoLocationBuilder {
            private double latitude;
            private double longitude;

            GeoLocationBuilder() {
            }

            public GeoLocationBuilder latitude(double latitude) {
                this.latitude = latitude;
                return this;
            }

            public GeoLocationBuilder longitude(double longitude) {
                this.longitude = longitude;
                return this;
            }

            public GeoLocation build() {
                return new GeoLocation(this.latitude, this.longitude);
            }

            public String toString() {
                return "RediSearchUtils.GeoLocation.GeoLocationBuilder(latitude=" + this.latitude + ", longitude=" + this.longitude + ")";
            }
        }
    }
}

