/*
 * Decompiled with CFR 0.152.
 */
package com.redislabs.mesclun.search;

import com.redislabs.mesclun.search.Language;
import com.redislabs.mesclun.search.Order;
import com.redislabs.mesclun.search.RediSearchArgument;
import com.redislabs.mesclun.search.protocol.CommandKeyword;
import com.redislabs.mesclun.search.protocol.RediSearchCommandArgs;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class SearchOptions
implements RediSearchArgument {
    private boolean noContent;
    private boolean verbatim;
    private boolean noStopWords;
    private boolean withScores;
    private boolean withPayloads;
    private boolean withSortKeys;
    private List<NumericFilter> filters;
    private GeoFilter geoFilter;
    private List<String> inKeys;
    private List<String> inFields;
    private List<String> returnFields;
    private Summarize summarize;
    private Highlight highlight;
    private Long slop;
    private boolean inOrder;
    private Language language;
    private String expander;
    private String scorer;
    private String payload;
    private SortBy sortBy;
    private Limit limit;

    public void build(RediSearchCommandArgs args) {
        if (this.noContent) {
            args.add(CommandKeyword.NOCONTENT);
        }
        if (this.verbatim) {
            args.add(CommandKeyword.VERBATIM);
        }
        if (this.noStopWords) {
            args.add(CommandKeyword.NOSTOPWORDS);
        }
        if (this.withScores) {
            args.add(CommandKeyword.WITHSCORES);
        }
        if (this.withPayloads) {
            args.add(CommandKeyword.WITHPAYLOADS);
        }
        if (this.withSortKeys) {
            args.add(CommandKeyword.WITHSORTKEYS);
        }
        for (NumericFilter filter : this.filters) {
            args.add(CommandKeyword.FILTER);
            filter.build(args);
        }
        if (this.geoFilter != null) {
            args.add(CommandKeyword.GEOFILTER);
            this.geoFilter.build(args);
        }
        if (!this.inKeys.isEmpty()) {
            args.add(CommandKeyword.INKEYS);
            args.add(this.inKeys.size());
            this.inKeys.forEach(args::add);
        }
        if (!this.inFields.isEmpty()) {
            args.add(CommandKeyword.INFIELDS);
            args.add(this.inFields.size());
            this.inFields.forEach(args::add);
        }
        if (!this.returnFields.isEmpty()) {
            args.add(CommandKeyword.RETURN);
            args.add(this.returnFields.size());
            this.returnFields.forEach(args::add);
        }
        if (this.summarize != null) {
            args.add(CommandKeyword.SUMMARIZE);
            this.summarize.build(args);
        }
        if (this.highlight != null) {
            args.add(CommandKeyword.HIGHLIGHT);
            this.highlight.build(args);
        }
        if (this.slop != null) {
            args.add(CommandKeyword.SLOP);
            args.add(this.slop);
        }
        if (this.inOrder) {
            args.add(CommandKeyword.INORDER);
        }
        if (this.language != null) {
            args.add(CommandKeyword.LANGUAGE);
            args.add(this.language.name());
        }
        if (this.expander != null) {
            args.add(CommandKeyword.EXPANDER);
            args.add(this.expander);
        }
        if (this.scorer != null) {
            args.add(CommandKeyword.SCORER);
            args.add(this.scorer);
        }
        if (this.payload != null) {
            args.add(CommandKeyword.PAYLOAD);
            args.add(this.payload);
        }
        if (this.sortBy != null) {
            args.add(CommandKeyword.SORTBY);
            this.sortBy.build(args);
        }
        if (this.limit != null) {
            this.limit.build(args);
        }
    }

    public static SearchOptionsBuilder builder() {
        return new SearchOptionsBuilder();
    }

    public boolean isNoContent() {
        return this.noContent;
    }

    public boolean isVerbatim() {
        return this.verbatim;
    }

    public boolean isNoStopWords() {
        return this.noStopWords;
    }

    public boolean isWithScores() {
        return this.withScores;
    }

    public boolean isWithPayloads() {
        return this.withPayloads;
    }

    public boolean isWithSortKeys() {
        return this.withSortKeys;
    }

    public List<NumericFilter> getFilters() {
        return this.filters;
    }

    public GeoFilter getGeoFilter() {
        return this.geoFilter;
    }

    public List<String> getInKeys() {
        return this.inKeys;
    }

    public List<String> getInFields() {
        return this.inFields;
    }

    public List<String> getReturnFields() {
        return this.returnFields;
    }

    public Summarize getSummarize() {
        return this.summarize;
    }

    public Highlight getHighlight() {
        return this.highlight;
    }

    public Long getSlop() {
        return this.slop;
    }

    public boolean isInOrder() {
        return this.inOrder;
    }

    public Language getLanguage() {
        return this.language;
    }

    public String getExpander() {
        return this.expander;
    }

    public String getScorer() {
        return this.scorer;
    }

    public String getPayload() {
        return this.payload;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public Limit getLimit() {
        return this.limit;
    }

    public void setNoContent(boolean noContent) {
        this.noContent = noContent;
    }

    public void setVerbatim(boolean verbatim) {
        this.verbatim = verbatim;
    }

    public void setNoStopWords(boolean noStopWords) {
        this.noStopWords = noStopWords;
    }

    public void setWithScores(boolean withScores) {
        this.withScores = withScores;
    }

    public void setWithPayloads(boolean withPayloads) {
        this.withPayloads = withPayloads;
    }

    public void setWithSortKeys(boolean withSortKeys) {
        this.withSortKeys = withSortKeys;
    }

    public void setFilters(List<NumericFilter> filters) {
        this.filters = filters;
    }

    public void setGeoFilter(GeoFilter geoFilter) {
        this.geoFilter = geoFilter;
    }

    public void setInKeys(List<String> inKeys) {
        this.inKeys = inKeys;
    }

    public void setInFields(List<String> inFields) {
        this.inFields = inFields;
    }

    public void setReturnFields(List<String> returnFields) {
        this.returnFields = returnFields;
    }

    public void setSummarize(Summarize summarize) {
        this.summarize = summarize;
    }

    public void setHighlight(Highlight highlight) {
        this.highlight = highlight;
    }

    public void setSlop(Long slop) {
        this.slop = slop;
    }

    public void setInOrder(boolean inOrder) {
        this.inOrder = inOrder;
    }

    public void setLanguage(Language language) {
        this.language = language;
    }

    public void setExpander(String expander) {
        this.expander = expander;
    }

    public void setScorer(String scorer) {
        this.scorer = scorer;
    }

    public void setPayload(String payload) {
        this.payload = payload;
    }

    public void setSortBy(SortBy sortBy) {
        this.sortBy = sortBy;
    }

    public void setLimit(Limit limit) {
        this.limit = limit;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SearchOptions)) {
            return false;
        }
        SearchOptions other = (SearchOptions)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isNoContent() != other.isNoContent()) {
            return false;
        }
        if (this.isVerbatim() != other.isVerbatim()) {
            return false;
        }
        if (this.isNoStopWords() != other.isNoStopWords()) {
            return false;
        }
        if (this.isWithScores() != other.isWithScores()) {
            return false;
        }
        if (this.isWithPayloads() != other.isWithPayloads()) {
            return false;
        }
        if (this.isWithSortKeys() != other.isWithSortKeys()) {
            return false;
        }
        if (this.isInOrder() != other.isInOrder()) {
            return false;
        }
        Long this$slop = this.getSlop();
        Long other$slop = other.getSlop();
        if (this$slop == null ? other$slop != null : !((Object)this$slop).equals(other$slop)) {
            return false;
        }
        List<NumericFilter> this$filters = this.getFilters();
        List<NumericFilter> other$filters = other.getFilters();
        if (this$filters == null ? other$filters != null : !((Object)this$filters).equals(other$filters)) {
            return false;
        }
        GeoFilter this$geoFilter = this.getGeoFilter();
        GeoFilter other$geoFilter = other.getGeoFilter();
        if (this$geoFilter == null ? other$geoFilter != null : !this$geoFilter.equals(other$geoFilter)) {
            return false;
        }
        List<String> this$inKeys = this.getInKeys();
        List<String> other$inKeys = other.getInKeys();
        if (this$inKeys == null ? other$inKeys != null : !((Object)this$inKeys).equals(other$inKeys)) {
            return false;
        }
        List<String> this$inFields = this.getInFields();
        List<String> other$inFields = other.getInFields();
        if (this$inFields == null ? other$inFields != null : !((Object)this$inFields).equals(other$inFields)) {
            return false;
        }
        List<String> this$returnFields = this.getReturnFields();
        List<String> other$returnFields = other.getReturnFields();
        if (this$returnFields == null ? other$returnFields != null : !((Object)this$returnFields).equals(other$returnFields)) {
            return false;
        }
        Summarize this$summarize = this.getSummarize();
        Summarize other$summarize = other.getSummarize();
        if (this$summarize == null ? other$summarize != null : !((Object)this$summarize).equals(other$summarize)) {
            return false;
        }
        Highlight this$highlight = this.getHighlight();
        Highlight other$highlight = other.getHighlight();
        if (this$highlight == null ? other$highlight != null : !((Object)this$highlight).equals(other$highlight)) {
            return false;
        }
        Language this$language = this.getLanguage();
        Language other$language = other.getLanguage();
        if (this$language == null ? other$language != null : !((Object)((Object)this$language)).equals((Object)other$language)) {
            return false;
        }
        String this$expander = this.getExpander();
        String other$expander = other.getExpander();
        if (this$expander == null ? other$expander != null : !this$expander.equals(other$expander)) {
            return false;
        }
        String this$scorer = this.getScorer();
        String other$scorer = other.getScorer();
        if (this$scorer == null ? other$scorer != null : !this$scorer.equals(other$scorer)) {
            return false;
        }
        String this$payload = this.getPayload();
        String other$payload = other.getPayload();
        if (this$payload == null ? other$payload != null : !this$payload.equals(other$payload)) {
            return false;
        }
        SortBy this$sortBy = this.getSortBy();
        SortBy other$sortBy = other.getSortBy();
        if (this$sortBy == null ? other$sortBy != null : !this$sortBy.equals(other$sortBy)) {
            return false;
        }
        Limit this$limit = this.getLimit();
        Limit other$limit = other.getLimit();
        return !(this$limit == null ? other$limit != null : !this$limit.equals(other$limit));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SearchOptions;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isNoContent() ? 79 : 97);
        result = result * 59 + (this.isVerbatim() ? 79 : 97);
        result = result * 59 + (this.isNoStopWords() ? 79 : 97);
        result = result * 59 + (this.isWithScores() ? 79 : 97);
        result = result * 59 + (this.isWithPayloads() ? 79 : 97);
        result = result * 59 + (this.isWithSortKeys() ? 79 : 97);
        result = result * 59 + (this.isInOrder() ? 79 : 97);
        Long $slop = this.getSlop();
        result = result * 59 + ($slop == null ? 43 : ((Object)$slop).hashCode());
        List<NumericFilter> $filters = this.getFilters();
        result = result * 59 + ($filters == null ? 43 : ((Object)$filters).hashCode());
        GeoFilter $geoFilter = this.getGeoFilter();
        result = result * 59 + ($geoFilter == null ? 43 : $geoFilter.hashCode());
        List<String> $inKeys = this.getInKeys();
        result = result * 59 + ($inKeys == null ? 43 : ((Object)$inKeys).hashCode());
        List<String> $inFields = this.getInFields();
        result = result * 59 + ($inFields == null ? 43 : ((Object)$inFields).hashCode());
        List<String> $returnFields = this.getReturnFields();
        result = result * 59 + ($returnFields == null ? 43 : ((Object)$returnFields).hashCode());
        Summarize $summarize = this.getSummarize();
        result = result * 59 + ($summarize == null ? 43 : ((Object)$summarize).hashCode());
        Highlight $highlight = this.getHighlight();
        result = result * 59 + ($highlight == null ? 43 : ((Object)$highlight).hashCode());
        Language $language = this.getLanguage();
        result = result * 59 + ($language == null ? 43 : ((Object)((Object)$language)).hashCode());
        String $expander = this.getExpander();
        result = result * 59 + ($expander == null ? 43 : $expander.hashCode());
        String $scorer = this.getScorer();
        result = result * 59 + ($scorer == null ? 43 : $scorer.hashCode());
        String $payload = this.getPayload();
        result = result * 59 + ($payload == null ? 43 : $payload.hashCode());
        SortBy $sortBy = this.getSortBy();
        result = result * 59 + ($sortBy == null ? 43 : $sortBy.hashCode());
        Limit $limit = this.getLimit();
        result = result * 59 + ($limit == null ? 43 : $limit.hashCode());
        return result;
    }

    public String toString() {
        return "SearchOptions(noContent=" + this.isNoContent() + ", verbatim=" + this.isVerbatim() + ", noStopWords=" + this.isNoStopWords() + ", withScores=" + this.isWithScores() + ", withPayloads=" + this.isWithPayloads() + ", withSortKeys=" + this.isWithSortKeys() + ", filters=" + this.getFilters() + ", geoFilter=" + this.getGeoFilter() + ", inKeys=" + this.getInKeys() + ", inFields=" + this.getInFields() + ", returnFields=" + this.getReturnFields() + ", summarize=" + this.getSummarize() + ", highlight=" + this.getHighlight() + ", slop=" + this.getSlop() + ", inOrder=" + this.isInOrder() + ", language=" + (Object)((Object)this.getLanguage()) + ", expander=" + this.getExpander() + ", scorer=" + this.getScorer() + ", payload=" + this.getPayload() + ", sortBy=" + this.getSortBy() + ", limit=" + this.getLimit() + ")";
    }

    public SearchOptions() {
    }

    public SearchOptions(boolean noContent, boolean verbatim, boolean noStopWords, boolean withScores, boolean withPayloads, boolean withSortKeys, List<NumericFilter> filters, GeoFilter geoFilter, List<String> inKeys, List<String> inFields, List<String> returnFields, Summarize summarize, Highlight highlight, Long slop, boolean inOrder, Language language, String expander, String scorer, String payload, SortBy sortBy, Limit limit) {
        this.noContent = noContent;
        this.verbatim = verbatim;
        this.noStopWords = noStopWords;
        this.withScores = withScores;
        this.withPayloads = withPayloads;
        this.withSortKeys = withSortKeys;
        this.filters = filters;
        this.geoFilter = geoFilter;
        this.inKeys = inKeys;
        this.inFields = inFields;
        this.returnFields = returnFields;
        this.summarize = summarize;
        this.highlight = highlight;
        this.slop = slop;
        this.inOrder = inOrder;
        this.language = language;
        this.expander = expander;
        this.scorer = scorer;
        this.payload = payload;
        this.sortBy = sortBy;
        this.limit = limit;
    }

    public static class SearchOptionsBuilder {
        private boolean noContent;
        private boolean verbatim;
        private boolean noStopWords;
        private boolean withScores;
        private boolean withPayloads;
        private boolean withSortKeys;
        private ArrayList<NumericFilter> filters;
        private GeoFilter geoFilter;
        private ArrayList<String> inKeys;
        private ArrayList<String> inFields;
        private ArrayList<String> returnFields;
        private Summarize summarize;
        private Highlight highlight;
        private Long slop;
        private boolean inOrder;
        private Language language;
        private String expander;
        private String scorer;
        private String payload;
        private SortBy sortBy;
        private Limit limit;

        SearchOptionsBuilder() {
        }

        public SearchOptionsBuilder noContent(boolean noContent) {
            this.noContent = noContent;
            return this;
        }

        public SearchOptionsBuilder verbatim(boolean verbatim) {
            this.verbatim = verbatim;
            return this;
        }

        public SearchOptionsBuilder noStopWords(boolean noStopWords) {
            this.noStopWords = noStopWords;
            return this;
        }

        public SearchOptionsBuilder withScores(boolean withScores) {
            this.withScores = withScores;
            return this;
        }

        public SearchOptionsBuilder withPayloads(boolean withPayloads) {
            this.withPayloads = withPayloads;
            return this;
        }

        public SearchOptionsBuilder withSortKeys(boolean withSortKeys) {
            this.withSortKeys = withSortKeys;
            return this;
        }

        public SearchOptionsBuilder filter(NumericFilter filter) {
            if (this.filters == null) {
                this.filters = new ArrayList();
            }
            this.filters.add(filter);
            return this;
        }

        public SearchOptionsBuilder filters(Collection<? extends NumericFilter> filters) {
            if (filters == null) {
                throw new NullPointerException("filters cannot be null");
            }
            if (this.filters == null) {
                this.filters = new ArrayList();
            }
            this.filters.addAll(filters);
            return this;
        }

        public SearchOptionsBuilder clearFilters() {
            if (this.filters != null) {
                this.filters.clear();
            }
            return this;
        }

        public SearchOptionsBuilder geoFilter(GeoFilter geoFilter) {
            this.geoFilter = geoFilter;
            return this;
        }

        public SearchOptionsBuilder inKey(String inKey) {
            if (this.inKeys == null) {
                this.inKeys = new ArrayList();
            }
            this.inKeys.add(inKey);
            return this;
        }

        public SearchOptionsBuilder inKeys(Collection<? extends String> inKeys) {
            if (inKeys == null) {
                throw new NullPointerException("inKeys cannot be null");
            }
            if (this.inKeys == null) {
                this.inKeys = new ArrayList();
            }
            this.inKeys.addAll(inKeys);
            return this;
        }

        public SearchOptionsBuilder clearInKeys() {
            if (this.inKeys != null) {
                this.inKeys.clear();
            }
            return this;
        }

        public SearchOptionsBuilder inField(String inField) {
            if (this.inFields == null) {
                this.inFields = new ArrayList();
            }
            this.inFields.add(inField);
            return this;
        }

        public SearchOptionsBuilder inFields(Collection<? extends String> inFields) {
            if (inFields == null) {
                throw new NullPointerException("inFields cannot be null");
            }
            if (this.inFields == null) {
                this.inFields = new ArrayList();
            }
            this.inFields.addAll(inFields);
            return this;
        }

        public SearchOptionsBuilder clearInFields() {
            if (this.inFields != null) {
                this.inFields.clear();
            }
            return this;
        }

        public SearchOptionsBuilder returnField(String returnField) {
            if (this.returnFields == null) {
                this.returnFields = new ArrayList();
            }
            this.returnFields.add(returnField);
            return this;
        }

        public SearchOptionsBuilder returnFields(Collection<? extends String> returnFields) {
            if (returnFields == null) {
                throw new NullPointerException("returnFields cannot be null");
            }
            if (this.returnFields == null) {
                this.returnFields = new ArrayList();
            }
            this.returnFields.addAll(returnFields);
            return this;
        }

        public SearchOptionsBuilder clearReturnFields() {
            if (this.returnFields != null) {
                this.returnFields.clear();
            }
            return this;
        }

        public SearchOptionsBuilder summarize(Summarize summarize) {
            this.summarize = summarize;
            return this;
        }

        public SearchOptionsBuilder highlight(Highlight highlight) {
            this.highlight = highlight;
            return this;
        }

        public SearchOptionsBuilder slop(Long slop) {
            this.slop = slop;
            return this;
        }

        public SearchOptionsBuilder inOrder(boolean inOrder) {
            this.inOrder = inOrder;
            return this;
        }

        public SearchOptionsBuilder language(Language language) {
            this.language = language;
            return this;
        }

        public SearchOptionsBuilder expander(String expander) {
            this.expander = expander;
            return this;
        }

        public SearchOptionsBuilder scorer(String scorer) {
            this.scorer = scorer;
            return this;
        }

        public SearchOptionsBuilder payload(String payload) {
            this.payload = payload;
            return this;
        }

        public SearchOptionsBuilder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public SearchOptionsBuilder limit(Limit limit) {
            this.limit = limit;
            return this;
        }

        public SearchOptions build() {
            List<String> returnFields;
            List<String> inFields;
            List<String> inKeys;
            List<NumericFilter> filters;
            switch (this.filters == null ? 0 : this.filters.size()) {
                case 0: {
                    filters = Collections.emptyList();
                    break;
                }
                case 1: {
                    filters = Collections.singletonList(this.filters.get(0));
                    break;
                }
                default: {
                    filters = Collections.unmodifiableList(new ArrayList<NumericFilter>(this.filters));
                }
            }
            switch (this.inKeys == null ? 0 : this.inKeys.size()) {
                case 0: {
                    inKeys = Collections.emptyList();
                    break;
                }
                case 1: {
                    inKeys = Collections.singletonList(this.inKeys.get(0));
                    break;
                }
                default: {
                    inKeys = Collections.unmodifiableList(new ArrayList<String>(this.inKeys));
                }
            }
            switch (this.inFields == null ? 0 : this.inFields.size()) {
                case 0: {
                    inFields = Collections.emptyList();
                    break;
                }
                case 1: {
                    inFields = Collections.singletonList(this.inFields.get(0));
                    break;
                }
                default: {
                    inFields = Collections.unmodifiableList(new ArrayList<String>(this.inFields));
                }
            }
            switch (this.returnFields == null ? 0 : this.returnFields.size()) {
                case 0: {
                    returnFields = Collections.emptyList();
                    break;
                }
                case 1: {
                    returnFields = Collections.singletonList(this.returnFields.get(0));
                    break;
                }
                default: {
                    returnFields = Collections.unmodifiableList(new ArrayList<String>(this.returnFields));
                }
            }
            return new SearchOptions(this.noContent, this.verbatim, this.noStopWords, this.withScores, this.withPayloads, this.withSortKeys, filters, this.geoFilter, inKeys, inFields, returnFields, this.summarize, this.highlight, this.slop, this.inOrder, this.language, this.expander, this.scorer, this.payload, this.sortBy, this.limit);
        }

        public String toString() {
            return "SearchOptions.SearchOptionsBuilder(noContent=" + this.noContent + ", verbatim=" + this.verbatim + ", noStopWords=" + this.noStopWords + ", withScores=" + this.withScores + ", withPayloads=" + this.withPayloads + ", withSortKeys=" + this.withSortKeys + ", filters=" + this.filters + ", geoFilter=" + this.geoFilter + ", inKeys=" + this.inKeys + ", inFields=" + this.inFields + ", returnFields=" + this.returnFields + ", summarize=" + this.summarize + ", highlight=" + this.highlight + ", slop=" + this.slop + ", inOrder=" + this.inOrder + ", language=" + (Object)((Object)this.language) + ", expander=" + this.expander + ", scorer=" + this.scorer + ", payload=" + this.payload + ", sortBy=" + this.sortBy + ", limit=" + this.limit + ")";
        }
    }

    public static class Tags {
        private String open;
        private String close;

        Tags(String open, String close) {
            this.open = open;
            this.close = close;
        }

        public static TagsBuilder builder() {
            return new TagsBuilder();
        }

        public String getOpen() {
            return this.open;
        }

        public String getClose() {
            return this.close;
        }

        public void setOpen(String open) {
            this.open = open;
        }

        public void setClose(String close) {
            this.close = close;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Tags)) {
                return false;
            }
            Tags other = (Tags)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$open = this.getOpen();
            String other$open = other.getOpen();
            if (this$open == null ? other$open != null : !this$open.equals(other$open)) {
                return false;
            }
            String this$close = this.getClose();
            String other$close = other.getClose();
            return !(this$close == null ? other$close != null : !this$close.equals(other$close));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Tags;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $open = this.getOpen();
            result = result * 59 + ($open == null ? 43 : $open.hashCode());
            String $close = this.getClose();
            result = result * 59 + ($close == null ? 43 : $close.hashCode());
            return result;
        }

        public String toString() {
            return "SearchOptions.Tags(open=" + this.getOpen() + ", close=" + this.getClose() + ")";
        }

        public static class TagsBuilder {
            private String open;
            private String close;

            TagsBuilder() {
            }

            public TagsBuilder open(String open) {
                this.open = open;
                return this;
            }

            public TagsBuilder close(String close) {
                this.close = close;
                return this;
            }

            public Tags build() {
                return new Tags(this.open, this.close);
            }

            public String toString() {
                return "SearchOptions.Tags.TagsBuilder(open=" + this.open + ", close=" + this.close + ")";
            }
        }
    }

    public static class SortBy
    implements RediSearchArgument {
        private final String field;
        private final Order direction;

        public SortBy(String field, Order direction) {
            this.field = field;
            this.direction = direction;
        }

        public void build(RediSearchCommandArgs args) {
            args.add(this.field);
            args.add(this.direction == Order.ASC ? CommandKeyword.ASC : CommandKeyword.DESC);
        }

        public static SortByBuilder field(String field) {
            return new SortByBuilder(field);
        }

        public static class SortByBuilder {
            private final String field;

            public SortByBuilder(String field) {
                this.field = field;
            }

            public SortBy order(Order order) {
                return new SortBy(this.field, order);
            }
        }
    }

    public static class Summarize
    implements RediSearchArgument {
        private List<String> fields;
        private Long frags;
        private Long length;
        private String separator;

        public void build(RediSearchCommandArgs args) {
            if (this.fields.size() > 0) {
                args.add(CommandKeyword.FIELDS);
                args.add(this.fields.size());
                this.fields.forEach(args::add);
            }
            if (this.frags != null) {
                args.add(CommandKeyword.FRAGS);
                args.add(this.frags);
            }
            if (this.length != null) {
                args.add(CommandKeyword.LEN);
                args.add(this.length);
            }
            if (this.separator != null) {
                args.add(CommandKeyword.SEPARATOR);
                args.add(this.separator);
            }
        }

        public static SummarizeBuilder builder() {
            return new SummarizeBuilder();
        }

        public List<String> getFields() {
            return this.fields;
        }

        public Long getFrags() {
            return this.frags;
        }

        public Long getLength() {
            return this.length;
        }

        public String getSeparator() {
            return this.separator;
        }

        public void setFields(List<String> fields) {
            this.fields = fields;
        }

        public void setFrags(Long frags) {
            this.frags = frags;
        }

        public void setLength(Long length) {
            this.length = length;
        }

        public void setSeparator(String separator) {
            this.separator = separator;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Summarize)) {
                return false;
            }
            Summarize other = (Summarize)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$frags = this.getFrags();
            Long other$frags = other.getFrags();
            if (this$frags == null ? other$frags != null : !((Object)this$frags).equals(other$frags)) {
                return false;
            }
            Long this$length = this.getLength();
            Long other$length = other.getLength();
            if (this$length == null ? other$length != null : !((Object)this$length).equals(other$length)) {
                return false;
            }
            List<String> this$fields = this.getFields();
            List<String> other$fields = other.getFields();
            if (this$fields == null ? other$fields != null : !((Object)this$fields).equals(other$fields)) {
                return false;
            }
            String this$separator = this.getSeparator();
            String other$separator = other.getSeparator();
            return !(this$separator == null ? other$separator != null : !this$separator.equals(other$separator));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Summarize;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $frags = this.getFrags();
            result = result * 59 + ($frags == null ? 43 : ((Object)$frags).hashCode());
            Long $length = this.getLength();
            result = result * 59 + ($length == null ? 43 : ((Object)$length).hashCode());
            List<String> $fields = this.getFields();
            result = result * 59 + ($fields == null ? 43 : ((Object)$fields).hashCode());
            String $separator = this.getSeparator();
            result = result * 59 + ($separator == null ? 43 : $separator.hashCode());
            return result;
        }

        public String toString() {
            return "SearchOptions.Summarize(fields=" + this.getFields() + ", frags=" + this.getFrags() + ", length=" + this.getLength() + ", separator=" + this.getSeparator() + ")";
        }

        public Summarize() {
        }

        public Summarize(List<String> fields, Long frags, Long length, String separator) {
            this.fields = fields;
            this.frags = frags;
            this.length = length;
            this.separator = separator;
        }

        public static class SummarizeBuilder {
            private ArrayList<String> fields;
            private Long frags;
            private Long length;
            private String separator;

            SummarizeBuilder() {
            }

            public SummarizeBuilder field(String field) {
                if (this.fields == null) {
                    this.fields = new ArrayList();
                }
                this.fields.add(field);
                return this;
            }

            public SummarizeBuilder fields(Collection<? extends String> fields) {
                if (fields == null) {
                    throw new NullPointerException("fields cannot be null");
                }
                if (this.fields == null) {
                    this.fields = new ArrayList();
                }
                this.fields.addAll(fields);
                return this;
            }

            public SummarizeBuilder clearFields() {
                if (this.fields != null) {
                    this.fields.clear();
                }
                return this;
            }

            public SummarizeBuilder frags(Long frags) {
                this.frags = frags;
                return this;
            }

            public SummarizeBuilder length(Long length) {
                this.length = length;
                return this;
            }

            public SummarizeBuilder separator(String separator) {
                this.separator = separator;
                return this;
            }

            public Summarize build() {
                List<String> fields;
                switch (this.fields == null ? 0 : this.fields.size()) {
                    case 0: {
                        fields = Collections.emptyList();
                        break;
                    }
                    case 1: {
                        fields = Collections.singletonList(this.fields.get(0));
                        break;
                    }
                    default: {
                        fields = Collections.unmodifiableList(new ArrayList<String>(this.fields));
                    }
                }
                return new Summarize(fields, this.frags, this.length, this.separator);
            }

            public String toString() {
                return "SearchOptions.Summarize.SummarizeBuilder(fields=" + this.fields + ", frags=" + this.frags + ", length=" + this.length + ", separator=" + this.separator + ")";
            }
        }
    }

    public static class Highlight
    implements RediSearchArgument {
        private List<String> fields;
        private Tags tags;

        public void build(RediSearchCommandArgs args) {
            if (this.fields.size() > 0) {
                args.add(CommandKeyword.FIELDS);
                args.add(this.fields.size());
                this.fields.forEach(args::add);
            }
            if (this.tags != null) {
                args.add(CommandKeyword.TAGS);
                args.add(this.tags.getOpen());
                args.add(this.tags.getClose());
            }
        }

        public static HighlightBuilder builder() {
            return new HighlightBuilder();
        }

        public List<String> getFields() {
            return this.fields;
        }

        public Tags getTags() {
            return this.tags;
        }

        public void setFields(List<String> fields) {
            this.fields = fields;
        }

        public void setTags(Tags tags) {
            this.tags = tags;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Highlight)) {
                return false;
            }
            Highlight other = (Highlight)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<String> this$fields = this.getFields();
            List<String> other$fields = other.getFields();
            if (this$fields == null ? other$fields != null : !((Object)this$fields).equals(other$fields)) {
                return false;
            }
            Tags this$tags = this.getTags();
            Tags other$tags = other.getTags();
            return !(this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Highlight;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<String> $fields = this.getFields();
            result = result * 59 + ($fields == null ? 43 : ((Object)$fields).hashCode());
            Tags $tags = this.getTags();
            result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
            return result;
        }

        public String toString() {
            return "SearchOptions.Highlight(fields=" + this.getFields() + ", tags=" + this.getTags() + ")";
        }

        public Highlight() {
        }

        public Highlight(List<String> fields, Tags tags) {
            this.fields = fields;
            this.tags = tags;
        }

        public static class HighlightBuilder {
            private ArrayList<String> fields;
            private Tags tags;

            HighlightBuilder() {
            }

            public HighlightBuilder field(String field) {
                if (this.fields == null) {
                    this.fields = new ArrayList();
                }
                this.fields.add(field);
                return this;
            }

            public HighlightBuilder fields(Collection<? extends String> fields) {
                if (fields == null) {
                    throw new NullPointerException("fields cannot be null");
                }
                if (this.fields == null) {
                    this.fields = new ArrayList();
                }
                this.fields.addAll(fields);
                return this;
            }

            public HighlightBuilder clearFields() {
                if (this.fields != null) {
                    this.fields.clear();
                }
                return this;
            }

            public HighlightBuilder tags(Tags tags) {
                this.tags = tags;
                return this;
            }

            public Highlight build() {
                List<String> fields;
                switch (this.fields == null ? 0 : this.fields.size()) {
                    case 0: {
                        fields = Collections.emptyList();
                        break;
                    }
                    case 1: {
                        fields = Collections.singletonList(this.fields.get(0));
                        break;
                    }
                    default: {
                        fields = Collections.unmodifiableList(new ArrayList<String>(this.fields));
                    }
                }
                return new Highlight(fields, this.tags);
            }

            public String toString() {
                return "SearchOptions.Highlight.HighlightBuilder(fields=" + this.fields + ", tags=" + this.tags + ")";
            }
        }
    }

    public static class GeoFilter
    implements RediSearchArgument {
        private final String field;
        private final double longitude;
        private final double latitude;
        private final double radius;
        private final String unit;

        public GeoFilter(String field, double longitude, double latitude, double radius, String unit) {
            this.field = field;
            this.longitude = longitude;
            this.latitude = latitude;
            this.radius = radius;
            this.unit = unit;
        }

        public void build(RediSearchCommandArgs args) {
            args.add(this.field);
            args.add(this.longitude);
            args.add(this.latitude);
            args.add(this.radius);
            args.add(this.unit);
        }

        public static GeoFilterBuilder field(String field) {
            return new GeoFilterBuilder(field);
        }

        public static class GeoFilterBuilder {
            private final String field;
            private double longitude;
            private double latitude;
            private double radius;
            private String unit;

            public GeoFilterBuilder(String field) {
                this.field = field;
            }

            public GeoFilter build() {
                return new GeoFilter(this.field, this.longitude, this.latitude, this.radius, this.unit);
            }

            public GeoFilterBuilder longitude(double longitude) {
                this.longitude = longitude;
                return this;
            }

            public GeoFilterBuilder latitude(double latitude) {
                this.latitude = latitude;
                return this;
            }

            public GeoFilterBuilder radius(double radius) {
                this.radius = radius;
                return this;
            }

            public GeoFilterBuilder unit(String unit) {
                this.unit = unit;
                return this;
            }
        }
    }

    public static class NumericFilter
    implements RediSearchArgument {
        private final String field;
        private final double min;
        private final double max;

        public NumericFilter(String field, double min, double max) {
            this.field = field;
            this.min = min;
            this.max = max;
        }

        public void build(RediSearchCommandArgs args) {
            args.add(this.field);
            args.add(this.min);
            args.add(this.max);
        }

        public static NumericFilterBuilder field(String field) {
            return new NumericFilterBuilder(field);
        }

        public static class MinNumericFilterBuilder {
            private final String field;
            private final double min;

            public MinNumericFilterBuilder(String field, double min) {
                this.field = field;
                this.min = min;
            }

            public NumericFilter max(double max) {
                return new NumericFilter(this.field, this.min, max);
            }
        }

        public static class NumericFilterBuilder {
            private final String field;

            public NumericFilterBuilder(String field) {
                this.field = field;
            }

            public MinNumericFilterBuilder min(double min) {
                return new MinNumericFilterBuilder(this.field, min);
            }
        }
    }

    public static class Limit
    implements RediSearchArgument {
        private final long offset;
        private final long num;

        public Limit(long offset, long num) {
            this.offset = offset;
            this.num = num;
        }

        public void build(RediSearchCommandArgs args) {
            args.add(CommandKeyword.LIMIT);
            args.add(this.offset);
            args.add(this.num);
        }

        public static LimitBuilder offset(long offset) {
            return new LimitBuilder(offset);
        }

        public static class LimitBuilder {
            private final long offset;

            public LimitBuilder(long offset) {
                this.offset = offset;
            }

            public Limit num(long num) {
                return new Limit(this.offset, num);
            }
        }
    }
}

