/*
 * Decompiled with CFR 0.152.
 */
package com.redislabs.mesclun.search;

import com.redislabs.mesclun.search.RediSearchArgument;
import com.redislabs.mesclun.search.protocol.CommandKeyword;
import com.redislabs.mesclun.search.protocol.RediSearchCommandArgs;

public class SuggetOptions
implements RediSearchArgument {
    private boolean fuzzy;
    private boolean withScores;
    private boolean withPayloads;
    private Long max;

    public void build(RediSearchCommandArgs args) {
        if (this.fuzzy) {
            args.add(CommandKeyword.FUZZY);
        }
        if (this.withScores) {
            args.add(CommandKeyword.WITHSCORES);
        }
        if (this.withPayloads) {
            args.add(CommandKeyword.WITHPAYLOADS);
        }
        if (this.max != null) {
            args.add(CommandKeyword.MAX);
            args.add(this.max);
        }
    }

    public static SuggetOptionsBuilder builder() {
        return new SuggetOptionsBuilder();
    }

    public boolean isFuzzy() {
        return this.fuzzy;
    }

    public boolean isWithScores() {
        return this.withScores;
    }

    public boolean isWithPayloads() {
        return this.withPayloads;
    }

    public Long getMax() {
        return this.max;
    }

    public void setFuzzy(boolean fuzzy) {
        this.fuzzy = fuzzy;
    }

    public void setWithScores(boolean withScores) {
        this.withScores = withScores;
    }

    public void setWithPayloads(boolean withPayloads) {
        this.withPayloads = withPayloads;
    }

    public void setMax(Long max) {
        this.max = max;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SuggetOptions)) {
            return false;
        }
        SuggetOptions other = (SuggetOptions)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isFuzzy() != other.isFuzzy()) {
            return false;
        }
        if (this.isWithScores() != other.isWithScores()) {
            return false;
        }
        if (this.isWithPayloads() != other.isWithPayloads()) {
            return false;
        }
        Long this$max = this.getMax();
        Long other$max = other.getMax();
        return !(this$max == null ? other$max != null : !((Object)this$max).equals(other$max));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SuggetOptions;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isFuzzy() ? 79 : 97);
        result = result * 59 + (this.isWithScores() ? 79 : 97);
        result = result * 59 + (this.isWithPayloads() ? 79 : 97);
        Long $max = this.getMax();
        result = result * 59 + ($max == null ? 43 : ((Object)$max).hashCode());
        return result;
    }

    public String toString() {
        return "SuggetOptions(fuzzy=" + this.isFuzzy() + ", withScores=" + this.isWithScores() + ", withPayloads=" + this.isWithPayloads() + ", max=" + this.getMax() + ")";
    }

    public SuggetOptions() {
    }

    public SuggetOptions(boolean fuzzy, boolean withScores, boolean withPayloads, Long max) {
        this.fuzzy = fuzzy;
        this.withScores = withScores;
        this.withPayloads = withPayloads;
        this.max = max;
    }

    public static class SuggetOptionsBuilder {
        private boolean fuzzy;
        private boolean withScores;
        private boolean withPayloads;
        private Long max;

        SuggetOptionsBuilder() {
        }

        public SuggetOptionsBuilder fuzzy(boolean fuzzy) {
            this.fuzzy = fuzzy;
            return this;
        }

        public SuggetOptionsBuilder withScores(boolean withScores) {
            this.withScores = withScores;
            return this;
        }

        public SuggetOptionsBuilder withPayloads(boolean withPayloads) {
            this.withPayloads = withPayloads;
            return this;
        }

        public SuggetOptionsBuilder max(Long max) {
            this.max = max;
            return this;
        }

        public SuggetOptions build() {
            return new SuggetOptions(this.fuzzy, this.withScores, this.withPayloads, this.max);
        }

        public String toString() {
            return "SuggetOptions.SuggetOptionsBuilder(fuzzy=" + this.fuzzy + ", withScores=" + this.withScores + ", withPayloads=" + this.withPayloads + ", max=" + this.max + ")";
        }
    }
}

