/*
 * Decompiled with CFR 0.152.
 */
package com.redislabs.mesclun.search.aggregate;

import com.redislabs.mesclun.search.AggregateOptions;
import com.redislabs.mesclun.search.protocol.CommandKeyword;
import com.redislabs.mesclun.search.protocol.RediSearchCommandArgs;
import io.lettuce.core.internal.LettuceAssert;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class GroupBy
implements AggregateOptions.Operation {
    private final String[] properties;
    private final AggregateOptions.Reducer[] reducers;

    public GroupBy(String[] properties, AggregateOptions.Reducer[] reducers) {
        LettuceAssert.notEmpty((Object[])properties, (String)"Group must have at least one property");
        LettuceAssert.noNullElements((Object[])properties, (String)"Properties must not be null");
        LettuceAssert.notEmpty((Object[])reducers, (String)"Group must have at least one reducer");
        LettuceAssert.noNullElements((Object[])reducers, (String)"Reducers must not be null");
        this.properties = properties;
        this.reducers = reducers;
    }

    public void build(RediSearchCommandArgs args) {
        args.add(CommandKeyword.GROUPBY);
        args.add(this.properties.length);
        for (String property : this.properties) {
            args.addProperty(property);
        }
        for (AggregateOptions.Reducer reducer : this.reducers) {
            reducer.build(args);
        }
    }

    public static GroupByBuilder property(String property) {
        return GroupBy.properties(property);
    }

    public static GroupByBuilder properties(String ... properties) {
        return new GroupByBuilder(properties);
    }

    public static class GroupByBuilder {
        private final List<String> properties = new ArrayList<String>();
        private final List<AggregateOptions.Reducer> reducers = new ArrayList<AggregateOptions.Reducer>();

        public GroupByBuilder(String ... properties) {
            Collections.addAll(this.properties, properties);
        }

        public GroupByBuilder property(String property) {
            return GroupBy.properties(property);
        }

        public GroupByBuilder reducer(AggregateOptions.Reducer reducer) {
            return this.reducers(reducer);
        }

        public GroupByBuilder reducers(AggregateOptions.Reducer ... reducers) {
            Collections.addAll(this.reducers, reducers);
            return this;
        }

        public GroupBy build() {
            return new GroupBy(this.properties.toArray(new String[0]), this.reducers.toArray(new AggregateOptions.Reducer[0]));
        }
    }
}

