/*
 * Decompiled with CFR 0.152.
 */
package com.redislabs.mesclun.search.aggregate;

import com.redislabs.mesclun.search.AggregateOptions;
import com.redislabs.mesclun.search.Order;
import com.redislabs.mesclun.search.RediSearchArgument;
import com.redislabs.mesclun.search.protocol.CommandKeyword;
import com.redislabs.mesclun.search.protocol.RediSearchCommandArgs;
import io.lettuce.core.internal.LettuceAssert;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SortBy
implements AggregateOptions.Operation {
    private final Property[] properties;
    private final Long max;

    public SortBy(Property[] properties, Long max) {
        LettuceAssert.notEmpty((Object[])properties, (String)"At least one property is required");
        LettuceAssert.noNullElements((Object[])properties, (String)"Properties must not be null");
        this.properties = properties;
        this.max = max;
    }

    public void build(RediSearchCommandArgs args) {
        args.add(CommandKeyword.SORTBY);
        args.add((long)this.properties.length * 2L);
        for (Property property : this.properties) {
            property.build(args);
        }
        if (this.max != null) {
            args.add(CommandKeyword.MAX);
            args.add(this.max);
        }
    }

    public static SortByBuilder property(Property property) {
        return SortBy.properties(property);
    }

    public static SortByBuilder properties(Property ... properties) {
        return new SortByBuilder(properties);
    }

    public static class Property
    implements RediSearchArgument {
        private final String name;
        private final Order order;

        public Property(String name, Order order) {
            LettuceAssert.notNull((Object)name, (String)"Name is required");
            LettuceAssert.notNull((Object)((Object)order), (String)"Order is required");
            this.name = name;
            this.order = order;
        }

        public void build(RediSearchCommandArgs args) {
            args.addProperty(this.name);
            args.add(this.order == Order.ASC ? CommandKeyword.ASC : CommandKeyword.DESC);
        }

        public static PropertyBuilder name(String name) {
            return new PropertyBuilder(name);
        }

        public static class PropertyBuilder {
            private final String name;

            public PropertyBuilder(String name) {
                this.name = name;
            }

            public Property order(Order order) {
                return new Property(this.name, order);
            }
        }
    }

    public static class SortByBuilder {
        private final List<Property> properties = new ArrayList<Property>();
        private Long max;

        public SortByBuilder(Property ... properties) {
            Collections.addAll(this.properties, properties);
        }

        public SortByBuilder property(Property property) {
            return SortBy.properties(property);
        }

        public SortByBuilder max(long max) {
            this.max = max;
            return this;
        }

        public SortBy build() {
            return new SortBy(this.properties.toArray(new Property[0]), this.max);
        }
    }
}

