/*
 * Decompiled with CFR 0.152.
 */
package com.redislabs.mesclun.search.aggregate.reducers;

import com.redislabs.mesclun.search.Order;
import com.redislabs.mesclun.search.aggregate.reducers.AbstractPropertyReducer;
import com.redislabs.mesclun.search.protocol.CommandKeyword;
import com.redislabs.mesclun.search.protocol.RediSearchCommandArgs;

public class FirstValue
extends AbstractPropertyReducer {
    private final By by;

    public FirstValue(String as, String property, By by) {
        super(as, property);
        this.by = by;
    }

    @Override
    protected void buildFunction(RediSearchCommandArgs args) {
        args.add(CommandKeyword.FIRST_VALUE);
        args.add(this.getNumberOfArgs());
        args.addProperty(this.property);
        if (this.by != null) {
            args.add(CommandKeyword.BY);
            args.addProperty(this.property);
            if (this.by.getOrder() != null) {
                args.add(this.by.getOrder() == Order.ASC ? CommandKeyword.ASC : CommandKeyword.DESC);
            }
        }
    }

    private int getNumberOfArgs() {
        int nargs = 1;
        if (this.by != null) {
            nargs += this.by.getOrder() == null ? 2 : 3;
        }
        return nargs;
    }

    public static FirstValueBuilder property(String property) {
        return new FirstValueBuilder(property);
    }

    public static class By {
        private final String property;
        private final Order order;

        public By(String property, Order order) {
            this.property = property;
            this.order = order;
        }

        public static ByBuilder property(String property) {
            return new ByBuilder(property);
        }

        public String getProperty() {
            return this.property;
        }

        public Order getOrder() {
            return this.order;
        }

        public static class ByBuilder {
            private final String property;
            private Order order;

            public ByBuilder(String property) {
                this.property = property;
            }

            public By build() {
                return new By(this.property, this.order);
            }

            public ByBuilder order(Order order) {
                this.order = order;
                return this;
            }
        }
    }

    public static class FirstValueBuilder
    extends AbstractPropertyReducer.PropertyReducerBuilder<FirstValueBuilder> {
        private By by;

        protected FirstValueBuilder(String property) {
            super(property);
        }

        public FirstValue build() {
            return new FirstValue(this.as, this.property, this.by);
        }

        public FirstValueBuilder by(By by) {
            this.by = by;
            return this;
        }
    }
}

