/*
 * Decompiled with CFR 0.152.
 */
package com.redislabs.mesclun.search.output;

import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.output.CommandOutput;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class AggregateResultOutput<K, V>
extends CommandOutput<K, V, Map<K, Object>> {
    private final List<V> array = new ArrayList<V>();
    private boolean initialized;
    private K key;
    private int count;

    public AggregateResultOutput(RedisCodec<K, V> codec) {
        super(codec, Collections.emptyMap());
    }

    public void set(ByteBuffer bytes) {
        Object value;
        if (this.key == null) {
            this.key = bytes == null ? null : this.codec.decodeKey(bytes);
            return;
        }
        Object object = value = bytes == null ? null : this.codec.decodeValue(bytes);
        if (this.count > 0) {
            this.array.add(value);
            if (this.array.size() == this.count) {
                ((Map)this.output).put(this.key, new ArrayList<V>(this.array));
                this.key = null;
                this.array.clear();
                this.count = 0;
            }
        } else {
            ((Map)this.output).put(this.key, value);
            this.key = null;
        }
    }

    public void set(long integer) {
        if (this.key == null) {
            this.key = integer;
            return;
        }
        Long value = integer;
        ((Map)this.output).put(this.key, value);
        this.key = null;
    }

    public void multi(int count) {
        if (this.initialized) {
            if (this.key != null) {
                this.count = count;
            }
        } else {
            this.output = new LinkedHashMap(count / 2, 1.0f);
            this.initialized = true;
        }
    }
}

