/*
 * Decompiled with CFR 0.152.
 */
package com.redislabs.mesclun.search.output;

import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.output.CommandOutput;
import io.lettuce.core.output.ListSubscriber;
import io.lettuce.core.output.StreamingOutput;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class MapListOutput<K, V>
extends CommandOutput<K, V, List<Map<K, V>>>
implements StreamingOutput<Map<K, V>> {
    private boolean initialized;
    private StreamingOutput.Subscriber<Map<K, V>> subscriber;
    private K key;
    private Map<K, V> body;

    public MapListOutput(RedisCodec<K, V> codec) {
        super(codec, Collections.emptyList());
        this.setSubscriber((StreamingOutput.Subscriber<Map<K, V>>)ListSubscriber.instance());
    }

    public void set(ByteBuffer bytes) {
        if (this.key == null) {
            this.key = bytes == null ? null : this.codec.decodeKey(bytes);
            return;
        }
        if (this.body == null) {
            this.body = new LinkedHashMap();
        }
        this.body.put(this.key, bytes == null ? null : this.codec.decodeValue(bytes));
        this.key = null;
    }

    public void multi(int count) {
        if (!this.initialized) {
            this.output = count > 0 ? new ArrayList(count) : Collections.emptyList();
            this.initialized = true;
        }
    }

    public void complete(int depth) {
        if (depth == 1) {
            this.subscriber.onNext((Collection)this.output, this.body);
            this.key = null;
            this.body = null;
        }
    }

    public void setSubscriber(StreamingOutput.Subscriber<Map<K, V>> subscriber) {
        LettuceAssert.notNull(subscriber, (String)"Subscriber must not be null");
        this.subscriber = subscriber;
    }

    public StreamingOutput.Subscriber<Map<K, V>> getSubscriber() {
        return this.subscriber;
    }
}

