/*
 * Decompiled with CFR 0.152.
 */
package com.redislabs.mesclun.search.output;

import com.redislabs.mesclun.search.Document;
import com.redislabs.mesclun.search.SearchResults;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.output.CommandOutput;
import io.lettuce.core.output.MapOutput;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class SearchOutput<K, V>
extends CommandOutput<K, V, SearchResults<K, V>> {
    private final List<Integer> counts = new ArrayList<Integer>();
    private final boolean withScores;
    private final boolean withSortKeys;
    private final boolean withPayloads;
    private MapOutput<K, V> nested;
    private Document<K, V> current;
    private int mapCount = -1;
    private boolean payloadSet = false;
    private boolean scoreSet = false;

    public SearchOutput(RedisCodec<K, V> codec) {
        this(codec, false, false, false);
    }

    public SearchOutput(RedisCodec<K, V> codec, boolean withScores, boolean withSortKeys, boolean withPayloads) {
        super(codec, new SearchResults());
        this.nested = new MapOutput(codec);
        this.withScores = withScores;
        this.withSortKeys = withSortKeys;
        this.withPayloads = withPayloads;
    }

    public void set(ByteBuffer bytes) {
        if (this.current == null) {
            this.current = new Document();
            this.payloadSet = false;
            this.scoreSet = false;
            if (bytes != null) {
                this.current.setId(this.codec.decodeKey(bytes));
            }
            ((SearchResults)this.output).add(this.current);
        } else if (this.withSortKeys && this.current.getSortKey() == null) {
            if (bytes != null) {
                this.current.setSortKey(this.codec.decodeValue(bytes));
            }
        } else if (this.withPayloads && !this.payloadSet) {
            if (bytes != null) {
                this.current.setPayload(this.codec.decodeValue(bytes));
            }
            this.payloadSet = true;
        } else {
            this.nested.set(bytes);
        }
    }

    public void set(long integer) {
        ((SearchResults)this.output).setCount(integer);
    }

    public void set(double number) {
        if (this.withScores && !this.scoreSet) {
            this.current.setScore(number);
            this.scoreSet = true;
        }
    }

    public void complete(int depth) {
        if (!this.counts.isEmpty() && ((Map)this.nested.get()).size() == this.counts.get(0).intValue()) {
            this.counts.remove(0);
            this.current.putAll((Map)this.nested.get());
            this.nested = new MapOutput(this.codec);
            this.current = null;
            this.payloadSet = false;
            this.scoreSet = false;
        }
    }

    public void multi(int count) {
        this.nested.multi(count);
        if (this.mapCount == -1) {
            this.mapCount = count;
        } else {
            this.counts.add(count / 2);
        }
    }
}

