/*
 * Decompiled with CFR 0.152.
 */
package com.redislabs.mesclun.timeseries;

import com.redislabs.mesclun.timeseries.protocol.CommandKeyword;
import io.lettuce.core.CompositeArgument;
import io.lettuce.core.protocol.CommandArgs;
import io.lettuce.core.protocol.ProtocolKeyword;

public class CreateOptions
implements CompositeArgument {
    private Long retentionTime;
    private boolean uncompressed;
    private Long chunkSize;
    private DuplicatePolicy policy;

    public <K, V> void build(CommandArgs<K, V> args) {
        if (this.retentionTime != null) {
            args.add((ProtocolKeyword)CommandKeyword.RETENTION);
            args.add(this.retentionTime.longValue());
        }
        if (this.uncompressed) {
            args.add((ProtocolKeyword)CommandKeyword.UNCOMPRESSED);
        }
        if (this.chunkSize != null) {
            args.add((ProtocolKeyword)CommandKeyword.CHUNK_SIZE);
            args.add(this.chunkSize.longValue());
        }
        if (this.policy != null) {
            args.add((ProtocolKeyword)CommandKeyword.ON_DUPLICATE);
            args.add(this.policy.name());
        }
    }

    public static CreateOptionsBuilder builder() {
        return new CreateOptionsBuilder();
    }

    public Long getRetentionTime() {
        return this.retentionTime;
    }

    public boolean isUncompressed() {
        return this.uncompressed;
    }

    public Long getChunkSize() {
        return this.chunkSize;
    }

    public DuplicatePolicy getPolicy() {
        return this.policy;
    }

    public void setRetentionTime(Long retentionTime) {
        this.retentionTime = retentionTime;
    }

    public void setUncompressed(boolean uncompressed) {
        this.uncompressed = uncompressed;
    }

    public void setChunkSize(Long chunkSize) {
        this.chunkSize = chunkSize;
    }

    public void setPolicy(DuplicatePolicy policy) {
        this.policy = policy;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CreateOptions)) {
            return false;
        }
        CreateOptions other = (CreateOptions)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isUncompressed() != other.isUncompressed()) {
            return false;
        }
        Long this$retentionTime = this.getRetentionTime();
        Long other$retentionTime = other.getRetentionTime();
        if (this$retentionTime == null ? other$retentionTime != null : !((Object)this$retentionTime).equals(other$retentionTime)) {
            return false;
        }
        Long this$chunkSize = this.getChunkSize();
        Long other$chunkSize = other.getChunkSize();
        if (this$chunkSize == null ? other$chunkSize != null : !((Object)this$chunkSize).equals(other$chunkSize)) {
            return false;
        }
        DuplicatePolicy this$policy = this.getPolicy();
        DuplicatePolicy other$policy = other.getPolicy();
        return !(this$policy == null ? other$policy != null : !((Object)((Object)this$policy)).equals((Object)other$policy));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CreateOptions;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isUncompressed() ? 79 : 97);
        Long $retentionTime = this.getRetentionTime();
        result = result * 59 + ($retentionTime == null ? 43 : ((Object)$retentionTime).hashCode());
        Long $chunkSize = this.getChunkSize();
        result = result * 59 + ($chunkSize == null ? 43 : ((Object)$chunkSize).hashCode());
        DuplicatePolicy $policy = this.getPolicy();
        result = result * 59 + ($policy == null ? 43 : ((Object)((Object)$policy)).hashCode());
        return result;
    }

    public String toString() {
        return "CreateOptions(retentionTime=" + this.getRetentionTime() + ", uncompressed=" + this.isUncompressed() + ", chunkSize=" + this.getChunkSize() + ", policy=" + (Object)((Object)this.getPolicy()) + ")";
    }

    public CreateOptions() {
    }

    public CreateOptions(Long retentionTime, boolean uncompressed, Long chunkSize, DuplicatePolicy policy) {
        this.retentionTime = retentionTime;
        this.uncompressed = uncompressed;
        this.chunkSize = chunkSize;
        this.policy = policy;
    }

    public static enum DuplicatePolicy {
        BLOCK,
        FIRST,
        LAST,
        MIN,
        MAX,
        SUM;

    }

    public static class CreateOptionsBuilder {
        private Long retentionTime;
        private boolean uncompressed;
        private Long chunkSize;
        private DuplicatePolicy policy;

        public CreateOptionsBuilder retentionTime(long retentionTime) {
            this.retentionTime = retentionTime;
            return this;
        }

        public CreateOptionsBuilder chunkSize(long chunkSize) {
            this.chunkSize = chunkSize;
            return this;
        }

        CreateOptionsBuilder() {
        }

        public CreateOptionsBuilder uncompressed(boolean uncompressed) {
            this.uncompressed = uncompressed;
            return this;
        }

        public CreateOptionsBuilder policy(DuplicatePolicy policy) {
            this.policy = policy;
            return this;
        }

        public CreateOptions build() {
            return new CreateOptions(this.retentionTime, this.uncompressed, this.chunkSize, this.policy);
        }

        public String toString() {
            return "CreateOptions.CreateOptionsBuilder(retentionTime=" + this.retentionTime + ", uncompressed=" + this.uncompressed + ", chunkSize=" + this.chunkSize + ", policy=" + (Object)((Object)this.policy) + ")";
        }
    }
}

