/*
 * Decompiled with CFR 0.152.
 */
package com.redislabs.mesclun.timeseries;

import com.redislabs.mesclun.impl.RedisModulesCommandBuilder;
import com.redislabs.mesclun.timeseries.Aggregation;
import com.redislabs.mesclun.timeseries.CreateOptions;
import com.redislabs.mesclun.timeseries.Label;
import com.redislabs.mesclun.timeseries.protocol.CommandKeyword;
import com.redislabs.mesclun.timeseries.protocol.CommandType;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.output.CommandOutput;
import io.lettuce.core.output.IntegerOutput;
import io.lettuce.core.output.StatusOutput;
import io.lettuce.core.protocol.Command;
import io.lettuce.core.protocol.CommandArgs;
import io.lettuce.core.protocol.ProtocolKeyword;

public class RedisTimeSeriesCommandBuilder<K, V>
extends RedisModulesCommandBuilder<K, V> {
    public RedisTimeSeriesCommandBuilder(RedisCodec<K, V> codec) {
        super(codec);
    }

    protected <A, B, T> Command<A, B, T> createCommand(CommandType type, CommandOutput<A, B, T> output, CommandArgs<A, B> args) {
        return new Command((ProtocolKeyword)type, output, args);
    }

    public Command<K, V, String> create(K key, CreateOptions options, Label<K, V>[] labels) {
        CommandArgs<K, V> args = this.args(key);
        this.addOptions(args, options, labels);
        return this.createCommand(CommandType.CREATE, (CommandOutput)new StatusOutput(this.codec), (CommandArgs)args);
    }

    public Command<K, V, Long> add(K key, long timestamp, double value, CreateOptions options, Label<K, V>[] labels) {
        CommandArgs<K, V> args = this.args(key);
        args.add(timestamp);
        args.add(value);
        this.addOptions(args, options, labels);
        return this.createCommand(CommandType.ADD, (CommandOutput)new IntegerOutput(this.codec), (CommandArgs)args);
    }

    private void addOptions(CommandArgs<K, V> args, CreateOptions options, Label<K, V>[] labels) {
        if (options != null) {
            options.build(args);
        }
        if (labels != null && labels.length > 0) {
            args.add((ProtocolKeyword)CommandKeyword.LABELS);
            for (Label<K, V> label : labels) {
                args.addKey(label.getLabel());
                args.addValue(label.getValue());
            }
        }
    }

    private CommandArgs<K, V> args(K key) {
        this.notNull(key, "key");
        return new CommandArgs(this.codec).addKey(key);
    }

    public Command<K, V, String> createRule(K sourceKey, K destKey, Aggregation aggregation, long timeBucket) {
        this.notNull(sourceKey, "Source key");
        this.notNull(destKey, "Destination key");
        this.notNull((Object)aggregation, "Aggregation");
        CommandArgs<K, V> args = this.args(sourceKey);
        args.addKey(destKey);
        args.add((ProtocolKeyword)CommandKeyword.AGGREGATION);
        args.add(aggregation.getName());
        args.add(timeBucket);
        return this.createCommand(CommandType.CREATERULE, (CommandOutput)new StatusOutput(this.codec), (CommandArgs)args);
    }

    public Command<K, V, String> deleteRule(K sourceKey, K destKey) {
        this.notNull(sourceKey, "Source key");
        this.notNull(destKey, "Destination key");
        CommandArgs<K, V> args = this.args(sourceKey);
        args.addKey(destKey);
        return this.createCommand(CommandType.DELETERULE, (CommandOutput)new StatusOutput(this.codec), (CommandArgs)args);
    }
}

