/*
 * Decompiled with CFR 0.152.
 */
package com.redislabs.mesclun.timeseries;

public class Sample {
    private long timestamp;
    private double value;

    public static SampleBuilder builder() {
        return new SampleBuilder();
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public double getValue() {
        return this.value;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public void setValue(double value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Sample)) {
            return false;
        }
        Sample other = (Sample)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTimestamp() != other.getTimestamp()) {
            return false;
        }
        return Double.compare(this.getValue(), other.getValue()) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof Sample;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $timestamp = this.getTimestamp();
        result = result * 59 + (int)($timestamp >>> 32 ^ $timestamp);
        long $value = Double.doubleToLongBits(this.getValue());
        result = result * 59 + (int)($value >>> 32 ^ $value);
        return result;
    }

    public String toString() {
        return "Sample(timestamp=" + this.getTimestamp() + ", value=" + this.getValue() + ")";
    }

    public Sample() {
    }

    public Sample(long timestamp, double value) {
        this.timestamp = timestamp;
        this.value = value;
    }

    public static class SampleBuilder {
        private long timestamp;
        private double value;

        SampleBuilder() {
        }

        public SampleBuilder timestamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public SampleBuilder value(double value) {
            this.value = value;
            return this;
        }

        public Sample build() {
            return new Sample(this.timestamp, this.value);
        }

        public String toString() {
            return "Sample.SampleBuilder(timestamp=" + this.timestamp + ", value=" + this.value + ")";
        }
    }
}

