/*
 * Decompiled with CFR 0.152.
 */
package com.redislabs.provider.redis;

import com.redislabs.provider.redis.RedisEndpoint;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.exceptions.JedisConnectionException;
import scala.Function0;
import scala.Serializable;
import scala.collection.JavaConversions$;
import scala.runtime.BoxedUnit;

public final class ConnectionPool$ {
    public static ConnectionPool$ MODULE$;
    private transient ConcurrentHashMap<RedisEndpoint, JedisPool> pools;
    private volatile transient boolean bitmap$trans$0;

    static {
        new ConnectionPool$();
    }

    private ConcurrentHashMap<RedisEndpoint, JedisPool> pools$lzycompute() {
        ConnectionPool$ connectionPool$ = this;
        synchronized (connectionPool$) {
            if (!this.bitmap$trans$0) {
                this.pools = new ConcurrentHashMap();
                this.bitmap$trans$0 = true;
            }
        }
        return this.pools;
    }

    private ConcurrentHashMap<RedisEndpoint, JedisPool> pools() {
        return !this.bitmap$trans$0 ? this.pools$lzycompute() : this.pools;
    }

    public Jedis connect(RedisEndpoint re) {
        JedisPool pool = (JedisPool)JavaConversions$.MODULE$.deprecated$u0020mapAsScalaConcurrentMap(this.pools()).getOrElseUpdate((Object)re, (Function0 & java.io.Serializable & Serializable)() -> {
            JedisPoolConfig poolConfig = new JedisPoolConfig();
            poolConfig.setMaxTotal(250);
            poolConfig.setMaxIdle(32);
            poolConfig.setTestOnBorrow(false);
            poolConfig.setTestOnReturn(false);
            poolConfig.setTestWhileIdle(false);
            poolConfig.setMinEvictableIdleTimeMillis(60000L);
            poolConfig.setTimeBetweenEvictionRunsMillis(30000L);
            poolConfig.setNumTestsPerEvictionRun(-1);
            return new JedisPool((GenericObjectPoolConfig)poolConfig, re.host(), re.port(), re.timeout(), re.auth(), re.dbNum());
        });
        int sleepTime = 4;
        Jedis conn = null;
        while (conn == null) {
            try {
                conn = pool.getResource();
            }
            catch (Throwable throwable) {
                JedisConnectionException jedisConnectionException;
                Throwable throwable2 = throwable;
                if (throwable2 instanceof JedisConnectionException && (jedisConnectionException = (JedisConnectionException)throwable2).getCause().toString().contains("ERR max number of clients reached")) {
                    if (sleepTime < 500) {
                        sleepTime *= 2;
                    }
                    Thread.sleep(sleepTime);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                if (throwable2 instanceof Exception) {
                    Exception exception = (Exception)throwable2;
                    throw exception;
                }
                throw throwable;
            }
        }
        return conn;
    }

    private ConnectionPool$() {
        MODULE$ = this;
    }
}

