/*
 * Decompiled with CFR 0.152.
 */
package com.redislabs.provider.redis;

import com.redislabs.provider.redis.RedisConfig$;
import com.redislabs.provider.redis.RedisEndpoint;
import com.redislabs.provider.redis.RedisEndpoint$;
import com.redislabs.provider.redis.RedisNode;
import java.io.Serializable;
import java.util.List;
import org.apache.spark.SparkConf;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.util.JedisClusterCRC16;
import redis.clients.jedis.util.SafeEncoder;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001\u0005ms!B\u000f\u001f\u0011\u00039c!B\u0015\u001f\u0011\u0003Q\u0003\"\u0002\u001b\u0002\t\u0003)\u0004\"\u0002\u001c\u0002\t\u00039\u0004\"CA$\u0003\u0005\u0005I\u0011BA%\r\u0011Ic\u0004A\u001d\t\u0011i*!Q1A\u0005\u0002mB\u0001bP\u0003\u0003\u0002\u0003\u0006I\u0001\u0010\u0005\u0006i\u0015!\t\u0001\u0011\u0005\b\u0005\u0016\u0011\r\u0011\"\u0001D\u0011\u0019yU\u0001)A\u0005\t\"9\u0001+\u0002b\u0001\n\u0003\t\u0006B\u0002-\u0006A\u0003%!\u000bC\u0004Z\u000b\t\u0007I\u0011A)\t\ri+\u0001\u0015!\u0003S\u0011\u0015YV\u0001\"\u0001D\u0011\u0015aV\u0001\"\u0001^\u0011\u0015\tW\u0001\"\u0001c\u0011\u0015\u0019W\u0001\"\u0001e\u0011\u0015IW\u0001\"\u0001k\u0011\u0015IW\u0001\"\u0001w\u0011\u0015aX\u0001\"\u0003~\u0011\u001d\t)!\u0002C\u0001\u0003\u000fAq!!\u0002\u0006\t\u0003\tY\u0001C\u0004\u0002\u0010\u0015!I!!\u0005\t\u000f\u0005]Q\u0001\"\u0003\u0002\u001a!9\u0011QD\u0003\u0005\n\u0005}\u0001bBA\u0012\u000b\u0011%\u0011Q\u0005\u0005\b\u0003S)A\u0011AA\u0016\u0003-\u0011V\rZ5t\u0007>tg-[4\u000b\u0005}\u0001\u0013!\u0002:fI&\u001c(BA\u0011#\u0003!\u0001(o\u001c<jI\u0016\u0014(BA\u0012%\u0003%\u0011X\rZ5tY\u0006\u00147OC\u0001&\u0003\r\u0019w.\\\u0002\u0001!\tA\u0013!D\u0001\u001f\u0005-\u0011V\rZ5t\u0007>tg-[4\u0014\u0007\u0005Y\u0013\u0007\u0005\u0002-_5\tQFC\u0001/\u0003\u0015\u00198-\u00197b\u0013\t\u0001TF\u0001\u0004B]f\u0014VM\u001a\t\u0003YIJ!aM\u0017\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\rqJg.\u001b;?)\u00059\u0013!\u00044s_6\u001c\u0006/\u0019:l\u0007>tg\rF\u00029\u0003_\u0001\"\u0001K\u0003\u0014\u0007\u0015Y\u0013'A\u0006j]&$\u0018.\u00197I_N$X#\u0001\u001f\u0011\u0005!j\u0014B\u0001 \u001f\u00055\u0011V\rZ5t\u000b:$\u0007o\\5oi\u0006a\u0011N\\5uS\u0006d\u0007j\\:uAQ\u0011\u0001(\u0011\u0005\u0006u!\u0001\r\u0001P\u0001\fS:LG/[1m\u0003\u0012$'/F\u0001E!\t)EJ\u0004\u0002G\u0015B\u0011q)L\u0007\u0002\u0011*\u0011\u0011JJ\u0001\u0007yI|w\u000e\u001e \n\u0005-k\u0013A\u0002)sK\u0012,g-\u0003\u0002N\u001d\n11\u000b\u001e:j]\u001eT!aS\u0017\u0002\u0019%t\u0017\u000e^5bY\u0006#GM\u001d\u0011\u0002\u000b!|7\u000f^:\u0016\u0003I\u00032\u0001L*V\u0013\t!VFA\u0003BeJ\f\u0017\u0010\u0005\u0002)-&\u0011qK\b\u0002\n%\u0016$\u0017n\u001d(pI\u0016\fa\u0001[8tiN\u0004\u0013!\u00028pI\u0016\u001c\u0018A\u00028pI\u0016\u001c\b%A\u0004hKR\fU\u000f\u001e5\u0002\u000b\u001d,G\u000f\u0012\"\u0016\u0003y\u0003\"\u0001L0\n\u0005\u0001l#aA%oi\u0006iq-\u001a;SC:$w.\u001c(pI\u0016$\u0012!V\u0001\u0010O\u0016$hj\u001c3fg\nK8\u000b\\8ugR\u0019!+Z4\t\u000b\u0019\u0014\u0002\u0019\u00010\u0002\tM\u0004vn\u001d\u0005\u0006QJ\u0001\rAX\u0001\u0005KB{7/\u0001\td_:tWm\u0019;j_:4uN]&fsR\u00111\u000e\u001e\t\u0003YJl\u0011!\u001c\u0006\u0003]>\fQA[3eSNT!\u0001]9\u0002\u000f\rd\u0017.\u001a8ug*\tq$\u0003\u0002t[\n)!*\u001a3jg\")Qo\u0005a\u0001\t\u0006\u00191.Z=\u0015\u0005-<\b\"B;\u0015\u0001\u0004A\bc\u0001\u0017TsB\u0011AF_\u0005\u0003w6\u0012AAQ=uK\u0006q1\r\\;ti\u0016\u0014XI\\1cY\u0016$Gc\u0001@\u0002\u0004A\u0011Af`\u0005\u0004\u0003\u0003i#a\u0002\"p_2,\u0017M\u001c\u0005\u0006uU\u0001\r\u0001P\u0001\bO\u0016$\bj\\:u)\r)\u0016\u0011\u0002\u0005\u0006kZ\u0001\r\u0001\u0012\u000b\u0004+\u00065\u0001\"B;\u0018\u0001\u0004A\u0018!D4fi\"{7\u000f\u001e\"z'2|G\u000fF\u0002V\u0003'Aa!!\u0006\u0019\u0001\u0004q\u0016\u0001B:m_R\f\u0001bZ3u\u0011>\u001cHo\u001d\u000b\u0004%\u0006m\u0001\"\u0002\u001e\u001a\u0001\u0004a\u0014AE4fi:{gn\u00117vgR,'OT8eKN$2AUA\u0011\u0011\u0015Q$\u00041\u0001=\u0003=9W\r^\"mkN$XM\u001d(pI\u0016\u001cHc\u0001*\u0002(!)!h\u0007a\u0001y\u0005Aq-\u001a;O_\u0012,7\u000fF\u0002S\u0003[AQA\u000f\u000fA\u0002qBq!!\r\u0004\u0001\u0004\t\u0019$\u0001\u0003d_:4\u0007\u0003BA\u001b\u0003\u0007j!!a\u000e\u000b\t\u0005e\u00121H\u0001\u0006gB\f'o\u001b\u0006\u0005\u0003{\ty$\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0003\u0003\u0003\n1a\u001c:h\u0013\u0011\t)%a\u000e\u0003\u0013M\u0003\u0018M]6D_:4\u0017a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!a\u0013\u0011\t\u00055\u0013qK\u0007\u0003\u0003\u001fRA!!\u0015\u0002T\u0005!A.\u00198h\u0015\t\t)&\u0001\u0003kCZ\f\u0017\u0002BA-\u0003\u001f\u0012aa\u00142kK\u000e$\b")
public class RedisConfig
implements scala.Serializable {
    private final RedisEndpoint initialHost;
    private final String initialAddr;
    private final RedisNode[] hosts;
    private final RedisNode[] nodes;

    public static RedisConfig fromSparkConf(SparkConf sparkConf) {
        return RedisConfig$.MODULE$.fromSparkConf(sparkConf);
    }

    public RedisEndpoint initialHost() {
        return this.initialHost;
    }

    public String initialAddr() {
        return this.initialAddr;
    }

    public RedisNode[] hosts() {
        return this.hosts;
    }

    public RedisNode[] nodes() {
        return this.nodes;
    }

    public String getAuth() {
        return this.initialHost().auth();
    }

    public int getDB() {
        return this.initialHost().dbNum();
    }

    public RedisNode getRandomNode() {
        int rnd = RichInt$.MODULE$.abs$extension(Predef$.MODULE$.intWrapper(Random$.MODULE$.nextInt())) % this.hosts().length;
        return this.hosts()[rnd];
    }

    public RedisNode[] getNodesBySlots(int sPos, int ePos) {
        return (RedisNode[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.nodes())).filter((Function1 & Serializable & scala.Serializable)node -> BoxesRunTime.boxToBoolean((boolean)RedisConfig.inter$1(sPos, ePos, node.startSlot(), node.endSlot()))))).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)RedisConfig.$anonfun$getNodesBySlots$2(x$1)));
    }

    public Jedis connectionForKey(String key) {
        return this.getHost(key).connect();
    }

    public Jedis connectionForKey(byte[] key) {
        return this.getHost(key).connect();
    }

    private boolean clusterEnabled(RedisEndpoint initialHost) {
        Jedis conn = initialHost.connect();
        String[] info = conn.info().split("\n");
        String version = ((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])info)).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.contains("redis_version:"))))[0];
        String[] clusterEnable = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])info)).filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.contains("cluster_enabled:")));
        int mainVersion = new StringOps(Predef$.MODULE$.augmentString(version.substring(14, version.indexOf(".")))).toInt();
        boolean res = mainVersion > 2 && clusterEnable.length > 0 && clusterEnable[0].contains("1");
        conn.close();
        return res;
    }

    public RedisNode getHost(String key) {
        int slot = JedisClusterCRC16.getSlot((String)key);
        return this.getHostBySlot(slot);
    }

    public RedisNode getHost(byte[] key) {
        int slot = JedisClusterCRC16.getSlot((byte[])key);
        return this.getHostBySlot(slot);
    }

    private RedisNode getHostBySlot(int slot) {
        return ((RedisNode[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.hosts())).filter((Function1 & Serializable & scala.Serializable)host -> BoxesRunTime.boxToBoolean((boolean)RedisConfig.$anonfun$getHostBySlot$1(slot, host))))[0];
    }

    private RedisNode[] getHosts(RedisEndpoint initialHost) {
        return (RedisNode[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.getNodes(initialHost))).filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)RedisConfig.$anonfun$getHosts$1(x$4)));
    }

    private RedisNode[] getNonClusterNodes(RedisEndpoint initialHost) {
        String[] replinfo;
        Tuple2 master;
        while (true) {
            master = new Tuple2((Object)initialHost.host(), (Object)BoxesRunTime.boxToInteger((int)initialHost.port()));
            Jedis conn = initialHost.connect();
            replinfo = conn.info("Replication").split("\n");
            conn.close();
            if (!new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])replinfo)).exists((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.contains("role:slave")))) break;
            String host = ((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])replinfo)).filter((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)x$6.contains("master_host:"))))[0].trim().substring(12);
            int port = new StringOps(Predef$.MODULE$.augmentString(((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])replinfo)).filter((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)x$7.contains("master_port:"))))[0].trim().substring(12))).toInt();
            initialHost = new RedisEndpoint(host, port, initialHost.auth(), initialHost.dbNum(), RedisEndpoint$.MODULE$.$lessinit$greater$default$5());
        }
        Tuple2[] slaves = (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])replinfo)).filter((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)RedisConfig.$anonfun$getNonClusterNodes$4(x))))).map((Function1 & Serializable & scala.Serializable)rl -> {
            String[] content = rl.substring(rl.indexOf(58) + 1).split(",");
            String ip = content[0];
            String port = content[1];
            return new Tuple2((Object)ip.substring(ip.indexOf(61) + 1), (Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(port.substring(port.indexOf(61) + 1))).toInt()));
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
        Tuple2 tuple2 = master;
        Tuple2[] nodes = (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])slaves)).$plus$colon((Object)tuple2, ClassTag$.MODULE$.apply(Tuple2.class));
        int range = nodes.length;
        return (RedisNode[])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), range).map((Function1 & Serializable & scala.Serializable)i -> RedisConfig.$anonfun$getNonClusterNodes$6(nodes, initialHost, range, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(RedisNode.class));
    }

    /*
     * WARNING - void declaration
     */
    private RedisNode[] getClusterNodes(RedisEndpoint initialHost) {
        void var3_3;
        Jedis conn = initialHost.connect();
        RedisNode[] res = (RedisNode[])((TraversableOnce)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(conn.clusterSlots()).flatMap((Function1 & Serializable & scala.Serializable)slotInfoObj -> {
            List slotInfo = (List)slotInfoObj;
            int sPos = new StringOps(Predef$.MODULE$.augmentString(slotInfo.get(0).toString())).toInt();
            int ePos = new StringOps(Predef$.MODULE$.augmentString(slotInfo.get(1).toString())).toInt();
            return (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), slotInfo.size() - 2).map((Function1 & Serializable & scala.Serializable)i -> RedisConfig.$anonfun$getClusterNodes$2(slotInfo, initialHost, sPos, ePos, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        }, Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(RedisNode.class));
        conn.close();
        return var3_3;
    }

    public RedisNode[] getNodes(RedisEndpoint initialHost) {
        return this.clusterEnabled(initialHost) ? this.getClusterNodes(initialHost) : this.getNonClusterNodes(initialHost);
    }

    private static final boolean inter$1(int sPos1, int ePos1, int sPos2, int ePos2) {
        return sPos1 <= sPos2 ? ePos1 >= sPos2 : ePos2 >= sPos1;
    }

    public static final /* synthetic */ boolean $anonfun$getNodesBySlots$2(RedisNode x$1) {
        return x$1.idx() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$getHostBySlot$1(int slot$1, RedisNode host) {
        return host.startSlot() <= slot$1 && host.endSlot() >= slot$1;
    }

    public static final /* synthetic */ boolean $anonfun$getHosts$1(RedisNode x$4) {
        return x$4.idx() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$getNonClusterNodes$4(String x) {
        return x.contains("slave") && x.contains("online");
    }

    public static final /* synthetic */ RedisNode $anonfun$getNonClusterNodes$6(Tuple2[] nodes$1, RedisEndpoint initialHost$1, int range$1, int i) {
        return new RedisNode(new RedisEndpoint((String)nodes$1[i]._1(), nodes$1[i]._2$mcI$sp(), initialHost$1.auth(), initialHost$1.dbNum(), initialHost$1.timeout()), 0, 16383, i, range$1);
    }

    public static final /* synthetic */ RedisNode $anonfun$getClusterNodes$2(List slotInfo$1, RedisEndpoint initialHost$2, int sPos$2, int ePos$2, int i) {
        List node = (List)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(slotInfo$1).apply(i + 2);
        String host = SafeEncoder.encode((byte[])((byte[])node.get(0)));
        int port = new StringOps(Predef$.MODULE$.augmentString(node.get(1).toString())).toInt();
        return new RedisNode(new RedisEndpoint(host, port, initialHost$2.auth(), initialHost$2.dbNum(), initialHost$2.timeout()), sPos$2, ePos$2, i, slotInfo$1.size() - 2);
    }

    public RedisConfig(RedisEndpoint initialHost) {
        this.initialHost = initialHost;
        this.initialAddr = initialHost.host();
        this.hosts = this.getHosts(initialHost);
        this.nodes = this.getNodes(initialHost);
    }
}

