/*
 * Decompiled with CFR 0.152.
 */
package com.redislabs.provider.redis;

import com.redislabs.provider.redis.ReadWriteConfig;
import com.redislabs.provider.redis.RedisConfig;
import com.redislabs.provider.redis.RedisNode;
import com.redislabs.provider.redis.util.ConnectionUtils$;
import com.redislabs.provider.redis.util.PipelineUtils$;
import java.io.Serializable;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.Pipeline;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

public final class RedisContext$
implements scala.Serializable {
    public static RedisContext$ MODULE$;

    static {
        new RedisContext$();
    }

    public void setKVs(Iterator<Tuple2<String, String>> arr, int ttl, RedisConfig redisConfig, ReadWriteConfig readWriteConfig) {
        ReadWriteConfig rwConf = readWriteConfig;
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])arr.map((Function1 & Serializable & scala.Serializable)kv -> new Tuple2((Object)redisConfig.getHost((String)kv._1()), kv)).toArray(ClassTag$.MODULE$.apply(Tuple2.class)))).groupBy((Function1 & Serializable & scala.Serializable)x$1 -> (RedisNode)x$1._1()).mapValues((Function1 & Serializable & scala.Serializable)a -> (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])a)).map((Function1 & Serializable & scala.Serializable)p -> (Tuple2)p._2(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).foreach((Function1 & Serializable & scala.Serializable)x -> {
            RedisContext$.$anonfun$setKVs$5(ttl, rwConf, x);
            return BoxedUnit.UNIT;
        });
    }

    public void setHash(String hashName, Iterator<Tuple2<String, String>> arr, int ttl, RedisConfig redisConfig, ReadWriteConfig readWriteConfig) {
        ReadWriteConfig rwConf = readWriteConfig;
        Jedis conn = redisConfig.connectionForKey(hashName);
        Pipeline pipeline = PipelineUtils$.MODULE$.foreachWithPipelineNoLastSync(conn, arr, (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            RedisContext$.$anonfun$setHash$1(hashName, x0$1, x1$1);
            return BoxedUnit.UNIT;
        }, rwConf);
        Object object = ttl > 0 ? pipeline.expire(hashName, ttl) : BoxedUnit.UNIT;
        pipeline.sync();
        conn.close();
    }

    public void setZset(String zsetName, Iterator<Tuple2<String, String>> arr, int ttl, RedisConfig redisConfig, ReadWriteConfig readWriteConfig) {
        ReadWriteConfig rwConf = readWriteConfig;
        Jedis conn = redisConfig.connectionForKey(zsetName);
        Pipeline pipeline = PipelineUtils$.MODULE$.foreachWithPipelineNoLastSync(conn, arr, (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            RedisContext$.$anonfun$setZset$1(zsetName, x0$1, x1$1);
            return BoxedUnit.UNIT;
        }, rwConf);
        Object object = ttl > 0 ? pipeline.expire(zsetName, ttl) : BoxedUnit.UNIT;
        pipeline.sync();
        conn.close();
    }

    public void setSet(String setName, Iterator<String> arr, int ttl, RedisConfig redisConfig, ReadWriteConfig readWriteConfig) {
        ReadWriteConfig rwConf = readWriteConfig;
        Jedis conn = redisConfig.connectionForKey(setName);
        Pipeline pipeline2 = PipelineUtils$.MODULE$.foreachWithPipelineNoLastSync(conn, arr, (Function2 & Serializable & scala.Serializable)(pipeline, v) -> {
            pipeline.sadd(setName, new String[]{v});
            return BoxedUnit.UNIT;
        }, rwConf);
        Object object = ttl > 0 ? pipeline2.expire(setName, ttl) : BoxedUnit.UNIT;
        pipeline2.sync();
        conn.close();
    }

    public void setList(String listName, Iterator<String> arr, int ttl, RedisConfig redisConfig, ReadWriteConfig readWriteConfig) {
        ReadWriteConfig rwConf = readWriteConfig;
        Jedis conn = redisConfig.connectionForKey(listName);
        Pipeline pipeline2 = PipelineUtils$.MODULE$.foreachWithPipelineNoLastSync(conn, arr, (Function2 & Serializable & scala.Serializable)(pipeline, v) -> {
            pipeline.rpush(listName, new String[]{v});
            return BoxedUnit.UNIT;
        }, rwConf);
        Object object = ttl > 0 ? pipeline2.expire(listName, ttl) : BoxedUnit.UNIT;
        pipeline2.sync();
        conn.close();
    }

    public void setByteList(Iterator<Tuple2<byte[], Seq<byte[]>>> keyValues, int ttl, RedisConfig redisConfig, ReadWriteConfig readWriteConfig) {
        ReadWriteConfig rwConf = readWriteConfig;
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])keyValues.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            byte[] key = (byte[])tuple2._1();
            Seq listValues = (Seq)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)redisConfig.getHost(key), (Object)new Tuple2((Object)key, (Object)listValues));
            return tuple22;
        }).toArray(ClassTag$.MODULE$.apply(Tuple2.class)))).groupBy((Function1 & Serializable & scala.Serializable)x$2 -> (RedisNode)x$2._1()).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            RedisContext$.$anonfun$setByteList$3(ttl, rwConf, x0$2);
            return BoxedUnit.UNIT;
        });
    }

    public void setList(Iterator<Tuple2<String, Seq<String>>> keyValues, int ttl, RedisConfig redisConfig, ReadWriteConfig readWriteConfig) {
        ReadWriteConfig rwConf = readWriteConfig;
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])keyValues.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String key = (String)tuple2._1();
            Seq listValues = (Seq)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)redisConfig.getHost(key), (Object)new Tuple2((Object)key, (Object)listValues));
            return tuple22;
        }).toArray(ClassTag$.MODULE$.apply(Tuple2.class)))).groupBy((Function1 & Serializable & scala.Serializable)x$4 -> (RedisNode)x$4._1()).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            RedisContext$.$anonfun$setList$4(ttl, rwConf, x0$2);
            return BoxedUnit.UNIT;
        });
    }

    public void setFixedList(String key, int listSize, Iterator<String> arr, RedisConfig redisConfig, ReadWriteConfig readWriteConfig) {
        ReadWriteConfig rwConf = readWriteConfig;
        Jedis conn = redisConfig.connectionForKey(key);
        Pipeline pipeline2 = PipelineUtils$.MODULE$.foreachWithPipelineNoLastSync(conn, arr, (Function2 & Serializable & scala.Serializable)(pipeline, v) -> {
            pipeline.lpush(key, new String[]{v});
            return BoxedUnit.UNIT;
        }, rwConf);
        Object object = listSize > 0 ? pipeline2.ltrim(key, 0L, (long)(listSize - 1)) : BoxedUnit.UNIT;
        pipeline2.sync();
        conn.close();
    }

    private Object readResolve() {
        return MODULE$;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ void $anonfun$setKVs$6(int ttl$8, Pipeline x0$1, Tuple2 x1$1) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = new Tuple2((Object)x0$1, (Object)x1$1);
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        Pipeline pipeline = (Pipeline)tuple2._1();
        Tuple2 tuple22 = (Tuple2)tuple2._2();
        if (tuple22 == null) throw new MatchError((Object)tuple2);
        String k = (String)tuple22._1();
        String v = (String)tuple22._2();
        if (ttl$8 <= 0) {
            pipeline.set(k, v);
            boxedUnit = BoxedUnit.UNIT;
        } else {
            pipeline.setex(k, ttl$8, v);
            boxedUnit = BoxedUnit.UNIT;
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    public static final /* synthetic */ void $anonfun$setKVs$5(int ttl$8, ReadWriteConfig rwConf$1, Tuple2 x) {
        Jedis conn = ((RedisNode)x._1()).endpoint().connect();
        PipelineUtils$.MODULE$.foreachWithPipeline(conn, new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x._2())), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            RedisContext$.$anonfun$setKVs$6(ttl$8, x0$1, x1$1);
            return BoxedUnit.UNIT;
        }, rwConf$1);
        conn.close();
    }

    public static final /* synthetic */ void $anonfun$setHash$1(String hashName$2, Pipeline x0$1, Tuple2 x1$1) {
        Tuple2 tuple2;
        Pipeline pipeline;
        block3: {
            Tuple2 tuple22;
            block2: {
                tuple22 = new Tuple2((Object)x0$1, (Object)x1$1);
                if (tuple22 == null) break block2;
                pipeline = (Pipeline)tuple22._1();
                tuple2 = (Tuple2)tuple22._2();
                if (tuple2 != null) break block3;
            }
            throw new MatchError((Object)tuple22);
        }
        String k = (String)tuple2._1();
        String v = (String)tuple2._2();
        pipeline.hset(hashName$2, k, v);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$setZset$1(String zsetName$2, Pipeline x0$1, Tuple2 x1$1) {
        Tuple2 tuple2;
        Pipeline pipeline;
        block3: {
            Tuple2 tuple22;
            block2: {
                tuple22 = new Tuple2((Object)x0$1, (Object)x1$1);
                if (tuple22 == null) break block2;
                pipeline = (Pipeline)tuple22._1();
                tuple2 = (Tuple2)tuple22._2();
                if (tuple2 != null) break block3;
            }
            throw new MatchError((Object)tuple22);
        }
        String k = (String)tuple2._1();
        String v = (String)tuple2._2();
        pipeline.zadd(zsetName$2, new StringOps(Predef$.MODULE$.augmentString(v)).toDouble(), k);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$setByteList$5(int ttl$9, Pipeline pipeline, Tuple2 a) {
        block1: {
            Tuple2 tuple2 = (Tuple2)a._2();
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            byte[] key = (byte[])tuple2._1();
            Seq listVals = (Seq)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)key, (Object)listVals);
            Tuple2 tuple23 = tuple22;
            byte[] key2 = (byte[])tuple23._1();
            Seq listVals2 = (Seq)tuple23._2();
            pipeline.rpush(key2, (byte[][])listVals2.toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE))));
            if (ttl$9 <= 0) break block1;
            pipeline.expire(key2, ttl$9);
        }
    }

    public static final /* synthetic */ void $anonfun$setByteList$3(int ttl$9, ReadWriteConfig rwConf$2, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        RedisNode node = (RedisNode)tuple2._1();
        Tuple2[] arr = (Tuple2[])tuple2._2();
        BoxedUnit boxedUnit = (BoxedUnit)ConnectionUtils$.MODULE$.withConnection(node.endpoint().connect(), (Function1 & Serializable & scala.Serializable)conn -> {
            PipelineUtils$.MODULE$.foreachWithPipeline(conn, new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])arr)), (Function2 & Serializable & scala.Serializable)(pipeline, a) -> {
                RedisContext$.$anonfun$setByteList$5(ttl$9, pipeline, a);
                return BoxedUnit.UNIT;
            }, rwConf$2);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$setList$6(int ttl$10, Pipeline pipeline, Tuple2 a) {
        block1: {
            Tuple2 tuple2 = (Tuple2)a._2();
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String key = (String)tuple2._1();
            Seq listVals = (Seq)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)key, (Object)listVals);
            Tuple2 tuple23 = tuple22;
            String key2 = (String)tuple23._1();
            Seq listVals2 = (Seq)tuple23._2();
            pipeline.rpush(key2, (String[])listVals2.toArray(ClassTag$.MODULE$.apply(String.class)));
            if (ttl$10 <= 0) break block1;
            pipeline.expire(key2, ttl$10);
        }
    }

    public static final /* synthetic */ void $anonfun$setList$4(int ttl$10, ReadWriteConfig rwConf$3, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        RedisNode node = (RedisNode)tuple2._1();
        Tuple2[] arr = (Tuple2[])tuple2._2();
        BoxedUnit boxedUnit = (BoxedUnit)ConnectionUtils$.MODULE$.withConnection(node.endpoint().connect(), (Function1 & Serializable & scala.Serializable)conn -> {
            PipelineUtils$.MODULE$.foreachWithPipeline(conn, new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])arr)), (Function2 & Serializable & scala.Serializable)(pipeline, a) -> {
                RedisContext$.$anonfun$setList$6(ttl$10, pipeline, a);
                return BoxedUnit.UNIT;
            }, rwConf$3);
            return BoxedUnit.UNIT;
        });
    }

    private RedisContext$() {
        MODULE$ = this;
    }
}

