/*
 * Decompiled with CFR 0.152.
 */
package com.redislabs.provider.redis.rdd;

import com.redislabs.provider.redis.ReadWriteConfig;
import com.redislabs.provider.redis.RedisNode;
import com.redislabs.provider.redis.partitioner.RedisPartition;
import com.redislabs.provider.redis.rdd.Keys;
import com.redislabs.provider.redis.rdd.ZSetContext;
import java.io.Serializable;
import org.apache.spark.Partition;
import org.apache.spark.TaskContext;
import org.apache.spark.rdd.RDD;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.Tuple;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConversions$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.package$;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005]b\u0001\u0002\u0007\u000e\u0001aA\u0001b\u000e\u0001\u0003\u0002\u0003\u0006I\u0001\u000f\u0005\t\t\u0002\u0011\t\u0011)A\u0005\u000b\"A\u0001\n\u0001B\u0001B\u0003%\u0011\n\u0003\u0005M\u0001\t\u0015\r\u0011b\u0001N\u0011!\u0011\u0006A!A!\u0002\u0013q\u0005\u0002C*\u0001\u0005\u0007\u0005\u000b1\u0002+\t\u000bi\u0003A\u0011A.\t\u000b\r\u0004A\u0011\t3\t\u000b1\u0004A\u0011I7\t\u000by\u0004A\u0011B@\t\u000f\u0005\u0005\u0002\u0001\"\u0003\u0002$\ta!+\u001a3jgj\u001bV\r\u001e*E\t*\u0011abD\u0001\u0004e\u0012$'B\u0001\t\u0012\u0003\u0015\u0011X\rZ5t\u0015\t\u00112#\u0001\u0005qe>4\u0018\u000eZ3s\u0015\t!R#A\u0005sK\u0012L7\u000f\\1cg*\ta#A\u0002d_6\u001c\u0001!\u0006\u0002\u001aOM\u0019\u0001AG\u001a\u0011\u0007m\u0019S%D\u0001\u001d\u0015\tqQD\u0003\u0002\u001f?\u0005)1\u000f]1sW*\u0011\u0001%I\u0001\u0007CB\f7\r[3\u000b\u0003\t\n1a\u001c:h\u0013\t!CDA\u0002S\t\u0012\u0003\"AJ\u0014\r\u0001\u0011)\u0001\u0006\u0001b\u0001S\t\tA+\u0005\u0002+aA\u00111FL\u0007\u0002Y)\tQ&A\u0003tG\u0006d\u0017-\u0003\u00020Y\t9aj\u001c;iS:<\u0007CA\u00162\u0013\t\u0011DFA\u0002B]f\u0004\"\u0001N\u001b\u000e\u00035I!AN\u0007\u0003\t-+\u0017p]\u0001\u0005aJ,g\u000fE\u0002\u001cGe\u0002\"AO!\u000f\u0005mz\u0004C\u0001\u001f-\u001b\u0005i$B\u0001 \u0018\u0003\u0019a$o\\8u}%\u0011\u0001\tL\u0001\u0007!J,G-\u001a4\n\u0005\t\u001b%AB*ue&twM\u0003\u0002AY\u0005Y!p]3u\u0007>tG/\u001a=u!\t!d)\u0003\u0002H\u001b\tY!lU3u\u0007>tG/\u001a=u\u0003\u001d\u0011H\r\u001a+za\u0016\u00042A\u000f&&\u0013\tY5IA\u0003DY\u0006\u001c8/A\bsK\u0006$wK]5uK\u000e{gNZ5h+\u0005q\u0005CA(Q\u001b\u0005y\u0011BA)\u0010\u0005=\u0011V-\u00193Xe&$XmQ8oM&<\u0017\u0001\u0005:fC\u0012<&/\u001b;f\u0007>tg-[4!\u0003))g/\u001b3f]\u000e,G%\r\t\u0004+b+S\"\u0001,\u000b\u0005]c\u0013a\u0002:fM2,7\r^\u0005\u00033Z\u0013\u0001b\u00117bgN$\u0016mZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000bq{\u0006-\u00192\u0015\u0005us\u0006c\u0001\u001b\u0001K!)1k\u0002a\u0002)\")qg\u0002a\u0001q!)Ai\u0002a\u0001\u000b\")\u0001j\u0002a\u0001\u0013\")Aj\u0002a\u0002\u001d\u0006iq-\u001a;QCJ$\u0018\u000e^5p]N,\u0012!\u001a\t\u0004W\u0019D\u0017BA4-\u0005\u0015\t%O]1z!\tI'.D\u0001\u001e\u0013\tYWDA\u0005QCJ$\u0018\u000e^5p]\u000691m\\7qkR,Gc\u00018xsB\u0019q\u000e^\u0013\u000f\u0005A\u0014hB\u0001\u001fr\u0013\u0005i\u0013BA:-\u0003\u001d\u0001\u0018mY6bO\u0016L!!\u001e<\u0003\u0011%#XM]1u_JT!a\u001d\u0017\t\u000baL\u0001\u0019\u00015\u0002\u000bM\u0004H.\u001b;\t\u000biL\u0001\u0019A>\u0002\u000f\r|g\u000e^3yiB\u0011\u0011\u000e`\u0005\u0003{v\u00111\u0002V1tW\u000e{g\u000e^3yi\u0006qq-\u001a;['\u0016$()\u001f*b]\u001e,G#\u00038\u0002\u0002\u00055\u00111CA\u000f\u0011\u001d\t\u0019A\u0003a\u0001\u0003\u000b\tQA\\8eKN\u0004Ba\u000b4\u0002\bA\u0019q*!\u0003\n\u0007\u0005-qBA\u0005SK\u0012L7OT8eK\"9\u0011q\u0002\u0006A\u0002\u0005E\u0011\u0001B6fsN\u00042a\u001c;:\u0011\u001d\t)B\u0003a\u0001\u0003/\t\u0001b\u001d;beR\u0004vn\u001d\t\u0004W\u0005e\u0011bAA\u000eY\t!Aj\u001c8h\u0011\u001d\tyB\u0003a\u0001\u0003/\ta!\u001a8e!>\u001c\u0018AD4fij\u001bV\r\u001e\"z'\u000e|'/\u001a\u000b\n]\u0006\u0015\u0012qEA\u0015\u0003gAq!a\u0001\f\u0001\u0004\t)\u0001C\u0004\u0002\u0010-\u0001\r!!\u0005\t\u000f\u0005-2\u00021\u0001\u0002.\u0005Q1\u000f^1siN\u001bwN]3\u0011\u0007-\ny#C\u0002\u000221\u0012a\u0001R8vE2,\u0007bBA\u001b\u0017\u0001\u0007\u0011QF\u0001\tK:$7kY8sK\u0002")
public class RedisZSetRDD<T>
extends RDD<T>
implements Keys {
    private final RDD<String> prev;
    private final ZSetContext zsetContext;
    private final ReadWriteConfig readWriteConfig;
    private final ClassTag<T> evidence$1;

    @Override
    public boolean isRedisRegex(String key) {
        return Keys.isRedisRegex$(this, key);
    }

    @Override
    public Iterator<String> getKeys(RedisNode[] nodes, int sPos, int ePos, String keyPattern, ReadWriteConfig readWriteConfig) {
        return Keys.getKeys$(this, nodes, sPos, ePos, keyPattern, readWriteConfig);
    }

    @Override
    public RedisNode getMasterNode(RedisNode[] nodes, String key) {
        return Keys.getMasterNode$(this, nodes, key);
    }

    @Override
    public Iterator<Tuple2<RedisNode, String[]>> groupKeysByNode(RedisNode[] nodes, Iterator<String> keys) {
        return Keys.groupKeysByNode$(this, nodes, keys);
    }

    @Override
    public String[] filterKeysByType(Jedis conn, String[] keys, String t, ReadWriteConfig readWriteConfig) {
        return Keys.filterKeysByType$(this, conn, keys, t, readWriteConfig);
    }

    public ReadWriteConfig readWriteConfig() {
        return this.readWriteConfig;
    }

    public Partition[] getPartitions() {
        return this.prev.partitions();
    }

    public Iterator<T> compute(Partition split, TaskContext context) {
        Iterator<T> iterator;
        RedisPartition partition = (RedisPartition)split;
        int sPos = partition.slots()._1$mcI$sp();
        int ePos = partition.slots()._2$mcI$sp();
        RedisNode[] nodes = partition.redisConfig().getNodesBySlots(sPos, ePos);
        Iterator keys = this.firstParent(ClassTag$.MODULE$.apply(String.class)).iterator(split, context);
        String auth = partition.redisConfig().getAuth();
        int db = partition.redisConfig().getDB();
        String string = this.zsetContext.typ();
        if ("byRange".equals(string)) {
            iterator = this.getZSetByRange(nodes, (Iterator<String>)keys, this.zsetContext.startPos(), this.zsetContext.endPos());
        } else if ("byScore".equals(string)) {
            iterator = this.getZSetByScore(nodes, (Iterator<String>)keys, this.zsetContext.min(), this.zsetContext.max());
        } else {
            throw new MatchError((Object)string);
        }
        return iterator;
    }

    private Iterator<T> getZSetByRange(RedisNode[] nodes, Iterator<String> keys, long startPos, long endPos) {
        return this.groupKeysByNode(nodes, keys).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Iterator iterator;
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            RedisNode node = (RedisNode)tuple2._1();
            String[] nodeKeys = (String[])tuple2._2();
            Jedis conn = node.endpoint().connect();
            String[] zsetKeys = this.filterKeysByType(conn, nodeKeys, "zset", this.readWriteConfig());
            ClassTag classTag = package$.MODULE$.classTag($this.evidence$1);
            ClassTag classTag2 = package$.MODULE$.classTag(ClassTag$.MODULE$.apply(Tuple2.class));
            if (!(classTag != null ? !classTag.equals(classTag2) : classTag2 != null)) {
                iterator = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])zsetKeys)).flatMap((Function1 & Serializable & scala.Serializable)k -> JavaConversions$.MODULE$.deprecated$u0020asScalaSet(conn.zrangeWithScores(k, startPos, endPos)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple.class))))).map((Function1 & Serializable & scala.Serializable)tup -> new Tuple2((Object)tup.getElement(), (Object)BoxesRunTime.boxToDouble((double)tup.getScore())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).iterator();
            } else {
                ClassTag classTag3 = package$.MODULE$.classTag($this.evidence$1);
                ClassTag classTag4 = package$.MODULE$.classTag(ClassTag$.MODULE$.apply(String.class));
                if (classTag3 == null) {
                    if (classTag4 != null) {
                        throw new Exception("Unknown RedisZSetRDD type");
                    }
                } else if (!classTag3.equals(classTag4)) throw new Exception("Unknown RedisZSetRDD type");
                iterator = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])zsetKeys)).flatMap((Function1 & Serializable & scala.Serializable)k -> JavaConversions$.MODULE$.deprecated$u0020asScalaSet(conn.zrange(k, startPos, endPos)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).iterator();
            }
            Iterator res = iterator;
            conn.close();
            return res;
        });
    }

    private Iterator<T> getZSetByScore(RedisNode[] nodes, Iterator<String> keys, double startScore, double endScore) {
        return this.groupKeysByNode(nodes, keys).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Iterator iterator;
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            RedisNode node = (RedisNode)tuple2._1();
            String[] nodeKeys = (String[])tuple2._2();
            Jedis conn = node.endpoint().connect();
            String[] zsetKeys = this.filterKeysByType(conn, nodeKeys, "zset", this.readWriteConfig());
            ClassTag classTag = package$.MODULE$.classTag($this.evidence$1);
            ClassTag classTag2 = package$.MODULE$.classTag(ClassTag$.MODULE$.apply(Tuple2.class));
            if (!(classTag != null ? !classTag.equals(classTag2) : classTag2 != null)) {
                iterator = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])zsetKeys)).flatMap((Function1 & Serializable & scala.Serializable)k -> JavaConversions$.MODULE$.deprecated$u0020asScalaSet(conn.zrangeByScoreWithScores(k, startScore, endScore)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple.class))))).map((Function1 & Serializable & scala.Serializable)tup -> new Tuple2((Object)tup.getElement(), (Object)BoxesRunTime.boxToDouble((double)tup.getScore())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).iterator();
            } else {
                ClassTag classTag3 = package$.MODULE$.classTag($this.evidence$1);
                ClassTag classTag4 = package$.MODULE$.classTag(ClassTag$.MODULE$.apply(String.class));
                if (classTag3 == null) {
                    if (classTag4 != null) {
                        throw new Exception("Unknown RedisZSetRDD type");
                    }
                } else if (!classTag3.equals(classTag4)) throw new Exception("Unknown RedisZSetRDD type");
                iterator = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])zsetKeys)).flatMap((Function1 & Serializable & scala.Serializable)k -> JavaConversions$.MODULE$.deprecated$u0020asScalaSet(conn.zrangeByScore(k, startScore, endScore)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).iterator();
            }
            Iterator res = iterator;
            conn.close();
            return res;
        });
    }

    public RedisZSetRDD(RDD<String> prev, ZSetContext zsetContext, Class<T> rddType, ReadWriteConfig readWriteConfig, ClassTag<T> evidence$1) {
        this.prev = prev;
        this.zsetContext = zsetContext;
        this.readWriteConfig = readWriteConfig;
        this.evidence$1 = evidence$1;
        super(prev, evidence$1);
        Keys.$init$(this);
    }
}

