/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.redis;

import com.redislabs.provider.redis.ReadWriteConfig;
import com.redislabs.provider.redis.ReadWriteConfig$;
import com.redislabs.provider.redis.RedisConfig;
import com.redislabs.provider.redis.RedisContext;
import com.redislabs.provider.redis.RedisEndpoint;
import com.redislabs.provider.redis.RedisNode;
import com.redislabs.provider.redis.rdd.Keys;
import com.redislabs.provider.redis.rdd.Keys$;
import com.redislabs.provider.redis.rdd.RedisKeysRDD;
import com.redislabs.provider.redis.util.ConnectionUtils$;
import com.redislabs.provider.redis.util.Logging;
import com.redislabs.provider.redis.util.PipelineUtils$;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.catalyst.expressions.GenericRow;
import org.apache.spark.sql.redis.RedisPersistence;
import org.apache.spark.sql.redis.RedisPersistence$;
import org.apache.spark.sql.redis.RedisSourceRelation$;
import org.apache.spark.sql.redis.package$;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.sources.InsertableRelation;
import org.apache.spark.sql.sources.PrunedFilteredScan;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.Pipeline;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.Iterator;
import scala.collection.JavaConversions$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.MapLike;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\tUg\u0001B A\u0001-C\u0001\"\u001d\u0001\u0003\u0006\u0004%\tE\u001d\u0005\to\u0002\u0011\t\u0011)A\u0005g\"A\u0001\u0010\u0001B\u0001B\u0003%\u0011\u0010\u0003\u0006\u0002\u0010\u0001\u0011\t\u0011)A\u0005\u0003#Aq!a\t\u0001\t\u0003\t)\u0003C\u0005\u00022\u0001\u0011\r\u0011b\u0003\u00024!A\u0011Q\b\u0001!\u0002\u0013\t)\u0004C\u0005\u0002@\u0001\u0011\r\u0011b\u0003\u0002B!A\u0011\u0011\n\u0001!\u0002\u0013\t\u0019\u0005C\u0005\u0002L\u0001\u0011\r\u0011\"\u0003\u0002N!A\u0011q\u000b\u0001!\u0002\u0013\ty\u0005C\u0006\u0002b\u0001\u0001\r\u00111A\u0005\n\u0005\r\u0004bCA3\u0001\u0001\u0007\t\u0019!C\u0005\u0003OB1\"a\u001d\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002\u0018!I\u0011Q\u0010\u0001C\u0002\u0013%\u0011q\u0010\u0005\t\u0003\u000f\u0003\u0001\u0015!\u0003\u0002\u0002\"I\u0011\u0011\u0012\u0001C\u0002\u0013%\u0011q\u0010\u0005\t\u0003\u0017\u0003\u0001\u0015!\u0003\u0002\u0002\"I\u0011Q\u0012\u0001C\u0002\u0013%\u0011q\u0012\u0005\t\u0003/\u0003\u0001\u0015!\u0003\u0002\u0012\"I\u0011\u0011\u0014\u0001C\u0002\u0013%\u00111\u0014\u0005\t\u0003?\u0003\u0001\u0015!\u0003\u0002\u001e\"I\u0011\u0011\u0015\u0001C\u0002\u0013%\u00111\u0015\u0005\t\u0003K\u0003\u0001\u0015!\u0003\u0002\n!I\u0011q\u0015\u0001C\u0002\u0013%\u00111\u0014\u0005\t\u0003S\u0003\u0001\u0015!\u0003\u0002\u001e\"I\u00111\u0016\u0001C\u0002\u0013%\u0011q\u0012\u0005\t\u0003[\u0003\u0001\u0015!\u0003\u0002\u0012\"I\u0011q\u0016\u0001C\u0002\u0013%\u00111\u0015\u0005\t\u0003c\u0003\u0001\u0015!\u0003\u0002\n!I\u00111\u0017\u0001C\u0002\u0013%\u0011Q\u0017\u0005\t\u0003\u0007\u0004\u0001\u0015!\u0003\u00028\"I\u0011Q\u0019\u0001C\u0002\u0013%\u00111\u0014\u0005\t\u0003\u000f\u0004\u0001\u0015!\u0003\u0002\u001e\"I\u0011\u0011\u001a\u0001C\u0002\u0013%\u0011q\u0012\u0005\t\u0003\u0017\u0004\u0001\u0015!\u0003\u0002\u0012\"I\u0011Q\u001a\u0001C\u0002\u0013%\u00111\u0015\u0005\t\u0003\u001f\u0004\u0001\u0015!\u0003\u0002\n!I\u0011\u0011\u001b\u0001C\u0002\u0013%\u00111\u0015\u0005\t\u0003'\u0004\u0001\u0015!\u0003\u0002\n!9\u0011Q\u001b\u0001\u0005B\u0005\r\u0004bBAl\u0001\u0011\u0005\u0013\u0011\u001c\u0005\b\u0005\u0003\u0001A\u0011\tB\u0002\u0011\u001d\u0011Y\u0003\u0001C!\u0005[AqA!\r\u0001\t\u0003\ty\bC\u0004\u00034\u0001!\t!a \t\u000f\tU\u0002\u0001\"\u0003\u00038!9!\u0011\b\u0001\u0005\n\tm\u0002b\u0002B!\u0001\u0011%!1\t\u0005\b\u0005\u000b\u0002A\u0011\u0002B$\u0011\u001d\u0011Y\u0005\u0001C\u0005\u0005\u0007BqA!\u0014\u0001\t\u0013\u0011yeB\u0004\u0003z\u0001C\tAa\u001f\u0007\r}\u0002\u0005\u0012\u0001B?\u0011\u001d\t\u0019C\u000eC\u0001\u0005\u000bCqAa\"7\t\u0003\u0011I\tC\u0004\u0003\u000eZ\"\tAa$\t\u0013\t]e'%A\u0005\u0002\te\u0005b\u0002BXm\u0011\u0005!q\u0007\u0005\b\u0005c3D\u0011\u0001BZ\u0011\u001d\u00119L\u000eC\u0001\u0005sC\u0011B!17\u0003\u0003%IAa1\u0003'I+G-[:T_V\u00148-\u001a*fY\u0006$\u0018n\u001c8\u000b\u0005\u0005\u0013\u0015!\u0002:fI&\u001c(BA\"E\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u000b\u001a\u000bQa\u001d9be.T!a\u0012%\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005I\u0015aA8sO\u000e\u00011c\u0002\u0001M%VCVm\u001b\t\u0003\u001bBk\u0011A\u0014\u0006\u0003\u001f\n\u000bqa]8ve\u000e,7/\u0003\u0002R\u001d\na!)Y:f%\u0016d\u0017\r^5p]B\u0011QjU\u0005\u0003):\u0013!#\u00138tKJ$\u0018M\u00197f%\u0016d\u0017\r^5p]B\u0011QJV\u0005\u0003/:\u0013!\u0003\u0015:v]\u0016$g)\u001b7uKJ,GmU2b]B\u0011\u0011lY\u0007\u00025*\u00111\fX\u0001\u0004e\u0012$'BA!^\u0015\tqv,\u0001\u0005qe>4\u0018\u000eZ3s\u0015\t\u0001\u0017-A\u0005sK\u0012L7\u000f\\1cg*\t!-A\u0002d_6L!\u0001\u001a.\u0003\t-+\u0017p\u001d\t\u0003M&l\u0011a\u001a\u0006\u0002Q\u0006)1oY1mC&\u0011!n\u001a\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\t\u0003Y>l\u0011!\u001c\u0006\u0003]r\u000bA!\u001e;jY&\u0011\u0001/\u001c\u0002\b\u0019><w-\u001b8h\u0003)\u0019\u0018\u000f\\\"p]R,\u0007\u0010^\u000b\u0002gB\u0011A/^\u0007\u0002\u0005&\u0011aO\u0011\u0002\u000b'Fc5i\u001c8uKb$\u0018aC:rY\u000e{g\u000e^3yi\u0002\n!\u0002]1sC6,G/\u001a:t!\u001dQ\u00181AA\u0005\u0003\u0013q!a_@\u0011\u0005q<W\"A?\u000b\u0005yT\u0015A\u0002\u001fs_>$h(C\u0002\u0002\u0002\u001d\fa\u0001\u0015:fI\u00164\u0017\u0002BA\u0003\u0003\u000f\u00111!T1q\u0015\r\t\ta\u001a\t\u0004u\u0006-\u0011\u0002BA\u0007\u0003\u000f\u0011aa\u0015;sS:<\u0017aE;tKJ\u001c\u0006/Z2jM&,GmU2iK6\f\u0007#\u00024\u0002\u0014\u0005]\u0011bAA\u000bO\n1q\n\u001d;j_:\u0004B!!\u0007\u0002 5\u0011\u00111\u0004\u0006\u0004\u0003;\u0011\u0015!\u0002;za\u0016\u001c\u0018\u0002BA\u0011\u00037\u0011!b\u0015;sk\u000e$H+\u001f9f\u0003\u0019a\u0014N\\5u}QA\u0011qEA\u0016\u0003[\ty\u0003E\u0002\u0002*\u0001i\u0011\u0001\u0011\u0005\u0006c\u0016\u0001\ra\u001d\u0005\u0006q\u0016\u0001\r!\u001f\u0005\b\u0003\u001f)\u0001\u0019AA\t\u0003-\u0011X\rZ5t\u0007>tg-[4\u0016\u0005\u0005U\u0002\u0003BA\u001c\u0003si\u0011\u0001X\u0005\u0004\u0003wa&a\u0003*fI&\u001c8i\u001c8gS\u001e\fAB]3eSN\u001cuN\u001c4jO\u0002\nqB]3bI^\u0013\u0018\u000e^3D_:4\u0017nZ\u000b\u0003\u0003\u0007\u0002B!a\u000e\u0002F%\u0019\u0011q\t/\u0003\u001fI+\u0017\rZ,sSR,7i\u001c8gS\u001e\f\u0001C]3bI^\u0013\u0018\u000e^3D_:4\u0017n\u001a\u0011\u0002\u0005M\u001cWCAA(!\u0011\t\t&a\u0015\u000e\u0003\u0011K1!!\u0016E\u00051\u0019\u0006/\u0019:l\u0007>tG/\u001a=u\u0003\r\u00198\r\t\u0015\u0004\u0017\u0005m\u0003c\u00014\u0002^%\u0019\u0011qL4\u0003\u0013Q\u0014\u0018M\\:jK:$\u0018!D2veJ,g\u000e^*dQ\u0016l\u0017-\u0006\u0002\u0002\u0018\u0005\t2-\u001e:sK:$8k\u00195f[\u0006|F%Z9\u0015\t\u0005%\u0014q\u000e\t\u0004M\u0006-\u0014bAA7O\n!QK\\5u\u0011%\t\t(DA\u0001\u0002\u0004\t9\"A\u0002yIE\nabY;se\u0016tGoU2iK6\f\u0007\u0005K\u0002\u000f\u0003o\u00022AZA=\u0013\r\tYh\u001a\u0002\tm>d\u0017\r^5mK\u00069b-\u001b7uKJ\\U-_:CsRK\b/Z#oC\ndW\rZ\u000b\u0003\u0003\u0003\u00032AZAB\u0013\r\t)i\u001a\u0002\b\u0005>|G.Z1o\u0003a1\u0017\u000e\u001c;fe.+\u0017p\u001d\"z)f\u0004X-\u00128bE2,G\rI\u0001\u0013S:4WM]*dQ\u0016l\u0017-\u00128bE2,G-A\nj]\u001a,'oU2iK6\fWI\\1cY\u0016$\u0007%\u0001\u000bji\u0016\u0014\u0018\r^8s\u000fJ|W\u000f]5oONK'0Z\u000b\u0003\u0003#\u00032AZAJ\u0013\r\t)j\u001a\u0002\u0004\u0013:$\u0018!F5uKJ\fGo\u001c:He>,\b/\u001b8h'&TX\rI\u0001\nW\u0016L8i\u001c7v[:,\"!!(\u0011\u000b\u0019\f\u0019\"!\u0003\u0002\u0015-,\u0017pQ8mk6t\u0007%A\u0004lKft\u0015-\\3\u0016\u0005\u0005%\u0011\u0001C6fs:\u000bW.\u001a\u0011\u0002\u001d-,\u0017p\u001d)biR,'O\\(qi\u0006y1.Z=t!\u0006$H/\u001a:o\u001fB$\b%A\u0007ok6\u0004\u0016M\u001d;ji&|gn]\u0001\u000f]Vl\u0007+\u0019:uSRLwN\\:!\u0003A\u0001XM]:jgR,gnY3N_\u0012,G.A\tqKJ\u001c\u0018n\u001d;f]\u000e,Wj\u001c3fY\u0002\n1\u0002]3sg&\u001cH/\u001a8dKV\u0011\u0011q\u0017\t\u0007\u0003S\tI,!0\n\u0007\u0005m\u0006I\u0001\tSK\u0012L7\u000fU3sg&\u001cH/\u001a8dKB\u0019a-a0\n\u0007\u0005\u0005wMA\u0002B]f\fA\u0002]3sg&\u001cH/\u001a8dK\u0002\nA\u0002^1cY\u0016t\u0015-\\3PaR\fQ\u0002^1cY\u0016t\u0015-\\3PaR\u0004\u0013a\u0001;uY\u0006!A\u000f\u001e7!\u00039!\u0017\r^1LKf\u0004\u0016\r\u001e;fe:\fq\u0002Z1uC.+\u0017\u0010U1ui\u0016\u0014h\u000eI\u0001\u0012W\u0016L8\u000f\u0015:fM&D\b+\u0019;uKJt\u0017AE6fsN\u0004&/\u001a4jqB\u000bG\u000f^3s]\u0002\naa]2iK6\f\u0017AB5og\u0016\u0014H\u000f\u0006\u0004\u0002j\u0005m\u0017Q \u0005\b\u0003;T\u0003\u0019AAp\u0003\u0011!\u0017\r^1\u0011\t\u0005\u0005\u0018q\u001f\b\u0005\u0003G\f\u0019P\u0004\u0003\u0002f\u0006Eh\u0002BAt\u0003_tA!!;\u0002n:\u0019A0a;\n\u0003%K!a\u0012%\n\u0005\u00153\u0015BA\"E\u0013\r\t)PQ\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\tI0a?\u0003\u0013\u0011\u000bG/\u0019$sC6,'bAA{\u0005\"9\u0011q \u0016A\u0002\u0005\u0005\u0015!C8wKJ<(/\u001b;f\u0003%\u0011W/\u001b7e'\u000e\fg\u000e\u0006\u0004\u0003\u0006\tU!q\u0004\t\u0007\u0005\u000f\u0011YAa\u0004\u000e\u0005\t%!BA.E\u0013\u0011\u0011iA!\u0003\u0003\u0007I#E\tE\u0002u\u0005#I1Aa\u0005C\u0005\r\u0011vn\u001e\u0005\b\u0005/Y\u0003\u0019\u0001B\r\u0003=\u0011X-];je\u0016$7i\u001c7v[:\u001c\b#\u00024\u0003\u001c\u0005%\u0011b\u0001B\u000fO\n)\u0011I\u001d:bs\"9!\u0011E\u0016A\u0002\t\r\u0012a\u00024jYR,'o\u001d\t\u0006M\nm!Q\u0005\t\u0004\u001b\n\u001d\u0012b\u0001B\u0015\u001d\n1a)\u001b7uKJ\f\u0001#\u001e8iC:$G.\u001a3GS2$XM]:\u0015\t\t\r\"q\u0006\u0005\b\u0005Ca\u0003\u0019\u0001B\u0012\u0003\u001dI7/R7qif\f\u0001B\\8o\u000b6\u0004H/_\u0001\ni\u0006\u0014G.\u001a(b[\u0016$\"!!\u0003\u0002\u0013\u0011\fG/Y&fs&#G\u0003BA\u0005\u0005{AqAa\u00101\u0001\u0004\u0011y!A\u0002s_^\f1\"\u001b8gKJ\u001c6\r[3nCR\u0011\u0011qC\u0001\u000bg\u00064XmU2iK6\fG\u0003BA\f\u0005\u0013Bq!!63\u0001\u0004\t9\"\u0001\u0006m_\u0006$7k\u00195f[\u0006\f\u0001b]2b]J{wo\u001d\u000b\r\u0005#\u0012\tGa\u001b\u0003r\tU$q\u000f\t\u0007\u0005'\u0012YFa\u0004\u000f\t\tU#\u0011\f\b\u0004y\n]\u0013\"\u00015\n\u0007\u0005Ux-\u0003\u0003\u0003^\t}#aA*fc*\u0019\u0011Q_4\t\u000f\t\rD\u00071\u0001\u0003f\u0005!an\u001c3f!\u0011\t9Da\u001a\n\u0007\t%DLA\u0005SK\u0012L7OT8eK\"9!Q\u000e\u001bA\u0002\t=\u0014\u0001B6fsN\u0004bAa\u0015\u0003\\\u0005%\u0001b\u0002B:i\u0001\u0007\u0011\u0011B\u0001\bW\u0016LH+\u001f9f\u0011\u001d\t)\u000e\u000ea\u0001\u0003/AqAa\u00065\u0001\u0004\u0011y'A\nSK\u0012L7oU8ve\u000e,'+\u001a7bi&|g\u000eE\u0002\u0002*Y\u001aBA\u000eB@KB\u0019aM!!\n\u0007\t\ruM\u0001\u0004B]f\u0014VM\u001a\u000b\u0003\u0005w\n\u0011b]2iK6\f7*Z=\u0015\t\u0005%!1\u0012\u0005\b\u0005kA\u0004\u0019AA\u0005\u0003\u001d!\u0017\r^1LKf$b!!\u0003\u0003\u0012\nM\u0005b\u0002B\u001bs\u0001\u0007\u0011\u0011\u0002\u0005\n\u0005+K\u0004\u0013!a\u0001\u0003\u0013\t!!\u001b3\u0002#\u0011\fG/Y&fs\u0012\"WMZ1vYR$#'\u0006\u0002\u0003\u001c*\"\u0011\u0011\u0002BOW\t\u0011y\n\u0005\u0003\u0003\"\n-VB\u0001BR\u0015\u0011\u0011)Ka*\u0002\u0013Ut7\r[3dW\u0016$'b\u0001BUO\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t5&1\u0015\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017\u0001B;vS\u0012\f1\u0003^1cY\u0016$\u0015\r^1LKf\u0004\u0016\r\u001e;fe:$B!!\u0003\u00036\"9!Q\u0007\u001fA\u0002\u0005%\u0011\u0001\u0003;bE2,7*Z=\u0015\r\u0005%!1\u0018B_\u0011\u001d\t\t.\u0010a\u0001\u0003\u0013AqAa0>\u0001\u0004\tI!\u0001\u0005sK\u0012L7oS3z\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\t\u0015\u0007\u0003\u0002Bd\u0005#l!A!3\u000b\t\t-'QZ\u0001\u0005Y\u0006twM\u0003\u0002\u0003P\u0006!!.\u0019<b\u0013\u0011\u0011\u0019N!3\u0003\r=\u0013'.Z2u\u0001")
public class RedisSourceRelation
extends BaseRelation
implements InsertableRelation,
PrunedFilteredScan,
Keys,
scala.Serializable,
Logging {
    private final SQLContext sqlContext;
    private final Option<StructType> userSpecifiedSchema;
    private final RedisConfig redisConfig;
    private final ReadWriteConfig readWriteConfig;
    private final transient SparkContext sc;
    private volatile StructType currentSchema;
    private final boolean filterKeysByTypeEnabled;
    private final boolean inferSchemaEnabled;
    private final int iteratorGroupingSize;
    private final Option<String> keyColumn;
    private final String keyName;
    private final Option<String> keysPatternOpt;
    private final int numPartitions;
    private final String persistenceModel;
    private final RedisPersistence<Object> persistence;
    private final Option<String> tableNameOpt;
    private final int ttl;
    private final String dataKeyPattern;
    private final String keysPrefixPattern;
    private transient Logger com$redislabs$provider$redis$util$Logging$$_logger;

    public static String tableKey(String string, String string2) {
        return RedisSourceRelation$.MODULE$.tableKey(string, string2);
    }

    public static String tableDataKeyPattern(String string) {
        return RedisSourceRelation$.MODULE$.tableDataKeyPattern(string);
    }

    public static String uuid() {
        return RedisSourceRelation$.MODULE$.uuid();
    }

    public static String dataKey$default$2() {
        return RedisSourceRelation$.MODULE$.dataKey$default$2();
    }

    public static String dataKey(String string, String string2) {
        return RedisSourceRelation$.MODULE$.dataKey(string, string2);
    }

    public static String schemaKey(String string) {
        return RedisSourceRelation$.MODULE$.schemaKey(string);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public Logger logger() {
        return Logging.logger$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public boolean isRedisRegex(String key) {
        return Keys.isRedisRegex$(this, key);
    }

    @Override
    public Iterator<String> getKeys(RedisNode[] nodes, int sPos, int ePos, String keyPattern, ReadWriteConfig readWriteConfig) {
        return Keys.getKeys$(this, nodes, sPos, ePos, keyPattern, readWriteConfig);
    }

    @Override
    public RedisNode getMasterNode(RedisNode[] nodes, String key) {
        return Keys.getMasterNode$(this, nodes, key);
    }

    @Override
    public Iterator<Tuple2<RedisNode, String[]>> groupKeysByNode(RedisNode[] nodes, Iterator<String> keys) {
        return Keys.groupKeysByNode$(this, nodes, keys);
    }

    @Override
    public String[] filterKeysByType(Jedis conn, String[] keys, String t, ReadWriteConfig readWriteConfig) {
        return Keys.filterKeysByType$(this, conn, keys, t, readWriteConfig);
    }

    @Override
    public Logger com$redislabs$provider$redis$util$Logging$$_logger() {
        return this.com$redislabs$provider$redis$util$Logging$$_logger;
    }

    @Override
    public void com$redislabs$provider$redis$util$Logging$$_logger_$eq(Logger x$1) {
        this.com$redislabs$provider$redis$util$Logging$$_logger = x$1;
    }

    public SQLContext sqlContext() {
        return this.sqlContext;
    }

    private RedisConfig redisConfig() {
        return this.redisConfig;
    }

    private ReadWriteConfig readWriteConfig() {
        return this.readWriteConfig;
    }

    private SparkContext sc() {
        return this.sc;
    }

    private StructType currentSchema() {
        return this.currentSchema;
    }

    private void currentSchema_$eq(StructType x$1) {
        this.currentSchema = x$1;
    }

    private boolean filterKeysByTypeEnabled() {
        return this.filterKeysByTypeEnabled;
    }

    private boolean inferSchemaEnabled() {
        return this.inferSchemaEnabled;
    }

    private int iteratorGroupingSize() {
        return this.iteratorGroupingSize;
    }

    private Option<String> keyColumn() {
        return this.keyColumn;
    }

    private String keyName() {
        return this.keyName;
    }

    private Option<String> keysPatternOpt() {
        return this.keysPatternOpt;
    }

    private int numPartitions() {
        return this.numPartitions;
    }

    private String persistenceModel() {
        return this.persistenceModel;
    }

    private RedisPersistence<Object> persistence() {
        return this.persistence;
    }

    private Option<String> tableNameOpt() {
        return this.tableNameOpt;
    }

    private int ttl() {
        return this.ttl;
    }

    private String dataKeyPattern() {
        return this.dataKeyPattern;
    }

    private String keysPrefixPattern() {
        return this.keysPrefixPattern;
    }

    public StructType schema() {
        block0: {
            if (this.currentSchema() != null) break block0;
            this.currentSchema_$eq((StructType)this.userSpecifiedSchema.getOrElse((Function0 & Serializable & scala.Serializable)() -> this.inferSchemaEnabled() ? this.inferSchema() : this.loadSchema()));
        }
        return this.currentSchema();
    }

    public void insert(Dataset<Row> data, boolean overwrite) {
        StructType schema = (StructType)this.userSpecifiedSchema.getOrElse((Function0 & Serializable & scala.Serializable)() -> data.schema());
        this.currentSchema_$eq(this.saveSchema(schema));
        if (overwrite) {
            RedisContext qual$1 = com.redislabs.provider.redis.package$.MODULE$.toRedisContext(this.sc());
            String x$1 = this.dataKeyPattern();
            int x$2 = qual$1.fromRedisKeyPattern$default$2();
            qual$1.fromRedisKeyPattern(x$1, x$2, this.redisConfig(), this.readWriteConfig()).foreachPartition((Function1 & Serializable & scala.Serializable)partition -> {
                RedisSourceRelation.$anonfun$insert$2(this, partition);
                return BoxedUnit.UNIT;
            });
        }
        data.foreachPartition((Function1 & Serializable & scala.Serializable)partition -> {
            RedisSourceRelation.$anonfun$insert$5(this, partition);
            return BoxedUnit.UNIT;
        });
    }

    public RDD<Row> buildScan(String[] requiredColumns, Filter[] filters) {
        RDD rDD;
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "build scan");
        RedisKeysRDD keysRdd = com.redislabs.provider.redis.package$.MODULE$.toRedisContext(this.sc()).fromRedisKeyPattern(this.dataKeyPattern(), this.numPartitions(), this.redisConfig(), this.readWriteConfig());
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])requiredColumns)).isEmpty()) {
            rDD = keysRdd.map((Function1 & Serializable & scala.Serializable)x$12 -> new GenericRow((Object[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Any())), ClassTag$.MODULE$.apply(Row.class));
        } else {
            Map fieldsMap = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.schema().fields())).map((Function1 & Serializable & scala.Serializable)f -> new Tuple2((Object)f.name(), f), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
            StructField[] requiredFields = (StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])requiredColumns)).map((Function1 & Serializable & scala.Serializable)c -> (StructField)fieldsMap.apply(c), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class)));
            StructType requiredSchema = new StructType(requiredFields);
            String string = this.persistenceModel();
            String string2 = package$.MODULE$.SqlOptionModelBinary();
            String keyType = !(string != null ? !string.equals(string2) : string2 != null) ? com.redislabs.provider.redis.package$.MODULE$.RedisDataTypeString() : com.redislabs.provider.redis.package$.MODULE$.RedisDataTypeHash();
            rDD = keysRdd.mapPartitions((Function1 & Serializable & scala.Serializable)partition -> partition.grouped(this.iteratorGroupingSize()).flatMap((Function1 & Serializable & scala.Serializable)batch -> this.groupKeysByNode(this.redisConfig().hosts(), (Iterator<String>)batch.iterator()).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                RedisNode node = (RedisNode)tuple2._1();
                String[] keys = (String[])tuple2._2();
                Seq<Row> seq = this.scanRows(node, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])keys), keyType, requiredSchema, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])requiredColumns));
                return seq;
            })), keysRdd.mapPartitions$default$2(), ClassTag$.MODULE$.apply(Row.class));
        }
        return rDD;
    }

    public Filter[] unhandledFilters(Filter[] filters) {
        return filters;
    }

    public boolean isEmpty() {
        return com.redislabs.provider.redis.package$.MODULE$.toRedisContext(this.sc()).fromRedisKeyPattern(this.dataKeyPattern(), this.numPartitions(), this.redisConfig(), this.readWriteConfig()).isEmpty();
    }

    public boolean nonEmpty() {
        return !this.isEmpty();
    }

    private String tableName() {
        return (String)this.tableNameOpt().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalArgumentException(new StringBuilder(21).append("Option '").append(package$.MODULE$.SqlOptionTableName()).append("' is not set.").toString());
        });
    }

    private String dataKeyId(Row row) {
        String id2 = (String)this.keyColumn().map((Function1 & Serializable & scala.Serializable)id -> row.getAs(id)).map((Function1 & Serializable & scala.Serializable)x$13 -> x$13.toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> RedisSourceRelation$.MODULE$.uuid());
        return RedisSourceRelation$.MODULE$.dataKey(this.tableName(), id2);
    }

    private StructType inferSchema() {
        int x$2;
        String x$1;
        String string = this.persistenceModel();
        String string2 = package$.MODULE$.SqlOptionModelHash();
        if (string == null ? string2 != null : !string.equals(string2)) {
            throw new IllegalArgumentException(new StringBuilder(66).append("Cannot infer schema from model '").append(this.persistenceModel()).append("'. ").append("Currently, only '").append(package$.MODULE$.SqlOptionModelHash()).append("' is supported").toString());
        }
        RedisContext qual$1 = com.redislabs.provider.redis.package$.MODULE$.toRedisContext(this.sc());
        RedisKeysRDD keys = qual$1.fromRedisKeyPattern(x$1 = this.dataKeyPattern(), x$2 = qual$1.fromRedisKeyPattern$default$2(), this.redisConfig(), this.readWriteConfig());
        if (keys.isEmpty()) {
            throw new IllegalStateException("No key is available");
        }
        String firstKey = (String)keys.first();
        RedisNode node = this.getMasterNode(this.redisConfig().hosts(), firstKey);
        return (StructType)ConnectionUtils$.MODULE$.withConnection(node.connect(), (Function1 & Serializable & scala.Serializable)conn -> {
            Seq results = (Seq)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(conn.hgetAll(firstKey)).asScala()).toSeq().$colon$plus((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.keyName()), (Object)firstKey), Seq$.MODULE$.canBuildFrom());
            StructField[] fields = (StructField[])((TraversableOnce)results.map((Function1 & Serializable & scala.Serializable)kv -> new StructField((String)kv._1(), (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(StructField.class));
            return new StructType(fields);
        });
    }

    private StructType saveSchema(StructType schema) {
        String key = RedisSourceRelation$.MODULE$.schemaKey(this.tableName());
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(14).append("saving schema ").append(key).toString());
        RedisNode schemaNode = this.getMasterNode(this.redisConfig().hosts(), key);
        Jedis conn = schemaNode.connect();
        byte[] schemaBytes = SerializationUtils.serialize((Serializable)schema);
        conn.set(key.getBytes(), schemaBytes);
        conn.close();
        return schema;
    }

    private StructType loadSchema() {
        String key = RedisSourceRelation$.MODULE$.schemaKey(this.tableName());
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(15).append("loading schema ").append(key).toString());
        RedisNode schemaNode = this.getMasterNode(this.redisConfig().hosts(), key);
        Jedis conn = schemaNode.connect();
        byte[] schemaBytes = conn.get(key.getBytes());
        if (schemaBytes == null) {
            throw new IllegalStateException(new StringBuilder(157).append("Unable to read dataframe schema by key '").append(key).append("'. ").append("If dataframe was not persisted by Spark, provide a schema explicitly with .schema() ").append("or use 'infer.schema' option. ").toString());
        }
        StructType schema = (StructType)SerializationUtils.deserialize((byte[])schemaBytes);
        conn.close();
        return schema;
    }

    private Seq<Row> scanRows(RedisNode node, Seq<String> keys, String keyType, StructType schema, Seq<String> requiredColumns) {
        return (Seq)ConnectionUtils$.MODULE$.withConnection(node.connect(), (Function1 & Serializable & scala.Serializable)conn -> {
            Seq seq;
            if (this.filterKeysByTypeEnabled()) {
                Seq<Object> keyTypes = PipelineUtils$.MODULE$.mapWithPipeline((Jedis)conn, keys, (Function2 & Serializable & scala.Serializable)(pipeline, key) -> {
                    pipeline.type(key);
                    return BoxedUnit.UNIT;
                }, this.readWriteConfig());
                seq = (Seq)((TraversableLike)((TraversableLike)keys.zip(keyTypes, Seq$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)RedisSourceRelation.$anonfun$scanRows$3(keyType, x$14)))).map((Function1 & Serializable & scala.Serializable)x$15 -> (String)x$15._1(), Seq$.MODULE$.canBuildFrom());
            } else {
                seq = keys;
            }
            Seq filteredKeys = seq;
            Seq<Object> pipelineValues = PipelineUtils$.MODULE$.mapWithPipeline((Jedis)conn, filteredKeys, (Function2 & Serializable & scala.Serializable)(pipeline, key) -> {
                RedisSourceRelation.$anonfun$scanRows$5(this, requiredColumns, pipeline, key);
                return BoxedUnit.UNIT;
            }, this.readWriteConfig());
            Seq keysAndValues = (Seq)filteredKeys.zip(pipelineValues, Seq$.MODULE$.canBuildFrom());
            Seq filteredKeysAndValues = Keys$.MODULE$.isRedisRegex(this.dataKeyPattern()) ? keysAndValues : (Seq)keysAndValues.filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)RedisSourceRelation.$anonfun$scanRows$6(x0$1)));
            return (Seq)filteredKeysAndValues.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String key = (String)tuple2._1();
                Object value = tuple2._2();
                Tuple2 keyMap = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.keyName()), (Object)RedisSourceRelation$.MODULE$.tableKey(this.keysPrefixPattern(), key));
                Row row = this.persistence().decodeRow((Tuple2<String, String>)keyMap, value, schema, requiredColumns);
                return row;
            }, Seq$.MODULE$.canBuildFrom());
        });
    }

    public static final /* synthetic */ int $anonfun$redisConfig$2(String x$1) {
        return new StringOps(Predef$.MODULE$.augmentString(x$1)).toInt();
    }

    public static final /* synthetic */ int $anonfun$redisConfig$5(String x$2) {
        return new StringOps(Predef$.MODULE$.augmentString(x$2)).toInt();
    }

    public static final /* synthetic */ int $anonfun$redisConfig$7(String x$3) {
        return new StringOps(Predef$.MODULE$.augmentString(x$3)).toInt();
    }

    public static final /* synthetic */ int $anonfun$readWriteConfig$1(String x$4) {
        return new StringOps(Predef$.MODULE$.augmentString(x$4)).toInt();
    }

    public static final /* synthetic */ int $anonfun$readWriteConfig$3(String x$5) {
        return new StringOps(Predef$.MODULE$.augmentString(x$5)).toInt();
    }

    public static final /* synthetic */ boolean $anonfun$filterKeysByTypeEnabled$1(String x$6) {
        return new StringOps(Predef$.MODULE$.augmentString(x$6)).toBoolean();
    }

    public static final /* synthetic */ boolean $anonfun$inferSchemaEnabled$1(String x$7) {
        return new StringOps(Predef$.MODULE$.augmentString(x$7)).toBoolean();
    }

    public static final /* synthetic */ int $anonfun$iteratorGroupingSize$1(String x$8) {
        return new StringOps(Predef$.MODULE$.augmentString(x$8)).toInt();
    }

    public static final /* synthetic */ int $anonfun$numPartitions$1(String x$9) {
        return new StringOps(Predef$.MODULE$.augmentString(x$9)).toInt();
    }

    public static final /* synthetic */ int $anonfun$ttl$1(String x$10) {
        return new StringOps(Predef$.MODULE$.augmentString(x$10)).toInt();
    }

    public static final /* synthetic */ boolean $anonfun$keysPrefixPattern$1(char x$11) {
        return x$11 == '*';
    }

    public static final /* synthetic */ void $anonfun$insert$3(RedisSourceRelation $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        RedisNode node = (RedisNode)tuple2._1();
        String[] keys = (String[])tuple2._2();
        Jedis conn = node.connect();
        PipelineUtils$.MODULE$.foreachWithPipeline(conn, new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])keys)), (Function2 & Serializable & scala.Serializable)(pipeline, key) -> {
            pipeline.del(key);
            return BoxedUnit.UNIT;
        }, $this.readWriteConfig());
        conn.close();
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$insert$2(RedisSourceRelation $this, Iterator partition) {
        $this.groupKeysByNode($this.redisConfig().hosts(), (Iterator<String>)partition).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            RedisSourceRelation.$anonfun$insert$3($this, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$insert$9(RedisSourceRelation $this, Map rowsWithKey$1, Pipeline pipeline, String key) {
        Row row = (Row)rowsWithKey$1.apply((Object)key);
        Object encodedRow = $this.persistence().encodeRow($this.keyName(), row);
        $this.persistence().save(pipeline, key, encodedRow, $this.ttl());
    }

    public static final /* synthetic */ void $anonfun$insert$8(RedisSourceRelation $this, Map rowsWithKey$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        RedisNode node = (RedisNode)tuple2._1();
        String[] keys = (String[])tuple2._2();
        Jedis conn = node.connect();
        PipelineUtils$.MODULE$.foreachWithPipeline(conn, new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])keys)), (Function2 & Serializable & scala.Serializable)(pipeline, key) -> {
            RedisSourceRelation.$anonfun$insert$9($this, rowsWithKey$1, pipeline, key);
            return BoxedUnit.UNIT;
        }, $this.readWriteConfig());
        conn.close();
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$insert$6(RedisSourceRelation $this, Seq batch) {
        Map rowsWithKey = ((TraversableOnce)batch.map((Function1 & Serializable & scala.Serializable)row -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)$this.dataKeyId((Row)row)), row), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        $this.groupKeysByNode($this.redisConfig().hosts(), (Iterator<String>)rowsWithKey.keysIterator()).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            RedisSourceRelation.$anonfun$insert$8($this, rowsWithKey, x0$2);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$insert$5(RedisSourceRelation $this, Iterator partition) {
        partition.grouped($this.iteratorGroupingSize()).foreach((Function1 & Serializable & scala.Serializable)batch -> {
            RedisSourceRelation.$anonfun$insert$6($this, batch);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$scanRows$3(String keyType$2, Tuple2 x$14) {
        Object object = x$14._2();
        String string = keyType$2;
        return !(object != null ? !object.equals(string) : string != null);
    }

    public static final /* synthetic */ void $anonfun$scanRows$5(RedisSourceRelation $this, Seq requiredColumns$2, Pipeline pipeline, String key) {
        $this.persistence().load(pipeline, key, (Seq<String>)requiredColumns$2);
    }

    public static final /* synthetic */ boolean $anonfun$scanRows$7(Object x$16) {
        return x$16 == null;
    }

    public static final /* synthetic */ boolean $anonfun$scanRows$6(Tuple2 x0$1) {
        List list;
        Object value;
        Object object;
        Tuple2 tuple2 = x0$1;
        boolean bl = tuple2 != null && (object = tuple2._2()) == null ? false : tuple2 == null || !((value = tuple2._2()) instanceof List) || !JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(list = (List)value).forall((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)RedisSourceRelation.$anonfun$scanRows$7(x$16)));
        return bl;
    }

    public RedisSourceRelation(SQLContext sqlContext, Map<String, String> parameters, Option<StructType> userSpecifiedSchema) {
        RedisEndpoint redisEndpoint;
        this.sqlContext = sqlContext;
        this.userSpecifiedSchema = userSpecifiedSchema;
        Keys.$init$(this);
        Logging.$init$(this);
        if (((SetLike)parameters.keySet().$amp((GenSet)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"host", "port", "auth", "dbNum", "timeout"})))).isEmpty()) {
            redisEndpoint = new RedisEndpoint(sqlContext.sparkContext().getConf());
        } else {
            String host = (String)parameters.getOrElse((Object)"host", (Function0 & Serializable & scala.Serializable)() -> "localhost");
            int port = BoxesRunTime.unboxToInt((Object)parameters.get((Object)"port").map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)RedisSourceRelation.$anonfun$redisConfig$2(x$1))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 6379));
            String auth = (String)parameters.getOrElse((Object)"auth", (Function0 & Serializable & scala.Serializable)() -> null);
            int dbNum = BoxesRunTime.unboxToInt((Object)parameters.get((Object)"dbNum").map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)RedisSourceRelation.$anonfun$redisConfig$5(x$2))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
            int timeout = BoxesRunTime.unboxToInt((Object)parameters.get((Object)"timeout").map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)RedisSourceRelation.$anonfun$redisConfig$7(x$3))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 2000));
            redisEndpoint = new RedisEndpoint(host, port, auth, dbNum, timeout);
        }
        this.redisConfig = new RedisConfig(redisEndpoint);
        ReadWriteConfig global = ReadWriteConfig$.MODULE$.fromSparkConf(sqlContext.sparkContext().getConf());
        this.readWriteConfig = global.copy(BoxesRunTime.unboxToInt((Object)parameters.get((Object)package$.MODULE$.SqlOptionScanCount()).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)RedisSourceRelation.$anonfun$readWriteConfig$1(x$4))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> global.scanCount())), BoxesRunTime.unboxToInt((Object)parameters.get((Object)package$.MODULE$.SqlOptionMaxPipelineSize()).map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToInteger((int)RedisSourceRelation.$anonfun$readWriteConfig$3(x$5))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> global.maxPipelineSize())));
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("Redis config initial host: ").append(this.redisConfig().initialHost()).toString());
        this.sc = sqlContext.sparkContext();
        this.filterKeysByTypeEnabled = parameters.get((Object)package$.MODULE$.SqlOptionFilterKeysByType()).exists((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)RedisSourceRelation.$anonfun$filterKeysByTypeEnabled$1(x$6)));
        this.inferSchemaEnabled = parameters.get((Object)package$.MODULE$.SqlOptionInferSchema()).exists((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)RedisSourceRelation.$anonfun$inferSchemaEnabled$1(x$7)));
        this.iteratorGroupingSize = BoxesRunTime.unboxToInt((Object)parameters.get((Object)package$.MODULE$.SqlOptionIteratorGroupingSize()).map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToInteger((int)RedisSourceRelation.$anonfun$iteratorGroupingSize$1(x$8))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> package$.MODULE$.SqlOptionIteratorGroupingSizeDefault()));
        this.keyColumn = parameters.get((Object)package$.MODULE$.SqlOptionKeyColumn());
        this.keyName = (String)this.keyColumn().getOrElse((Function0 & Serializable & scala.Serializable)() -> "_id");
        this.keysPatternOpt = parameters.get((Object)package$.MODULE$.SqlOptionKeysPattern());
        this.numPartitions = BoxesRunTime.unboxToInt((Object)parameters.get((Object)package$.MODULE$.SqlOptionNumPartitions()).map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToInteger((int)RedisSourceRelation.$anonfun$numPartitions$1(x$9))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> package$.MODULE$.SqlOptionNumPartitionsDefault()));
        this.persistenceModel = JavaConversions$.MODULE$.deprecated$u0020mapAsJavaMap(parameters).getOrDefault(package$.MODULE$.SqlOptionModel(), package$.MODULE$.SqlOptionModelHash());
        this.persistence = RedisPersistence$.MODULE$.apply(this.persistenceModel());
        this.tableNameOpt = parameters.get((Object)package$.MODULE$.SqlOptionTableName());
        this.ttl = BoxesRunTime.unboxToInt((Object)parameters.get((Object)package$.MODULE$.SqlOptionTTL()).map((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToInteger((int)RedisSourceRelation.$anonfun$ttl$1(x$10))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
        this.dataKeyPattern = (String)this.keysPatternOpt().orElse((Function0 & Serializable & scala.Serializable)() -> this.tableNameOpt().map((Function1 & Serializable & scala.Serializable)tableName -> RedisSourceRelation$.MODULE$.tableDataKeyPattern((String)tableName))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            String msg = new StringBuilder(31).append("Neither '").append(package$.MODULE$.SqlOptionKeysPattern()).append("' or '").append(package$.MODULE$.SqlOptionTableName()).append("' option is set.").toString();
            throw new IllegalArgumentException(msg);
        });
        String string = this.keysPrefixPattern = this.dataKeyPattern().endsWith("*") && new StringOps(Predef$.MODULE$.augmentString(this.dataKeyPattern())).count((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)RedisSourceRelation.$anonfun$keysPrefixPattern$1(BoxesRunTime.unboxToChar((Object)x$11)))) == 1 ? this.dataKeyPattern() : "";
        if (this.tableNameOpt().isDefined() && this.keysPatternOpt().isDefined()) {
            throw new IllegalArgumentException(new StringBuilder(63).append("Both options '").append(package$.MODULE$.SqlOptionTableName()).append("' and '").append(package$.MODULE$.SqlOptionTableName()).append("' are set. ").append("You should only use either one.").toString());
        }
    }
}

