/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.redis;

import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.expressions.GenericRowWithSchema;
import org.apache.spark.sql.redis.RedisPersistence;
import org.apache.spark.sql.types.StructType;
import redis.clients.jedis.Pipeline;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001M4A!\u0001\u0002\u0001\u001b\t1\")\u001b8bef\u0014V\rZ5t!\u0016\u00148/[:uK:\u001cWM\u0003\u0002\u0004\t\u0005)!/\u001a3jg*\u0011QAB\u0001\u0004gFd'BA\u0004\t\u0003\u0015\u0019\b/\u0019:l\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M\u0019\u0001A\u0004\u000b\u0011\u0005=\u0011R\"\u0001\t\u000b\u0003E\tQa]2bY\u0006L!a\u0005\t\u0003\r\u0005s\u0017PU3g!\r)b\u0003G\u0007\u0002\u0005%\u0011qC\u0001\u0002\u0011%\u0016$\u0017n\u001d)feNL7\u000f^3oG\u0016\u00042aD\r\u001c\u0013\tQ\u0002CA\u0003BeJ\f\u0017\u0010\u0005\u0002\u00109%\u0011Q\u0004\u0005\u0002\u0005\u0005f$X\rC\u0003 \u0001\u0011\u0005\u0001%\u0001\u0004=S:LGO\u0010\u000b\u0002CA\u0011Q\u0003\u0001\u0005\u0006G\u0001!\t\u0005J\u0001\u0005g\u00064X\rF\u0003&QM\u0002%\t\u0005\u0002\u0010M%\u0011q\u0005\u0005\u0002\u0005+:LG\u000fC\u0003*E\u0001\u0007!&\u0001\u0005qSB,G.\u001b8f!\tY\u0013'D\u0001-\u0015\tic&A\u0003kK\u0012L7O\u0003\u00020a\u000591\r\\5f]R\u001c(\"A\u0002\n\u0005Ib#\u0001\u0003)ja\u0016d\u0017N\\3\t\u000bQ\u0012\u0003\u0019A\u001b\u0002\u0007-,\u0017\u0010\u0005\u00027{9\u0011qg\u000f\t\u0003qAi\u0011!\u000f\u0006\u0003u1\ta\u0001\u0010:p_Rt\u0014B\u0001\u001f\u0011\u0003\u0019\u0001&/\u001a3fM&\u0011ah\u0010\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005q\u0002\u0002\"B!#\u0001\u0004A\u0012!\u0002<bYV,\u0007\"B\"#\u0001\u0004!\u0015a\u0001;uYB\u0011q\"R\u0005\u0003\rB\u00111!\u00138u\u0011\u0015A\u0005\u0001\"\u0011J\u0003\u0011aw.\u00193\u0015\t\u0015R5\n\u0014\u0005\u0006S\u001d\u0003\rA\u000b\u0005\u0006i\u001d\u0003\r!\u000e\u0005\u0006\u001b\u001e\u0003\rAT\u0001\u0010e\u0016\fX/\u001b:fI\u000e{G.^7ogB\u0019q\nV\u001b\u000f\u0005A\u0013fB\u0001\u001dR\u0013\u0005\t\u0012BA*\u0011\u0003\u001d\u0001\u0018mY6bO\u0016L!!\u0016,\u0003\u0007M+\u0017O\u0003\u0002T!!)\u0001\f\u0001C!3\u0006IQM\\2pI\u0016\u0014vn\u001e\u000b\u00041ic\u0006\"B.X\u0001\u0004)\u0014aB6fs:\u000bW.\u001a\u0005\u0006\u0003^\u0003\r!\u0018\t\u0003=~k\u0011\u0001B\u0005\u0003A\u0012\u00111AU8x\u0011\u0015\u0011\u0007\u0001\"\u0011d\u0003%!WmY8eKJ{w\u000fF\u0003^I&T'\u000fC\u0003fC\u0002\u0007a-\u0001\u0004lKfl\u0015\r\u001d\t\u0005\u001f\u001d,T'\u0003\u0002i!\t1A+\u001e9mKJBQ!Q1A\u0002aAQa[1A\u00021\faa]2iK6\f\u0007CA7q\u001b\u0005q'BA8\u0005\u0003\u0015!\u0018\u0010]3t\u0013\t\thN\u0001\u0006TiJ,8\r\u001e+za\u0016DQ!T1A\u00029\u0003")
public class BinaryRedisPersistence
implements RedisPersistence<byte[]> {
    @Override
    public void save(Pipeline pipeline, String key, byte[] value, int ttl) {
        byte[] keyBytes = key.getBytes(StandardCharsets.UTF_8);
        if (ttl > 0) {
            pipeline.setex(keyBytes, ttl, value);
        } else {
            pipeline.set(keyBytes, value);
        }
    }

    @Override
    public void load(Pipeline pipeline, String key, Seq<String> requiredColumns) {
        pipeline.get(key.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public byte[] encodeRow(String keyName, Row value) {
        String[] fields = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])value.schema().fields())).map((Function1 & java.io.Serializable & Serializable)x$1 -> x$1.name(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        Object[] valuesArray = (Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fields)).map((Function1 & java.io.Serializable & Serializable)f -> value.getAs(f), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Any()));
        return SerializationUtils.serialize((java.io.Serializable)((java.io.Serializable)valuesArray));
    }

    @Override
    public Row decodeRow(Tuple2<String, String> keyMap, byte[] value, StructType schema, Seq<String> requiredColumns) {
        Object[] valuesArray = (Object[])SerializationUtils.deserialize((byte[])value);
        return new GenericRowWithSchema(valuesArray, schema);
    }
}

