/*
 * Decompiled with CFR 0.152.
 */
package com.redislabs.provider.redis;

import com.redislabs.provider.redis.RedisConfig$;
import com.redislabs.provider.redis.RedisEndpoint;
import com.redislabs.provider.redis.RedisEndpoint$;
import com.redislabs.provider.redis.RedisNode;
import java.io.Serializable;
import java.util.List;
import org.apache.spark.SparkConf;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.util.JedisClusterCRC16;
import redis.clients.jedis.util.SafeEncoder;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001\u00055t!B\u0001\u0003\u0011\u0003Y\u0011a\u0003*fI&\u001c8i\u001c8gS\u001eT!a\u0001\u0003\u0002\u000bI,G-[:\u000b\u0005\u00151\u0011\u0001\u00039s_ZLG-\u001a:\u000b\u0005\u001dA\u0011!\u0003:fI&\u001cH.\u00192t\u0015\u0005I\u0011aA2p[\u000e\u0001\u0001C\u0001\u0007\u000e\u001b\u0005\u0011a!\u0002\b\u0003\u0011\u0003y!a\u0003*fI&\u001c8i\u001c8gS\u001e\u001c2!\u0004\t\u0017!\t\tB#D\u0001\u0013\u0015\u0005\u0019\u0012!B:dC2\f\u0017BA\u000b\u0013\u0005\u0019\te.\u001f*fMB\u0011\u0011cF\u0005\u00031I\u0011AbU3sS\u0006d\u0017N_1cY\u0016DQAG\u0007\u0005\u0002m\ta\u0001P5oSRtD#A\u0006\t\u000buiA\u0011\u0001\u0010\u0002\u001b\u0019\u0014x.\\*qCJ\\7i\u001c8g)\ry\u0012Q\u0006\t\u0003\u0019\u00012AA\u0004\u0002\u0001CM\u0019\u0001\u0005\u0005\f\t\u0011\r\u0002#Q1A\u0005\u0002\u0011\n1\"\u001b8ji&\fG\u000eS8tiV\tQ\u0005\u0005\u0002\rM%\u0011qE\u0001\u0002\u000e%\u0016$\u0017n]#oIB|\u0017N\u001c;\t\u0011%\u0002#\u0011!Q\u0001\n\u0015\nA\"\u001b8ji&\fG\u000eS8ti\u0002BQA\u0007\u0011\u0005\u0002-\"\"a\b\u0017\t\u000b\rR\u0003\u0019A\u0013\t\u000f9\u0002#\u0019!C\u0001_\u0005Y\u0011N\\5uS\u0006d\u0017\t\u001a3s+\u0005\u0001\u0004CA\u00199\u001d\t\u0011d\u0007\u0005\u00024%5\tAG\u0003\u00026\u0015\u00051AH]8pizJ!a\u000e\n\u0002\rA\u0013X\rZ3g\u0013\tI$H\u0001\u0004TiJLgn\u001a\u0006\u0003oIAa\u0001\u0010\u0011!\u0002\u0013\u0001\u0014\u0001D5oSRL\u0017\r\\!eIJ\u0004\u0003b\u0002 !\u0005\u0004%\taP\u0001\u0006Q>\u001cHo]\u000b\u0002\u0001B\u0019\u0011#Q\"\n\u0005\t\u0013\"!B!se\u0006L\bC\u0001\u0007E\u0013\t)%AA\u0005SK\u0012L7OT8eK\"1q\t\tQ\u0001\n\u0001\u000ba\u0001[8tiN\u0004\u0003bB%!\u0005\u0004%\taP\u0001\u0006]>$Wm\u001d\u0005\u0007\u0017\u0002\u0002\u000b\u0011\u0002!\u0002\r9|G-Z:!\u0011\u0015i\u0005\u0005\"\u00010\u0003\u001d9W\r^!vi\"DQa\u0014\u0011\u0005\u0002A\u000bQaZ3u\t\n+\u0012!\u0015\t\u0003#IK!a\u0015\n\u0003\u0007%sG\u000fC\u0003VA\u0011\u0005a+A\u0007hKR\u0014\u0016M\u001c3p[:{G-\u001a\u000b\u0002\u0007\")\u0001\f\tC\u00013\u0006yq-\u001a;O_\u0012,7OQ=TY>$8\u000fF\u0002A5rCQaW,A\u0002E\u000bAa\u001d)pg\")Ql\u0016a\u0001#\u0006!Q\rU8t\u0011\u0015y\u0006\u0005\"\u0001a\u0003A\u0019wN\u001c8fGRLwN\u001c$pe.+\u0017\u0010\u0006\u0002bUB\u0011!\r[\u0007\u0002G*\u0011A-Z\u0001\u0006U\u0016$\u0017n\u001d\u0006\u0003M\u001e\fqa\u00197jK:$8OC\u0001\u0004\u0013\tI7MA\u0003KK\u0012L7\u000fC\u0003l=\u0002\u0007\u0001'A\u0002lKfDQa\u0018\u0011\u0005\u00025$\"!\u00198\t\u000b-d\u0007\u0019A8\u0011\u0007E\t\u0005\u000f\u0005\u0002\u0012c&\u0011!O\u0005\u0002\u0005\u0005f$X\rC\u0003uA\u0011%Q/\u0001\bdYV\u001cH/\u001a:F]\u0006\u0014G.\u001a3\u0015\u0005YL\bCA\tx\u0013\tA(CA\u0004C_>dW-\u00198\t\u000b\r\u001a\b\u0019A\u0013\t\u000bm\u0004C\u0011\u0001?\u0002\u000f\u001d,G\u000fS8tiR\u00111) \u0005\u0006Wj\u0004\r\u0001\r\u0005\u0006w\u0002\"\ta \u000b\u0004\u0007\u0006\u0005\u0001\"B6\u007f\u0001\u0004y\u0007bBA\u0003A\u0011%\u0011qA\u0001\u000eO\u0016$\bj\\:u\u0005f\u001cFn\u001c;\u0015\u0007\r\u000bI\u0001C\u0004\u0002\f\u0005\r\u0001\u0019A)\u0002\tMdw\u000e\u001e\u0005\b\u0003\u001f\u0001C\u0011BA\t\u0003!9W\r\u001e%pgR\u001cHc\u0001!\u0002\u0014!11%!\u0004A\u0002\u0015Bq!a\u0006!\t\u0013\tI\"\u0001\nhKRtuN\\\"mkN$XM\u001d(pI\u0016\u001cHc\u0001!\u0002\u001c!11%!\u0006A\u0002\u0015Bq!a\b!\t\u0013\t\t#A\bhKR\u001cE.^:uKJtu\u000eZ3t)\r\u0001\u00151\u0005\u0005\u0007G\u0005u\u0001\u0019A\u0013\t\u000f\u0005\u001d\u0002\u0005\"\u0001\u0002*\u0005Aq-\u001a;O_\u0012,7\u000fF\u0002A\u0003WAaaIA\u0013\u0001\u0004)\u0003bBA\u00189\u0001\u0007\u0011\u0011G\u0001\u0005G>tg\r\u0005\u0003\u00024\u0005\u0005SBAA\u001b\u0015\u0011\t9$!\u000f\u0002\u000bM\u0004\u0018M]6\u000b\t\u0005m\u0012QH\u0001\u0007CB\f7\r[3\u000b\u0005\u0005}\u0012aA8sO&!\u00111IA\u001b\u0005%\u0019\u0006/\u0019:l\u0007>tg\rC\u0004\u0002H5!\t!!\u0013\u00025\u0019\u0014x.\\*qCJ\\7i\u001c8g\u0003:$\u0007+\u0019:b[\u0016$XM]:\u0015\u000b}\tY%!\u0014\t\u0011\u0005=\u0012Q\ta\u0001\u0003cA\u0001\"a\u0014\u0002F\u0001\u0007\u0011\u0011K\u0001\u000ba\u0006\u0014\u0018-\\3uKJ\u001c\b#B\u0019\u0002TA\u0002\u0014bAA+u\t\u0019Q*\u00199\t\u0013\u0005eS\"!A\u0005\n\u0005m\u0013a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!!\u0018\u0011\t\u0005}\u0013\u0011N\u0007\u0003\u0003CRA!a\u0019\u0002f\u0005!A.\u00198h\u0015\t\t9'\u0001\u0003kCZ\f\u0017\u0002BA6\u0003C\u0012aa\u00142kK\u000e$\b")
public class RedisConfig
implements scala.Serializable {
    private final RedisEndpoint initialHost;
    private final String initialAddr;
    private final RedisNode[] hosts;
    private final RedisNode[] nodes;

    public static RedisConfig fromSparkConfAndParameters(SparkConf sparkConf, Map<String, String> map) {
        return RedisConfig$.MODULE$.fromSparkConfAndParameters(sparkConf, map);
    }

    public static RedisConfig fromSparkConf(SparkConf sparkConf) {
        return RedisConfig$.MODULE$.fromSparkConf(sparkConf);
    }

    public RedisEndpoint initialHost() {
        return this.initialHost;
    }

    public String initialAddr() {
        return this.initialAddr;
    }

    public RedisNode[] hosts() {
        return this.hosts;
    }

    public RedisNode[] nodes() {
        return this.nodes;
    }

    public String getAuth() {
        return this.initialHost().auth();
    }

    public int getDB() {
        return this.initialHost().dbNum();
    }

    public RedisNode getRandomNode() {
        int rnd = RichInt$.MODULE$.abs$extension(Predef$.MODULE$.intWrapper(Random$.MODULE$.nextInt())) % this.hosts().length;
        return this.hosts()[rnd];
    }

    public RedisNode[] getNodesBySlots(int sPos, int ePos) {
        return (RedisNode[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.nodes())).filter((Function1 & Serializable & scala.Serializable)node -> BoxesRunTime.boxToBoolean((boolean)RedisConfig.inter$1(sPos, ePos, node.startSlot(), node.endSlot()))))).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)RedisConfig.$anonfun$getNodesBySlots$2(x$1)));
    }

    public Jedis connectionForKey(String key) {
        return this.getHost(key).connect();
    }

    public Jedis connectionForKey(byte[] key) {
        return this.getHost(key).connect();
    }

    private boolean clusterEnabled(RedisEndpoint initialHost) {
        Jedis conn = initialHost.connect();
        String[] info = conn.info().split("\n");
        String version = ((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])info)).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.contains("redis_version:"))))[0];
        String[] clusterEnable = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])info)).filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.contains("cluster_enabled:")));
        int mainVersion = new StringOps(Predef$.MODULE$.augmentString(version.substring(14, version.indexOf(".")))).toInt();
        boolean res = mainVersion > 2 && clusterEnable.length > 0 && clusterEnable[0].contains("1");
        conn.close();
        return res;
    }

    public RedisNode getHost(String key) {
        int slot = JedisClusterCRC16.getSlot((String)key);
        return this.getHostBySlot(slot);
    }

    public RedisNode getHost(byte[] key) {
        int slot = JedisClusterCRC16.getSlot((byte[])key);
        return this.getHostBySlot(slot);
    }

    private RedisNode getHostBySlot(int slot) {
        return ((RedisNode[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.hosts())).filter((Function1 & Serializable & scala.Serializable)host -> BoxesRunTime.boxToBoolean((boolean)RedisConfig.$anonfun$getHostBySlot$1(slot, host))))[0];
    }

    private RedisNode[] getHosts(RedisEndpoint initialHost) {
        return (RedisNode[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.getNodes(initialHost))).filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)RedisConfig.$anonfun$getHosts$1(x$4)));
    }

    private RedisNode[] getNonClusterNodes(RedisEndpoint initialHost) {
        String[] replinfo;
        Tuple2 master;
        while (true) {
            master = new Tuple2((Object)initialHost.host(), (Object)BoxesRunTime.boxToInteger((int)initialHost.port()));
            Jedis conn = initialHost.connect();
            replinfo = conn.info("Replication").split("\n");
            conn.close();
            if (!new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])replinfo)).exists((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.contains("role:slave")))) break;
            String host = ((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])replinfo)).filter((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)x$6.contains("master_host:"))))[0].trim().substring(12);
            int port = new StringOps(Predef$.MODULE$.augmentString(((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])replinfo)).filter((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)x$7.contains("master_port:"))))[0].trim().substring(12))).toInt();
            String x$16 = host;
            int x$17 = port;
            String x$18 = initialHost.user();
            String x$19 = initialHost.auth();
            int x$20 = initialHost.dbNum();
            boolean x$21 = initialHost.ssl();
            int x$22 = RedisEndpoint$.MODULE$.apply$default$6();
            initialHost = new RedisEndpoint(x$16, x$17, x$18, x$19, x$20, x$22, x$21);
        }
        Tuple2[] slaves = (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])replinfo)).filter((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)RedisConfig.$anonfun$getNonClusterNodes$4(x))))).map((Function1 & Serializable & scala.Serializable)rl -> {
            String[] content = rl.substring(rl.indexOf(58) + 1).split(",");
            String ip = content[0];
            String port = content[1];
            return new Tuple2((Object)ip.substring(ip.indexOf(61) + 1), (Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(port.substring(port.indexOf(61) + 1))).toInt()));
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
        Tuple2 tuple2 = master;
        Tuple2[] nodes = (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])slaves)).$plus$colon((Object)tuple2, ClassTag$.MODULE$.apply(Tuple2.class));
        int range = nodes.length;
        return (RedisNode[])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), range).map((Function1 & Serializable & scala.Serializable)i -> RedisConfig.$anonfun$getNonClusterNodes$6(initialHost, nodes, range, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(RedisNode.class));
    }

    /*
     * WARNING - void declaration
     */
    private RedisNode[] getClusterNodes(RedisEndpoint initialHost) {
        void var3_3;
        Jedis conn = initialHost.connect();
        RedisNode[] res = (RedisNode[])((TraversableOnce)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(conn.clusterSlots()).flatMap((Function1 & Serializable & scala.Serializable)slotInfoObj -> {
            List slotInfo = (List)slotInfoObj;
            int sPos = new StringOps(Predef$.MODULE$.augmentString(slotInfo.get(0).toString())).toInt();
            int ePos = new StringOps(Predef$.MODULE$.augmentString(slotInfo.get(1).toString())).toInt();
            return (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), slotInfo.size() - 2).map((Function1 & Serializable & scala.Serializable)i -> RedisConfig.$anonfun$getClusterNodes$2(initialHost, slotInfo, sPos, ePos, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        }, Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(RedisNode.class));
        conn.close();
        return var3_3;
    }

    public RedisNode[] getNodes(RedisEndpoint initialHost) {
        return this.clusterEnabled(initialHost) ? this.getClusterNodes(initialHost) : this.getNonClusterNodes(initialHost);
    }

    private static final boolean inter$1(int sPos1, int ePos1, int sPos2, int ePos2) {
        return sPos1 <= sPos2 ? ePos1 >= sPos2 : ePos2 >= sPos1;
    }

    public static final /* synthetic */ boolean $anonfun$getNodesBySlots$2(RedisNode x$1) {
        return x$1.idx() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$getHostBySlot$1(int slot$1, RedisNode host) {
        return host.startSlot() <= slot$1 && host.endSlot() >= slot$1;
    }

    public static final /* synthetic */ boolean $anonfun$getHosts$1(RedisNode x$4) {
        return x$4.idx() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$getNonClusterNodes$4(String x) {
        return x.contains("slave") && x.contains("online");
    }

    public static final /* synthetic */ RedisNode $anonfun$getNonClusterNodes$6(RedisEndpoint initialHost$1, Tuple2[] nodes$1, int range$1, int i) {
        RedisEndpoint endpoint = new RedisEndpoint((String)nodes$1[i]._1(), nodes$1[i]._2$mcI$sp(), initialHost$1.user(), initialHost$1.auth(), initialHost$1.dbNum(), initialHost$1.timeout(), initialHost$1.ssl());
        return new RedisNode(endpoint, 0, 16383, i, range$1);
    }

    public static final /* synthetic */ RedisNode $anonfun$getClusterNodes$2(RedisEndpoint initialHost$2, List slotInfo$1, int sPos$2, int ePos$2, int i) {
        List node = (List)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(slotInfo$1).apply(i + 2);
        String host = SafeEncoder.encode((byte[])((byte[])node.get(0)));
        int port = new StringOps(Predef$.MODULE$.augmentString(node.get(1).toString())).toInt();
        RedisEndpoint endpoint = new RedisEndpoint(host, port, initialHost$2.user(), initialHost$2.auth(), initialHost$2.dbNum(), initialHost$2.timeout(), initialHost$2.ssl());
        return new RedisNode(endpoint, sPos$2, ePos$2, i, slotInfo$1.size() - 2);
    }

    public RedisConfig(RedisEndpoint initialHost) {
        this.initialHost = initialHost;
        this.initialAddr = initialHost.host();
        this.hosts = this.getHosts(initialHost);
        this.nodes = this.getNodes(initialHost);
    }
}

