/*
 * Decompiled with CFR 0.152.
 */
package com.redmadrobot.konfeature.builder;

import com.redmadrobot.konfeature.FeatureConfig;
import com.redmadrobot.konfeature.FeatureConfigSpec;
import com.redmadrobot.konfeature.FeatureValueSpec;
import com.redmadrobot.konfeature.Konfeature;
import com.redmadrobot.konfeature.Logger;
import com.redmadrobot.konfeature.LoggerKt;
import com.redmadrobot.konfeature.builder.KonfeatureImpl;
import com.redmadrobot.konfeature.exception.ConfigNameAlreadyExistException;
import com.redmadrobot.konfeature.exception.KeyDuplicationException;
import com.redmadrobot.konfeature.exception.NoFeatureConfigException;
import com.redmadrobot.konfeature.exception.SourceNameAlreadyExistException;
import com.redmadrobot.konfeature.source.FeatureSource;
import com.redmadrobot.konfeature.source.Interceptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\r\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\bJ\u000e\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0006J\u000e\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\nJ\u000e\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\u0014\u001a\u00020\u0015J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/redmadrobot/konfeature/builder/KonfeatureBuilder;", "", "<init>", "()V", "sources", "", "Lcom/redmadrobot/konfeature/source/FeatureSource;", "interceptors", "Lcom/redmadrobot/konfeature/source/Interceptor;", "spec", "Lcom/redmadrobot/konfeature/FeatureConfig;", "logger", "Lcom/redmadrobot/konfeature/Logger;", "addInterceptor", "interceptor", "addSource", "source", "register", "featureConfig", "setLogger", "build", "Lcom/redmadrobot/konfeature/Konfeature;", "validateConfigSpec", "", "config", "Lcom/redmadrobot/konfeature/FeatureConfigSpec;", "konfeature"})
@SourceDebugExtension(value={"SMAP\nKonfeatureBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KonfeatureBuilder.kt\ncom/redmadrobot/konfeature/builder/KonfeatureBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,87:1\n1755#2,3:88\n1755#2,3:91\n1863#2,2:94\n1863#2,2:96\n1863#2,2:98\n*S KotlinDebug\n*F\n+ 1 KonfeatureBuilder.kt\ncom/redmadrobot/konfeature/builder/KonfeatureBuilder\n*L\n23#1:88,3\n32#1:91,3\n47#1:94,2\n55#1:96,2\n64#1:98,2\n*E\n"})
public final class KonfeatureBuilder {
    @NotNull
    private final List<FeatureSource> sources = new ArrayList();
    @NotNull
    private List<Interceptor> interceptors = new ArrayList();
    @NotNull
    private List<FeatureConfig> spec = new ArrayList();
    @Nullable
    private Logger logger;

    @NotNull
    public final KonfeatureBuilder addInterceptor(@NotNull Interceptor interceptor) {
        Intrinsics.checkNotNullParameter((Object)interceptor, (String)"interceptor");
        this.interceptors.add(interceptor);
        return this;
    }

    @NotNull
    public final KonfeatureBuilder addSource(@NotNull FeatureSource source) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            Iterable $this$any$iv = this.sources;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    FeatureSource it = (FeatureSource)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)source.getName())) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        if (bl) {
            throw new SourceNameAlreadyExistException(source.getName());
        }
        this.sources.add(source);
        return this;
    }

    @NotNull
    public final KonfeatureBuilder register(@NotNull FeatureConfig featureConfig) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter((Object)featureConfig, (String)"featureConfig");
            Iterable $this$any$iv = this.spec;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    FeatureConfig it = (FeatureConfig)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)featureConfig.getName())) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        if (bl) {
            throw new ConfigNameAlreadyExistException(featureConfig.getName());
        }
        this.spec.add(featureConfig);
        return this;
    }

    @NotNull
    public final KonfeatureBuilder setLogger(@NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.logger = logger;
        return this;
    }

    @NotNull
    public final Konfeature build() {
        KonfeatureImpl konfeatureImpl;
        if (this.spec.isEmpty()) {
            throw new NoFeatureConfigException();
        }
        Iterable $this$forEach$iv = this.spec;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FeatureConfigSpec p0 = (FeatureConfigSpec)element$iv;
            boolean bl = false;
            this.validateConfigSpec(p0);
        }
        KonfeatureImpl toggleEase = konfeatureImpl = new KonfeatureImpl(this.sources, this.interceptors, this.logger, this.spec);
        boolean bl = false;
        Iterable $this$forEach$iv2 = this.spec;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            FeatureConfig values = (FeatureConfig)element$iv;
            boolean bl2 = false;
            values.bind$konfeature(toggleEase);
        }
        return konfeatureImpl;
    }

    private final void validateConfigSpec(FeatureConfigSpec config) {
        block4: {
            Map counter = MapsKt.withDefaultMutable((Map)new LinkedHashMap(), KonfeatureBuilder::validateConfigSpec$lambda$4);
            boolean hasDuplicates = false;
            Iterable $this$forEach$iv = config.getValues();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                FeatureValueSpec valueSpec = (FeatureValueSpec)element$iv;
                boolean bl = false;
                int value = ((Number)MapsKt.getValue((Map)counter, (Object)valueSpec.getKey())).intValue();
                if (value > 0) {
                    hasDuplicates = true;
                }
                counter.put(valueSpec.getKey(), value + 1);
            }
            if (hasDuplicates) {
                List values = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)MapsKt.asSequence((Map)counter), KonfeatureBuilder::validateConfigSpec$lambda$6), KonfeatureBuilder::validateConfigSpec$lambda$7));
                throw new KeyDuplicationException(values, config.getName());
            }
            if (!counter.isEmpty()) break block4;
            Logger logger = this.logger;
            if (logger != null) {
                LoggerKt.logWarn(logger, "Config '" + config.getName() + "' is empty");
            }
        }
    }

    private static final int validateConfigSpec$lambda$4(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return 0;
    }

    private static final boolean validateConfigSpec$lambda$6(Map.Entry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ((Number)it.getValue()).intValue() > 1;
    }

    private static final String validateConfigSpec$lambda$7(Map.Entry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (String)it.getKey();
    }
}

