/*
 * Decompiled with CFR 0.152.
 */
package com.redmadrobot.konfeature.builder;

import com.redmadrobot.konfeature.FeatureConfigSpec;
import com.redmadrobot.konfeature.FeatureValue;
import com.redmadrobot.konfeature.FeatureValueSpec;
import com.redmadrobot.konfeature.Konfeature;
import com.redmadrobot.konfeature.Logger;
import com.redmadrobot.konfeature.LoggerKt;
import com.redmadrobot.konfeature.source.FeatureSource;
import com.redmadrobot.konfeature.source.FeatureValueSource;
import com.redmadrobot.konfeature.source.Interceptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B;\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0003\u00a2\u0006\u0004\b\u000b\u0010\fJ&\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00140\u0013\"\b\b\u0000\u0010\u0014*\u00020\u00152\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00140\u0016H\u0016J8\u0010\u0017\u001a\u00020\u0018*\u00020\b2\u0006\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00152\b\u0010\u001d\u001a\u0004\u0018\u00010\u00112\b\u0010\u001e\u001a\u0004\u0018\u00010\u0011H\u0002J-\u0010\u001f\u001a\u0004\u0018\u0001H\u0014\"\b\b\u0000\u0010\u0014*\u00020\u0015*\b\u0012\u0004\u0012\u0002H\u00140 2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0015H\u0002\u00a2\u0006\u0002\u0010!R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/redmadrobot/konfeature/builder/KonfeatureImpl;", "Lcom/redmadrobot/konfeature/Konfeature;", "sources", "", "Lcom/redmadrobot/konfeature/source/FeatureSource;", "interceptors", "Lcom/redmadrobot/konfeature/source/Interceptor;", "logger", "Lcom/redmadrobot/konfeature/Logger;", "spec", "Lcom/redmadrobot/konfeature/FeatureConfigSpec;", "<init>", "(Ljava/util/List;Ljava/util/List;Lcom/redmadrobot/konfeature/Logger;Ljava/util/List;)V", "getSpec", "()Ljava/util/List;", "sourcesNames", "", "", "getValue", "Lcom/redmadrobot/konfeature/FeatureValue;", "T", "", "Lcom/redmadrobot/konfeature/FeatureValueSpec;", "logUnexpectedValueType", "", "key", "source", "Lcom/redmadrobot/konfeature/source/FeatureValueSource;", "value", "actualClass", "expectedClass", "tryCastOrNull", "Lkotlin/reflect/KClass;", "(Lkotlin/reflect/KClass;Ljava/lang/Object;)Ljava/lang/Object;", "konfeature"})
@SourceDebugExtension(value={"SMAP\nKonfeatureImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KonfeatureImpl.kt\ncom/redmadrobot/konfeature/builder/KonfeatureImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,98:1\n1557#2:99\n1628#2,3:100\n*S KotlinDebug\n*F\n+ 1 KonfeatureImpl.kt\ncom/redmadrobot/konfeature/builder/KonfeatureImpl\n*L\n20#1:99\n20#1:100,3\n*E\n"})
public final class KonfeatureImpl
implements Konfeature {
    @NotNull
    private final List<FeatureSource> sources;
    @NotNull
    private final List<Interceptor> interceptors;
    @Nullable
    private final Logger logger;
    @NotNull
    private final List<FeatureConfigSpec> spec;
    @NotNull
    private final Set<String> sourcesNames;

    /*
     * WARNING - void declaration
     */
    public KonfeatureImpl(@NotNull List<? extends FeatureSource> sources, @NotNull List<? extends Interceptor> interceptors, @Nullable Logger logger, @NotNull List<? extends FeatureConfigSpec> spec) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(sources, (String)"sources");
        Intrinsics.checkNotNullParameter(interceptors, (String)"interceptors");
        Intrinsics.checkNotNullParameter(spec, (String)"spec");
        this.sources = sources;
        this.interceptors = interceptors;
        this.logger = logger;
        this.spec = spec;
        Iterable iterable = this.sources;
        KonfeatureImpl konfeatureImpl = this;
        boolean $i$f$map = false;
        void var7_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FeatureSource featureSource = (FeatureSource)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getName());
        }
        konfeatureImpl.sourcesNames = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    @Override
    @NotNull
    public List<FeatureConfigSpec> getSpec() {
        return this.spec;
    }

    @Override
    @NotNull
    public <T> FeatureValue<T> getValue(@NotNull FeatureValueSpec<T> spec) {
        FeatureValueSource valueSource;
        T value;
        block6: {
            Intrinsics.checkNotNullParameter(spec, (String)"spec");
            Set<String> selectedSourcesNames = spec.getSourceSelectionStrategy().select(this.sourcesNames);
            KClass expectedClass = Reflection.getOrCreateKotlinClass(spec.getDefaultValue().getClass());
            value = spec.getDefaultValue();
            valueSource = FeatureValueSource.Default.INSTANCE;
            for (FeatureSource source : this.sources) {
                if (!selectedSourcesNames.contains(source.getName())) continue;
                Object actualSourceValue = source.get(spec.getKey());
                T sourceValue = this.tryCastOrNull(expectedClass, actualSourceValue);
                if (actualSourceValue != null && sourceValue == null) {
                    Logger logger = this.logger;
                    if (logger != null) {
                        this.logUnexpectedValueType(logger, spec.getKey(), new FeatureValueSource.Source(source.getName()), actualSourceValue, Reflection.getOrCreateKotlinClass(actualSourceValue.getClass()).getQualifiedName(), expectedClass.getQualifiedName());
                    }
                }
                if (sourceValue == null) continue;
                value = sourceValue;
                valueSource = new FeatureValueSource.Source(source.getName());
                break;
            }
            for (Interceptor interceptor : this.interceptors) {
                Object actualInterceptorValue = interceptor.intercept(valueSource, spec.getKey(), value);
                T interceptorValue = this.tryCastOrNull(expectedClass, actualInterceptorValue);
                if (actualInterceptorValue != null && interceptorValue == null) {
                    Logger logger = this.logger;
                    if (logger != null) {
                        this.logUnexpectedValueType(logger, spec.getKey(), new FeatureValueSource.Interceptor(interceptor.getName()), actualInterceptorValue, Reflection.getOrCreateKotlinClass(actualInterceptorValue.getClass()).getQualifiedName(), expectedClass.getQualifiedName());
                    }
                }
                if (interceptorValue == null) continue;
                value = interceptorValue;
                valueSource = new FeatureValueSource.Interceptor(interceptor.getName());
            }
            Logger logger = this.logger;
            if (logger == null) break block6;
            LoggerKt.logInfo(logger, "Get value '" + value + "' by key '" + spec.getKey() + "' from '" + valueSource + "'");
        }
        return new FeatureValue<T>(valueSource, value);
    }

    private final void logUnexpectedValueType(Logger $this$logUnexpectedValueType, String key, FeatureValueSource source, Object value, String actualClass, String expectedClass) {
        LoggerKt.logWarn($this$logUnexpectedValueType, "Unexpected value type for '" + key + "': expected type is '" + expectedClass + "', but value from '" + source + "' is '" + value + "' with type '" + actualClass + "'");
    }

    private final <T> T tryCastOrNull(KClass<T> $this$tryCastOrNull, Object value) {
        Object object;
        if ($this$tryCastOrNull.isInstance(value)) {
            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type T of com.redmadrobot.konfeature.builder.KonfeatureImpl.tryCastOrNull");
            object = value;
        } else {
            object = null;
        }
        return (T)object;
    }
}

