/*
 * Decompiled with CFR 0.152.
 */
package com.redpill_linpro.mule.jsonwebtoken;

import com.redpill_linpro.mule.jsonwebtoken.config.ConnectorConfig;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import java.util.Base64;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang.StringUtils;
import org.mule.module.json.JsonData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONWebTokenConnector {
    ConnectorConfig config;
    private static final Logger LOG = LoggerFactory.getLogger(JSONWebTokenConnector.class);

    public JsonData decode(String token, Boolean validateSignature) throws IOException {
        String[] jwtParts = this.splitToken(token);
        if (!validateSignature.booleanValue() || this.doValidate(jwtParts)) {
            JsonData jwtPayload = new JsonData((InputStream)new ByteArrayInputStream(Base64.getDecoder().decode(jwtParts[1])));
            return jwtPayload;
        }
        throw new RuntimeException("Invalid JSON Token");
    }

    public boolean signatureIsValid(String token) throws IOException {
        String[] jwtParts = this.splitToken(token);
        return this.doValidate(jwtParts);
    }

    private boolean doValidate(String[] jwtParts) throws IOException {
        JsonData jwtHeader = new JsonData((InputStream)new ByteArrayInputStream(Base64.getDecoder().decode(jwtParts[0])));
        if (!"JWT".equals(jwtHeader.get("typ")) && jwtHeader.get("alg") == null) {
            LOG.debug("JWT signature could not be verified: No algorithm specified");
        } else {
            String algHeader = jwtHeader.get("alg").getTextValue();
            if (algHeader.startsWith("NONE")) {
                return true;
            }
            if (algHeader.startsWith("RS")) {
                return this.verifyRSASignature(algHeader, jwtParts);
            }
            if (algHeader.startsWith("HS")) {
                return this.verifyHMACSHASignature(algHeader, jwtParts);
            }
            LOG.debug("JWT signature could not be verified: No known algorithm: " + algHeader);
        }
        return false;
    }

    private boolean verifyHMACSHASignature(String algHeader, String[] jwtParts) {
        String algorithm;
        switch (algHeader) {
            case "HS256": {
                algorithm = "HmacSHA256";
                break;
            }
            case "HS384": {
                algorithm = "HmacSHA384";
                break;
            }
            case "HS512": {
                algorithm = "HmacSHA512";
                break;
            }
            default: {
                algorithm = null;
            }
        }
        boolean verified = false;
        try {
            if (algorithm != null) {
                Mac shaHMAC = Mac.getInstance(algorithm);
                SecretKeySpec secret_key = new SecretKeySpec(this.config.getSecret().getBytes(), algorithm);
                shaHMAC.init(secret_key);
                byte[] calculatedSignature = shaHMAC.doFinal((jwtParts[0] + '.' + jwtParts[1]).getBytes());
                byte[] recivedSignature = Base64.getUrlDecoder().decode(jwtParts[2]);
                verified = Arrays.equals(calculatedSignature, recivedSignature);
            } else {
                LOG.debug("JWT signature could not be verified: No known algorithm: " + algHeader);
            }
        }
        catch (Exception e) {
            LOG.debug("JWT signature could not be verified: " + e);
            verified = false;
        }
        return verified;
    }

    private boolean verifyRSASignature(String algHeader, String[] jwtParts) {
        String algorithm = null;
        switch (algHeader) {
            case "RS256": {
                algorithm = "SHA256withRSA";
                break;
            }
            case "RS384": {
                algorithm = "SHA384withRSA";
                break;
            }
            case "RS512": {
                algorithm = "SHA512withRSA";
            }
        }
        boolean verified = false;
        try {
            byte[] pk = Base64.getDecoder().decode(this.config.getSecret());
            X509EncodedKeySpec pubKeySpec = new X509EncodedKeySpec(pk);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PublicKey publicKey = keyFactory.generatePublic(pubKeySpec);
            Signature signature = Signature.getInstance(algorithm);
            signature.initVerify(publicKey);
            signature.update((jwtParts[0] + '.' + jwtParts[1]).getBytes());
            verified = signature.verify(Base64.getDecoder().decode(jwtParts[2]));
        }
        catch (Exception e) {
            LOG.debug("JWT signature could not be verified: " + e);
            verified = false;
        }
        return verified;
    }

    private String[] splitToken(String token) {
        if (StringUtils.startsWith((String)token, (String)"Bearer ")) {
            token = token.substring(token.indexOf(32) + 1);
        }
        return token.split("\\.", 3);
    }

    public ConnectorConfig getConfig() {
        return this.config;
    }

    public void setConfig(ConnectorConfig config) {
        this.config = config;
    }
}

