/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.3.9.0.api.metadata;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.mule.devkit.3.9.0.api.metadata.ComposedMetaDataKey;
import org.mule.devkit.3.9.0.api.metadata.DefaultMetaDataKeyLevel;
import org.mule.devkit.3.9.0.api.metadata.MetaDataKeyLevel;
import org.mule.devkit.3.9.0.api.metadata.exception.InvalidKeyBuildStateException;
import org.mule.devkit.3.9.0.api.metadata.exception.InvalidKeyException;
import org.mule.devkit.3.9.0.internal.metadata.DefaultComposedMetaDataKey;

public class ComposedMetaDataKeyBuilder {
    protected List<ComposedMetaDataKey> keys = new LinkedList<ComposedMetaDataKey>();
    protected String customSeparator = "";

    protected ComposedMetaDataKeyBuilder() {
    }

    public static ComposedMetaDataKeyBuilder getInstance() {
        return new ComposedMetaDataKeyBuilder();
    }

    public CombinationBuilder newKeyCombination() {
        return new CombinationBuilder(this, this.customSeparator);
    }

    public ComposedMetaDataKeyBuilder endKeyCombination(List<ComposedMetaDataKey> keys) {
        this.keys.addAll(keys);
        return this;
    }

    public List<ComposedMetaDataKey> build() {
        List<ComposedMetaDataKey> result = this.keys;
        this.resetBuild();
        return result;
    }

    private void resetBuild() {
        this.keys = new LinkedList<ComposedMetaDataKey>();
    }

    public static class LevelBuilder {
        protected final CombinationBuilder parentBuilder;
        protected MetaDataKeyLevel currentLevel = new DefaultMetaDataKeyLevel();
        private boolean levelEnded = false;

        protected LevelBuilder(CombinationBuilder parentBuilder) {
            this.parentBuilder = parentBuilder;
        }

        public LevelBuilder addId(String id, String label) {
            if (this.levelEnded) {
                throw new InvalidKeyBuildStateException("Cannot add a new id to an already ended level");
            }
            this.currentLevel.addId(id, label);
            return this;
        }

        public LevelBuilder addIds(MetaDataKeyLevel level) {
            if (level != null && !level.getIds().isEmpty()) {
                if (this.currentLevel != null) {
                    for (Map.Entry<String, String> levelElement : level.getIds()) {
                        this.currentLevel.addId(levelElement.getKey(), levelElement.getValue());
                    }
                } else {
                    this.currentLevel = level;
                }
                return this;
            }
            throw new InvalidKeyException("Levels for key cannot be null nor empty");
        }

        public CombinationBuilder endLevel() {
            if (this.currentLevel.getIds().isEmpty()) {
                throw new InvalidKeyBuildStateException("Cannot create an empty Level");
            }
            this.levelEnded = true;
            return this.parentBuilder.endLevel(this.currentLevel);
        }
    }

    public static class CombinationBuilder {
        protected final ComposedMetaDataKeyBuilder parentBuilder;
        private final String keySeparator;
        protected List<MetaDataKeyLevel> levels = new LinkedList<MetaDataKeyLevel>();
        private boolean combinationEnded = false;

        protected CombinationBuilder(ComposedMetaDataKeyBuilder parentBuilder, String keySeparator) {
            this.parentBuilder = parentBuilder;
            this.keySeparator = keySeparator;
        }

        public LevelBuilder newLevel() {
            if (this.combinationEnded) {
                throw new InvalidKeyBuildStateException("Cannot add a new level to an already ended keyCombination");
            }
            return new LevelBuilder(this);
        }

        public CombinationBuilder endLevel(MetaDataKeyLevel currentLevel) {
            this.levels.add(currentLevel);
            return this;
        }

        public ComposedMetaDataKeyBuilder endKeyCombination() {
            if (this.levels.isEmpty()) {
                throw new InvalidKeyException("Key can not be empty, at least one MetaDataKeyLevel is required");
            }
            this.combinationEnded = true;
            return this.parentBuilder.endKeyCombination(this.buildKeyCombinationForLevels());
        }

        private List<ComposedMetaDataKey> buildKeyCombinationForLevels() {
            Iterator<MetaDataKeyLevel> levelsIt = this.levels.iterator();
            MetaDataKeyLevel level = levelsIt.next();
            List<ComposedMetaDataKey> composedKeys = this.initializeKeys(level);
            while (levelsIt.hasNext()) {
                level = levelsIt.next();
                composedKeys = this.expandKeysWithLevel(level, composedKeys);
            }
            this.levels = new LinkedList<MetaDataKeyLevel>();
            return composedKeys;
        }

        private List<ComposedMetaDataKey> initializeKeys(MetaDataKeyLevel level) {
            LinkedList<ComposedMetaDataKey> composedKeys = new LinkedList<ComposedMetaDataKey>();
            for (Map.Entry<String, String> entry : level.getIds()) {
                ComposedMetaDataKey key = this.keySeparator.isEmpty() ? this.newKey() : this.newKey(this.keySeparator);
                key.addLevel(entry.getKey(), entry.getValue());
                composedKeys.add(key);
            }
            return composedKeys;
        }

        private List<ComposedMetaDataKey> expandKeysWithLevel(MetaDataKeyLevel level, List<ComposedMetaDataKey> composedKeys) {
            if (level.getIds().isEmpty()) {
                return composedKeys;
            }
            LinkedList<ComposedMetaDataKey> expandedKeys = new LinkedList<ComposedMetaDataKey>();
            for (ComposedMetaDataKey key : composedKeys) {
                for (Map.Entry<String, String> entry : level.getIds()) {
                    DefaultComposedMetaDataKey expandedKey = new DefaultComposedMetaDataKey(key);
                    expandedKey.addLevel(entry.getKey(), entry.getValue());
                    expandedKeys.add(expandedKey);
                }
            }
            return expandedKeys;
        }

        private ComposedMetaDataKey newKey() {
            return new DefaultComposedMetaDataKey();
        }

        private ComposedMetaDataKey newKey(String separator) {
            return new DefaultComposedMetaDataKey(separator);
        }
    }
}

