/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.granite.projector;

import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Set;

public class ProjectionEnvironment {
    private final FileFormat outputFileFormat;
    private final String pojoPackage;
    private final String projectionServiceClass;
    private final Set<String> projectionClassOptions;

    public ProjectionEnvironment(FileFormat outputFileFormat, String pojoPackage, String projectionServiceClass, Set<String> projectionClassOptions) {
        this.outputFileFormat = (FileFormat)((Object)Preconditions.checkNotNull((Object)((Object)outputFileFormat)));
        this.pojoPackage = (String)Preconditions.checkNotNull((Object)pojoPackage);
        this.projectionServiceClass = (String)Preconditions.checkNotNull((Object)projectionServiceClass);
        this.projectionClassOptions = (Set)Preconditions.checkNotNull(projectionClassOptions);
    }

    public FileFormat getOutputFileFormat() {
        return this.outputFileFormat;
    }

    public String getPojoPackage() {
        return this.pojoPackage;
    }

    public String getProjectionServiceClass() {
        return this.projectionServiceClass;
    }

    public Set<String> getProjectionClassOptions() {
        return this.projectionClassOptions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProjectionEnvironment that = (ProjectionEnvironment)o;
        return this.outputFileFormat == that.outputFileFormat && this.pojoPackage.equals(that.pojoPackage) && this.projectionServiceClass.equals(that.projectionServiceClass) && this.projectionClassOptions.equals(that.projectionClassOptions);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.outputFileFormat, this.pojoPackage, this.projectionServiceClass, this.projectionClassOptions});
    }

    public static enum FileFormat {
        XML,
        JSON;

    }
}

