/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.common.hashing;

import com.regnosys.rosetta.common.hashing.GlobalKeyProcessStep;
import com.regnosys.rosetta.common.util.SimpleBuilderProcessor;
import com.rosetta.lib.postprocess.PostProcessorReport;
import com.rosetta.model.lib.GlobalKey;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.meta.GlobalKeyFields;
import com.rosetta.model.lib.meta.ReferenceWithMeta;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.PostProcessStep;
import com.rosetta.model.lib.process.ProcessingException;
import java.util.HashMap;
import java.util.Map;

public class ReKeyProcessStep
implements PostProcessStep {
    private final GlobalKeyProcessStep keyProcessor;

    public ReKeyProcessStep(GlobalKeyProcessStep keyProcessor) {
        this.keyProcessor = keyProcessor;
    }

    public <T extends RosettaModelObject> PostProcessorReport runProcessStep(Class<? extends T> topClass, T instance) {
        RosettaPath path = RosettaPath.valueOf((String)topClass.getSimpleName());
        RosettaModelObjectBuilder builder = instance.toBuilder();
        ReKeyPostProcessReport report = new ReKeyPostProcessReport(builder);
        ReKeyProcessor processor = new ReKeyProcessor(report, (GlobalKeyProcessStep.KeyPostProcessReport)this.keyProcessor.runProcessStep(topClass, (RosettaModelObject)instance));
        processor.processRosetta(path, topClass, builder, null, new AttributeMeta[0]);
        builder.process(path, (BuilderProcessor)processor);
        return report;
    }

    public Integer getPriority() {
        return 2;
    }

    public String getName() {
        return "Re-key PostProcessor";
    }

    class ReKeyPostProcessReport
    implements BuilderProcessor.Report,
    PostProcessorReport {
        private final RosettaModelObjectBuilder result;

        protected ReKeyPostProcessReport(RosettaModelObjectBuilder result) {
            this.result = result;
        }

        public RosettaModelObjectBuilder getResultObject() {
            return this.result;
        }
    }

    private class ReKeyProcessor
    extends SimpleBuilderProcessor {
        private final ReKeyPostProcessReport report;
        private Map<String, String> externalGlobalMap;

        public ReKeyProcessor(ReKeyPostProcessReport report, GlobalKeyProcessStep.KeyPostProcessReport keyPostProcessReport) {
            this.report = report;
            Map<RosettaPath, GlobalKey> globalKeyMap = keyPostProcessReport.getKeyMap();
            this.externalGlobalMap = new HashMap<String, String>();
            for (Map.Entry<RosettaPath, GlobalKey> globalKey : globalKeyMap.entrySet()) {
                GlobalKeyFields meta = globalKey.getValue().getMeta();
                if (meta.getExternalKey() == null) continue;
                String external = meta.getExternalKey();
                String global = meta.getGlobalKey();
                if (this.externalGlobalMap.containsKey(external) && !this.externalGlobalMap.get(external).equals(global)) {
                    throw new ProcessingException("Two distinct rosetta objects have the same external key " + external, globalKey.getValue().toString(), "ReKeyPostProcessor", globalKey.getKey());
                }
                this.externalGlobalMap.put(external, global);
            }
        }

        public <R extends RosettaModelObject> boolean processRosetta(RosettaPath path, Class<R> rosettaType, RosettaModelObjectBuilder builder, RosettaModelObjectBuilder parent, AttributeMeta ... metas) {
            ReferenceWithMeta.ReferenceWithMetaBuilder reference;
            String externalReference;
            String globalRef;
            if (builder instanceof ReferenceWithMeta.ReferenceWithMetaBuilder && (globalRef = this.externalGlobalMap.get(externalReference = (reference = (ReferenceWithMeta.ReferenceWithMetaBuilder)builder).getExternalReference())) != null) {
                reference.setGlobalReference(globalRef);
            }
            return true;
        }

        public BuilderProcessor.Report report() {
            return this.report;
        }
    }
}

