/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.common.serialisation.xml;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.PropertyMetadata;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.AnnotatedConstructor;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.introspect.TypeResolutionContext;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.impl.AttributePropertyWriter;
import com.fasterxml.jackson.databind.util.Annotations;
import com.fasterxml.jackson.databind.util.SimpleBeanPropertyDefinition;
import com.fasterxml.jackson.dataformat.xml.JacksonXmlAnnotationIntrospector;
import com.fasterxml.jackson.dataformat.xml.util.TypeUtil;
import com.regnosys.rosetta.common.serialisation.ConstantAttributePropertyWriter;
import com.regnosys.rosetta.common.serialisation.mixin.EnumAsStringBuilderIntrospector;
import com.regnosys.rosetta.common.serialisation.mixin.RosettaEnumBuilderIntrospector;
import com.regnosys.rosetta.common.serialisation.xml.VirtualXMLAttribute;
import com.rosetta.model.lib.ModelSymbolId;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.util.DottedPath;
import com.rosetta.util.serialisation.AttributeXMLConfiguration;
import com.rosetta.util.serialisation.AttributeXMLRepresentation;
import com.rosetta.util.serialisation.RosettaXMLConfiguration;
import com.rosetta.util.serialisation.TypeXMLConfiguration;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;

public class RosettaXMLAnnotationIntrospector
extends JacksonXmlAnnotationIntrospector {
    private static final long serialVersionUID = 1L;
    private static final JsonPOJOBuilder.Value ROSETTA_BUILDER_CONFIG = new JsonPOJOBuilder.Value("build", "set");
    public static final String SCHEMA_LOCATION_ATTRIBUTE_NAME = "schemaLocation";
    private static final String SCHEMA_LOCATION_ATTRIBUTE_PREFIXED_NAME = "xsi:schemaLocation";
    private final RosettaXMLConfiguration rosettaXMLConfiguration;
    private final RosettaEnumBuilderIntrospector rosettaEnumBuilderIntrospector;
    private final EnumAsStringBuilderIntrospector enumAsStringBuilderIntrospector;

    public RosettaXMLAnnotationIntrospector(RosettaXMLConfiguration rosettaXMLConfiguration, boolean supportNativeEnumValue) {
        this(rosettaXMLConfiguration, new RosettaEnumBuilderIntrospector(supportNativeEnumValue), new EnumAsStringBuilderIntrospector());
    }

    public RosettaXMLAnnotationIntrospector(RosettaXMLConfiguration rosettaXMLConfiguration, RosettaEnumBuilderIntrospector rosettaEnumBuilderIntrospector, EnumAsStringBuilderIntrospector enumAsStringBuilderIntrospector) {
        this.rosettaXMLConfiguration = rosettaXMLConfiguration;
        this.rosettaEnumBuilderIntrospector = rosettaEnumBuilderIntrospector;
        this.enumAsStringBuilderIntrospector = enumAsStringBuilderIntrospector;
    }

    public Class<?> findPOJOBuilder(AnnotatedClass ac) {
        if (ac.hasAnnotation(RosettaDataType.class)) {
            return ((RosettaDataType)ac.getAnnotation(RosettaDataType.class)).builder();
        }
        return super.findPOJOBuilder(ac);
    }

    public JsonPOJOBuilder.Value findPOJOBuilderConfig(AnnotatedClass ac) {
        if (ac.hasAnnotation(RosettaDataType.class)) {
            return ROSETTA_BUILDER_CONFIG;
        }
        return super.findPOJOBuilderConfig(ac);
    }

    public PropertyName findRootName(AnnotatedClass ac) {
        return this.getTypeXMLConfiguration(ac).flatMap(TypeXMLConfiguration::getXmlRootElementName).map(PropertyName::construct).orElseGet(() -> Optional.ofNullable((RosettaDataType)ac.getAnnotation(RosettaDataType.class)).map(rosettaDataTypeAnn -> PropertyName.construct((String)rosettaDataTypeAnn.value())).orElseGet(() -> super.findRootName(ac)));
    }

    protected PropertyName _findXmlName(Annotated a) {
        if (this.shouldUseDefaultPropertyName(a)) {
            return PropertyName.USE_DEFAULT;
        }
        return this.getAttributeXMLConfiguration(a).flatMap(AttributeXMLConfiguration::getXmlName).map(PropertyName::construct).orElseGet(() -> Optional.ofNullable((RosettaAttribute)a.getAnnotation(RosettaAttribute.class)).map(rosettaAttrAnn -> PropertyName.construct((String)rosettaAttrAnn.value())).orElseGet(() -> super._findXmlName(a)));
    }

    private boolean shouldUseDefaultPropertyName(Annotated a) {
        return this.getAttributeXMLConfiguration(a).flatMap(AttributeXMLConfiguration::getXmlRepresentation).map(attributeXMLRepresentation -> attributeXMLRepresentation == AttributeXMLRepresentation.VALUE).orElse(false);
    }

    public void findAndAddVirtualProperties(MapperConfig<?> config, AnnotatedClass ac, List<BeanPropertyWriter> properties) {
        this.getTypeXMLConfiguration(ac).ifPresent(typeXMLConfiguration -> {
            typeXMLConfiguration.getXmlAttributes().ifPresent(xmlAttributes -> {
                for (String xmlAttributeName : xmlAttributes.keySet()) {
                    String xmlAttributeValue = (String)xmlAttributes.get(xmlAttributeName);
                    JavaType propType = config.constructType(String.class);
                    BeanPropertyWriter bpw = this.constructVirtualXMLAttribute(xmlAttributeName, xmlAttributeValue, config, ac, propType);
                    properties.add(bpw);
                }
            });
            if (typeXMLConfiguration.getXmlRootElementName().isPresent()) {
                JavaType propType = config.constructType(String.class);
                BeanPropertyWriter bpw = this.constructVirtualSchemaLocationAttribute(config, ac, propType);
                properties.add(bpw);
            }
        });
        super.findAndAddVirtualProperties(config, ac, properties);
    }

    private BeanPropertyWriter constructVirtualXMLAttribute(String xmlAttributeName, String xmlAttributeValue, MapperConfig<?> config, AnnotatedClass ac, JavaType type) {
        PropertyName propertyName = PropertyName.construct((String)xmlAttributeName);
        VirtualXMLAttribute member = new VirtualXMLAttribute((TypeResolutionContext)ac, ac.getRawType(), xmlAttributeName, type);
        SimpleBeanPropertyDefinition xmlPropertyDefinition = SimpleBeanPropertyDefinition.construct(config, (AnnotatedMember)member, (PropertyName)propertyName, (PropertyMetadata)PropertyMetadata.STD_REQUIRED, (JsonInclude.Include)JsonInclude.Include.NON_NULL);
        return new ConstantAttributePropertyWriter(xmlAttributeName, (BeanPropertyDefinition)xmlPropertyDefinition, ac.getAnnotations(), type, xmlAttributeValue);
    }

    private BeanPropertyWriter constructVirtualSchemaLocationAttribute(MapperConfig<?> config, AnnotatedClass ac, JavaType type) {
        PropertyName propertyName = PropertyName.construct((String)SCHEMA_LOCATION_ATTRIBUTE_PREFIXED_NAME);
        VirtualXMLAttribute member = new VirtualXMLAttribute((TypeResolutionContext)ac, ac.getRawType(), SCHEMA_LOCATION_ATTRIBUTE_NAME, type);
        SimpleBeanPropertyDefinition xmlPropertyDefinition = SimpleBeanPropertyDefinition.construct(config, (AnnotatedMember)member, (PropertyName)propertyName, (PropertyMetadata)PropertyMetadata.STD_OPTIONAL, (JsonInclude.Include)JsonInclude.Include.NON_NULL);
        return AttributePropertyWriter.construct((String)SCHEMA_LOCATION_ATTRIBUTE_NAME, (BeanPropertyDefinition)xmlPropertyDefinition, (Annotations)ac.getAnnotations(), (JavaType)type);
    }

    public Boolean isOutputAsAttribute(MapperConfig<?> config, Annotated ann) {
        if (ann instanceof VirtualXMLAttribute) {
            return true;
        }
        return this.getAttributeXMLConfiguration(ann).flatMap(AttributeXMLConfiguration::getXmlRepresentation).map(attributeXMLRepresentation -> attributeXMLRepresentation == AttributeXMLRepresentation.ATTRIBUTE).orElseGet(() -> super.isOutputAsAttribute(config, ann));
    }

    public Boolean isOutputAsText(MapperConfig<?> config, Annotated ann) {
        return this.getAttributeXMLConfiguration(ann).flatMap(AttributeXMLConfiguration::getXmlRepresentation).map(attributeXMLRepresentation -> attributeXMLRepresentation == AttributeXMLRepresentation.VALUE).orElseGet(() -> super.isOutputAsText(config, ann));
    }

    protected boolean _isIgnorable(Annotated a) {
        boolean isIgnorable = super._isIgnorable(a);
        if (isIgnorable) {
            return true;
        }
        return !a.hasAnnotation(RosettaAttribute.class) && !(a instanceof AnnotatedConstructor);
    }

    public JsonIgnoreProperties.Value findPropertyIgnoralByName(MapperConfig<?> config, Annotated a) {
        JsonIgnoreProperties.Value ignoreProps = super.findPropertyIgnoralByName(config, a);
        return Optional.of(a).filter(ann -> ann instanceof AnnotatedClass).map(ann -> (AnnotatedClass)ann).flatMap(this::getTypeXMLConfiguration).flatMap(TypeXMLConfiguration::getXmlRootElementName).map(rootElementName -> {
            HashSet<String> ignoredNames = new HashSet<String>(ignoreProps.getIgnored());
            ignoredNames.add(SCHEMA_LOCATION_ATTRIBUTE_NAME);
            return JsonIgnoreProperties.Value.construct(ignoredNames, (boolean)ignoreProps.getIgnoreUnknown(), (boolean)ignoreProps.getAllowGetters(), (boolean)ignoreProps.getAllowSetters(), (boolean)ignoreProps.getMerge());
        }).orElse(ignoreProps);
    }

    public PropertyName findWrapperName(Annotated ann) {
        if (ann.hasAnnotation(RosettaAttribute.class) && this.hasCollectionType(ann)) {
            return PropertyName.NO_NAME;
        }
        return super.findWrapperName(ann);
    }

    private boolean hasCollectionType(Annotated ann) {
        if (ann instanceof AnnotatedMethod) {
            AnnotatedMethod method = (AnnotatedMethod)ann;
            JavaType attributeType = method.getParameterCount() == 1 ? method.getParameterType(0) : method.getType();
            return TypeUtil.isIndexedType((JavaType)attributeType);
        }
        return false;
    }

    public String[] findEnumValues(MapperConfig<?> config, AnnotatedClass enumType, Enum<?>[] enumValues, String[] names) {
        if (this.rosettaEnumBuilderIntrospector.isApplicable(enumType)) {
            this.rosettaEnumBuilderIntrospector.findEnumValues(enumType, enumValues, names);
        } else {
            this.enumAsStringBuilderIntrospector.findEnumValues(enumType, enumValues, names);
        }
        return names;
    }

    public void findEnumAliases(MapperConfig<?> config, AnnotatedClass enumType, Enum<?>[] enumValues, String[][] aliasList) {
        if (this.rosettaEnumBuilderIntrospector.isApplicable(enumType)) {
            this.rosettaEnumBuilderIntrospector.findEnumAliases(enumType, enumValues, aliasList);
        } else {
            super.findEnumAliases(config, enumType, (Enum[])enumValues, aliasList);
        }
    }

    private AnnotatedClass getEnclosingAnnotatedClass(AnnotatedMember member) {
        return (AnnotatedClass)member.getTypeContext();
    }

    private Optional<AttributeXMLConfiguration> getAttributeXMLConfiguration(Annotated a) {
        return Optional.of(a).filter(annotated -> annotated instanceof AnnotatedMember).map(annotated -> (AnnotatedMember)annotated).flatMap(annotatedMember -> Optional.ofNullable((RosettaAttribute)annotatedMember.getAnnotation(RosettaAttribute.class)).flatMap(rosettaAttributeAnnotation -> this.getTypeXMLConfiguration(this.getEnclosingAnnotatedClass((AnnotatedMember)annotatedMember)).flatMap(TypeXMLConfiguration::getAttributes).map(attributeMap -> (AttributeXMLConfiguration)attributeMap.get(rosettaAttributeAnnotation.value()))));
    }

    private Optional<TypeXMLConfiguration> getTypeXMLConfiguration(AnnotatedClass ac) {
        return Optional.ofNullable((RosettaDataType)ac.getAnnotation(RosettaDataType.class)).flatMap(rosettaDataTypeAnnotation -> {
            String namespace = ac.getType().getRawClass().getPackage().getName();
            DottedPath dottedPath = DottedPath.splitOnDots((String)namespace);
            String name = ((RosettaDataType)ac.getAnnotation(RosettaDataType.class)).value();
            ModelSymbolId modelSymbolId = new ModelSymbolId(dottedPath, name);
            return this.rosettaXMLConfiguration.getConfigurationForType(modelSymbolId);
        });
    }
}

